/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.curios;

import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.misc.AccessoryHandler;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/item/curios/BitingBeltItem;", "Lnet/minecraft/world/item/Item;", "Ltop/theillusivec4/curios/api/type/capability/ICurioItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "witchery"})
public class BitingBeltItem
extends Item
implements ICurioItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BitingBeltItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        WitcheryDataComponents.DualPotionContents dualData = (WitcheryDataComponents.DualPotionContents)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getDUAL_POTION_CONTENT().get());
        if (dualData != null) {
            Optional<PotionContents> pos = dualData.getPositive();
            Optional<PotionContents> neg = dualData.getNegative();
            if (pos.isPresent()) {
                MutableComponent mutableComponent = Component.literal((String)"Positive:");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
                tooltipComponents.add((Component)mutableComponent);
                pos.get().addPotionTooltip(arg_0 -> BitingBeltItem.appendHoverText$lambda$0(tooltipComponents, arg_0), 1.0f, context.tickRate());
            }
            if (neg.isPresent()) {
                MutableComponent mutableComponent = Component.literal((String)"Negative:");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
                tooltipComponents.add((Component)mutableComponent);
                neg.get().addPotionTooltip(arg_0 -> BitingBeltItem.appendHoverText$lambda$1(tooltipComponents, arg_0), 1.0f, context.tickRate());
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static final void appendHoverText$lambda$0(List $tooltipComponents, Component e) {
        Component component = e;
        Intrinsics.checkNotNull((Object)component);
        $tooltipComponents.add(component);
    }

    private static final void appendHoverText$lambda$1(List $tooltipComponents, Component e) {
        Component component = e;
        Intrinsics.checkNotNull((Object)component);
        $tooltipComponents.add(component);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/item/curios/BitingBeltItem$Companion;", "", "<init>", "()V", "usePotion", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "fl", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void usePotion(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource, float fl) {
            if (livingEntity != null) {
                Object object = WitcheryItems.INSTANCE.getBITING_BELT().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ItemStack belt = AccessoryHandler.INSTANCE.checkNoConsume(livingEntity, (Item)object);
                if (belt != null) {
                    WitcheryDataComponents.DualPotionContents dualData = (WitcheryDataComponents.DualPotionContents)belt.get((DataComponentType)WitcheryDataComponents.INSTANCE.getDUAL_POTION_CONTENT().get());
                    Object object2 = dualData;
                    if (object2 == null || (object2 = ((WitcheryDataComponents.DualPotionContents)object2).getPositive()) == null) {
                        Optional optional = Optional.empty();
                        object2 = optional;
                        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                    }
                    Optional pos = object2;
                    Object object3 = dualData;
                    if (object3 == null || (object3 = ((WitcheryDataComponents.DualPotionContents)object3).getNegative()) == null) {
                        Optional optional = Optional.empty();
                        object3 = optional;
                        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                    }
                    Optional neg = object3;
                    if (pos.isPresent()) {
                        ((PotionContents)pos.get()).forEachEffect(arg_0 -> Companion.usePotion$lambda$0(livingEntity, arg_0));
                    }
                    if (neg.isPresent()) {
                        DamageSource damageSource2 = damageSource;
                        if ((damageSource2 != null ? damageSource2.getEntity() : null) instanceof LivingEntity) {
                            ((PotionContents)neg.get()).forEachEffect(arg_0 -> Companion.usePotion$lambda$1(livingEntity, arg_0));
                        }
                    }
                }
            }
        }

        private static final void usePotion$lambda$0(LivingEntity $livingEntity, MobEffectInstance it) {
            if (!$livingEntity.hasEffect(it.getEffect())) {
                $livingEntity.addEffect(it);
            }
        }

        private static final void usePotion$lambda$1(LivingEntity $livingEntity, MobEffectInstance it) {
            if (!$livingEntity.hasEffect(it.getEffect())) {
                $livingEntity.addEffect(it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

