/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.menu;

import dev.sterner.witchery.content.block.spining_wheel.SpinningWheelBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryMenuTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/content/menu/SpinningWheelMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "getInventory", "()Lnet/minecraft/world/entity/player/Inventory;", "data", "Lnet/minecraft/world/inventory/ContainerData;", "level", "Lnet/minecraft/world/level/Level;", "blockEntity", "Ldev/sterner/witchery/content/block/spining_wheel/SpinningWheelBlockEntity;", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "stillValid", "", "getBurnProgress", "", "Companion", "witchery"})
public final class SpinningWheelMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Inventory inventory;
    @NotNull
    private ContainerData data;
    @NotNull
    private Level level;
    @Nullable
    private SpinningWheelBlockEntity blockEntity;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_EXTRA_INPUT_1 = 1;
    public static final int SLOT_EXTRA_INPUT_2 = 2;
    public static final int SLOT_EXTRA_INPUT_3 = 3;
    public static final int SLOT_RESULT = 4;

    public SpinningWheelMenu(int id, @NotNull Inventory inventory, @NotNull FriendlyByteBuf buf) {
        int i;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super((MenuType)WitcheryMenuTypes.INSTANCE.getSPINNING_WHEEL_MENU_TYPE().get(), id);
        this.inventory = inventory;
        this.data = (ContainerData)new SimpleContainerData(2);
        Level level = this.inventory.player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        BlockPos blockPos = buf.readBlockPos();
        if (this.level.getBlockEntity(blockPos) instanceof SpinningWheelBlockEntity) {
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.spining_wheel.SpinningWheelBlockEntity");
            SpinningWheelBlockEntity spinningWheelBlockEntity = this.blockEntity = (SpinningWheelBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)spinningWheelBlockEntity);
            this.data = spinningWheelBlockEntity.getDataAccess();
        }
        SpinningWheelBlockEntity spinningWheelBlockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity);
        this.addSlot(new Slot((Container)spinningWheelBlockEntity, 0, 44, 33));
        SpinningWheelBlockEntity spinningWheelBlockEntity2 = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity2);
        this.addSlot(new Slot((Container)spinningWheelBlockEntity2, 1, 80, 15));
        SpinningWheelBlockEntity spinningWheelBlockEntity3 = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity3);
        this.addSlot(new Slot((Container)spinningWheelBlockEntity3, 2, 80, 33));
        SpinningWheelBlockEntity spinningWheelBlockEntity4 = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity4);
        this.addSlot(new Slot((Container)spinningWheelBlockEntity4, 3, 80, 51));
        Player player = this.inventory.player;
        SpinningWheelBlockEntity spinningWheelBlockEntity5 = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity5);
        this.addSlot((Slot)new FurnaceResultSlot(player, (Container)spinningWheelBlockEntity5, 4, 116, 33));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.inventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(this.data);
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot == null) {
            ItemStack itemStack = resultStack;
            Intrinsics.checkNotNull((Object)itemStack);
            return itemStack;
        }
        Slot slot2 = slot;
        if (!slot2.hasItem()) {
            ItemStack itemStack = resultStack;
            Intrinsics.checkNotNull((Object)itemStack);
            return itemStack;
        }
        ItemStack slotStack = slot2.getItem();
        resultStack = slotStack.copy();
        boolean bl = 0 <= index ? index < 5 : false;
        if (bl) {
            if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (!this.moveItemStackTo(slotStack, 0, 4, false)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (slotStack.isEmpty()) {
            slot2.set(ItemStack.EMPTY);
        } else {
            slot2.setChanged();
        }
        ItemStack itemStack = resultStack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SpinningWheelBlockEntity spinningWheelBlockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)spinningWheelBlockEntity);
        return spinningWheelBlockEntity.stillValid(player);
    }

    public final float getBurnProgress() {
        int i = this.data.get(0);
        int j = this.data.get(1);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/menu/SpinningWheelMenu$Companion;", "", "<init>", "()V", "SLOT_INPUT", "", "SLOT_EXTRA_INPUT_1", "SLOT_EXTRA_INPUT_2", "SLOT_EXTRA_INPUT_3", "SLOT_RESULT", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

