/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.mob_effect;

import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/mob_effect/DiseaseMobEffect;", "Lnet/minecraft/world/effect/MobEffect;", "category", "Lnet/minecraft/world/effect/MobEffectCategory;", "color", "", "<init>", "(Lnet/minecraft/world/effect/MobEffectCategory;I)V", "applyEffectTick", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "amplifier", "shouldApplyEffectTickThisTick", "duration", "witchery"})
@SourceDebugExtension(value={"SMAP\nDiseaseMobEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiseaseMobEffect.kt\ndev/sterner/witchery/content/mob_effect/DiseaseMobEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1869#2,2:68\n*S KotlinDebug\n*F\n+ 1 DiseaseMobEffect.kt\ndev/sterner/witchery/content/mob_effect/DiseaseMobEffect\n*L\n22#1:68,2\n*E\n"})
public final class DiseaseMobEffect
extends MobEffect {
    public DiseaseMobEffect(@NotNull MobEffectCategory category, int color) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(category, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Level level = livingEntity.level();
        if (!level.isClientSide) {
            AABB box = livingEntity.getBoundingBox().inflate(1.0);
            List list = livingEntity.level().getEntitiesOfClass(LivingEntity.class, box);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LivingEntity targetEntity = (LivingEntity)element$iv;
                boolean bl = false;
                if (targetEntity.hasEffect((Holder)WitcheryMobEffects.INSTANCE.getDISEASE())) continue;
                targetEntity.addEffect(new MobEffectInstance((Holder)WitcheryMobEffects.INSTANCE.getDISEASE(), 600, amplifier));
            }
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, amplifier));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, amplifier));
            if (level.random.nextInt(10) == 0) {
                float damage = 1.0f;
                if (livingEntity instanceof Villager && ((Villager)livingEntity).getHealth() <= damage) {
                    ZombieVillager zombieVillager = (ZombieVillager)((Villager)livingEntity).convertTo(EntityType.ZOMBIE_VILLAGER, false);
                    if (zombieVillager != null) {
                        zombieVillager.setCanPickUpLoot(false);
                        zombieVillager.heal(10.0f);
                        level.playSound(null, (double)zombieVillager.getBlockX(), (double)zombieVillager.getBlockY(), (double)zombieVillager.getBlockZ(), SoundEvents.ZOMBIE_INFECT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else {
                    boolean harm = livingEntity.isInvertedHealAndHarm();
                    if (harm) {
                        livingEntity.heal(damage);
                    } else {
                        livingEntity.hurt(level.damageSources().starve(), damage);
                    }
                }
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

