/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api;

import dev.sterner.witchery.content.worldgen.WitcheryWorldgenKeys;
import dev.sterner.witchery.features.misc.MiscPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/core/api/WitcheryApi;", "", "<init>", "()V", "isInSpiritWorld", "", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/world/level/Level;", "makePlayerWitchy", "", "isWitchy", "maybeEntity", "witchery"})
public final class WitcheryApi {
    @NotNull
    public static final WitcheryApi INSTANCE = new WitcheryApi();

    private WitcheryApi() {
    }

    public final boolean isInSpiritWorld(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level);
        return this.isInSpiritWorld(level);
    }

    public final boolean isInSpiritWorld(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ResourceKey dim = level.dimension();
        return Intrinsics.areEqual((Object)dim, WitcheryWorldgenKeys.INSTANCE.getNIGHTMARE()) || Intrinsics.areEqual((Object)dim, WitcheryWorldgenKeys.INSTANCE.getDREAM());
    }

    public final void makePlayerWitchy(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!MiscPlayerAttachment.getData(player).isWitcheryAligned()) {
            MiscPlayerAttachment.INSTANCE.setWitcheryAligned(player, true);
        }
    }

    public final boolean isWitchy(@NotNull Player maybeEntity) {
        Intrinsics.checkNotNullParameter((Object)maybeEntity, (String)"maybeEntity");
        return MiscPlayerAttachment.getData(maybeEntity).isWitcheryAligned();
    }
}

