/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.block;

import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.features.misc.AltarLevelAttachment;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Ldev/sterner/witchery/core/api/block/AltarPowerConsumer;", "", "tryConsumeAltarPower", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "amount", "", "simulate", "getAltarPos", "Lnet/minecraft/server/level/ServerLevel;", "origin", "witchery"})
@SourceDebugExtension(value={"SMAP\nAltarPowerConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarPowerConsumer.kt\ndev/sterner/witchery/core/api/block/AltarPowerConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n2423#2,14:34\n*S KotlinDebug\n*F\n+ 1 AltarPowerConsumer.kt\ndev/sterner/witchery/core/api/block/AltarPowerConsumer\n*L\n22#1:34,14\n*E\n"})
public interface AltarPowerConsumer {
    default public boolean tryConsumeAltarPower(@NotNull Level level, @NotNull BlockPos pos, int amount, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AltarBlockEntity) {
            return ((AltarBlockEntity)be).consumeAltarPower(amount, simulate);
        }
        return false;
    }

    @Nullable
    default public BlockPos getAltarPos(@NotNull ServerLevel level, @NotNull BlockPos origin) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Iterable $this$minByOrNull$iv = AltarLevelAttachment.getAltarPos(level);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BlockPos pos = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = AltarPowerConsumer.getAltarPos$lambda$0$distance(origin, pos);
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos pos2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-AltarPowerConsumer$getAltarPos$1 = false;
                    double v$iv = AltarPowerConsumer.getAltarPos$lambda$0$distance(origin, pos2);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private static double getAltarPos$lambda$0$distance(BlockPos pos1, BlockPos pos2) {
        return Math.sqrt(Math.pow(pos1.getX() - pos2.getX(), 2) + Math.pow(pos1.getY() - pos2.getY(), 2) + Math.pow(pos1.getZ() - pos2.getZ(), 2));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static boolean tryConsumeAltarPower(@NotNull AltarPowerConsumer $this, @NotNull Level level, @NotNull BlockPos pos, int amount, boolean simulate) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return $this.tryConsumeAltarPower(level, pos, amount, simulate);
        }

        @Deprecated
        @Nullable
        public static BlockPos getAltarPos(@NotNull AltarPowerConsumer $this, @NotNull ServerLevel level, @NotNull BlockPos origin) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            return $this.getAltarPos(level, origin);
        }
    }
}

