/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.multiblock;

import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B#\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "structurePieces", "Ljava/util/ArrayList;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/ArrayList;)V", "place", "", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "placeNoContext", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "horizontalDirection", "Lnet/minecraft/core/Direction;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nMultiBlockHorizontalDirectionStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiBlockHorizontalDirectionStructure.kt\ndev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1869#2,2:76\n1869#2,2:78\n*S KotlinDebug\n*F\n+ 1 MultiBlockHorizontalDirectionStructure.kt\ndev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure\n*L\n17#1:76,2\n39#1:78,2\n*E\n"})
public final class MultiBlockHorizontalDirectionStructure
extends MultiBlockStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MultiBlockHorizontalDirectionStructure(@Nullable ArrayList<MultiBlockStructure.StructurePiece> structurePieces) {
        ArrayList<MultiBlockStructure.StructurePiece> arrayList = structurePieces;
        Intrinsics.checkNotNull(arrayList);
        super(arrayList);
    }

    @Override
    public void place(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = context.getHorizontalDirection().getOpposite();
        Iterable $this$forEach$iv = this.getStructurePieces();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockEntity blockEntity;
            MultiBlockStructure.StructurePiece s = (MultiBlockStructure.StructurePiece)element$iv;
            boolean bl = false;
            Vec3i vec3i = s.getOffset();
            Intrinsics.checkNotNull((Object)direction);
            Vec3i rotatedOffset = Companion.rotateOffset(vec3i, direction);
            BlockPos pos = context.getClickedPos().offset(rotatedOffset);
            BlockState stateWithDirection = (BlockState)s.getState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
            context.getLevel().setBlock(pos, stateWithDirection, 3);
            BlockEntity blockEntity2 = blockEntity = context.getLevel().getBlockEntity(pos);
            if (blockEntity2 instanceof MultiBlockComponentBlockEntity) {
                ((MultiBlockComponentBlockEntity)blockEntity).setCorePos(context.getClickedPos());
                ((MultiBlockComponentBlockEntity)blockEntity).setStructureOffset(s.getOffset());
                continue;
            }
            if (!(blockEntity2 instanceof MultiBlockCoreEntity)) continue;
            ((MultiBlockCoreEntity)blockEntity).setStructureOffset(s.getOffset());
        }
    }

    public final void placeNoContext(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction horizontalDirection) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)horizontalDirection, (String)"horizontalDirection");
        Direction direction = horizontalDirection.getOpposite();
        Iterable $this$forEach$iv = this.getStructurePieces();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockEntity component;
            MultiBlockStructure.StructurePiece s = (MultiBlockStructure.StructurePiece)element$iv;
            boolean bl = false;
            Vec3i vec3i = s.getOffset();
            Intrinsics.checkNotNull((Object)direction);
            Vec3i rotatedOffset = Companion.rotateOffset(vec3i, direction);
            BlockPos componentPos = pos.offset(rotatedOffset);
            BlockState stateWithDirection = (BlockState)s.getState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
            level.setBlock(componentPos, stateWithDirection, 3);
            BlockEntity blockEntity = component = level.getBlockEntity(componentPos);
            if (blockEntity instanceof MultiBlockComponentBlockEntity) {
                ((MultiBlockComponentBlockEntity)component).setCorePos(pos);
                ((MultiBlockComponentBlockEntity)component).setStructureOffset(s.getOffset());
                continue;
            }
            if (!(blockEntity instanceof MultiBlockCoreEntity)) continue;
            ((MultiBlockCoreEntity)component).setStructureOffset(s.getOffset());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure$Companion;", "", "<init>", "()V", "of", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "pieces", "", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;", "([Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure$StructurePiece;)Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "rotateOffset", "Lnet/minecraft/core/Vec3i;", "offset", "direction", "Lnet/minecraft/core/Direction;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiBlockHorizontalDirectionStructure of(MultiBlockStructure.StructurePiece ... pieces) {
            Intrinsics.checkNotNullParameter((Object)pieces, (String)"pieces");
            return new MultiBlockHorizontalDirectionStructure(new ArrayList<MultiBlockStructure.StructurePiece>(CollectionsKt.listOf((Object[])Arrays.copyOf(pieces, pieces.length))));
        }

        @NotNull
        public final Vec3i rotateOffset(@NotNull Vec3i offset, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> new Vec3i(offset.getX(), offset.getY(), offset.getZ());
                case 2 -> new Vec3i(-offset.getX(), offset.getY(), -offset.getZ());
                case 3 -> new Vec3i(offset.getZ(), offset.getY(), -offset.getX());
                case 4 -> new Vec3i(-offset.getZ(), offset.getY(), offset.getX());
                default -> offset;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.NORTH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.SOUTH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.WEST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.EAST.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

