/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.content.block.ChaliceBlock;
import dev.sterner.witchery.core.data.AltarAugmentReloadListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener;", "", "<init>", "()V", "LOADER", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugmentResourceReloadListener;", "getLOADER", "()Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugmentResourceReloadListener;", "AUGMENTS", "", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugment;", "getAUGMENTS", "()Ljava/util/List;", "getAugment", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "AltarAugmentResourceReloadListener", "AltarAugment", "AugmentBonus", "AugmentCategory", "witchery"})
@SourceDebugExtension(value={"SMAP\nAltarAugmentReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarAugmentReloadListener.kt\ndev/sterner/witchery/core/data/AltarAugmentReloadListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n295#2,2:154\n*S KotlinDebug\n*F\n+ 1 AltarAugmentReloadListener.kt\ndev/sterner/witchery/core/data/AltarAugmentReloadListener\n*L\n59#1:154,2\n*E\n"})
public final class AltarAugmentReloadListener {
    @NotNull
    public static final AltarAugmentReloadListener INSTANCE = new AltarAugmentReloadListener();
    @NotNull
    private static final AltarAugmentResourceReloadListener LOADER = new AltarAugmentResourceReloadListener(new Gson(), "altar_augments");
    @NotNull
    private static final List<AltarAugment> AUGMENTS = new ArrayList();

    private AltarAugmentReloadListener() {
    }

    @NotNull
    public final AltarAugmentResourceReloadListener getLOADER() {
        return LOADER;
    }

    @NotNull
    public final List<AltarAugment> getAUGMENTS() {
        return AUGMENTS;
    }

    @Nullable
    public final AltarAugment getAugment(@NotNull BlockState state) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Iterable $this$firstOrNull$iv = AUGMENTS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AltarAugment augment = (AltarAugment)element$iv;
                boolean bl = false;
                if (!augment.matches(state)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eJ\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003J\t\u0010%\u001a\u00020\u000eH\u00c6\u0003Ja\u0010&\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00072\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\tH\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugment;", "", "block", "Ljava/util/Optional;", "Lnet/minecraft/resources/ResourceLocation;", "tag", "requiresLit", "", "requiredCandleCount", "", "requiresSoup", "bonus", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus;", "category", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory;", "<init>", "(Ljava/util/Optional;Ljava/util/Optional;ZLjava/util/Optional;ZLdev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus;Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory;)V", "getBlock", "()Ljava/util/Optional;", "getTag", "getRequiresLit", "()Z", "getRequiredCandleCount", "getRequiresSoup", "getBonus", "()Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus;", "getCategory", "()Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory;", "matches", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class AltarAugment {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Optional<ResourceLocation> block;
        @NotNull
        private final Optional<ResourceLocation> tag;
        private final boolean requiresLit;
        @NotNull
        private final Optional<Integer> requiredCandleCount;
        private final boolean requiresSoup;
        @NotNull
        private final AugmentBonus bonus;
        @NotNull
        private final AugmentCategory category;
        @NotNull
        private static final Codec<AltarAugment> CODEC;

        public AltarAugment(@NotNull Optional<ResourceLocation> block, @NotNull Optional<ResourceLocation> tag, boolean requiresLit, @NotNull Optional<Integer> requiredCandleCount, boolean requiresSoup, @NotNull AugmentBonus bonus, @NotNull AugmentCategory category) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter(requiredCandleCount, (String)"requiredCandleCount");
            Intrinsics.checkNotNullParameter((Object)bonus, (String)"bonus");
            Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
            this.block = block;
            this.tag = tag;
            this.requiresLit = requiresLit;
            this.requiredCandleCount = requiredCandleCount;
            this.requiresSoup = requiresSoup;
            this.bonus = bonus;
            this.category = category;
        }

        @NotNull
        public final Optional<ResourceLocation> getBlock() {
            return this.block;
        }

        @NotNull
        public final Optional<ResourceLocation> getTag() {
            return this.tag;
        }

        public final boolean getRequiresLit() {
            return this.requiresLit;
        }

        @NotNull
        public final Optional<Integer> getRequiredCandleCount() {
            return this.requiredCandleCount;
        }

        public final boolean getRequiresSoup() {
            return this.requiresSoup;
        }

        @NotNull
        public final AugmentBonus getBonus() {
            return this.bonus;
        }

        @NotNull
        public final AugmentCategory getCategory() {
            return this.category;
        }

        public final boolean matches(@NotNull BlockState state) {
            TagKey blockTag;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (this.block.isPresent()) {
                Object object = BuiltInRegistries.BLOCK.get(this.block.get());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Block expectedBlock = (Block)object;
                if (!Intrinsics.areEqual((Object)state.getBlock(), (Object)expectedBlock)) {
                    return false;
                }
            }
            if (this.tag.isPresent() && !state.is(blockTag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)this.tag.get()))) {
                return false;
            }
            if (this.requiresLit) {
                if (!state.hasProperty((Property)BlockStateProperties.LIT)) {
                    return false;
                }
                if (!((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    return false;
                }
            }
            if (this.requiredCandleCount.isPresent()) {
                if (!state.hasProperty((Property)BlockStateProperties.CANDLES)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)state.getValue((Property)BlockStateProperties.CANDLES), (Object)this.requiredCandleCount.get())) {
                    return false;
                }
            }
            if (this.requiresSoup) {
                if (!state.hasProperty((Property)ChaliceBlock.Companion.getHAS_SOUP())) {
                    return false;
                }
                if (!((Boolean)state.getValue((Property)ChaliceBlock.Companion.getHAS_SOUP())).booleanValue()) {
                    return false;
                }
            }
            return true;
        }

        @NotNull
        public final Optional<ResourceLocation> component1() {
            return this.block;
        }

        @NotNull
        public final Optional<ResourceLocation> component2() {
            return this.tag;
        }

        public final boolean component3() {
            return this.requiresLit;
        }

        @NotNull
        public final Optional<Integer> component4() {
            return this.requiredCandleCount;
        }

        public final boolean component5() {
            return this.requiresSoup;
        }

        @NotNull
        public final AugmentBonus component6() {
            return this.bonus;
        }

        @NotNull
        public final AugmentCategory component7() {
            return this.category;
        }

        @NotNull
        public final AltarAugment copy(@NotNull Optional<ResourceLocation> block, @NotNull Optional<ResourceLocation> tag, boolean requiresLit, @NotNull Optional<Integer> requiredCandleCount, boolean requiresSoup, @NotNull AugmentBonus bonus, @NotNull AugmentCategory category) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter(requiredCandleCount, (String)"requiredCandleCount");
            Intrinsics.checkNotNullParameter((Object)bonus, (String)"bonus");
            Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
            return new AltarAugment(block, tag, requiresLit, requiredCandleCount, requiresSoup, bonus, category);
        }

        public static /* synthetic */ AltarAugment copy$default(AltarAugment altarAugment, Optional optional, Optional optional2, boolean bl, Optional optional3, boolean bl2, AugmentBonus augmentBonus, AugmentCategory augmentCategory, int n, Object object) {
            if ((n & 1) != 0) {
                optional = altarAugment.block;
            }
            if ((n & 2) != 0) {
                optional2 = altarAugment.tag;
            }
            if ((n & 4) != 0) {
                bl = altarAugment.requiresLit;
            }
            if ((n & 8) != 0) {
                optional3 = altarAugment.requiredCandleCount;
            }
            if ((n & 0x10) != 0) {
                bl2 = altarAugment.requiresSoup;
            }
            if ((n & 0x20) != 0) {
                augmentBonus = altarAugment.bonus;
            }
            if ((n & 0x40) != 0) {
                augmentCategory = altarAugment.category;
            }
            return altarAugment.copy(optional, optional2, bl, optional3, bl2, augmentBonus, augmentCategory);
        }

        @NotNull
        public String toString() {
            return "AltarAugment(block=" + this.block + ", tag=" + this.tag + ", requiresLit=" + this.requiresLit + ", requiredCandleCount=" + this.requiredCandleCount + ", requiresSoup=" + this.requiresSoup + ", bonus=" + this.bonus + ", category=" + this.category + ")";
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = result * 31 + this.tag.hashCode();
            result = result * 31 + Boolean.hashCode(this.requiresLit);
            result = result * 31 + this.requiredCandleCount.hashCode();
            result = result * 31 + Boolean.hashCode(this.requiresSoup);
            result = result * 31 + this.bonus.hashCode();
            result = result * 31 + this.category.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AltarAugment)) {
                return false;
            }
            AltarAugment altarAugment = (AltarAugment)other;
            if (!Intrinsics.areEqual(this.block, altarAugment.block)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tag, altarAugment.tag)) {
                return false;
            }
            if (this.requiresLit != altarAugment.requiresLit) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requiredCandleCount, altarAugment.requiredCandleCount)) {
                return false;
            }
            if (this.requiresSoup != altarAugment.requiresSoup) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bonus, (Object)altarAugment.bonus)) {
                return false;
            }
            return this.category == altarAugment.category;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceLocation.CODEC.optionalFieldOf("block").forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)ResourceLocation.CODEC.optionalFieldOf("tag").forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("requires_lit", (Object)false).forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("required_candle_count").forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("requires_soup", (Object)false).forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$4((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0)), (App)AugmentBonus.Companion.getCODEC().fieldOf("bonus").forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$5((KProperty1)Companion.CODEC.1.6.INSTANCE, arg_0)), (App)AugmentCategory.Companion.getCODEC().fieldOf("category").forGetter(arg_0 -> AltarAugment.CODEC$lambda$0$6((KProperty1)Companion.CODEC.1.7.INSTANCE, arg_0))).apply((Applicative)instance, AltarAugment::new);
        }

        private static final Optional CODEC$lambda$0$0(KProperty1 $tmp0, AltarAugment p0) {
            return (Optional)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Optional CODEC$lambda$0$1(KProperty1 $tmp0, AltarAugment p0) {
            return (Optional)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$0$2(KProperty1 $tmp0, AltarAugment p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Optional CODEC$lambda$0$3(KProperty1 $tmp0, AltarAugment p0) {
            return (Optional)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$0$4(KProperty1 $tmp0, AltarAugment p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final AugmentBonus CODEC$lambda$0$5(KProperty1 $tmp0, AltarAugment p0) {
            return (AugmentBonus)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final AugmentCategory CODEC$lambda$0$6(KProperty1 $tmp0, AltarAugment p0) {
            return (AugmentCategory)((Object)((Function1)$tmp0).invoke((Object)p0));
        }

        static {
            Codec codec = RecordCodecBuilder.create(AltarAugment::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugment$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugment;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<AltarAugment> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugmentResourceReloadListener;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "gson", "Lcom/google/gson/Gson;", "directory", "", "<init>", "(Lcom/google/gson/Gson;Ljava/lang/String;)V", "apply", "", "objects", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "profiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "parseJson", "json", "Lcom/google/gson/JsonObject;", "file", "witchery"})
    @SourceDebugExtension(value={"SMAP\nAltarAugmentReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarAugmentReloadListener.kt\ndev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugmentResourceReloadListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n216#2:154\n217#2:161\n1563#3:155\n1634#3,3:156\n1869#3,2:159\n*S KotlinDebug\n*F\n+ 1 AltarAugmentReloadListener.kt\ndev/sterner/witchery/core/data/AltarAugmentReloadListener$AltarAugmentResourceReloadListener\n*L\n36#1:154\n36#1:161\n39#1:155\n39#1:156,3\n39#1:159,2\n*E\n"})
    public static final class AltarAugmentResourceReloadListener
    extends SimpleJsonResourceReloadListener {
        public AltarAugmentResourceReloadListener(@NotNull Gson gson, @NotNull String directory) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            super(gson, directory);
        }

        /*
         * WARNING - void declaration
         */
        protected void apply(@NotNull Map<ResourceLocation, JsonElement> objects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            Intrinsics.checkNotNullParameter(objects, (String)"objects");
            Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
            Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
            INSTANCE.getAUGMENTS().clear();
            Map<ResourceLocation, JsonElement> $this$forEach$iv = objects;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, JsonElement> element$iv;
                Map.Entry<ResourceLocation, JsonElement> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceLocation file = entry.getKey();
                JsonElement element = entry.getValue();
                try {
                    if (element.isJsonArray()) {
                        void $this$forEach$iv2;
                        void $this$mapTo$iv$iv;
                        JsonArray jsonArray = element.getAsJsonArray();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv = (Iterable)jsonArray;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            JsonElement jsonElement = (JsonElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(p0.getAsJsonObject());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            JsonObject it = (JsonObject)element$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            this.parseJson(it, file);
                        }
                        continue;
                    }
                    if (!element.isJsonObject()) continue;
                    JsonObject jsonObject = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                    this.parseJson(jsonObject, file);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error parsing altar augment " + file + ": " + e.getMessage(), e);
                }
            }
        }

        private final void parseJson(JsonObject json, ResourceLocation file) {
            AltarAugment data2 = (AltarAugment)((Pair)AltarAugment.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(AltarAugmentResourceReloadListener::parseJson$lambda$0)).getFirst();
            List<AltarAugment> list = INSTANCE.getAUGMENTS();
            Intrinsics.checkNotNull((Object)data2);
            list.add(data2);
        }

        private static final IllegalArgumentException parseJson$lambda$0(String it) {
            return new IllegalArgumentException("Failed to decode altar augment: " + it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus;", "", "lightBonus", "", "headBonus", "chaliceBonus", "rangeMultiplier", "hasPentacle", "", "hasInfinityEgg", "<init>", "(DDDDZZ)V", "getLightBonus", "()D", "getHeadBonus", "getChaliceBonus", "getRangeMultiplier", "getHasPentacle", "()Z", "getHasInfinityEgg", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class AugmentBonus {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double lightBonus;
        private final double headBonus;
        private final double chaliceBonus;
        private final double rangeMultiplier;
        private final boolean hasPentacle;
        private final boolean hasInfinityEgg;
        @NotNull
        private static final Codec<AugmentBonus> CODEC;

        public AugmentBonus(double lightBonus, double headBonus, double chaliceBonus, double rangeMultiplier, boolean hasPentacle, boolean hasInfinityEgg) {
            this.lightBonus = lightBonus;
            this.headBonus = headBonus;
            this.chaliceBonus = chaliceBonus;
            this.rangeMultiplier = rangeMultiplier;
            this.hasPentacle = hasPentacle;
            this.hasInfinityEgg = hasInfinityEgg;
        }

        public final double getLightBonus() {
            return this.lightBonus;
        }

        public final double getHeadBonus() {
            return this.headBonus;
        }

        public final double getChaliceBonus() {
            return this.chaliceBonus;
        }

        public final double getRangeMultiplier() {
            return this.rangeMultiplier;
        }

        public final boolean getHasPentacle() {
            return this.hasPentacle;
        }

        public final boolean getHasInfinityEgg() {
            return this.hasInfinityEgg;
        }

        public final double component1() {
            return this.lightBonus;
        }

        public final double component2() {
            return this.headBonus;
        }

        public final double component3() {
            return this.chaliceBonus;
        }

        public final double component4() {
            return this.rangeMultiplier;
        }

        public final boolean component5() {
            return this.hasPentacle;
        }

        public final boolean component6() {
            return this.hasInfinityEgg;
        }

        @NotNull
        public final AugmentBonus copy(double lightBonus, double headBonus, double chaliceBonus, double rangeMultiplier, boolean hasPentacle, boolean hasInfinityEgg) {
            return new AugmentBonus(lightBonus, headBonus, chaliceBonus, rangeMultiplier, hasPentacle, hasInfinityEgg);
        }

        public static /* synthetic */ AugmentBonus copy$default(AugmentBonus augmentBonus, double d, double d2, double d3, double d4, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                d = augmentBonus.lightBonus;
            }
            if ((n & 2) != 0) {
                d2 = augmentBonus.headBonus;
            }
            if ((n & 4) != 0) {
                d3 = augmentBonus.chaliceBonus;
            }
            if ((n & 8) != 0) {
                d4 = augmentBonus.rangeMultiplier;
            }
            if ((n & 0x10) != 0) {
                bl = augmentBonus.hasPentacle;
            }
            if ((n & 0x20) != 0) {
                bl2 = augmentBonus.hasInfinityEgg;
            }
            return augmentBonus.copy(d, d2, d3, d4, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "AugmentBonus(lightBonus=" + this.lightBonus + ", headBonus=" + this.headBonus + ", chaliceBonus=" + this.chaliceBonus + ", rangeMultiplier=" + this.rangeMultiplier + ", hasPentacle=" + this.hasPentacle + ", hasInfinityEgg=" + this.hasInfinityEgg + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.lightBonus);
            result = result * 31 + Double.hashCode(this.headBonus);
            result = result * 31 + Double.hashCode(this.chaliceBonus);
            result = result * 31 + Double.hashCode(this.rangeMultiplier);
            result = result * 31 + Boolean.hashCode(this.hasPentacle);
            result = result * 31 + Boolean.hashCode(this.hasInfinityEgg);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AugmentBonus)) {
                return false;
            }
            AugmentBonus augmentBonus = (AugmentBonus)other;
            if (Double.compare(this.lightBonus, augmentBonus.lightBonus) != 0) {
                return false;
            }
            if (Double.compare(this.headBonus, augmentBonus.headBonus) != 0) {
                return false;
            }
            if (Double.compare(this.chaliceBonus, augmentBonus.chaliceBonus) != 0) {
                return false;
            }
            if (Double.compare(this.rangeMultiplier, augmentBonus.rangeMultiplier) != 0) {
                return false;
            }
            if (this.hasPentacle != augmentBonus.hasPentacle) {
                return false;
            }
            return this.hasInfinityEgg == augmentBonus.hasInfinityEgg;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.DOUBLE.optionalFieldOf("light_bonus", (Object)0.0).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.DOUBLE.optionalFieldOf("head_bonus", (Object)0.0).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.DOUBLE.optionalFieldOf("chalice_bonus", (Object)0.0).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.DOUBLE.optionalFieldOf("range_multiplier", (Object)1.0).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$3((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("has_pentacle", (Object)false).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$4((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("has_infinity_egg", (Object)false).forGetter(arg_0 -> AugmentBonus.CODEC$lambda$0$5((KProperty1)Companion.CODEC.1.6.INSTANCE, arg_0))).apply((Applicative)instance, AugmentBonus::new);
        }

        private static final Double CODEC$lambda$0$0(KProperty1 $tmp0, AugmentBonus p0) {
            return (Double)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Double CODEC$lambda$0$1(KProperty1 $tmp0, AugmentBonus p0) {
            return (Double)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Double CODEC$lambda$0$2(KProperty1 $tmp0, AugmentBonus p0) {
            return (Double)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Double CODEC$lambda$0$3(KProperty1 $tmp0, AugmentBonus p0) {
            return (Double)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$0$4(KProperty1 $tmp0, AugmentBonus p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Boolean CODEC$lambda$0$5(KProperty1 $tmp0, AugmentBonus p0) {
            return (Boolean)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(AugmentBonus::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentBonus;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<AugmentBonus> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory;", "", "<init>", "(Ljava/lang/String;I)V", "LIGHT", "HEAD", "CHALICE", "RANGE", "SPECIAL", "Companion", "witchery"})
    public static final class AugmentCategory
    extends Enum<AugmentCategory> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final Codec<AugmentCategory> CODEC;
        public static final /* enum */ AugmentCategory LIGHT;
        public static final /* enum */ AugmentCategory HEAD;
        public static final /* enum */ AugmentCategory CHALICE;
        public static final /* enum */ AugmentCategory RANGE;
        public static final /* enum */ AugmentCategory SPECIAL;
        private static final /* synthetic */ AugmentCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AugmentCategory[] values() {
            return (AugmentCategory[])$VALUES.clone();
        }

        public static AugmentCategory valueOf(String value) {
            return Enum.valueOf(AugmentCategory.class, value);
        }

        @NotNull
        public static EnumEntries<AugmentCategory> getEntries() {
            return $ENTRIES;
        }

        private static final AugmentCategory CODEC$lambda$0(String name) {
            Intrinsics.checkNotNull((Object)name);
            String string = name.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return AugmentCategory.valueOf(string);
        }

        private static final AugmentCategory CODEC$lambda$1(Function1 $tmp0, Object p0) {
            return (AugmentCategory)((Object)$tmp0.invoke(p0));
        }

        private static final String CODEC$lambda$2(AugmentCategory it) {
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        private static final String CODEC$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        static {
            LIGHT = new AugmentCategory();
            HEAD = new AugmentCategory();
            CHALICE = new AugmentCategory();
            RANGE = new AugmentCategory();
            SPECIAL = new AugmentCategory();
            $VALUES = augmentCategoryArray = new AugmentCategory[]{AugmentCategory.LIGHT, AugmentCategory.HEAD, AugmentCategory.CHALICE, AugmentCategory.RANGE, AugmentCategory.SPECIAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Codec codec = Codec.STRING.xmap(arg_0 -> AugmentCategory.CODEC$lambda$1(AugmentCategory::CODEC$lambda$0, arg_0), arg_0 -> AugmentCategory.CODEC$lambda$3(AugmentCategory::CODEC$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"xmap(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/core/data/AltarAugmentReloadListener$AugmentCategory;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<AugmentCategory> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

