/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/core/data/BloodPoolReloadListener;", "", "<init>", "()V", "LOADER", "Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodPoolResourceReloadListener;", "getLOADER", "()Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodPoolResourceReloadListener;", "BLOOD_PAIR", "", "Lnet/minecraft/world/entity/EntityType;", "Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodData;", "getBLOOD_PAIR", "()Ljava/util/Map;", "BloodPoolResourceReloadListener", "BloodData", "witchery"})
public final class BloodPoolReloadListener {
    @NotNull
    public static final BloodPoolReloadListener INSTANCE = new BloodPoolReloadListener();
    @NotNull
    private static final BloodPoolResourceReloadListener LOADER = new BloodPoolResourceReloadListener(new Gson(), "blood_pool");
    @NotNull
    private static final Map<EntityType<?>, BloodData> BLOOD_PAIR = new LinkedHashMap();

    private BloodPoolReloadListener() {
    }

    @NotNull
    public final BloodPoolResourceReloadListener getLOADER() {
        return LOADER;
    }

    @NotNull
    public final Map<EntityType<?>, BloodData> getBLOOD_PAIR() {
        return BLOOD_PAIR;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodData;", "", "entityId", "Lnet/minecraft/resources/ResourceLocation;", "bloodDrops", "", "qualityBloodDrops", "<init>", "(Lnet/minecraft/resources/ResourceLocation;II)V", "getEntityId", "()Lnet/minecraft/resources/ResourceLocation;", "getBloodDrops", "()I", "getQualityBloodDrops", "resolveEntity", "Lnet/minecraft/world/entity/EntityType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class BloodData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation entityId;
        private final int bloodDrops;
        private final int qualityBloodDrops;
        @NotNull
        private static final Codec<BloodData> CODEC;

        public BloodData(@NotNull ResourceLocation entityId, int bloodDrops, int qualityBloodDrops) {
            Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
            this.entityId = entityId;
            this.bloodDrops = bloodDrops;
            this.qualityBloodDrops = qualityBloodDrops;
        }

        @NotNull
        public final ResourceLocation getEntityId() {
            return this.entityId;
        }

        public final int getBloodDrops() {
            return this.bloodDrops;
        }

        public final int getQualityBloodDrops() {
            return this.qualityBloodDrops;
        }

        @Nullable
        public final EntityType<?> resolveEntity() {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(this.entityId).orElse(null);
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.entityId;
        }

        public final int component2() {
            return this.bloodDrops;
        }

        public final int component3() {
            return this.qualityBloodDrops;
        }

        @NotNull
        public final BloodData copy(@NotNull ResourceLocation entityId, int bloodDrops, int qualityBloodDrops) {
            Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
            return new BloodData(entityId, bloodDrops, qualityBloodDrops);
        }

        public static /* synthetic */ BloodData copy$default(BloodData bloodData, ResourceLocation resourceLocation, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                resourceLocation = bloodData.entityId;
            }
            if ((n3 & 2) != 0) {
                n = bloodData.bloodDrops;
            }
            if ((n3 & 4) != 0) {
                n2 = bloodData.qualityBloodDrops;
            }
            return bloodData.copy(resourceLocation, n, n2);
        }

        @NotNull
        public String toString() {
            return "BloodData(entityId=" + this.entityId + ", bloodDrops=" + this.bloodDrops + ", qualityBloodDrops=" + this.qualityBloodDrops + ")";
        }

        public int hashCode() {
            int result = this.entityId.hashCode();
            result = result * 31 + Integer.hashCode(this.bloodDrops);
            result = result * 31 + Integer.hashCode(this.qualityBloodDrops);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BloodData)) {
                return false;
            }
            BloodData bloodData = (BloodData)other;
            if (!Intrinsics.areEqual((Object)this.entityId, (Object)bloodData.entityId)) {
                return false;
            }
            if (this.bloodDrops != bloodData.bloodDrops) {
                return false;
            }
            return this.qualityBloodDrops == bloodData.qualityBloodDrops;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance inst) {
            return inst.group((App)ResourceLocation.CODEC.fieldOf("entityType").forGetter(arg_0 -> BloodData.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("bloodDrops").forGetter(arg_0 -> BloodData.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("qualityBloodDrops").forGetter(arg_0 -> BloodData.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)inst, BloodData::CODEC$lambda$0$3);
        }

        private static final ResourceLocation CODEC$lambda$0$0(KProperty1 $tmp0, BloodData p0) {
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer CODEC$lambda$0$1(KProperty1 $tmp0, BloodData p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer CODEC$lambda$0$2(KProperty1 $tmp0, BloodData p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final BloodData CODEC$lambda$0$3(ResourceLocation entityId, Integer bloodDrops, Integer qualityBloodDrops) {
            Intrinsics.checkNotNull((Object)entityId);
            Intrinsics.checkNotNull((Object)bloodDrops);
            int n = bloodDrops;
            Intrinsics.checkNotNull((Object)qualityBloodDrops);
            return new BloodData(entityId, n, qualityBloodDrops);
        }

        static {
            Codec codec = RecordCodecBuilder.create(BloodData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<BloodData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/core/data/BloodPoolReloadListener$BloodPoolResourceReloadListener;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "gson", "Lcom/google/gson/Gson;", "directory", "", "<init>", "(Lcom/google/gson/Gson;Ljava/lang/String;)V", "apply", "", "object", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "profiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "parseJson", "json", "Lcom/google/gson/JsonObject;", "file", "witchery"})
    @SourceDebugExtension(value={"SMAP\nBloodPoolReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloodPoolReloadListener.kt\ndev/sterner/witchery/core/data/BloodPoolReloadListener$BloodPoolResourceReloadListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n216#2:68\n217#2:75\n1563#3:69\n1634#3,3:70\n1869#3,2:73\n*S KotlinDebug\n*F\n+ 1 BloodPoolReloadListener.kt\ndev/sterner/witchery/core/data/BloodPoolReloadListener$BloodPoolResourceReloadListener\n*L\n29#1:68\n29#1:75\n31#1:69\n31#1:70,3\n31#1:73,2\n*E\n"})
    public static final class BloodPoolResourceReloadListener
    extends SimpleJsonResourceReloadListener {
        public BloodPoolResourceReloadListener(@NotNull Gson gson, @NotNull String directory) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            super(gson, directory);
        }

        /*
         * WARNING - void declaration
         */
        protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            Intrinsics.checkNotNullParameter(object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
            Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
            Map<ResourceLocation, JsonElement> $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, JsonElement> element$iv;
                Map.Entry<ResourceLocation, JsonElement> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceLocation file = entry.getKey();
                JsonElement element = entry.getValue();
                if (element.isJsonArray()) {
                    void $this$forEach$iv2;
                    void $this$mapTo$iv$iv;
                    JsonArray jsonArray = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    Iterable $this$map$iv = (Iterable)jsonArray;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        JsonElement jsonElement = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.getAsJsonObject());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        JsonObject it = (JsonObject)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        this.parseJson(it, file);
                    }
                    continue;
                }
                if (!element.isJsonObject()) continue;
                JsonObject jsonObject = element.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                this.parseJson(jsonObject, file);
            }
        }

        private final void parseJson(JsonObject json, ResourceLocation file) {
            BloodData data2 = (BloodData)((Pair)BloodData.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(IllegalArgumentException::new)).getFirst();
            EntityType<?> entity = data2.resolveEntity();
            if (entity != null) {
                INSTANCE.getBLOOD_PAIR().put(entity, data2);
            }
        }
    }
}

