/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.data.NaturePowerReloadListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002)*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ2\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0006\u0010(\u001a\u00020$R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR;\u0010\u000b\u001a,\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006+"}, d2={"Ldev/sterner/witchery/core/data/NaturePowerReloadListener;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOADER", "Ldev/sterner/witchery/core/data/NaturePowerReloadListener$NaturePowerLoader;", "getLOADER", "()Ldev/sterner/witchery/core/data/NaturePowerReloadListener$NaturePowerLoader;", "NATURE_POWER_VALUES", "", "Lcom/mojang/datafixers/util/Either;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/tags/TagKey;", "Lkotlin/Pair;", "", "getNATURE_POWER_VALUES", "()Ljava/util/Map;", "pendingDataProcessed", "", "tagQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ldev/sterner/witchery/core/data/NaturePowerReloadListener$Data;", "getTagQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "blockQueue", "getBlockQueue", "getPower", "block", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/world/level/block/state/BlockState;)Ljava/lang/Integer;", "getLimit", "Lnet/minecraft/resources/ResourceLocation;", "addEitherBlockOrTag", "", "either", "power", "limit", "addPending", "NaturePowerLoader", "Data", "witchery"})
@SourceDebugExtension(value={"SMAP\nNaturePowerReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NaturePowerReloadListener.kt\ndev/sterner/witchery/core/data/NaturePowerReloadListener\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n488#2,7:177\n488#2,7:184\n1#3:191\n1869#4,2:192\n1869#4,2:194\n*S KotlinDebug\n*F\n+ 1 NaturePowerReloadListener.kt\ndev/sterner/witchery/core/data/NaturePowerReloadListener\n*L\n46#1:177,7\n62#1:184,7\n80#1:192,2\n84#1:194,2\n*E\n"})
public final class NaturePowerReloadListener {
    @NotNull
    public static final NaturePowerReloadListener INSTANCE = new NaturePowerReloadListener();
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private static final NaturePowerLoader LOADER = new NaturePowerLoader();
    @NotNull
    private static final Map<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> NATURE_POWER_VALUES = new LinkedHashMap();
    private static boolean pendingDataProcessed;
    @NotNull
    private static final ConcurrentLinkedQueue<Data> tagQueue;
    @NotNull
    private static final ConcurrentLinkedQueue<Data> blockQueue;

    private NaturePowerReloadListener() {
    }

    @NotNull
    public final NaturePowerLoader getLOADER() {
        return LOADER;
    }

    @NotNull
    public final Map<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> getNATURE_POWER_VALUES() {
        return NATURE_POWER_VALUES;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Data> getTagQueue() {
        return tagQueue;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Data> getBlockQueue() {
        return blockQueue;
    }

    @Nullable
    public final Integer getPower(@NotNull BlockState block) {
        Integer power;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Pair<Integer, Integer> pair = NATURE_POWER_VALUES.get(Either.left((Object)block.getBlock()));
        Integer n = power = pair != null ? (Integer)pair.getFirst() : null;
        if (n != null) {
            return n;
        }
        Map<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> $this$filterKeys$iv = NATURE_POWER_VALUES;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> result$iv = new LinkedHashMap<Either<Block, TagKey<Block>>, Pair<Integer, Integer>>();
        for (Map.Entry<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> entry$iv : $this$filterKeys$iv.entrySet()) {
            Either<Block, TagKey<Block>> it = entry$iv.getKey();
            boolean bl = false;
            if (!(it.right().isPresent() && block.is((TagKey)it.right().get()))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set set = MapsKt.toSortedMap((Map)result$iv, (arg_0, arg_1) -> NaturePowerReloadListener.getPower$lambda$2(NaturePowerReloadListener::getPower$lambda$1, arg_0, arg_1)).keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Set tags = set;
        if (!((Collection)tags).isEmpty()) {
            Pair<Integer, Integer> pair2 = NATURE_POWER_VALUES.get(CollectionsKt.first((Iterable)tags));
            power = pair2 != null ? (Integer)pair2.getFirst() : null;
        }
        return power;
    }

    @Nullable
    public final Pair<ResourceLocation, Integer> getLimit(@NotNull BlockState block) {
        Pair pair;
        Integer limit;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Pair<Integer, Integer> pair2 = NATURE_POWER_VALUES.get(Either.left((Object)block.getBlock()));
        Integer n = limit = pair2 != null ? (Integer)pair2.getSecond() : null;
        if (limit != null) {
            return new Pair((Object)BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()), (Object)limit);
        }
        Map<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> $this$filterKeys$iv = NATURE_POWER_VALUES;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> result$iv = new LinkedHashMap<Either<Block, TagKey<Block>>, Pair<Integer, Integer>>();
        for (Map.Entry<Either<Block, TagKey<Block>>, Pair<Integer, Integer>> entry$iv : $this$filterKeys$iv.entrySet()) {
            Either<Block, TagKey<Block>> it = entry$iv.getKey();
            boolean bl = false;
            if (!(it.right().isPresent() && block.is((TagKey)it.right().get()))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set set = MapsKt.toSortedMap((Map)result$iv, (arg_0, arg_1) -> NaturePowerReloadListener.getLimit$lambda$2(NaturePowerReloadListener::getLimit$lambda$1, arg_0, arg_1)).keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Set tags = set;
        if (!((Collection)tags).isEmpty()) {
            Pair<Integer, Integer> pair3 = NATURE_POWER_VALUES.get(CollectionsKt.first((Iterable)tags));
            limit = pair3 != null ? (Integer)pair3.getSecond() : null;
        }
        Integer n2 = limit;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            pair = new Pair((Object)((TagKey)((Either)CollectionsKt.first((Iterable)tags)).right().get()).location(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    private final void addEitherBlockOrTag(Either<Block, TagKey<Block>> either, int power, int limit) {
        NATURE_POWER_VALUES.put(either, (Pair<Integer, Integer>)new Pair((Object)power, (Object)limit));
    }

    public final void addPending() {
        Data it;
        if (pendingDataProcessed) {
            return;
        }
        Iterable $this$forEach$iv = tagQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Data)element$iv;
            boolean bl = false;
            Either either = Either.right((Object)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)it.getBlock()));
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
            INSTANCE.addEitherBlockOrTag((Either<Block, TagKey<Block>>)either, it.getPower(), it.getLimit());
        }
        $this$forEach$iv = blockQueue;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Data)element$iv;
            boolean bl = false;
            Either either = Either.left((Object)BuiltInRegistries.BLOCK.get(it.getBlock()));
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
            INSTANCE.addEitherBlockOrTag((Either<Block, TagKey<Block>>)either, it.getPower(), it.getLimit());
        }
        pendingDataProcessed = true;
        tagQueue.clear();
        blockQueue.clear();
    }

    private static final int getPower$lambda$1(Either first, Either second) {
        Pair<Integer, Integer> pair = NATURE_POWER_VALUES.get(second);
        Pair<Integer, Integer> pair2 = NATURE_POWER_VALUES.get(first);
        return (pair != null ? ((Number)pair.getFirst()).intValue() : 0) - (pair2 != null ? ((Number)pair2.getFirst()).intValue() : 0);
    }

    private static final int getPower$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int getLimit$lambda$1(Either first, Either second) {
        Pair<Integer, Integer> pair = NATURE_POWER_VALUES.get(second);
        Pair<Integer, Integer> pair2 = NATURE_POWER_VALUES.get(first);
        return (pair != null ? ((Number)pair.getFirst()).intValue() : 0) - (pair2 != null ? ((Number)pair2.getFirst()).intValue() : 0);
    }

    private static final int getLimit$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        tagQueue = new ConcurrentLinkedQueue();
        blockQueue = new ConcurrentLinkedQueue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/core/data/NaturePowerReloadListener$Data;", "", "block", "Lnet/minecraft/resources/ResourceLocation;", "power", "", "limit", "<init>", "(Lnet/minecraft/resources/ResourceLocation;II)V", "getBlock", "()Lnet/minecraft/resources/ResourceLocation;", "getPower", "()I", "getLimit", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation block;
        private final int power;
        private final int limit;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final Codec<Data> TAG_CODEC;

        public Data(@NotNull ResourceLocation block, int power, int limit) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.power = power;
            this.limit = limit;
        }

        @NotNull
        public final ResourceLocation getBlock() {
            return this.block;
        }

        public final int getPower() {
            return this.power;
        }

        public final int getLimit() {
            return this.limit;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            return instance.group((App)ResourceLocation.CODEC.fieldOf("block").forGetter(arg_0 -> Data.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("power").forGetter(arg_0 -> Data.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("limit").forGetter(arg_0 -> Data.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)instance, Data::CODEC$lambda$0$3);
        }

        private static final ResourceLocation CODEC$lambda$0$0(KProperty1 $tmp0, Data p0) {
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer CODEC$lambda$0$1(KProperty1 $tmp0, Data p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer CODEC$lambda$0$2(KProperty1 $tmp0, Data p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Data CODEC$lambda$0$3(ResourceLocation name, Integer parentCombinations, Integer mutationChance) {
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)parentCombinations);
            int n = parentCombinations;
            Intrinsics.checkNotNull((Object)mutationChance);
            return new Data(name, n, mutationChance);
        }

        private static final App TAG_CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            return instance.group((App)ResourceLocation.CODEC.fieldOf("tag").forGetter(arg_0 -> Data.TAG_CODEC$lambda$0$0((KProperty1)Companion.TAG_CODEC.1.1.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("power").forGetter(arg_0 -> Data.TAG_CODEC$lambda$0$1((KProperty1)Companion.TAG_CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("limit").forGetter(arg_0 -> Data.TAG_CODEC$lambda$0$2((KProperty1)Companion.TAG_CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)instance, Data::TAG_CODEC$lambda$0$3);
        }

        private static final ResourceLocation TAG_CODEC$lambda$0$0(KProperty1 $tmp0, Data p0) {
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer TAG_CODEC$lambda$0$1(KProperty1 $tmp0, Data p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Integer TAG_CODEC$lambda$0$2(KProperty1 $tmp0, Data p0) {
            return (Integer)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Data TAG_CODEC$lambda$0$3(ResourceLocation name, Integer parentCombinations, Integer mutationChance) {
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)parentCombinations);
            int n = parentCombinations;
            Intrinsics.checkNotNull((Object)mutationChance);
            return new Data(name, n, mutationChance);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            Codec codec2 = RecordCodecBuilder.create(Data::TAG_CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
            TAG_CODEC = codec2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/core/data/NaturePowerReloadListener$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/core/data/NaturePowerReloadListener$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "TAG_CODEC", "getTAG_CODEC", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final Codec<Data> getTAG_CODEC() {
                return TAG_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/core/data/NaturePowerReloadListener$NaturePowerLoader;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "<init>", "()V", "apply", "", "object", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "profiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "parseJson", "json", "Lcom/google/gson/JsonObject;", "file", "witchery"})
    @SourceDebugExtension(value={"SMAP\nNaturePowerReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NaturePowerReloadListener.kt\ndev/sterner/witchery/core/data/NaturePowerReloadListener$NaturePowerLoader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n216#2:177\n217#2:184\n1563#3:178\n1634#3,3:179\n1869#3,2:182\n*S KotlinDebug\n*F\n+ 1 NaturePowerReloadListener.kt\ndev/sterner/witchery/core/data/NaturePowerReloadListener$NaturePowerLoader\n*L\n104#1:177\n104#1:184\n106#1:178\n106#1:179,3\n106#1:182,2\n*E\n"})
    public static final class NaturePowerLoader
    extends SimpleJsonResourceReloadListener {
        public NaturePowerLoader() {
            super(new Gson(), "nature");
        }

        /*
         * WARNING - void declaration
         */
        protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            Intrinsics.checkNotNullParameter(object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
            Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
            INSTANCE.getNATURE_POWER_VALUES().clear();
            INSTANCE.getTagQueue().clear();
            INSTANCE.getBlockQueue().clear();
            pendingDataProcessed = false;
            Map<ResourceLocation, JsonElement> $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, JsonElement> element$iv;
                Map.Entry<ResourceLocation, JsonElement> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceLocation file = entry.getKey();
                JsonElement element = entry.getValue();
                if (element.isJsonArray()) {
                    void $this$forEach$iv2;
                    void $this$mapTo$iv$iv;
                    JsonArray jsonArray = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    Iterable $this$map$iv = (Iterable)jsonArray;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        JsonElement jsonElement = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.getAsJsonObject());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        JsonObject it = (JsonObject)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        this.parseJson(it, file);
                    }
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject jsonObject = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                    this.parseJson(jsonObject, file);
                    continue;
                }
                LOGGER.error("The file " + file + " seems to have neither a JSON object or a JSON array... Skipping...");
            }
            INSTANCE.addPending();
        }

        public final void parseJson(@NotNull JsonObject json, @NotNull ResourceLocation file) {
            String block;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            JsonElement jsonElement = json.get("tag");
            String tag = jsonElement != null ? jsonElement.getAsString() : null;
            JsonElement jsonElement2 = json.get("block");
            String string = block = jsonElement2 != null ? jsonElement2.getAsString() : null;
            if (tag != null) {
                if (ResourceLocation.tryParse((String)tag) == null) {
                    LOGGER.error("Invalid ResourceLocation of " + tag + " in " + file);
                    return;
                }
                INSTANCE.getTagQueue().add((Data)((com.mojang.datafixers.util.Pair)Data.Companion.getTAG_CODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(IllegalArgumentException::new)).getFirst());
            } else if (block != null) {
                if (ResourceLocation.tryParse((String)block) == null) {
                    LOGGER.error("Invalid ResourceLocation of " + block + " in " + file);
                    return;
                }
                Data data2 = (Data)((com.mojang.datafixers.util.Pair)Data.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(IllegalArgumentException::new)).getFirst();
                Optional block2 = BuiltInRegistries.BLOCK.getOptional(data2.getBlock());
                if (block2.isPresent()) {
                    INSTANCE.getBlockQueue().add(data2);
                } else {
                    LOGGER.error("Invalid Block " + data2.getBlock() + " from file " + file + "!!!! Skipping it...");
                }
            } else {
                LOGGER.error("JSON missing block or tag in file " + file + "!!!! Skipping it...");
            }
        }
    }
}

