/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/core/data/PotionDataReloadListener;", "", "<init>", "()V", "getIngredientFromItem", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient;", "item", "Lnet/minecraft/world/item/ItemStack;", "LOADER", "Ldev/sterner/witchery/core/data/PotionDataReloadListener$PotionResourceReloadListener;", "getLOADER", "()Ldev/sterner/witchery/core/data/PotionDataReloadListener$PotionResourceReloadListener;", "POTION_PAIR", "", "Lnet/minecraft/world/item/Item;", "getPOTION_PAIR", "()Ljava/util/Map;", "PotionResourceReloadListener", "witchery"})
public final class PotionDataReloadListener {
    @NotNull
    public static final PotionDataReloadListener INSTANCE = new PotionDataReloadListener();
    @NotNull
    private static final PotionResourceReloadListener LOADER = new PotionResourceReloadListener(new Gson(), "potion");
    @NotNull
    private static final Map<Item, WitcheryPotionIngredient> POTION_PAIR = new LinkedHashMap();

    private PotionDataReloadListener() {
    }

    @Nullable
    public final WitcheryPotionIngredient getIngredientFromItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return POTION_PAIR.get(item.getItem());
    }

    @NotNull
    public final PotionResourceReloadListener getLOADER() {
        return LOADER;
    }

    @NotNull
    public final Map<Item, WitcheryPotionIngredient> getPOTION_PAIR() {
        return POTION_PAIR;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/core/data/PotionDataReloadListener$PotionResourceReloadListener;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "gson", "Lcom/google/gson/Gson;", "directory", "", "<init>", "(Lcom/google/gson/Gson;Ljava/lang/String;)V", "apply", "", "object", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "profiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "parseJson", "json", "Lcom/google/gson/JsonObject;", "file", "witchery"})
    @SourceDebugExtension(value={"SMAP\nPotionDataReloadListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PotionDataReloadListener.kt\ndev/sterner/witchery/core/data/PotionDataReloadListener$PotionResourceReloadListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n216#2:58\n217#2:65\n1563#3:59\n1634#3,3:60\n1869#3,2:63\n*S KotlinDebug\n*F\n+ 1 PotionDataReloadListener.kt\ndev/sterner/witchery/core/data/PotionDataReloadListener$PotionResourceReloadListener\n*L\n32#1:58\n32#1:65\n35#1:59\n35#1:60,3\n35#1:63,2\n*E\n"})
    public static final class PotionResourceReloadListener
    extends SimpleJsonResourceReloadListener {
        public PotionResourceReloadListener(@NotNull Gson gson, @NotNull String directory) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            super(gson, directory);
        }

        /*
         * WARNING - void declaration
         */
        protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
            Intrinsics.checkNotNullParameter(object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
            Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
            Map<ResourceLocation, JsonElement> $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, JsonElement> element$iv;
                Map.Entry<ResourceLocation, JsonElement> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceLocation file = entry.getKey();
                JsonElement element = entry.getValue();
                try {
                    if (element.isJsonArray()) {
                        void $this$forEach$iv2;
                        void $this$mapTo$iv$iv;
                        JsonArray jsonArray = element.getAsJsonArray();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                        Iterable $this$map$iv = (Iterable)jsonArray;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            JsonElement jsonElement = (JsonElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(p0.getAsJsonObject());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            JsonObject it = (JsonObject)element$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            this.parseJson(it, file);
                        }
                        continue;
                    }
                    if (!element.isJsonObject()) continue;
                    JsonObject jsonObject = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                    this.parseJson(jsonObject, file);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.fillInStackTrace());
                }
            }
        }

        private final void parseJson(JsonObject json, ResourceLocation file) {
            block1: {
                DataResult result = WitcheryPotionIngredient.Companion.getCODEC().parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                Optional optional = result.resultOrPartial(PotionResourceReloadListener::parseJson$lambda$0);
                if (optional == null) break block1;
                Optional ingredient = optional;
                boolean bl = false;
                Item item = ((WitcheryPotionIngredient)ingredient.get()).getItem().getItem();
                if (!Intrinsics.areEqual((Object)item, (Object)Items.AIR) && ingredient.isPresent()) {
                    INSTANCE.getPOTION_PAIR().put(item, (WitcheryPotionIngredient)ingredient.get());
                }
            }
        }

        private static final void parseJson$lambda$0(String string) {
        }
    }
}

