/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.core.api.SpecialPotion;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.core.registry.WitcherySpecialPotionEffects;
import dev.sterner.witchery.core.world.WitcheryWorldState;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomAbility;
import dev.sterner.witchery.features.affliction.lich.LichdomSpecificEventHandler;
import dev.sterner.witchery.mixin.SaplingBlockAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J(\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010PJ\u000e\u0010Q\u001a\u00020\u00152\u0006\u0010R\u001a\u00020SR\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RU\u0010\u0018\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bRU\u0010\u001c\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bRU\u0010\u001e\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bRU\u0010 \u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bRU\u0010\"\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bRU\u0010$\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bRU\u0010&\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bRU\u0010(\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001bRU\u0010*\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001bRU\u0010,\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001bRU\u0010.\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001bRU\u00100\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001bRU\u00102\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001bRU\u00104\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001bRU\u00106\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001bRU\u00108\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001bRU\u0010:\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001bRU\u0010<\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001bRU\u0010>\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u001bRU\u0010@\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001bRU\u0010B\u001aF\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001bR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\f0E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u001d\u0010T\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020J0U\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010X\u00a8\u0006Y"}, d2={"Ldev/sterner/witchery/core/registry/WitcherySpecialPotionEffects;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "SPECIAL_REGISTRY_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "Ldev/sterner/witchery/core/api/SpecialPotion;", "getSPECIAL_REGISTRY_KEY", "()Lnet/minecraft/resources/ResourceKey;", "SPECIAL_REGISTRY", "getSPECIAL_REGISTRY", "()Lnet/minecraft/core/Registry;", "SPECIALS", "Lnet/neoforged/neoforge/registries/DeferredRegister;", "register", "", "modEventBus", "Lnet/neoforged/bus/api/IEventBus;", "HARVEST", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "getHARVEST", "()Lnet/neoforged/neoforge/registries/DeferredHolder;", "FERTILE", "getFERTILE", "EXTINGUISH", "getEXTINGUISH", "GROW_FLOWERS", "getGROW_FLOWERS", "TILL_LAND", "getTILL_LAND", "GROW_LILY", "getGROW_LILY", "PRUNE_LEAVES", "getPRUNE_LEAVES", "PART_WATER", "getPART_WATER", "PLANT_DROPPED_SEEDS", "getPLANT_DROPPED_SEEDS", "FELL_TREE", "getFELL_TREE", "PART_LAVA", "getPART_LAVA", "SPROUTING", "getSPROUTING", "PULL", "getPULL", "PUSH", "getPUSH", "TELEPORT", "getTELEPORT", "TAME_ANIMALS", "getTAME_ANIMALS", "LOVE", "getLOVE", "GROW", "getGROW", "SHRINK", "getSHRINK", "SOUL_SEVERANCE", "getSOUL_SEVERANCE", "SUMMON_LEONARD", "getSUMMON_LEONARD", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "changeIntoState", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "entity", "Lnet/minecraft/world/entity/Entity;", "serverTick", "server", "Lnet/minecraft/server/MinecraftServer;", "TILLABLES", "", "Lnet/minecraft/world/level/block/Block;", "getTILLABLES", "()Ljava/util/Map;", "witchery"})
public final class WitcherySpecialPotionEffects {
    @NotNull
    public static final WitcherySpecialPotionEffects INSTANCE = new WitcherySpecialPotionEffects();
    private static final ResourceLocation ID = Witchery.Companion.id("special_potion_effect");
    @NotNull
    private static final ResourceKey<Registry<SpecialPotion>> SPECIAL_REGISTRY_KEY;
    @NotNull
    private static final Registry<SpecialPotion> SPECIAL_REGISTRY;
    @NotNull
    private static final DeferredRegister<SpecialPotion> SPECIALS;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> HARVEST;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> FERTILE;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> EXTINGUISH;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> GROW_FLOWERS;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> TILL_LAND;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> GROW_LILY;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PRUNE_LEAVES;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PART_WATER;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PLANT_DROPPED_SEEDS;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> FELL_TREE;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PART_LAVA;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> SPROUTING;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PULL;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> PUSH;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> TELEPORT;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> TAME_ANIMALS;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> LOVE;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> GROW;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> SHRINK;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> SOUL_SEVERANCE;
    private static final DeferredHolder<SpecialPotion, ? extends SpecialPotion> SUMMON_LEONARD;
    @NotNull
    private static final Codec<SpecialPotion> CODEC;
    @NotNull
    private static final Map<Block, BlockState> TILLABLES;

    private WitcherySpecialPotionEffects() {
    }

    public final ResourceLocation getID() {
        return ID;
    }

    @NotNull
    public final ResourceKey<Registry<SpecialPotion>> getSPECIAL_REGISTRY_KEY() {
        return SPECIAL_REGISTRY_KEY;
    }

    @NotNull
    public final Registry<SpecialPotion> getSPECIAL_REGISTRY() {
        return SPECIAL_REGISTRY;
    }

    public final void register(@NotNull IEventBus modEventBus) {
        Intrinsics.checkNotNullParameter((Object)modEventBus, (String)"modEventBus");
        SPECIALS.register(modEventBus);
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getHARVEST() {
        return HARVEST;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getFERTILE() {
        return FERTILE;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getEXTINGUISH() {
        return EXTINGUISH;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getGROW_FLOWERS() {
        return GROW_FLOWERS;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getTILL_LAND() {
        return TILL_LAND;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getGROW_LILY() {
        return GROW_LILY;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPRUNE_LEAVES() {
        return PRUNE_LEAVES;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPART_WATER() {
        return PART_WATER;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPLANT_DROPPED_SEEDS() {
        return PLANT_DROPPED_SEEDS;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getFELL_TREE() {
        return FELL_TREE;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPART_LAVA() {
        return PART_LAVA;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getSPROUTING() {
        return SPROUTING;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPULL() {
        return PULL;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getPUSH() {
        return PUSH;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getTELEPORT() {
        return TELEPORT;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getTAME_ANIMALS() {
        return TAME_ANIMALS;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getLOVE() {
        return LOVE;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getGROW() {
        return GROW;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getSHRINK() {
        return SHRINK;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getSOUL_SEVERANCE() {
        return SOUL_SEVERANCE;
    }

    public final DeferredHolder<SpecialPotion, ? extends SpecialPotion> getSUMMON_LEONARD() {
        return SUMMON_LEONARD;
    }

    @NotNull
    public final Codec<SpecialPotion> getCODEC() {
        return CODEC;
    }

    public final void changeIntoState(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        level.setBlock(pos, state, 11);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state));
    }

    public final void serverTick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        for (ServerLevel level : server.getAllLevels()) {
            ResourceKey levelKey = level.dimension();
            Intrinsics.checkNotNull((Object)level);
            WitcheryWorldState data2 = WitcheryWorldState.Companion.get(level);
            Iterator<Map.Entry<GlobalPos, Pair<Integer, Map<BlockPos, BlockState>>>> iterator = data2.getPendingRestores().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GlobalPos, Pair<Integer, Map<BlockPos, BlockState>>> entry = iterator.next();
                GlobalPos globalPos = entry.getKey();
                Pair<Integer, Map<BlockPos, BlockState>> pair = entry.getValue();
                int ticks = ((Number)pair.component1()).intValue();
                Map stateMap = (Map)pair.component2();
                if (!Intrinsics.areEqual((Object)globalPos.dimension(), (Object)levelKey)) continue;
                if (ticks - 1 <= 0) {
                    for (Map.Entry entry2 : stateMap.entrySet()) {
                        BlockPos pos = (BlockPos)entry2.getKey();
                        BlockState state = (BlockState)entry2.getValue();
                        if (!level.getBlockState(pos).isAir() && level.getBlockState(pos).getFluidState().isEmpty()) continue;
                        level.setBlockAndUpdate(pos, state);
                    }
                    iterator.remove();
                    data2.setDirty();
                    continue;
                }
                data2.getPendingRestores().put(globalPos, (Pair<Integer, Map<BlockPos, BlockState>>)TuplesKt.to((Object)(ticks - 1), (Object)stateMap));
            }
        }
    }

    @NotNull
    public final Map<Block, BlockState> getTILLABLES() {
        return TILLABLES;
    }

    private static final HARVEST.1.1 HARVEST$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                Stream stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box);
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
                Stream blockPoses = stream;
                blockPoses.forEach(arg_0 -> HARVEST.1.1.onActivated$lambda$1(arg_0 -> HARVEST.1.1.onActivated$lambda$0(level, arg_0), arg_0));
            }

            private static final Unit onActivated$lambda$0(Level $level, BlockPos pos) {
                BlockState state = $level.getBlockState(pos);
                if (state.getBlock() instanceof CropBlock) {
                    Block block = state.getBlock();
                    Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.CropBlock");
                    CropBlock c = (CropBlock)block;
                    $level.setBlockAndUpdate(pos, c.getStateForAge(0));
                } else if (state.canBeReplaced()) {
                    $level.destroyBlock(pos, true);
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final FERTILE.1.1 FERTILE$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (level instanceof ServerLevel) {
                    Stream stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
                    Stream blockPoses = stream;
                    blockPoses.forEach(arg_0 -> FERTILE.1.1.onActivated$lambda$1(arg_0 -> FERTILE.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                }
            }

            private static final Unit onActivated$lambda$0(Level $level, BlockPos pos) {
                BlockState state = ((ServerLevel)$level).getBlockState(pos);
                if (state.getBlock() instanceof CropBlock) {
                    Block block = state.getBlock();
                    Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.CropBlock");
                    CropBlock c = (CropBlock)block;
                    c.performBonemeal((ServerLevel)$level, $level.random, pos, state);
                    if ($level.random.nextBoolean()) {
                        c.performBonemeal((ServerLevel)$level, $level.random, pos, state);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final EXTINGUISH.1.1 EXTINGUISH$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (level instanceof ServerLevel) {
                    Stream stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
                    Stream blockPoses = stream;
                    blockPoses.forEach(arg_0 -> EXTINGUISH.1.1.onActivated$lambda$1(arg_0 -> EXTINGUISH.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                }
            }

            private static final Unit onActivated$lambda$0(Level $level, BlockPos pos) {
                BlockState state = ((ServerLevel)$level).getBlockState(pos);
                if (state.getBlock() instanceof FireBlock) {
                    ((ServerLevel)$level).removeBlock(pos, false);
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final GROW_FLOWERS.1.1 GROW_FLOWERS$lambda$0() {
        return new SpecialPotion(){

            public final List<Block> getAllFlowers() {
                List<Block> list = BuiltInRegistries.BLOCK.stream().filter(arg_0 -> GROW_FLOWERS.1.1.getAllFlowers$lambda$1(GROW_FLOWERS.1.1::getAllFlowers$lambda$0, arg_0)).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
                return list;
            }

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                Stream<Object> stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> GROW_FLOWERS.1.1.onActivated$lambda$3(arg_0 -> GROW_FLOWERS.1.1.onActivated$lambda$2(level, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
                Stream<Object> blockPoses = stream;
                List<Block> flowers = this.getAllFlowers();
                blockPoses.forEach(arg_0 -> GROW_FLOWERS.1.1.onActivated$lambda$5(arg_0 -> GROW_FLOWERS.1.1.onActivated$lambda$4(level, flowers, arg_0), arg_0));
            }

            private static final boolean getAllFlowers$lambda$0(Block block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                return block.builtInRegistryHolder().is(BlockTags.FLOWERS);
            }

            private static final boolean getAllFlowers$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean onActivated$lambda$2(Level $level, BlockPos it) {
                return $level.getBlockState(it.below()).is(BlockTags.DIRT) && $level.getBlockState(it).isAir();
            }

            private static final boolean onActivated$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final Unit onActivated$lambda$4(Level $level, List $flowers, BlockPos pos) {
                if ((double)$level.random.nextFloat() < 0.45) {
                    $level.setBlockAndUpdate(pos, ((Block)CollectionsKt.random((Collection)$flowers, (Random)((Random)Random.Default))).defaultBlockState());
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$5(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final TILL_LAND.1.1 TILL_LAND$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (level instanceof ServerLevel) {
                    Stream<Object> stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> TILL_LAND.1.1.onActivated$lambda$1(arg_0 -> TILL_LAND.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
                    Stream<Object> blockPoses = stream;
                    blockPoses.forEach(arg_0 -> TILL_LAND.1.1.onActivated$lambda$3(arg_0 -> TILL_LAND.1.1.onActivated$lambda$2(level, owner, arg_0), arg_0));
                }
            }

            private static final boolean onActivated$lambda$0(Level $level, BlockPos it) {
                return ((ServerLevel)$level).getBlockState(it).is(BlockTags.DIRT);
            }

            private static final boolean onActivated$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final Unit onActivated$lambda$2(Level $level, Entity $owner, BlockPos pos) {
                block1: {
                    BlockState newState;
                    BlockState state = ((ServerLevel)$level).getBlockState(pos);
                    if (((ServerLevel)$level).getBlockState(pos.above()).isCollisionShapeFullBlock((BlockGetter)$level, pos)) break block1;
                    BlockState blockState = newState = WitcherySpecialPotionEffects.INSTANCE.getTILLABLES().get(state.getBlock());
                    if (blockState != null) {
                        BlockState it = blockState;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)pos);
                        WitcherySpecialPotionEffects.INSTANCE.changeIntoState(it, $level, pos, $owner);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$3(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final GROW_LILY.1.1 GROW_LILY$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (level instanceof ServerLevel) {
                    Stream stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
                    Stream blockPoses = stream;
                    blockPoses.forEach(arg_0 -> GROW_LILY.1.1.onActivated$lambda$1(arg_0 -> GROW_LILY.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                }
            }

            private static final Unit onActivated$lambda$0(Level $level, BlockPos pos) {
                if ($level.random.nextFloat() < 0.25f) {
                    BlockState state = ((ServerLevel)$level).getBlockState(pos);
                    if (Intrinsics.areEqual((Object)((ServerLevel)$level).getFluidState(pos.below()).getType(), (Object)Fluids.WATER) && state.canBeReplaced()) {
                        $level.setBlockAndUpdate(pos, Blocks.LILY_PAD.defaultBlockState());
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final PRUNE_LEAVES.1.1 PRUNE_LEAVES$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (level instanceof ServerLevel) {
                    Stream stream = BlockPos.MutableBlockPos.betweenClosedStream((AABB)box);
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
                    Stream blockPoses = stream;
                    blockPoses.forEach(arg_0 -> PRUNE_LEAVES.1.1.onActivated$lambda$1(arg_0 -> PRUNE_LEAVES.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                }
            }

            private static final Unit onActivated$lambda$0(Level $level, BlockPos pos) {
                BlockState state = ((ServerLevel)$level).getBlockState(pos);
                if (state.is(BlockTags.LEAVES)) {
                    $level.destroyBlock(pos, false);
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final PART_WATER.1.1 PART_WATER$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                SpecialPotion specialPotion = this;
                AABB aABB = this.getBox(hitResult, mergedDispersalModifier);
                FlowingFluid flowingFluid = Fluids.WATER;
                Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
                SpecialPotion.partLiquidFor$default(specialPotion, level, aABB, (Fluid)flowingFluid, 0, 8, null);
            }
        };
    }

    private static final PLANT_DROPPED_SEEDS.1.1 PLANT_DROPPED_SEEDS$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier).inflate(2.0);
                if (level instanceof ServerLevel) {
                    Stream<Object> blockPoses = BlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> PLANT_DROPPED_SEEDS.1.1.onActivated$lambda$1(arg_0 -> PLANT_DROPPED_SEEDS.1.1.onActivated$lambda$0(level, arg_0), arg_0));
                    List list2 = ((ServerLevel)level).getEntities((EntityTypeTest)EntityType.ITEM, box, arg_0 -> PLANT_DROPPED_SEEDS.1.1.onActivated$lambda$3(PLANT_DROPPED_SEEDS.1.1::onActivated$lambda$2, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntities(...)");
                    List seedEntities = CollectionsKt.toMutableList((Collection)list2);
                    Iterator<T> iterator = blockPoses.iterator();
                    while (iterator.hasNext()) {
                        ItemEntity seedEntity;
                        Object v1;
                        BlockPos pos;
                        block3: {
                            pos = (BlockPos)iterator.next();
                            Iterable $this$firstOrNull$iv = seedEntities;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                ItemEntity it = (ItemEntity)element$iv;
                                boolean bl = false;
                                if (!(it.getItem().getCount() > 0)) continue;
                                v1 = element$iv;
                                break block3;
                            }
                            v1 = null;
                        }
                        if ((ItemEntity)v1 == null) break;
                        Item item = seedEntity.getItem().getItem();
                        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemNameBlockItem");
                        ItemNameBlockItem seedItem = (ItemNameBlockItem)item;
                        level.setBlockAndUpdate(pos, seedItem.getBlock().defaultBlockState());
                        seedEntity.getItem().shrink(1);
                        if (!seedEntity.getItem().isEmpty()) continue;
                        seedEntity.discard();
                        seedEntities.remove(seedEntity);
                    }
                }
            }

            private static final boolean onActivated$lambda$0(Level $level, BlockPos it) {
                boolean air = ((ServerLevel)$level).getBlockState(it).isAir();
                BlockState below = ((ServerLevel)$level).getBlockState(it.below());
                boolean isFarmland = below.getBlock() instanceof FarmBlock;
                return air && isFarmland;
            }

            private static final boolean onActivated$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean onActivated$lambda$2(ItemEntity entity) {
                Item item = entity.getItem().getItem();
                return item instanceof ItemNameBlockItem && ((ItemNameBlockItem)item).getBlock() instanceof CropBlock;
            }

            private static final boolean onActivated$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    private static final FELL_TREE.1.1 FELL_TREE$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                Optional<Object> logStart = BlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> FELL_TREE.1.1.onActivated$lambda$1(arg_0 -> FELL_TREE.1.1.onActivated$lambda$0(level, arg_0), arg_0)).findFirst();
                logStart.ifPresent(arg_0 -> FELL_TREE.1.1.onActivated$lambda$3(arg_0 -> FELL_TREE.1.1.onActivated$lambda$2(level, arg_0), arg_0));
            }

            private static final boolean onActivated$lambda$0(Level $level, BlockPos pos) {
                return $level.getBlockState(pos).is(BlockTags.LOGS);
            }

            private static final boolean onActivated$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final Unit onActivated$lambda$2(Level $level, BlockPos start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                Set visited = new LinkedHashSet<E>();
                ArrayDeque queue = new ArrayDeque();
                queue.add((Object)start);
                while (!((Collection)queue).isEmpty() && visited.size() < 64) {
                    BlockPos current = (BlockPos)queue.removeFirst();
                    if (!visited.add(current) || !$level.getBlockState(current).is(BlockTags.LOGS)) continue;
                    $level.destroyBlock(current, true);
                    for (int dx = -1; dx < 2; ++dx) {
                        for (int dy = -1; dy < 2; ++dy) {
                            for (int dz = -1; dz < 2; ++dz) {
                                BlockPos neighbor = current.offset(dx, dy, dz);
                                if (visited.contains(neighbor) || !$level.getBlockState(neighbor).is(BlockTags.LOGS)) continue;
                                Intrinsics.checkNotNull((Object)neighbor);
                                queue.add((Object)neighbor);
                            }
                        }
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void onActivated$lambda$3(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final PART_LAVA.1.1 PART_LAVA$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                SpecialPotion specialPotion = this;
                AABB aABB = this.getBox(hitResult, mergedDispersalModifier);
                FlowingFluid flowingFluid = Fluids.LAVA;
                Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"LAVA");
                SpecialPotion.partLiquidFor$default(specialPotion, level, aABB, (Fluid)flowingFluid, 0, 8, null);
            }
        };
    }

    private static final SPROUTING.1.1 SPROUTING$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                BlockPos pos = BlockPos.containing((Position)((Position)hitResult.getLocation()));
                Block sapling = Blocks.OAK_SAPLING;
                if (owner instanceof Player) {
                    int n = ((Player)owner).getInventory().getContainerSize();
                    for (int i = 0; i < n; ++i) {
                        ItemStack stack = ((Player)owner).getInventory().getItem(i);
                        Item item = stack.getItem();
                        if (!(item instanceof BlockItem) || !(((BlockItem)item).getBlock() instanceof SaplingBlock)) continue;
                        sapling = ((BlockItem)item).getBlock();
                        break;
                    }
                }
                if (level instanceof ServerLevel) {
                    Block block = sapling;
                    Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type dev.sterner.witchery.mixin.SaplingBlockAccessor");
                    boolean success = ((SaplingBlockAccessor)block).getTreeGrower().growTree((ServerLevel)level, ((ServerLevel)level).getChunkSource().getGenerator(), pos, sapling.defaultBlockState(), level.random);
                    if (!success) {
                        TreeGrower.OAK.growTree((ServerLevel)level, ((ServerLevel)level).getChunkSource().getGenerator(), pos, sapling.defaultBlockState(), level.random);
                    }
                    Intrinsics.checkNotNull((Object)pos);
                    int treeHeight = this.getTreeHeight(level, pos);
                    int radius = 10;
                    List entities = level.getEntitiesOfClass(Entity.class, new AABB(pos).inflate((double)radius));
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        Vec3 entityPos = ((LivingEntity)entity).position();
                        if (!this.isUnderTree(level, entity, treeHeight)) continue;
                        Vec3 newPos = new Vec3(entityPos.x, (double)pos.getY() + (double)treeHeight, entityPos.z);
                        ((LivingEntity)entity).teleportTo(newPos.x, newPos.y, newPos.z);
                    }
                }
            }

            private final int getTreeHeight(Level level, BlockPos basePos) {
                int height = 0;
                boolean foundLeaf = false;
                while (!foundLeaf && level.getBlockState(basePos.above(height)).is(BlockTags.LEAVES) || level.getBlockState(basePos.above(height)).is(BlockTags.LOGS)) {
                    if (level.getBlockState(basePos.above(height)).is(Blocks.OAK_LEAVES)) {
                        foundLeaf = true;
                    }
                    ++height;
                }
                return height;
            }

            private final boolean isUnderTree(Level level, Entity entity, int treeHeight) {
                BlockPos entityPos = entity.blockPosition();
                for (int y = 0; y < treeHeight; ++y) {
                    BlockState treePart = level.getBlockState(entityPos.above(y));
                    if (!treePart.is(BlockTags.LEAVES) && !treePart.is(BlockTags.LOGS)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static final PULL.1.1 PULL$lambda$0() {
        return new SpecialPotion(){

            /*
             * WARNING - void declaration
             */
            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                Vec3 center = box.getCenter();
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Entity entity = (Entity)element$iv$iv;
                    boolean bl = false;
                    if (!box.contains(entity.blockPosition().getCenter())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Entity entity = (Entity)element$iv;
                    boolean bl = false;
                    Vec3 entityPos = entity.position();
                    Vec3 direction = center.subtract(entityPos).normalize().scale(0.5);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(direction));
                }
            }
        };
    }

    private static final PUSH.1.1 PUSH$lambda$0() {
        return new SpecialPotion(){

            /*
             * WARNING - void declaration
             */
            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                Vec3 center = box.getCenter();
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Entity entity = (Entity)element$iv$iv;
                    boolean bl = false;
                    if (!box.contains(entity.blockPosition().getCenter())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Entity entity = (Entity)element$iv;
                    boolean bl = false;
                    Vec3 entityPos = entity.position();
                    Vec3 direction = entityPos.subtract(center).normalize().scale(0.5);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(direction));
                }
            }
        };
    }

    private static final TELEPORT.1.1 TELEPORT$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                List entitiesInBox = level.getEntitiesOfClass(LivingEntity.class, box);
                block0: for (LivingEntity entity : entitiesInBox) {
                    for (int i = 0; i < 16; ++i) {
                        SoundEvent soundEvent;
                        double d = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                        double e = Mth.clamp((double)(entity.getY() + (double)(entity.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1));
                        double f = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                        if (entity.isPassenger()) {
                            entity.stopRiding();
                        }
                        Vec3 vec3 = entity.position();
                        if (!entity.randomTeleport(d, e, f, true)) continue;
                        ((ServerLevel)level).gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)((Entity)entity)));
                        if (entity instanceof Fox) {
                            var21_18 = SoundEvents.FOX_TELEPORT;
                            Intrinsics.checkNotNull((Object)var21_18);
                            soundEvent = var21_18;
                        } else {
                            var21_18 = SoundEvents.CHORUS_FRUIT_TELEPORT;
                            Intrinsics.checkNotNull((Object)var21_18);
                            soundEvent = var21_18;
                        }
                        SoundEvent soundEvent2 = soundEvent;
                        SoundSource soundSource = SoundSource.PLAYERS;
                        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundEvent2, soundSource);
                        entity.resetFallDistance();
                        continue block0;
                    }
                }
            }
        };
    }

    private static final TAME_ANIMALS.1.1 TAME_ANIMALS$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                if (owner instanceof Player) {
                    List entitiesInBox = level.getEntitiesOfClass(LivingEntity.class, box);
                    for (LivingEntity entity : entitiesInBox) {
                        double dz;
                        if (!(entity instanceof TamableAnimal)) continue;
                        if (!((TamableAnimal)entity).isTame()) {
                            ((TamableAnimal)entity).getNavigation().moveTo(owner, 1.0);
                            ((TamableAnimal)entity).tame((Player)owner);
                            SimpleParticleType simpleParticleType = ParticleTypes.HEART;
                            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"HEART");
                            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                            for (int i = 0; i < 7; ++i) {
                                double d = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                                double e = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                                double f = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                                ((TamableAnimal)entity).level().addParticle(particleOptions, ((TamableAnimal)entity).getRandomX(1.0), ((TamableAnimal)entity).getRandomY() + 0.5, ((TamableAnimal)entity).getRandomZ(1.0), d, e, f);
                            }
                            continue;
                        }
                        double dx = ((TamableAnimal)entity).getX() - ((Player)owner).getX();
                        double distance = Math.sqrt(dx * dx + (dz = ((TamableAnimal)entity).getZ() - ((Player)owner).getZ()) * dz);
                        if (distance < 3.0) {
                            double randomDirection = ((TamableAnimal)entity).getRandom().nextDouble() * 360.0;
                            double newX = ((TamableAnimal)entity).getX() + Math.cos(randomDirection) * 5.0;
                            double newZ = ((TamableAnimal)entity).getZ() + Math.sin(randomDirection) * 5.0;
                            ((TamableAnimal)entity).getNavigation().moveTo(newX, ((TamableAnimal)entity).getY(), newZ, 1.0);
                        }
                        ((TamableAnimal)entity).setTame(true, true);
                        ((TamableAnimal)entity).setOwnerUUID(null);
                        SimpleParticleType simpleParticleType = ParticleTypes.SMOKE;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SMOKE");
                        ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                        for (int i = 0; i < 7; ++i) {
                            double d = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                            double e = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                            double f = ((TamableAnimal)entity).getRandom().nextGaussian() * 0.02;
                            ((TamableAnimal)entity).level().addParticle(particleOptions, ((TamableAnimal)entity).getRandomX(1.0), ((TamableAnimal)entity).getRandomY() + 0.5, ((TamableAnimal)entity).getRandomZ(1.0), d, e, f);
                        }
                    }
                }
            }
        };
    }

    private static final LOVE.1.1 LOVE$lambda$0() {
        return new SpecialPotion(){

            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                AABB box = this.getBox(hitResult, mergedDispersalModifier);
                List lovableEntities = level.getEntitiesOfClass(Animal.class, box);
                Intrinsics.checkNotNull((Object)lovableEntities);
                Iterable $this$forEach$iv = lovableEntities;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Animal it = (Animal)element$iv;
                    boolean bl = false;
                    it.setInLove(owner instanceof Player ? (Player)owner : null);
                }
            }
        };
    }

    private static final GROW.1.1 GROW$lambda$0() {
        return new SpecialPotion(){

            /*
             * WARNING - void declaration
             */
            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LivingEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    LivingEntity living = (LivingEntity)element$iv;
                    boolean bl = false;
                    living.addEffect(new MobEffectInstance((Holder)WitcheryMobEffects.INSTANCE.getGROW(), duration, amplifier));
                }
            }

            public void onDrunk(Level level, LivingEntity owner, int duration, int amplifier) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    LivingEntity livingEntity = owner;
                    if (livingEntity == null) break block0;
                    livingEntity.addEffect(new MobEffectInstance((Holder)WitcheryMobEffects.INSTANCE.getGROW(), duration, amplifier));
                }
            }
        };
    }

    private static final SHRINK.1.1 SHRINK$lambda$0() {
        return new SpecialPotion(){

            /*
             * WARNING - void declaration
             */
            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LivingEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    LivingEntity living = (LivingEntity)element$iv;
                    boolean bl = false;
                    living.addEffect(new MobEffectInstance((Holder)WitcheryMobEffects.INSTANCE.getSHRINK(), duration, amplifier));
                }
            }

            public void onDrunk(Level level, LivingEntity owner, int duration, int amplifier) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    LivingEntity livingEntity = owner;
                    if (livingEntity == null) break block0;
                    livingEntity.addEffect(new MobEffectInstance((Holder)WitcheryMobEffects.INSTANCE.getSHRINK(), duration, amplifier));
                }
            }
        };
    }

    private static final SOUL_SEVERANCE.1.1 SOUL_SEVERANCE$lambda$0() {
        return new SpecialPotion(){

            public void onDrunk(Level level, LivingEntity owner, int duration, int amplifier) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                if (owner instanceof ServerPlayer) {
                    AfflictionAbilityHandler.INSTANCE.addAbilityOnLevelUp((Player)owner, LichdomAbility.SOUL_FORM.getRequiredLevel(), AfflictionTypes.LICHDOM, true);
                    LichdomSpecificEventHandler.INSTANCE.activateSoulForm((ServerPlayer)owner);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onActivated(Level level, Entity owner, HitResult hitResult, List<Entity> list, WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ServerPlayer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    ServerPlayer serverPlayer = (ServerPlayer)element$iv;
                    boolean bl = false;
                    AfflictionAbilityHandler.INSTANCE.addAbilityOnLevelUp((Player)serverPlayer, LichdomAbility.SOUL_FORM.getRequiredLevel(), AfflictionTypes.LICHDOM, true);
                    LichdomSpecificEventHandler.INSTANCE.activateSoulForm(serverPlayer);
                }
            }
        };
    }

    private static final SUMMON_LEONARD.1.1 SUMMON_LEONARD$lambda$0() {
        return new SpecialPotion(){};
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(WitcherySpecialPotionEffects::CODEC$lambda$0$0)).apply((Applicative)instance, WitcherySpecialPotionEffects::CODEC$lambda$0$1);
    }

    private static final ResourceLocation CODEC$lambda$0$0(SpecialPotion special) {
        return special.getId();
    }

    private static final SpecialPotion CODEC$lambda$0$1(ResourceLocation resourceLocation) {
        return (SpecialPotion)((Registry)SPECIALS.getRegistry().get()).get(resourceLocation);
    }

    static {
        ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)ID);
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"createRegistryKey(...)");
        SPECIAL_REGISTRY_KEY = resourceKey;
        Registry registry = new RegistryBuilder(SPECIAL_REGISTRY_KEY).sync(true).defaultKey(ID).maxId(256).create();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"create(...)");
        SPECIAL_REGISTRY = registry;
        DeferredRegister deferredRegister = DeferredRegister.create(SPECIAL_REGISTRY, (String)"witchery");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        SPECIALS = deferredRegister;
        HARVEST = SPECIALS.register("harvest", WitcherySpecialPotionEffects::HARVEST$lambda$0);
        FERTILE = SPECIALS.register("fertile", WitcherySpecialPotionEffects::FERTILE$lambda$0);
        EXTINGUISH = SPECIALS.register("extinguish", WitcherySpecialPotionEffects::EXTINGUISH$lambda$0);
        GROW_FLOWERS = SPECIALS.register("grow_flowers", WitcherySpecialPotionEffects::GROW_FLOWERS$lambda$0);
        TILL_LAND = SPECIALS.register("till_land", WitcherySpecialPotionEffects::TILL_LAND$lambda$0);
        GROW_LILY = SPECIALS.register("grow_lily", WitcherySpecialPotionEffects::GROW_LILY$lambda$0);
        PRUNE_LEAVES = SPECIALS.register("prune_leaves", WitcherySpecialPotionEffects::PRUNE_LEAVES$lambda$0);
        PART_WATER = SPECIALS.register("part_water", WitcherySpecialPotionEffects::PART_WATER$lambda$0);
        PLANT_DROPPED_SEEDS = SPECIALS.register("plant_dropped_seeds", WitcherySpecialPotionEffects::PLANT_DROPPED_SEEDS$lambda$0);
        FELL_TREE = SPECIALS.register("fell_tree", WitcherySpecialPotionEffects::FELL_TREE$lambda$0);
        PART_LAVA = SPECIALS.register("part_lava", WitcherySpecialPotionEffects::PART_LAVA$lambda$0);
        SPROUTING = SPECIALS.register("sprouting", WitcherySpecialPotionEffects::SPROUTING$lambda$0);
        PULL = SPECIALS.register("pull", WitcherySpecialPotionEffects::PULL$lambda$0);
        PUSH = SPECIALS.register("push", WitcherySpecialPotionEffects::PUSH$lambda$0);
        TELEPORT = SPECIALS.register("teleport", WitcherySpecialPotionEffects::TELEPORT$lambda$0);
        TAME_ANIMALS = SPECIALS.register("tame_animals", WitcherySpecialPotionEffects::TAME_ANIMALS$lambda$0);
        LOVE = SPECIALS.register("love", WitcherySpecialPotionEffects::LOVE$lambda$0);
        GROW = SPECIALS.register("grow", WitcherySpecialPotionEffects::GROW$lambda$0);
        SHRINK = SPECIALS.register("shrink", WitcherySpecialPotionEffects::SHRINK$lambda$0);
        SOUL_SEVERANCE = SPECIALS.register("soul_severance", WitcherySpecialPotionEffects::SOUL_SEVERANCE$lambda$0);
        SUMMON_LEONARD = SPECIALS.register("summon_leonard", WitcherySpecialPotionEffects::SUMMON_LEONARD$lambda$0);
        Codec codec = RecordCodecBuilder.create(WitcherySpecialPotionEffects::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        HashMap hashMap = Maps.newHashMap((Map)((Map)ImmutableMap.of((Object)Blocks.GRASS_BLOCK, (Object)Blocks.FARMLAND.defaultBlockState(), (Object)Blocks.DIRT_PATH, (Object)Blocks.FARMLAND.defaultBlockState(), (Object)Blocks.DIRT, (Object)Blocks.FARMLAND.defaultBlockState(), (Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT.defaultBlockState(), (Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT.defaultBlockState())));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        TILLABLES = hashMap;
    }
}

