/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.data_gen;

import dev.sterner.witchery.content.block.MandrakeCropBlock;
import dev.sterner.witchery.content.block.WitcheryCropBlock;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/data_gen/WitcheryLootProvider;", "Lnet/minecraft/data/loot/LootTableProvider;", "packOutput", "Lnet/minecraft/data/PackOutput;", "provider", "Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/core/HolderLookup$Provider;", "<init>", "(Lnet/minecraft/data/PackOutput;Ljava/util/concurrent/CompletableFuture;)V", "validate", "", "writableregistry", "Lnet/minecraft/core/WritableRegistry;", "Lnet/minecraft/world/level/storage/loot/LootTable;", "validationcontext", "Lnet/minecraft/world/level/storage/loot/ValidationContext;", "problemreporter$collector", "Lnet/minecraft/util/ProblemReporter$Collector;", "EntityLoot", "BlocksLoot", "witchery"})
public final class WitcheryLootProvider
extends LootTableProvider {
    public WitcheryLootProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> provider) {
        Intrinsics.checkNotNullParameter((Object)packOutput, (String)"packOutput");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Object[] objectArray = new LootTableProvider.SubProviderEntry[]{new LootTableProvider.SubProviderEntry(WitcheryLootProvider::_init_$lambda$0, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(WitcheryLootProvider::_init_$lambda$1, LootContextParamSets.ENTITY)};
        super(packOutput, (Set)new LinkedHashSet(), CollectionsKt.listOf((Object[])objectArray), provider);
    }

    protected void validate(@NotNull WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext validationcontext, @NotNull ProblemReporter.Collector problemreporter$collector) {
        Intrinsics.checkNotNullParameter(writableregistry, (String)"writableregistry");
        Intrinsics.checkNotNullParameter((Object)validationcontext, (String)"validationcontext");
        Intrinsics.checkNotNullParameter((Object)problemreporter$collector, (String)"problemreporter$collector");
    }

    private static final LootTableSubProvider _init_$lambda$0(HolderLookup.Provider it) {
        Intrinsics.checkNotNull((Object)it);
        return (LootTableSubProvider)new BlocksLoot(it);
    }

    private static final LootTableSubProvider _init_$lambda$1(HolderLookup.Provider it) {
        Intrinsics.checkNotNull((Object)it);
        return (LootTableSubProvider)new EntityLoot(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0014J\b\u0010\t\u001a\u00020\nH\u0014J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00020\u0012\"\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/data_gen/WitcheryLootProvider$BlocksLoot;", "Lnet/minecraft/data/loot/BlockLootSubProvider;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "<init>", "(Lnet/minecraft/core/HolderLookup$Provider;)V", "getKnownBlocks", "", "Lnet/minecraft/world/level/block/Block;", "generate", "", "createFruitDroppingLeaves", "Lnet/minecraft/world/level/storage/loot/LootTable$Builder;", "leavesBlock", "saplingBlock", "fruitItem", "Lnet/minecraft/world/item/Item;", "chances", "", "", "createMandrakeCropDrops", "seedsItem", "sleepBuilder", "Lnet/minecraft/world/level/storage/loot/predicates/LootItemCondition$Builder;", "awakeBuilder", "witchery"})
    public static final class BlocksLoot
    extends BlockLootSubProvider {
        public BlocksLoot(@NotNull HolderLookup.Provider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(SetsKt.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            List list = WitcheryBlocks.INSTANCE.getBLOCKS().getEntries().stream().map(arg_0 -> BlocksLoot.getKnownBlocks$lambda$1(BlocksLoot::getKnownBlocks$lambda$0, arg_0)).filter(arg_0 -> BlocksLoot.getKnownBlocks$lambda$3(BlocksLoot::getKnownBlocks$lambda$2, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
            return list;
        }

        protected void generate() {
            Block block = (Block)WitcheryBlocks.INSTANCE.getCOFFIN().get();
            Object object = WitcheryBlocks.INSTANCE.getCOFFIN().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.add(block, BlocksLoot.generate$createCoffinTable(this, (Block)object));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDEEPLSTAE_ALTAR_BLOCK().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCRYSTAL_BALL().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCENSER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getPHYLACTERY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWITCHS_LADDER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWEREWOLF_ALTAR().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSOUL_CAGE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLOOD_CRUCIBLE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSCARECROW().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCLAY_EFFIGY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBEAR_TRAP().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCOPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getEXPOSED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_EXPOSED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWEATHERED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_WEATHERED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getOXIDIZED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_OXIDIZED_COPPER_CAULDRON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSPINNING_WHEEL().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBRAZIER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getIRON_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCOPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCOPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getEXPOSED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_EXPOSED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWEATHERED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_WEATHERED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getOXIDIZED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_OXIDIZED_COPPER_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getIRON_WITCHES_OVEN_FUME_EXTENSION().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getEXPOSED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWEATHERED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getOXIDIZED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_EXPOSED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_WEATHERED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWAXED_OXIDIZED_COPPER_WITCHES_OVEN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDISTILLERY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDEMON_HEART().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getGRAVESTONE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSUNLIGHT_COLLECTOR().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLOOD_STAINED_WOOL().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLOOD_STAINED_HAY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getGRASSPER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getSACRIFICIAL_CIRCLE().get(), (ItemLike)Blocks.SKELETON_SKULL);
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getSOUL_CAGE().get(), (ItemLike)WitcheryBlocks.INSTANCE.getBRAZIER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getIRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getWHITE_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getORANGE_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getMAGENTA_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getLIGHT_BLUE_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getYELLOW_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getLIME_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getPINK_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getGRAY_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getLIGHT_GRAY_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCYAN_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getPURPLE_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLUE_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBROWN_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getGREEN_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getRED_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLACK_IRON_CANDELABRA().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getCHALICE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getPENTACLE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getBLOOD_POPPY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_FLEET_FOOT().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_IRON_ARM().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_NIGHTMARES().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_FASTING().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getDREAM_WEAVER_OF_INTENSITY().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_WOOD().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_ROWAN_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_ROWAN_WOOD().get());
            float[] fArray = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            this.add((Block)WitcheryBlocks.INSTANCE.getROWAN_LEAVES().get(), this.createLeavesDrops((Block)WitcheryBlocks.INSTANCE.getROWAN_LEAVES().get(), (Block)WitcheryBlocks.INSTANCE.getROWAN_SAPLING().get(), fArray));
            Block block2 = (Block)WitcheryBlocks.INSTANCE.getROWAN_BERRY_LEAVES().get();
            Object object2 = WitcheryBlocks.INSTANCE.getROWAN_BERRY_LEAVES().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Block block3 = (Block)object2;
            Object object3 = WitcheryBlocks.INSTANCE.getROWAN_SAPLING().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            Block block4 = (Block)object3;
            Object object4 = WitcheryItems.INSTANCE.getROWAN_BERRIES().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            fArray = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            this.add(block2, this.createFruitDroppingLeaves(block3, block4, (Item)object4, fArray));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_PLANKS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_STAIRS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_SLAB().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_FENCE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_FENCE_GATE().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getROWAN_DOOR().get(), this.createDoorTable((Block)WitcheryBlocks.INSTANCE.getROWAN_DOOR().get()));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_TRAPDOOR().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_PRESSURE_PLATE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_BUTTON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getROWAN_SAPLING().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getPOTTED_ROWAN_SAPLING().get(), this.createPotFlowerItemTable((ItemLike)WitcheryItems.INSTANCE.getROWAN_SAPLING().get()));
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getROWAN_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getROWAN_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getROWAN_WALL_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getROWAN_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getROWAN_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getROWAN_HANGING_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getROWAN_WALL_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getROWAN_HANGING_SIGN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_WOOD().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_ALDER_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_ALDER_WOOD().get());
            fArray = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            this.add((Block)WitcheryBlocks.INSTANCE.getALDER_LEAVES().get(), this.createLeavesDrops((Block)WitcheryBlocks.INSTANCE.getALDER_LEAVES().get(), (Block)WitcheryBlocks.INSTANCE.getALDER_SAPLING().get(), fArray));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_PLANKS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_STAIRS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_SLAB().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_FENCE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_FENCE_GATE().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getALDER_DOOR().get(), this.createDoorTable((Block)WitcheryBlocks.INSTANCE.getALDER_DOOR().get()));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_TRAPDOOR().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_PRESSURE_PLATE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_BUTTON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getALDER_SAPLING().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getPOTTED_ALDER_SAPLING().get(), this.createPotFlowerItemTable((ItemLike)WitcheryItems.INSTANCE.getALDER_SAPLING().get()));
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getALDER_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getALDER_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getALDER_WALL_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getALDER_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getALDER_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getALDER_HANGING_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getALDER_WALL_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getALDER_HANGING_SIGN().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_WOOD().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_HAWTHORN_LOG().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getSTRIPPED_HAWTHORN_WOOD().get());
            fArray = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            this.add((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_LEAVES().get(), this.createLeavesDrops((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_LEAVES().get(), (Block)WitcheryBlocks.INSTANCE.getHAWTHORN_SAPLING().get(), fArray));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_PLANKS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_STAIRS().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_SLAB().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_FENCE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_FENCE_GATE().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_DOOR().get(), this.createDoorTable((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_DOOR().get()));
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_TRAPDOOR().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_PRESSURE_PLATE().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_BUTTON().get());
            this.dropSelf((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_SAPLING().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getPOTTED_HAWTHORN_SAPLING().get(), this.createPotFlowerItemTable((ItemLike)WitcheryItems.INSTANCE.getHAWTHORN_SAPLING().get()));
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getHAWTHORN_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_WALL_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getHAWTHORN_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getHAWTHORN_HANGING_SIGN().get());
            this.dropOther((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_WALL_HANGING_SIGN().get(), (ItemLike)WitcheryItems.INSTANCE.getHAWTHORN_HANGING_SIGN().get());
            this.add((Block)WitcheryBlocks.INSTANCE.getEMBER_MOSS().get(), BlocksLoot::generate$lambda$0);
            this.add((Block)WitcheryBlocks.INSTANCE.getLIFE_BLOOD().get(), BlocksLoot::generate$lambda$1);
            this.add((Block)WitcheryBlocks.INSTANCE.getLIFE_BLOOD_PLANT().get(), BlocksLoot::generate$lambda$2);
            this.add((Block)WitcheryBlocks.INSTANCE.getGLINTWEED().get(), BlocksLoot::generate$lambda$3);
            this.add((Block)WitcheryBlocks.INSTANCE.getSPANISH_MOSS().get(), BlocksLoot::generate$lambda$4);
            LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getMANDRAKE_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4).hasProperty((Property)MandrakeCropBlock.Companion.getAWAKE(), false));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setProperties(...)");
            LootItemCondition.Builder builder2 = (LootItemCondition.Builder)builder;
            LootItemBlockStatePropertyCondition.Builder otherBuilder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getMANDRAKE_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4).hasProperty((Property)MandrakeCropBlock.Companion.getAWAKE(), true));
            LootItemBlockStatePropertyCondition.Builder builder3 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getBELLADONNA_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setProperties(...)");
            LootItemCondition.Builder builder22 = (LootItemCondition.Builder)builder3;
            LootItemBlockStatePropertyCondition.Builder builder4 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getSNOWBELL_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setProperties(...)");
            LootItemCondition.Builder builder32 = (LootItemCondition.Builder)builder4;
            LootItemBlockStatePropertyCondition.Builder builder5 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getWATER_ARTICHOKE_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"setProperties(...)");
            LootItemCondition.Builder builder42 = (LootItemCondition.Builder)builder5;
            LootItemBlockStatePropertyCondition.Builder builder6 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getWOLFSFBANE_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"setProperties(...)");
            LootItemCondition.Builder builder52 = (LootItemCondition.Builder)builder6;
            LootItemBlockStatePropertyCondition.Builder builder7 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"setProperties(...)");
            LootItemCondition.Builder builder62 = (LootItemCondition.Builder)builder7;
            LootItemBlockStatePropertyCondition.Builder builder8 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)WitcheryBlocks.INSTANCE.getGARLIC_CROP().get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WitcheryCropBlock.Companion.getAGE(), 4));
            Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"setProperties(...)");
            LootItemCondition.Builder builder72 = (LootItemCondition.Builder)builder8;
            Block block5 = (Block)WitcheryBlocks.INSTANCE.getMANDRAKE_CROP().get();
            Object object5 = WitcheryItems.INSTANCE.getMANDRAKE_SEEDS().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            Item item = (Item)object5;
            Intrinsics.checkNotNull((Object)otherBuilder);
            this.add(block5, this.createMandrakeCropDrops(item, builder2, (LootItemCondition.Builder)otherBuilder));
            this.add((Block)WitcheryBlocks.INSTANCE.getBELLADONNA_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getBELLADONNA_CROP().get(), (Item)WitcheryItems.INSTANCE.getBELLADONNA_FLOWER().get(), (Item)WitcheryItems.INSTANCE.getBELLADONNA_SEEDS().get(), builder22));
            this.add((Block)WitcheryBlocks.INSTANCE.getWATER_ARTICHOKE_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getWATER_ARTICHOKE_CROP().get(), (Item)WitcheryItems.INSTANCE.getWATER_ARTICHOKE_GLOBE().get(), (Item)WitcheryItems.INSTANCE.getWATER_ARTICHOKE_SEEDS().get(), builder42));
            this.add((Block)WitcheryBlocks.INSTANCE.getSNOWBELL_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getSNOWBELL_CROP().get(), (Item)WitcheryItems.INSTANCE.getICY_NEEDLE().get(), (Item)WitcheryItems.INSTANCE.getSNOWBELL_SEEDS().get(), builder32));
            this.add((Block)WitcheryBlocks.INSTANCE.getWOLFSFBANE_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getWOLFSFBANE_CROP().get(), (Item)WitcheryItems.INSTANCE.getWOLFSBANE().get(), (Item)WitcheryItems.INSTANCE.getWOLFSBANE_SEEDS().get(), builder52));
            this.add((Block)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get(), (Item)WitcheryItems.INSTANCE.getWORMWOOD().get(), (Item)WitcheryItems.INSTANCE.getWORMWOOD_SEEDS().get(), builder62));
            this.add((Block)WitcheryBlocks.INSTANCE.getGARLIC_CROP().get(), this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getGARLIC_CROP().get(), (Item)WitcheryItems.INSTANCE.getGARLIC().get(), (Item)WitcheryItems.INSTANCE.getGARLIC().get(), builder72));
        }

        @NotNull
        public final LootTable.Builder createFruitDroppingLeaves(@NotNull Block leavesBlock, @NotNull Block saplingBlock, @NotNull Item fruitItem, float ... chances) {
            Intrinsics.checkNotNullParameter((Object)leavesBlock, (String)"leavesBlock");
            Intrinsics.checkNotNullParameter((Object)saplingBlock, (String)"saplingBlock");
            Intrinsics.checkNotNullParameter((Object)fruitItem, (String)"fruitItem");
            Intrinsics.checkNotNullParameter((Object)chances, (String)"chances");
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootTable.Builder builder = this.createLeavesDrops(leavesBlock, saplingBlock, Arrays.copyOf(chances, chances.length));
            LootPool.Builder builder2 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(BlockLootSubProvider.HAS_SHEARS.or(this.hasSilkTouch()).invert());
            ConditionUserBuilder conditionUserBuilder = this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)fruitItem)));
            Intrinsics.checkNotNull((Object)conditionUserBuilder, (String)"null cannot be cast to non-null type net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer.Builder<*>");
            float[] fArray = new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f};
            LootTable.Builder builder3 = builder.withPool(builder2.add(((LootPoolSingletonContainer.Builder)conditionUserBuilder).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)), (float[])fArray))));
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"withPool(...)");
            return builder3;
        }

        @NotNull
        public final LootTable.Builder createMandrakeCropDrops(@NotNull Item seedsItem, @NotNull LootItemCondition.Builder sleepBuilder, @NotNull LootItemCondition.Builder awakeBuilder) {
            Intrinsics.checkNotNullParameter((Object)seedsItem, (String)"seedsItem");
            Intrinsics.checkNotNullParameter((Object)sleepBuilder, (String)"sleepBuilder");
            Intrinsics.checkNotNullParameter((Object)awakeBuilder, (String)"awakeBuilder");
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootTable.Builder builder = this.createCropDrops((Block)WitcheryBlocks.INSTANCE.getMANDRAKE_CROP().get(), (Item)WitcheryItems.INSTANCE.getMANDRAKE_ROOT().get(), (Item)WitcheryItems.INSTANCE.getMANDRAKE_SEEDS().get(), sleepBuilder).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(awakeBuilder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)seedsItem))).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)), (float)0.5714286f, (int)3)));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"withPool(...)");
            return builder;
        }

        private static final Block getKnownBlocks$lambda$0(DeferredHolder it) {
            return (Block)it.value();
        }

        private static final Block getKnownBlocks$lambda$1(Function1 $tmp0, Object p0) {
            return (Block)$tmp0.invoke(p0);
        }

        private static final boolean getKnownBlocks$lambda$2(Block it) {
            return !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getALTAR().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getCOMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getALTAR_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getCAULDRON_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getEFFIGY_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getMUSHROOM_LOG_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getIRON_WITCHES_OVEN_FUME_EXTENSION_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getSACRIFICIAL_CIRCLE_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getWEREWOLF_ALTAR_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getCAULDRON_DUMMY().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getINFINITY_EGG().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getRITUAL_CHALK_BLOCK().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getINFERNAL_CHALK_BLOCK().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getOTHERWHERE_CHALK_BLOCK().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getGOLDEN_CHALK_BLOCK().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getWISPY_COTTON().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getSPIRIT_PORTAL().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getANCIENT_TABLET().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getDISTURBED_COTTON().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getPOPPET().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getMUSHROOM_LOG().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getSUSPICIOUS_GRAVEYARD_DIRT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getANCIENT_TABLET_COMPONENT().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryBlocks.INSTANCE.getDISTILLERY_COMPONENT().get());
        }

        private static final boolean getKnownBlocks$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final LootTable.Builder generate$createCoffinTable(BlocksLoot this$0, Block coffin) {
            LootTable.Builder builder = this$0.createSinglePropConditionTable(coffin, (Property)BedBlock.PART, (Comparable)BedPart.HEAD);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createSinglePropConditionTable(...)");
            return builder;
        }

        private static final LootTable.Builder generate$lambda$0(Block itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return BlockLootSubProvider.createShearsOnlyDrop((ItemLike)((ItemLike)itemLike));
        }

        private static final LootTable.Builder generate$lambda$1(Block itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return BlockLootSubProvider.createShearsOnlyDrop((ItemLike)((ItemLike)itemLike));
        }

        private static final LootTable.Builder generate$lambda$2(Block itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return BlockLootSubProvider.createShearsOnlyDrop((ItemLike)((ItemLike)itemLike));
        }

        private static final LootTable.Builder generate$lambda$3(Block itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return BlockLootSubProvider.createShearsOnlyDrop((ItemLike)((ItemLike)itemLike));
        }

        private static final LootTable.Builder generate$lambda$4(Block itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return BlockLootSubProvider.createShearsOnlyDrop((ItemLike)((ItemLike)itemLike));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007H\u0014J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/data_gen/WitcheryLootProvider$EntityLoot;", "Lnet/minecraft/data/loot/EntityLootSubProvider;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "<init>", "(Lnet/minecraft/core/HolderLookup$Provider;)V", "getKnownEntityTypes", "Ljava/util/stream/Stream;", "Lnet/minecraft/world/entity/EntityType;", "generate", "", "witchery"})
    public static final class EntityLoot
    extends EntityLootSubProvider {
        public EntityLoot(@NotNull HolderLookup.Provider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(FeatureFlags.REGISTRY.allFlags(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        @NotNull
        protected Stream<EntityType<?>> getKnownEntityTypes() {
            Stream<EntityType<?>> stream = WitcheryEntityTypes.INSTANCE.getENTITY_TYPES().getEntries().stream().map(arg_0 -> EntityLoot.getKnownEntityTypes$lambda$1(EntityLoot::getKnownEntityTypes$lambda$0, arg_0)).filter(arg_0 -> EntityLoot.getKnownEntityTypes$lambda$3(EntityLoot::getKnownEntityTypes$lambda$2, arg_0)).collect(Collectors.toList()).stream();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
            return stream;
        }

        public void generate() {
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getDEATH().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getDEATH_HOOD().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f))))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getDEATH_BOOTS().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f))))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getDEATH_SICKLE().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f))))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getDEATH_ROBE().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getHORNED_HUNTSMAN().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getHUNTSMAN_SPEAR().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getBABA_YAGA().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getBABA_YAGAS_HAT().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getMANDRAKE().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getMANDRAKE_ROOT().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f))))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getMANDRAKE_SEEDS().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getOWL().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getOWLETS_WING().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getDEMON().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getDEMON_HEART().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getENT().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getENT_TWIG().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getBANSHEE().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getSPECTRE().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getSPECTRAL_PIG().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
            this.add((EntityType)WitcheryEntityTypes.INSTANCE.getNIGHTMARE().get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)WitcheryItems.INSTANCE.getMELLIFLUOUS_HUNGER().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)ConstantValue.exactly((float)1.0f)))))));
        }

        private static final EntityType getKnownEntityTypes$lambda$0(DeferredHolder it) {
            return (EntityType)it.value();
        }

        private static final EntityType getKnownEntityTypes$lambda$1(Function1 $tmp0, Object p0) {
            return (EntityType)$tmp0.invoke(p0);
        }

        private static final boolean getKnownEntityTypes$lambda$2(EntityType it) {
            return !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getINSANITY().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getWEREWOLF().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getAREA_EFFECT_CLOUD().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getELLE().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getTHROWN_BREW().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getBROOM().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getVAMPIRE().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getLILITH().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getPARASITIC_LOUSE().get()) && !Intrinsics.areEqual((Object)it, (Object)WitcheryEntityTypes.INSTANCE.getIMP().get());
        }

        private static final boolean getKnownEntityTypes$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

