/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.FieldDefinition;
import dev.sterner.witchery.features.affliction.SyncFieldRegistry;
import dev.sterner.witchery.network.OptimizedSelectiveSyncPayload;
import dev.sterner.witchery.network.SyncAfflictionS2CPayload;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0007H\u0007J9\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0019\b\u0004\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0086\b\u00f8\u0001\u0000J&\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment;", "", "<init>", "()V", "playerDataCache", "Ljava/util/WeakHashMap;", "Ljava/util/UUID;", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "getData", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "", "syncFull", "syncSmart", "newData", "smartUpdate", "operations", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "detectChanges", "", "", "oldData", "Data", "LichData", "VampData", "WereData", "witchery"})
@SourceDebugExtension(value={"SMAP\nAfflictionPlayerAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,526:1\n1869#2,2:527\n*S KotlinDebug\n*F\n+ 1 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n89#1:527,2\n*E\n"})
public final class AfflictionPlayerAttachment {
    @NotNull
    public static final AfflictionPlayerAttachment INSTANCE = new AfflictionPlayerAttachment();
    @NotNull
    private static final WeakHashMap<UUID, Data> playerDataCache = new WeakHashMap();

    private AfflictionPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getAFFLICTION_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2, boolean sync) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getAFFLICTION_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        if (sync) {
            AfflictionPlayerAttachment.syncFull(player, data2);
        }
    }

    public static /* synthetic */ void setData$default(Player player, Data data2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        AfflictionPlayerAttachment.setData(player, data2, bl);
    }

    @JvmStatic
    public static final void syncFull(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player instanceof ServerPlayer) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncAfflictionS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((Map)playerDataCache).put(((ServerPlayer)player).getUUID(), Data.copy$default(data2, null, 0, null, null, null, null, null, 127, null));
        }
    }

    @JvmStatic
    public static final void syncSmart(@NotNull Player player, @NotNull Data newData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        UUID playerId = ((ServerPlayer)player).getUUID();
        Data oldData = playerDataCache.get(playerId);
        if (oldData == null) {
            AfflictionPlayerAttachment.syncFull(player, newData);
            return;
        }
        Map<String, Object> changes = INSTANCE.detectChanges(oldData, newData);
        if (!changes.isEmpty()) {
            Entity entity = (Entity)player;
            Intrinsics.checkNotNull((Object)playerId);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new OptimizedSelectiveSyncPayload(playerId, changes), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((Map)playerDataCache).put(playerId, Data.copy$default(newData, null, 0, null, null, null, null, null, 127, null));
        }
    }

    @NotNull
    public final Data smartUpdate(@NotNull Player player, boolean sync, @NotNull Function1<? super Data, Data> operations) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        boolean $i$f$smartUpdate = false;
        Data currentData = AfflictionPlayerAttachment.getData(player);
        Data newData = (Data)operations.invoke((Object)currentData);
        AfflictionPlayerAttachment.setData(player, newData, false);
        if (sync && player.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player, newData);
        }
        return newData;
    }

    public static /* synthetic */ Data smartUpdate$default(AfflictionPlayerAttachment $this, Player player, boolean sync, Function1 operations, int n, Object object) {
        if ((n & 2) != 0) {
            sync = true;
        }
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        boolean $i$f$smartUpdate = false;
        Data currentData = AfflictionPlayerAttachment.getData(player);
        Data newData = (Data)operations.invoke((Object)currentData);
        AfflictionPlayerAttachment.setData(player, newData, false);
        if (sync && player.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player, newData);
        }
        return newData;
    }

    private final Map<String, Object> detectChanges(Data oldData, Data newData) {
        Map changes = new LinkedHashMap();
        Iterable $this$forEach$iv = SyncFieldRegistry.INSTANCE.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object newValue;
            FieldDefinition field = (FieldDefinition)element$iv;
            boolean bl = false;
            Object oldValue = field.getGetter().invoke((Object)oldData);
            if (Intrinsics.areEqual((Object)oldValue, (Object)(newValue = field.getGetter().invoke((Object)newData)))) continue;
            changes.put(field.getPath(), newValue);
        }
        return changes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b1\n\u0002\u0018\u0002\n\u0002\b&\b\u0086\b\u0018\u0000 \u00b9\u00012\u00020\u0001:\u0002\u00b9\u0001Bk\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\bJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0005J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u0014\u0010,\u001a\u00020\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\bJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\bJ\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0005J\u0006\u00103\u001a\u00020\u0005J\u0006\u00104\u001a\u00020\u0005J\u0006\u00105\u001a\u00020\u0005J\u0006\u00106\u001a\u00020 J\u0006\u00107\u001a\u00020 J\u0006\u00108\u001a\u00020 J\u0006\u00109\u001a\u00020\u0005J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0010J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u0010J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u0010J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0005J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0005J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0005J\u001f\u0010E\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00052\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010GJ!\u0010H\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u00052\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010GJ\u0010\u0010J\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0006\u0010K\u001a\u00020\u0000J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0005J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020;J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010S\u001a\u00020;J\u0006\u0010U\u001a\u00020\u0000J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020=J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010W\u001a\u00020=J\u0006\u0010Y\u001a\u00020\u0000J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010W\u001a\u00020=J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010W\u001a\u00020=J\u0006\u0010\\\u001a\u00020\u0000J\u0010\u0010]\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0006\u0010^\u001a\u00020\u0000J\u0010\u0010_\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0006\u0010`\u001a\u00020\u0000J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020=0bJ\u0006\u0010c\u001a\u00020 J\u0006\u0010d\u001a\u00020\u0005J\u0006\u0010e\u001a\u00020\u0005J\u0006\u0010f\u001a\u00020 J\u0006\u0010g\u001a\u00020\u0005J\u0006\u0010h\u001a\u00020\u0005J\u0006\u0010i\u001a\u00020\u0005J\u0006\u0010j\u001a\u00020\u0005J\u0006\u0010k\u001a\u00020 J\u0006\u0010l\u001a\u00020 J\u0006\u0010m\u001a\u00020 J\u0014\u0010n\u001a\u00020\u00002\f\u0010o\u001a\b\u0012\u0004\u0012\u00020=0bJ\u000e\u0010p\u001a\u00020\u00002\u0006\u0010q\u001a\u00020 J\u000e\u0010r\u001a\u00020\u00002\u0006\u0010s\u001a\u00020\u0005J\u000e\u0010t\u001a\u00020\u00002\u0006\u0010s\u001a\u00020\u0005J\u000e\u0010u\u001a\u00020\u00002\u0006\u0010@\u001a\u00020 J\u000e\u0010v\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000e\u0010x\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000e\u0010y\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000e\u0010z\u001a\u00020\u00002\u0006\u0010s\u001a\u00020\u0005J\u000e\u0010{\u001a\u00020\u00002\u0006\u0010|\u001a\u00020 J\u000e\u0010}\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000e\u0010~\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u0010\u0010\u007f\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u0080\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u0081\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u0082\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u0083\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u0084\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\r\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020=0\u0010J\u0007\u0010\u0086\u0001\u001a\u00020\u0005J\u0007\u0010\u0087\u0001\u001a\u00020 J\u0007\u0010\u0088\u0001\u001a\u00020\u0005J\u0007\u0010\u0089\u0001\u001a\u00020\u0005J\u0007\u0010\u008a\u0001\u001a\u00020 J\u0007\u0010\u008b\u0001\u001a\u00020 J\u0007\u0010\u008c\u0001\u001a\u00020 J\u0007\u0010\u008d\u0001\u001a\u00020\u0005J\r\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020;0\u0010J\u0007\u0010\u008f\u0001\u001a\u00020\u0005J\u0007\u0010\u0090\u0001\u001a\u00020 J\u0007\u0010\u0091\u0001\u001a\u00020 J\u0011\u0010\u0092\u0001\u001a\u00020\u00052\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001J\u0010\u0010\u0095\u0001\u001a\u00020\u00002\u0007\u0010\u0096\u0001\u001a\u00020=J\u0016\u0010\u0097\u0001\u001a\u00020\u00002\r\u0010\u0098\u0001\u001a\b\u0012\u0004\u0012\u00020=0\u0010J\u000f\u0010\u0099\u0001\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000f\u0010\u009a\u0001\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000f\u0010\u009b\u0001\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u000f\u0010\u009c\u0001\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u0005J\u0015\u0010\u009d\u0001\u001a\u00020\u00002\f\u0010w\u001a\b\u0012\u0004\u0012\u00020;0\u0010J\u0011\u0010\u009e\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u000f\u0010\u009f\u0001\u001a\u00020\u00002\u0006\u0010@\u001a\u00020 J\u0011\u0010\u00a0\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u0011\u0010\u00a1\u0001\u001a\u00020\u00002\b\b\u0002\u0010I\u001a\u00020\u0005J\u000f\u0010\u00a2\u0001\u001a\u00020\u00002\u0006\u0010@\u001a\u00020 J\u000f\u0010\u00a3\u0001\u001a\u00020\u00002\u0006\u0010@\u001a\u00020 J\u0010\u0010\u00a4\u0001\u001a\u00020\u00002\u0007\u0010\u00a5\u0001\u001a\u00020 J\u0011\u0010\u00a6\u0001\u001a\u00020\u00002\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001J\u0010\u0010\u00a7\u0001\u001a\u00020\u00002\u0007\u0010\u00a8\u0001\u001a\u00020\u0005J\u000f\u0010\u00a9\u0001\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u000f\u0010\u00aa\u0001\u001a\u00020\u00002\u0006\u0010M\u001a\u00020 J\u001c\u0010\u00ab\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c0\u0003\u00a2\u0006\u0003\b\u00ac\u0001J\n\u0010\u00ad\u0001\u001a\u00020\u0005H\u00c2\u0003J\u001c\u0010\u00ae\u0001\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003H\u00c0\u0003\u00a2\u0006\u0003\b\u00af\u0001J\n\u0010\u00b0\u0001\u001a\u00020\nH\u00c6\u0003J\n\u0010\u00b1\u0001\u001a\u00020\fH\u00c6\u0003J\n\u0010\u00b2\u0001\u001a\u00020\u000eH\u00c6\u0003J\u0010\u0010\u00b3\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u00c2\u0003Jn\u0010\u00b4\u0001\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u00c6\u0001J\u0015\u0010\u00b5\u0001\u001a\u00020 2\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010\u00b7\u0001\u001a\u00020\u0005H\u00d6\u0001J\n\u0010\u00b8\u0001\u001a\u00020\bH\u00d6\u0001R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ba\u0001"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "", "afflictionLevels", "", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "", "abilityIndex", "abilityCooldowns", "", "vampData", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData;", "wereData", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData;", "lichData", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData;", "selectedAbilities", "", "<init>", "(Ljava/util/Map;ILjava/util/Map;Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData;Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData;Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData;Ljava/util/List;)V", "getAfflictionLevels$witchery", "()Ljava/util/Map;", "getAbilityCooldowns$witchery", "getVampData", "()Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData;", "getWereData", "()Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData;", "getLichData", "()Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData;", "getWerewolfLevel", "getVampireLevel", "getLichLevel", "getAnyLevel", "", "setLevel", "type", "level", "getAbilityIndex", "withAbilityIndex", "index", "getAbilityCooldown", "ability", "withAbilityCooldown", "cooldown", "getSelectedAbilities", "withSelectedAbilities", "abilities", "addSelectedAbility", "abilityId", "removeSelectedAbility", "clearSelectedAbilities", "getKilledBlazes", "getUsedSunGrenades", "getNightTicker", "getInSunTick", "hasNightVision", "hasSpeedBoost", "isBatForm", "getMaxInSunTickClient", "getVisitedVillages", "", "getVillagersHalfBlood", "Ljava/util/UUID;", "getTrappedVillagers", "withKilledBlazes", "killed", "withUsedSunGrenades", "used", "withNightTicker", "ticks", "withInSunTick", "maxTicks", "(ILjava/lang/Integer;)Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "incrementInSunTick", "by", "decrementInSunTick", "incrementNightTicker", "withNightVision", "active", "withSpeedBoost", "withBatForm", "withMaxInSunTickClient", "value", "addVisitedVillage", "pos", "removeVisitedVillage", "clearVisitedVillages", "addVillagerHalfBlood", "uuid", "removeVillagerHalfBlood", "clearVillagerHalfBlood", "addTrappedVillager", "removeTrappedVillager", "clearTrappedVillager", "incrementKilledBlazes", "clearKilledBlazes", "incrementUsedSunGrenades", "clearUsedSunGrenades", "getLycanSource", "Ljava/util/Optional;", "hasGivenGold", "getKilledSheep", "getKilledWolves", "hasKilledHornedOne", "getAirSlayMonster", "getNightHowl", "getWolfPack", "getPigmenKilled", "hasSpreadLycanthropy", "isWolfManForm", "isWolfForm", "withLycanSource", "src", "withGivenGold", "given", "withKilledSheep", "kills", "withKilledWolves", "withKilledHornedOne", "withAirSlayMonster", "count", "withNightHowl", "withWolfPack", "withPigmenKilled", "withSpreadLycanthropy", "spread", "withWolfManForm", "withWolfForm", "incrementKilledSheep", "incrementKilledWolves", "incrementAirSlayMonster", "incrementNightHowl", "incrementWolfPack", "incrementPigmenKilled", "getReadTablets", "getBoundSouls", "hasZombieKilledMob", "getKilledGolems", "getDrainedAnimals", "hasPossessedKillVillager", "hasKilledWither", "isPhylacteryBound", "getPhylacteryDeaths", "getPhylacteryDeathTimes", "getPhylacterySouls", "isSoulForm", "isVagrant", "getPhylacteryDeathsInOneNight", "player", "Lnet/minecraft/server/level/ServerPlayer;", "addReadTablet", "tabletId", "withReadTablets", "list", "withGolemKills", "withDrainedAnimals", "withBoundSouls", "withPhylacteryDeaths", "withPhylacteryDeathTimes", "incrementBoundSouls", "withZombieKilledMob", "incrementKilledGolems", "incrementDrainedAnimals", "withPossessedKillVillager", "withKilledWither", "withPhylacteryBound", "bound", "incrementPhylacteryDeaths", "withPhylacterySouls", "souls", "withSoulForm", "withVagrant", "component1", "component1$witchery", "component2", "component3", "component3$witchery", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Companion", "witchery"})
    @SourceDebugExtension(value={"SMAP\nAfflictionPlayerAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,526:1\n188#2,3:527\n1788#3,4:530\n*S KotlinDebug\n*F\n+ 1 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data\n*L\n115#1:527,3\n329#1:530,4\n*E\n"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<AfflictionTypes, Integer> afflictionLevels;
        private final int abilityIndex;
        @NotNull
        private final Map<String, Integer> abilityCooldowns;
        @NotNull
        private final VampData vampData;
        @NotNull
        private final WereData wereData;
        @NotNull
        private final LichData lichData;
        @NotNull
        private final List<String> selectedAbilities;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@NotNull Map<AfflictionTypes, Integer> afflictionLevels, int abilityIndex, @NotNull Map<String, Integer> abilityCooldowns, @NotNull VampData vampData, @NotNull WereData wereData, @NotNull LichData lichData, @NotNull List<String> selectedAbilities) {
            Intrinsics.checkNotNullParameter(afflictionLevels, (String)"afflictionLevels");
            Intrinsics.checkNotNullParameter(abilityCooldowns, (String)"abilityCooldowns");
            Intrinsics.checkNotNullParameter((Object)vampData, (String)"vampData");
            Intrinsics.checkNotNullParameter((Object)wereData, (String)"wereData");
            Intrinsics.checkNotNullParameter((Object)lichData, (String)"lichData");
            Intrinsics.checkNotNullParameter(selectedAbilities, (String)"selectedAbilities");
            this.afflictionLevels = afflictionLevels;
            this.abilityIndex = abilityIndex;
            this.abilityCooldowns = abilityCooldowns;
            this.vampData = vampData;
            this.wereData = wereData;
            this.lichData = lichData;
            this.selectedAbilities = selectedAbilities;
        }

        public /* synthetic */ Data(Map map, int n, Map map2, VampData vampData, WereData wereData, LichData lichData, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                map = new LinkedHashMap();
            }
            if ((n2 & 2) != 0) {
                n = -1;
            }
            if ((n2 & 4) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n2 & 8) != 0) {
                vampData = new VampData(0, 0, false, false, false, 0, 0, 0, null, null, null, 2047, null);
            }
            if ((n2 & 0x10) != 0) {
                wereData = new WereData(0, 0, false, 0, 0, 0, 0, false, false, false, null, false, 4095, null);
            }
            if ((n2 & 0x20) != 0) {
                lichData = new LichData(null, 0, false, 0, 0, false, false, false, 0, null, 0, false, false, 8191, null);
            }
            if ((n2 & 0x40) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(map, n, map2, vampData, wereData, lichData, list);
        }

        @NotNull
        public final Map<AfflictionTypes, Integer> getAfflictionLevels$witchery() {
            return this.afflictionLevels;
        }

        @NotNull
        public final Map<String, Integer> getAbilityCooldowns$witchery() {
            return this.abilityCooldowns;
        }

        @NotNull
        public final VampData getVampData() {
            return this.vampData;
        }

        @NotNull
        public final WereData getWereData() {
            return this.wereData;
        }

        @NotNull
        public final LichData getLichData() {
            return this.lichData;
        }

        public final int getWerewolfLevel() {
            return ((Number)this.afflictionLevels.getOrDefault((Object)AfflictionTypes.LYCANTHROPY, 0)).intValue();
        }

        public final int getVampireLevel() {
            return ((Number)this.afflictionLevels.getOrDefault((Object)AfflictionTypes.VAMPIRISM, 0)).intValue();
        }

        public final int getLichLevel() {
            return ((Number)this.afflictionLevels.getOrDefault((Object)AfflictionTypes.LICHDOM, 0)).intValue();
        }

        public final boolean getAnyLevel() {
            boolean bl;
            block3: {
                Map<AfflictionTypes, Integer> $this$any$iv = this.afflictionLevels;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<AfflictionTypes, Integer>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<AfflictionTypes, Integer> element$iv;
                        Map.Entry<AfflictionTypes, Integer> it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(((Number)it.getValue()).intValue() > 0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final Data setLevel(@NotNull AfflictionTypes type, int level) {
            Data data2;
            boolean shouldClearAbilities;
            boolean hadAffliction;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Map newLevels = MapsKt.toMutableMap(this.afflictionLevels);
            boolean bl = hadAffliction = ((Number)newLevels.getOrDefault((Object)type, 0)).intValue() > 0;
            if (level <= 0) {
                newLevels.remove((Object)type);
            } else {
                newLevels.put(type, level);
            }
            boolean bl2 = shouldClearAbilities = hadAffliction && level <= 0 || level > 0 && !hadAffliction;
            if (shouldClearAbilities) {
                List list = CollectionsKt.emptyList();
                data2 = Data.copy$default(this, newLevels, -1, null, null, null, null, list, 60, null);
            } else {
                data2 = Data.copy$default(this, newLevels, 0, null, null, null, null, null, 126, null);
            }
            return data2;
        }

        public final int getAbilityIndex() {
            return this.abilityIndex;
        }

        @NotNull
        public final Data withAbilityIndex(int index) {
            return Data.copy$default(this, null, index, null, null, null, null, null, 125, null);
        }

        public final int getAbilityCooldown(@NotNull String ability) {
            Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
            return ((Number)this.abilityCooldowns.getOrDefault(ability, 0)).intValue();
        }

        @NotNull
        public final Data withAbilityCooldown(@NotNull String ability, int cooldown) {
            Intrinsics.checkNotNullParameter((Object)ability, (String)"ability");
            Map newCooldowns = MapsKt.toMutableMap(this.abilityCooldowns);
            if (cooldown <= 0) {
                newCooldowns.remove(ability);
            } else {
                newCooldowns.put(ability, cooldown);
            }
            return Data.copy$default(this, null, 0, newCooldowns, null, null, null, null, 123, null);
        }

        @NotNull
        public final List<String> getSelectedAbilities() {
            return CollectionsKt.take((Iterable)this.selectedAbilities, (int)5);
        }

        @NotNull
        public final Data withSelectedAbilities(@NotNull List<String> abilities) {
            Intrinsics.checkNotNullParameter(abilities, (String)"abilities");
            return Data.copy$default(this, null, 0, null, null, null, null, CollectionsKt.take((Iterable)abilities, (int)5), 63, null);
        }

        @NotNull
        public final Data addSelectedAbility(@NotNull String abilityId) {
            Intrinsics.checkNotNullParameter((Object)abilityId, (String)"abilityId");
            if (this.selectedAbilities.size() >= 5 || this.selectedAbilities.contains(abilityId)) {
                return this;
            }
            return Data.copy$default(this, null, 0, null, null, null, null, CollectionsKt.plus((Collection)this.selectedAbilities, (Object)abilityId), 63, null);
        }

        @NotNull
        public final Data removeSelectedAbility(@NotNull String abilityId) {
            Intrinsics.checkNotNullParameter((Object)abilityId, (String)"abilityId");
            return Data.copy$default(this, null, 0, null, null, null, null, CollectionsKt.minus((Iterable)this.selectedAbilities, (Object)abilityId), 63, null);
        }

        @NotNull
        public final Data clearSelectedAbilities() {
            return Data.copy$default(this, null, 0, null, null, null, null, CollectionsKt.emptyList(), 63, null);
        }

        public final int getKilledBlazes() {
            return this.vampData.getKilledBlazes();
        }

        public final int getUsedSunGrenades() {
            return this.vampData.getUsedSunGrenades();
        }

        public final int getNightTicker() {
            return this.vampData.getNightTicker();
        }

        public final int getInSunTick() {
            return this.vampData.getInSunTick();
        }

        public final boolean hasNightVision() {
            return this.vampData.isNightVisionActive();
        }

        public final boolean hasSpeedBoost() {
            return this.vampData.isSpeedBoostActive();
        }

        public final boolean isBatForm() {
            return this.vampData.isBatFormActive();
        }

        public final int getMaxInSunTickClient() {
            return this.vampData.getMaxInSunTickClient();
        }

        @NotNull
        public final List<Long> getVisitedVillages() {
            return this.vampData.getVisitedVillages();
        }

        @NotNull
        public final List<UUID> getVillagersHalfBlood() {
            return this.vampData.getVillagersHalfBlood();
        }

        @NotNull
        public final List<UUID> getTrappedVillagers() {
            return this.vampData.getTrappedVillagers();
        }

        @NotNull
        public final Data withKilledBlazes(int killed) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, killed, 0, false, false, false, 0, 0, 0, null, null, null, 2046, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withUsedSunGrenades(int used) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, used, false, false, false, 0, 0, 0, null, null, null, 2045, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withNightTicker(int ticks) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, ticks, 0, 0, null, null, null, 2015, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withInSunTick(int ticks, @Nullable Integer maxTicks) {
            int clamped = maxTicks != null ? RangesKt.coerceIn((int)ticks, (int)0, (int)maxTicks) : RangesKt.coerceAtLeast((int)ticks, (int)0);
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, clamped, 0, null, null, null, 1983, null), null, null, null, 119, null);
        }

        public static /* synthetic */ Data withInSunTick$default(Data data2, int n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = null;
            }
            return data2.withInSunTick(n, n2);
        }

        @NotNull
        public final Data incrementInSunTick(int by, @Nullable Integer maxTicks) {
            int newValue = this.vampData.getInSunTick() + by;
            int clamped = maxTicks != null ? RangesKt.coerceIn((int)newValue, (int)0, (int)maxTicks) : RangesKt.coerceAtLeast((int)newValue, (int)0);
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, clamped, 0, null, null, null, 1983, null), null, null, null, 119, null);
        }

        public static /* synthetic */ Data incrementInSunTick$default(Data data2, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 1;
            }
            if ((n3 & 2) != 0) {
                n2 = null;
            }
            return data2.incrementInSunTick(n, n2);
        }

        @NotNull
        public final Data decrementInSunTick(int by) {
            int newValue = RangesKt.coerceAtLeast((int)(this.vampData.getInSunTick() - by), (int)0);
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, newValue, 0, null, null, null, 1983, null), null, null, null, 119, null);
        }

        public static /* synthetic */ Data decrementInSunTick$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.decrementInSunTick(n);
        }

        @NotNull
        public final Data incrementNightTicker() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, this.vampData.getNightTicker() + 1, 0, 0, null, null, null, 2015, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withNightVision(boolean active) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, active, false, false, 0, 0, 0, null, null, null, 2043, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withSpeedBoost(boolean active) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, active, false, 0, 0, 0, null, null, null, 2039, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withBatForm(boolean active) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, active, 0, 0, 0, null, null, null, 2031, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data withMaxInSunTickClient(int value) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, value, null, null, null, 1919, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data addVisitedVillage(long pos) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, CollectionsKt.plus((Collection)this.vampData.getVisitedVillages(), (Object)pos), null, null, 1791, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data removeVisitedVillage(long pos) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, CollectionsKt.minus((Iterable)this.vampData.getVisitedVillages(), (Object)pos), null, null, 1791, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data clearVisitedVillages() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, CollectionsKt.emptyList(), null, null, 1791, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data addVillagerHalfBlood(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, CollectionsKt.plus((Collection)this.vampData.getVillagersHalfBlood(), (Object)uuid), null, 1535, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data removeVillagerHalfBlood(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, CollectionsKt.minus((Iterable)this.vampData.getVillagersHalfBlood(), (Object)uuid), null, 1535, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data clearVillagerHalfBlood() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, CollectionsKt.emptyList(), null, 1535, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data addTrappedVillager(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, null, CollectionsKt.plus((Collection)this.vampData.getTrappedVillagers(), (Object)uuid), 1023, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data removeTrappedVillager(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, null, CollectionsKt.minus((Iterable)this.vampData.getTrappedVillagers(), (Object)uuid), 1023, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data clearTrappedVillager() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, null, CollectionsKt.emptyList(), 1023, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data incrementKilledBlazes(int by) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, this.vampData.getKilledBlazes() + by, 0, false, false, false, 0, 0, 0, null, null, null, 2046, null), null, null, null, 119, null);
        }

        public static /* synthetic */ Data incrementKilledBlazes$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementKilledBlazes(n);
        }

        @NotNull
        public final Data clearKilledBlazes() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, null, null, 2046, null), null, null, null, 119, null);
        }

        @NotNull
        public final Data incrementUsedSunGrenades(int by) {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, this.vampData.getUsedSunGrenades() + by, false, false, false, 0, 0, 0, null, null, null, 2045, null), null, null, null, 119, null);
        }

        public static /* synthetic */ Data incrementUsedSunGrenades$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementUsedSunGrenades(n);
        }

        @NotNull
        public final Data clearUsedSunGrenades() {
            return Data.copy$default(this, null, 0, null, VampData.copy$default(this.vampData, 0, 0, false, false, false, 0, 0, 0, null, null, null, 2045, null), null, null, null, 119, null);
        }

        @NotNull
        public final Optional<UUID> getLycanSource() {
            return this.wereData.getLycanSourceUUID();
        }

        public final boolean hasGivenGold() {
            return this.wereData.getHasGivenGold();
        }

        public final int getKilledSheep() {
            return this.wereData.getKilledSheep();
        }

        public final int getKilledWolves() {
            return this.wereData.getKilledWolves();
        }

        public final boolean hasKilledHornedOne() {
            return this.wereData.getKillHornedOne();
        }

        public final int getAirSlayMonster() {
            return this.wereData.getAirSlayMonster();
        }

        public final int getNightHowl() {
            return this.wereData.getNightHowl();
        }

        public final int getWolfPack() {
            return this.wereData.getWolfPack();
        }

        public final int getPigmenKilled() {
            return this.wereData.getPigmenKilled();
        }

        public final boolean hasSpreadLycanthropy() {
            return this.wereData.getSpreadLycanthropy();
        }

        public final boolean isWolfManForm() {
            return this.wereData.isWolfManFormActive();
        }

        public final boolean isWolfForm() {
            return this.wereData.isWolfFormActive();
        }

        @NotNull
        public final Data withLycanSource(@NotNull Optional<UUID> src) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, 0, false, false, false, src, false, 3071, null), null, null, 111, null);
        }

        @NotNull
        public final Data withGivenGold(boolean given) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, 0, false, false, false, null, given, 2047, null), null, null, 111, null);
        }

        @NotNull
        public final Data withKilledSheep(int kills) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, kills, 0, false, 0, 0, 0, 0, false, false, false, null, false, 4094, null), null, null, 111, null);
        }

        @NotNull
        public final Data withKilledWolves(int kills) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, kills, false, 0, 0, 0, 0, false, false, false, null, false, 4093, null), null, null, 111, null);
        }

        @NotNull
        public final Data withKilledHornedOne(boolean killed) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, killed, 0, 0, 0, 0, false, false, false, null, false, 4091, null), null, null, 111, null);
        }

        @NotNull
        public final Data withAirSlayMonster(int count) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, count, 0, 0, 0, false, false, false, null, false, 4087, null), null, null, 111, null);
        }

        @NotNull
        public final Data withNightHowl(int count) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, count, 0, 0, false, false, false, null, false, 4079, null), null, null, 111, null);
        }

        @NotNull
        public final Data withWolfPack(int count) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, count, 0, false, false, false, null, false, 4063, null), null, null, 111, null);
        }

        @NotNull
        public final Data withPigmenKilled(int kills) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, kills, false, false, false, null, false, 4031, null), null, null, 111, null);
        }

        @NotNull
        public final Data withSpreadLycanthropy(boolean spread) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, 0, spread, false, false, null, false, 3967, null), null, null, 111, null);
        }

        @NotNull
        public final Data withWolfManForm(boolean active) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, 0, false, active, false, null, false, 3839, null), null, null, 111, null);
        }

        @NotNull
        public final Data withWolfForm(boolean active) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, 0, false, false, active, null, false, 3583, null), null, null, 111, null);
        }

        @NotNull
        public final Data incrementKilledSheep(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, this.wereData.getKilledSheep() + by, 0, false, 0, 0, 0, 0, false, false, false, null, false, 4094, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementKilledSheep$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementKilledSheep(n);
        }

        @NotNull
        public final Data incrementKilledWolves(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, this.wereData.getKilledWolves() + by, false, 0, 0, 0, 0, false, false, false, null, false, 4093, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementKilledWolves$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementKilledWolves(n);
        }

        @NotNull
        public final Data incrementAirSlayMonster(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, this.wereData.getAirSlayMonster() + by, 0, 0, 0, false, false, false, null, false, 4087, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementAirSlayMonster$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementAirSlayMonster(n);
        }

        @NotNull
        public final Data incrementNightHowl(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, this.wereData.getNightHowl() + by, 0, 0, false, false, false, null, false, 4079, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementNightHowl$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementNightHowl(n);
        }

        @NotNull
        public final Data incrementWolfPack(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, this.wereData.getWolfPack() + by, 0, false, false, false, null, false, 4063, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementWolfPack$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementWolfPack(n);
        }

        @NotNull
        public final Data incrementPigmenKilled(int by) {
            return Data.copy$default(this, null, 0, null, null, WereData.copy$default(this.wereData, 0, 0, false, 0, 0, 0, this.wereData.getPigmenKilled() + by, false, false, false, null, false, 4031, null), null, null, 111, null);
        }

        public static /* synthetic */ Data incrementPigmenKilled$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementPigmenKilled(n);
        }

        @NotNull
        public final List<UUID> getReadTablets() {
            return this.lichData.getReadTablets();
        }

        public final int getBoundSouls() {
            return this.lichData.getBoundSouls();
        }

        public final boolean hasZombieKilledMob() {
            return this.lichData.getZombieKilledMob();
        }

        public final int getKilledGolems() {
            return this.lichData.getKilledGolems();
        }

        public final int getDrainedAnimals() {
            return this.lichData.getDrainedAnimals();
        }

        public final boolean hasPossessedKillVillager() {
            return this.lichData.getPossessedKillVillager();
        }

        public final boolean hasKilledWither() {
            return this.lichData.getKilledWither();
        }

        public final boolean isPhylacteryBound() {
            return this.lichData.getPhylacteryBound();
        }

        public final int getPhylacteryDeaths() {
            return this.lichData.getPhylacteryDeaths();
        }

        @NotNull
        public final List<Long> getPhylacteryDeathTimes() {
            return this.lichData.getPhylacteryDeathTimes();
        }

        public final int getPhylacterySouls() {
            return this.lichData.getPhylacterySouls();
        }

        public final boolean isSoulForm() {
            return this.lichData.isSoulFormActive();
        }

        public final boolean isVagrant() {
            return this.lichData.isVagrant();
        }

        public final int getPhylacteryDeathsInOneNight(@NotNull ServerPlayer player) {
            int n;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            long oneNightAgo = player.level().getGameTime() - (long)12000;
            Iterable $this$count$iv = this.lichData.getPhylacteryDeathTimes();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl = false;
                    if (!(it > oneNightAgo) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n;
        }

        @NotNull
        public final Data addReadTablet(@NotNull UUID tabletId) {
            Intrinsics.checkNotNullParameter((Object)tabletId, (String)"tabletId");
            if (this.lichData.getReadTablets().contains(tabletId)) {
                return this;
            }
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, CollectionsKt.plus((Collection)this.lichData.getReadTablets(), (Object)tabletId), 0, false, 0, 0, false, false, false, 0, null, 0, false, false, 8190, null), null, 95, null);
        }

        @NotNull
        public final Data withReadTablets(@NotNull List<UUID> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, list, 0, false, 0, 0, false, false, false, 0, null, 0, false, false, 8190, null), null, 95, null);
        }

        @NotNull
        public final Data withGolemKills(int count) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, count, 0, false, false, false, 0, null, 0, false, false, 8183, null), null, 95, null);
        }

        @NotNull
        public final Data withDrainedAnimals(int count) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, count, false, false, false, 0, null, 0, false, false, 8175, null), null, 95, null);
        }

        @NotNull
        public final Data withBoundSouls(int count) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, count, false, 0, 0, false, false, false, 0, null, 0, false, false, 8189, null), null, 95, null);
        }

        @NotNull
        public final Data withPhylacteryDeaths(int count) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, count, null, 0, false, false, 7935, null), null, 95, null);
        }

        @NotNull
        public final Data withPhylacteryDeathTimes(@NotNull List<Long> count) {
            Intrinsics.checkNotNullParameter(count, (String)"count");
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, 0, count, 0, false, false, 7679, null), null, 95, null);
        }

        @NotNull
        public final Data incrementBoundSouls(int by) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, this.lichData.getBoundSouls() + by, false, 0, 0, false, false, false, 0, null, 0, false, false, 8189, null), null, 95, null);
        }

        public static /* synthetic */ Data incrementBoundSouls$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementBoundSouls(n);
        }

        @NotNull
        public final Data withZombieKilledMob(boolean killed) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, killed, 0, 0, false, false, false, 0, null, 0, false, false, 8187, null), null, 95, null);
        }

        @NotNull
        public final Data incrementKilledGolems(int by) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, this.lichData.getKilledGolems() + by, 0, false, false, false, 0, null, 0, false, false, 8183, null), null, 95, null);
        }

        public static /* synthetic */ Data incrementKilledGolems$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementKilledGolems(n);
        }

        @NotNull
        public final Data incrementDrainedAnimals(int by) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, this.lichData.getDrainedAnimals() + by, false, false, false, 0, null, 0, false, false, 8175, null), null, 95, null);
        }

        public static /* synthetic */ Data incrementDrainedAnimals$default(Data data2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return data2.incrementDrainedAnimals(n);
        }

        @NotNull
        public final Data withPossessedKillVillager(boolean killed) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, killed, false, false, 0, null, 0, false, false, 8159, null), null, 95, null);
        }

        @NotNull
        public final Data withKilledWither(boolean killed) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, killed, false, 0, null, 0, false, false, 8127, null), null, 95, null);
        }

        @NotNull
        public final Data withPhylacteryBound(boolean bound) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, bound, 0, null, 0, false, false, 8063, null), null, 95, null);
        }

        @NotNull
        public final Data incrementPhylacteryDeaths(@NotNull ServerPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            long gameTime = player.level().getGameTime();
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, this.lichData.getPhylacteryDeaths() + 1, CollectionsKt.plus((Collection)this.lichData.getPhylacteryDeathTimes(), (Object)gameTime), 0, false, false, 7423, null), null, 95, null);
        }

        @NotNull
        public final Data withPhylacterySouls(int souls) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, 0, null, RangesKt.coerceIn((int)souls, (int)0, (int)3), false, false, 7167, null), null, 95, null);
        }

        @NotNull
        public final Data withSoulForm(boolean active) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, 0, null, 0, active, false, 6143, null), null, 95, null);
        }

        @NotNull
        public final Data withVagrant(boolean active) {
            return Data.copy$default(this, null, 0, null, null, null, LichData.copy$default(this.lichData, null, 0, false, 0, 0, false, false, false, 0, null, 0, false, active, 4095, null), null, 95, null);
        }

        @NotNull
        public final Map<AfflictionTypes, Integer> component1$witchery() {
            return this.afflictionLevels;
        }

        private final int component2() {
            return this.abilityIndex;
        }

        @NotNull
        public final Map<String, Integer> component3$witchery() {
            return this.abilityCooldowns;
        }

        @NotNull
        public final VampData component4() {
            return this.vampData;
        }

        @NotNull
        public final WereData component5() {
            return this.wereData;
        }

        @NotNull
        public final LichData component6() {
            return this.lichData;
        }

        private final List<String> component7() {
            return this.selectedAbilities;
        }

        @NotNull
        public final Data copy(@NotNull Map<AfflictionTypes, Integer> afflictionLevels, int abilityIndex, @NotNull Map<String, Integer> abilityCooldowns, @NotNull VampData vampData, @NotNull WereData wereData, @NotNull LichData lichData, @NotNull List<String> selectedAbilities) {
            Intrinsics.checkNotNullParameter(afflictionLevels, (String)"afflictionLevels");
            Intrinsics.checkNotNullParameter(abilityCooldowns, (String)"abilityCooldowns");
            Intrinsics.checkNotNullParameter((Object)vampData, (String)"vampData");
            Intrinsics.checkNotNullParameter((Object)wereData, (String)"wereData");
            Intrinsics.checkNotNullParameter((Object)lichData, (String)"lichData");
            Intrinsics.checkNotNullParameter(selectedAbilities, (String)"selectedAbilities");
            return new Data(afflictionLevels, abilityIndex, abilityCooldowns, vampData, wereData, lichData, selectedAbilities);
        }

        public static /* synthetic */ Data copy$default(Data data2, Map map, int n, Map map2, VampData vampData, WereData wereData, LichData lichData, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                map = data2.afflictionLevels;
            }
            if ((n2 & 2) != 0) {
                n = data2.abilityIndex;
            }
            if ((n2 & 4) != 0) {
                map2 = data2.abilityCooldowns;
            }
            if ((n2 & 8) != 0) {
                vampData = data2.vampData;
            }
            if ((n2 & 0x10) != 0) {
                wereData = data2.wereData;
            }
            if ((n2 & 0x20) != 0) {
                lichData = data2.lichData;
            }
            if ((n2 & 0x40) != 0) {
                list = data2.selectedAbilities;
            }
            return data2.copy(map, n, map2, vampData, wereData, lichData, list);
        }

        @NotNull
        public String toString() {
            return "Data(afflictionLevels=" + this.afflictionLevels + ", abilityIndex=" + this.abilityIndex + ", abilityCooldowns=" + this.abilityCooldowns + ", vampData=" + this.vampData + ", wereData=" + this.wereData + ", lichData=" + this.lichData + ", selectedAbilities=" + this.selectedAbilities + ")";
        }

        public int hashCode() {
            int result = ((Object)this.afflictionLevels).hashCode();
            result = result * 31 + Integer.hashCode(this.abilityIndex);
            result = result * 31 + ((Object)this.abilityCooldowns).hashCode();
            result = result * 31 + this.vampData.hashCode();
            result = result * 31 + this.wereData.hashCode();
            result = result * 31 + this.lichData.hashCode();
            result = result * 31 + ((Object)this.selectedAbilities).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual(this.afflictionLevels, data2.afflictionLevels)) {
                return false;
            }
            if (this.abilityIndex != data2.abilityIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.abilityCooldowns, data2.abilityCooldowns)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vampData, (Object)data2.vampData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wereData, (Object)data2.wereData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lichData, (Object)data2.lichData)) {
                return false;
            }
            return Intrinsics.areEqual(this.selectedAbilities, data2.selectedAbilities);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.unboundedMap((Codec)((Codec)StringRepresentable.fromEnum(AfflictionTypes::values)), (Codec)((Codec)Codec.INT)).fieldOf("afflictionLevels").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("abilityIndex").forGetter(Data::CODEC$lambda$0$1), (App)Codec.unboundedMap((Codec)((Codec)Codec.STRING), (Codec)((Codec)Codec.INT)).fieldOf("abilityCooldowns").forGetter(Data::CODEC$lambda$0$2), (App)VampData.Companion.getCODEC().fieldOf("vampData").forGetter(Data::CODEC$lambda$0$3), (App)WereData.Companion.getCODEC().fieldOf("wereData").forGetter(Data::CODEC$lambda$0$4), (App)LichData.Companion.getCODEC().fieldOf("lichData").forGetter(Data::CODEC$lambda$0$5), (App)Codec.STRING.listOf().optionalFieldOf("selectedAbilities", (Object)CollectionsKt.emptyList()).forGetter(Data::CODEC$lambda$0$6)).apply((Applicative)instance, Data::CODEC$lambda$0$7);
        }

        private static final Map CODEC$lambda$0$0(Data it) {
            return it.afflictionLevels;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.abilityIndex;
        }

        private static final Map CODEC$lambda$0$2(Data it) {
            return it.abilityCooldowns;
        }

        private static final VampData CODEC$lambda$0$3(Data it) {
            return it.vampData;
        }

        private static final WereData CODEC$lambda$0$4(Data it) {
            return it.wereData;
        }

        private static final LichData CODEC$lambda$0$5(Data it) {
            return it.lichData;
        }

        private static final List CODEC$lambda$0$6(Data it) {
            return it.selectedAbilities;
        }

        private static final Data CODEC$lambda$0$7(Map levels, Integer index, Map cooldowns, VampData vamp, WereData were, LichData lich, List sel) {
            Intrinsics.checkNotNull((Object)levels);
            Intrinsics.checkNotNull((Object)index);
            int n = index;
            Intrinsics.checkNotNull((Object)cooldowns);
            Intrinsics.checkNotNull((Object)vamp);
            Intrinsics.checkNotNull((Object)were);
            Intrinsics.checkNotNull((Object)lich);
            Intrinsics.checkNotNull((Object)sel);
            return new Data(levels, n, cooldowns, vamp, were, lich, sel);
        }

        public Data() {
            this(null, 0, null, null, null, null, null, 127, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("affliction_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b%\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B\u0095\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0012\u001a\u00020\b\u0012\b\b\u0002\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\bH\u00c6\u0003J\u0097\u0001\u00101\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\bH\u00c6\u0001J\u0013\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u00020\u0006H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010\u0012\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u001bR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001b\u00a8\u00068"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData;", "", "readTablets", "", "Ljava/util/UUID;", "boundSouls", "", "zombieKilledMob", "", "killedGolems", "drainedAnimals", "possessedKillVillager", "killedWither", "phylacteryBound", "phylacteryDeaths", "phylacteryDeathTimes", "", "phylacterySouls", "isSoulFormActive", "isVagrant", "<init>", "(Ljava/util/List;IZIIZZZILjava/util/List;IZZ)V", "getReadTablets", "()Ljava/util/List;", "getBoundSouls", "()I", "getZombieKilledMob", "()Z", "getKilledGolems", "getDrainedAnimals", "getPossessedKillVillager", "getKilledWither", "getPhylacteryBound", "getPhylacteryDeaths", "getPhylacteryDeathTimes", "getPhylacterySouls", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class LichData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<UUID> readTablets;
        private final int boundSouls;
        private final boolean zombieKilledMob;
        private final int killedGolems;
        private final int drainedAnimals;
        private final boolean possessedKillVillager;
        private final boolean killedWither;
        private final boolean phylacteryBound;
        private final int phylacteryDeaths;
        @NotNull
        private final List<Long> phylacteryDeathTimes;
        private final int phylacterySouls;
        private final boolean isSoulFormActive;
        private final boolean isVagrant;
        @NotNull
        private static final Codec<LichData> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public LichData(@NotNull List<UUID> readTablets, int boundSouls, boolean zombieKilledMob, int killedGolems, int drainedAnimals, boolean possessedKillVillager, boolean killedWither, boolean phylacteryBound, int phylacteryDeaths, @NotNull List<Long> phylacteryDeathTimes, int phylacterySouls, boolean isSoulFormActive, boolean isVagrant) {
            Intrinsics.checkNotNullParameter(readTablets, (String)"readTablets");
            Intrinsics.checkNotNullParameter(phylacteryDeathTimes, (String)"phylacteryDeathTimes");
            this.readTablets = readTablets;
            this.boundSouls = boundSouls;
            this.zombieKilledMob = zombieKilledMob;
            this.killedGolems = killedGolems;
            this.drainedAnimals = drainedAnimals;
            this.possessedKillVillager = possessedKillVillager;
            this.killedWither = killedWither;
            this.phylacteryBound = phylacteryBound;
            this.phylacteryDeaths = phylacteryDeaths;
            this.phylacteryDeathTimes = phylacteryDeathTimes;
            this.phylacterySouls = phylacterySouls;
            this.isSoulFormActive = isSoulFormActive;
            this.isVagrant = isVagrant;
        }

        public /* synthetic */ LichData(List list, int n, boolean bl, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, int n4, List list2, int n5, boolean bl5, boolean bl6, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n6 & 2) != 0) {
                n = 0;
            }
            if ((n6 & 4) != 0) {
                bl = false;
            }
            if ((n6 & 8) != 0) {
                n2 = 0;
            }
            if ((n6 & 0x10) != 0) {
                n3 = 0;
            }
            if ((n6 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n6 & 0x40) != 0) {
                bl3 = false;
            }
            if ((n6 & 0x80) != 0) {
                bl4 = false;
            }
            if ((n6 & 0x100) != 0) {
                n4 = 0;
            }
            if ((n6 & 0x200) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n6 & 0x400) != 0) {
                n5 = 0;
            }
            if ((n6 & 0x800) != 0) {
                bl5 = false;
            }
            if ((n6 & 0x1000) != 0) {
                bl6 = false;
            }
            this(list, n, bl, n2, n3, bl2, bl3, bl4, n4, list2, n5, bl5, bl6);
        }

        @NotNull
        public final List<UUID> getReadTablets() {
            return this.readTablets;
        }

        public final int getBoundSouls() {
            return this.boundSouls;
        }

        public final boolean getZombieKilledMob() {
            return this.zombieKilledMob;
        }

        public final int getKilledGolems() {
            return this.killedGolems;
        }

        public final int getDrainedAnimals() {
            return this.drainedAnimals;
        }

        public final boolean getPossessedKillVillager() {
            return this.possessedKillVillager;
        }

        public final boolean getKilledWither() {
            return this.killedWither;
        }

        public final boolean getPhylacteryBound() {
            return this.phylacteryBound;
        }

        public final int getPhylacteryDeaths() {
            return this.phylacteryDeaths;
        }

        @NotNull
        public final List<Long> getPhylacteryDeathTimes() {
            return this.phylacteryDeathTimes;
        }

        public final int getPhylacterySouls() {
            return this.phylacterySouls;
        }

        public final boolean isSoulFormActive() {
            return this.isSoulFormActive;
        }

        public final boolean isVagrant() {
            return this.isVagrant;
        }

        @NotNull
        public final List<UUID> component1() {
            return this.readTablets;
        }

        public final int component2() {
            return this.boundSouls;
        }

        public final boolean component3() {
            return this.zombieKilledMob;
        }

        public final int component4() {
            return this.killedGolems;
        }

        public final int component5() {
            return this.drainedAnimals;
        }

        public final boolean component6() {
            return this.possessedKillVillager;
        }

        public final boolean component7() {
            return this.killedWither;
        }

        public final boolean component8() {
            return this.phylacteryBound;
        }

        public final int component9() {
            return this.phylacteryDeaths;
        }

        @NotNull
        public final List<Long> component10() {
            return this.phylacteryDeathTimes;
        }

        public final int component11() {
            return this.phylacterySouls;
        }

        public final boolean component12() {
            return this.isSoulFormActive;
        }

        public final boolean component13() {
            return this.isVagrant;
        }

        @NotNull
        public final LichData copy(@NotNull List<UUID> readTablets, int boundSouls, boolean zombieKilledMob, int killedGolems, int drainedAnimals, boolean possessedKillVillager, boolean killedWither, boolean phylacteryBound, int phylacteryDeaths, @NotNull List<Long> phylacteryDeathTimes, int phylacterySouls, boolean isSoulFormActive, boolean isVagrant) {
            Intrinsics.checkNotNullParameter(readTablets, (String)"readTablets");
            Intrinsics.checkNotNullParameter(phylacteryDeathTimes, (String)"phylacteryDeathTimes");
            return new LichData(readTablets, boundSouls, zombieKilledMob, killedGolems, drainedAnimals, possessedKillVillager, killedWither, phylacteryBound, phylacteryDeaths, phylacteryDeathTimes, phylacterySouls, isSoulFormActive, isVagrant);
        }

        public static /* synthetic */ LichData copy$default(LichData lichData, List list, int n, boolean bl, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, int n4, List list2, int n5, boolean bl5, boolean bl6, int n6, Object object) {
            if ((n6 & 1) != 0) {
                list = lichData.readTablets;
            }
            if ((n6 & 2) != 0) {
                n = lichData.boundSouls;
            }
            if ((n6 & 4) != 0) {
                bl = lichData.zombieKilledMob;
            }
            if ((n6 & 8) != 0) {
                n2 = lichData.killedGolems;
            }
            if ((n6 & 0x10) != 0) {
                n3 = lichData.drainedAnimals;
            }
            if ((n6 & 0x20) != 0) {
                bl2 = lichData.possessedKillVillager;
            }
            if ((n6 & 0x40) != 0) {
                bl3 = lichData.killedWither;
            }
            if ((n6 & 0x80) != 0) {
                bl4 = lichData.phylacteryBound;
            }
            if ((n6 & 0x100) != 0) {
                n4 = lichData.phylacteryDeaths;
            }
            if ((n6 & 0x200) != 0) {
                list2 = lichData.phylacteryDeathTimes;
            }
            if ((n6 & 0x400) != 0) {
                n5 = lichData.phylacterySouls;
            }
            if ((n6 & 0x800) != 0) {
                bl5 = lichData.isSoulFormActive;
            }
            if ((n6 & 0x1000) != 0) {
                bl6 = lichData.isVagrant;
            }
            return lichData.copy(list, n, bl, n2, n3, bl2, bl3, bl4, n4, list2, n5, bl5, bl6);
        }

        @NotNull
        public String toString() {
            return "LichData(readTablets=" + this.readTablets + ", boundSouls=" + this.boundSouls + ", zombieKilledMob=" + this.zombieKilledMob + ", killedGolems=" + this.killedGolems + ", drainedAnimals=" + this.drainedAnimals + ", possessedKillVillager=" + this.possessedKillVillager + ", killedWither=" + this.killedWither + ", phylacteryBound=" + this.phylacteryBound + ", phylacteryDeaths=" + this.phylacteryDeaths + ", phylacteryDeathTimes=" + this.phylacteryDeathTimes + ", phylacterySouls=" + this.phylacterySouls + ", isSoulFormActive=" + this.isSoulFormActive + ", isVagrant=" + this.isVagrant + ")";
        }

        public int hashCode() {
            int result = ((Object)this.readTablets).hashCode();
            result = result * 31 + Integer.hashCode(this.boundSouls);
            result = result * 31 + Boolean.hashCode(this.zombieKilledMob);
            result = result * 31 + Integer.hashCode(this.killedGolems);
            result = result * 31 + Integer.hashCode(this.drainedAnimals);
            result = result * 31 + Boolean.hashCode(this.possessedKillVillager);
            result = result * 31 + Boolean.hashCode(this.killedWither);
            result = result * 31 + Boolean.hashCode(this.phylacteryBound);
            result = result * 31 + Integer.hashCode(this.phylacteryDeaths);
            result = result * 31 + ((Object)this.phylacteryDeathTimes).hashCode();
            result = result * 31 + Integer.hashCode(this.phylacterySouls);
            result = result * 31 + Boolean.hashCode(this.isSoulFormActive);
            result = result * 31 + Boolean.hashCode(this.isVagrant);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LichData)) {
                return false;
            }
            LichData lichData = (LichData)other;
            if (!Intrinsics.areEqual(this.readTablets, lichData.readTablets)) {
                return false;
            }
            if (this.boundSouls != lichData.boundSouls) {
                return false;
            }
            if (this.zombieKilledMob != lichData.zombieKilledMob) {
                return false;
            }
            if (this.killedGolems != lichData.killedGolems) {
                return false;
            }
            if (this.drainedAnimals != lichData.drainedAnimals) {
                return false;
            }
            if (this.possessedKillVillager != lichData.possessedKillVillager) {
                return false;
            }
            if (this.killedWither != lichData.killedWither) {
                return false;
            }
            if (this.phylacteryBound != lichData.phylacteryBound) {
                return false;
            }
            if (this.phylacteryDeaths != lichData.phylacteryDeaths) {
                return false;
            }
            if (!Intrinsics.areEqual(this.phylacteryDeathTimes, lichData.phylacteryDeathTimes)) {
                return false;
            }
            if (this.phylacterySouls != lichData.phylacterySouls) {
                return false;
            }
            if (this.isSoulFormActive != lichData.isSoulFormActive) {
                return false;
            }
            return this.isVagrant == lichData.isVagrant;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)UUIDUtil.CODEC.listOf().fieldOf("readTablets").forGetter(LichData::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("boundSouls").forGetter(LichData::CODEC$lambda$0$1), (App)Codec.BOOL.fieldOf("zombieKilledMob").forGetter(LichData::CODEC$lambda$0$2), (App)Codec.INT.fieldOf("killedGolems").forGetter(LichData::CODEC$lambda$0$3), (App)Codec.INT.fieldOf("drainedAnimals").forGetter(LichData::CODEC$lambda$0$4), (App)Codec.BOOL.fieldOf("possessedKillVillager").forGetter(LichData::CODEC$lambda$0$5), (App)Codec.BOOL.fieldOf("killedWither").forGetter(LichData::CODEC$lambda$0$6), (App)Codec.BOOL.fieldOf("phylacteryBound").forGetter(LichData::CODEC$lambda$0$7), (App)Codec.INT.fieldOf("phylacteryDeaths").forGetter(LichData::CODEC$lambda$0$8), (App)Codec.LONG.listOf().fieldOf("phylacteryDeathTimes").forGetter(LichData::CODEC$lambda$0$9), (App)Codec.INT.fieldOf("phylacterySouls").forGetter(LichData::CODEC$lambda$0$10), (App)Codec.BOOL.fieldOf("isSoulFormActive").forGetter(LichData::CODEC$lambda$0$11), (App)Codec.BOOL.fieldOf("isVagrant").forGetter(LichData::CODEC$lambda$0$12)).apply((Applicative)instance, LichData::new);
        }

        private static final List CODEC$lambda$0$0(LichData it) {
            return it.readTablets;
        }

        private static final Integer CODEC$lambda$0$1(LichData it) {
            return it.boundSouls;
        }

        private static final Boolean CODEC$lambda$0$2(LichData it) {
            return it.zombieKilledMob;
        }

        private static final Integer CODEC$lambda$0$3(LichData it) {
            return it.killedGolems;
        }

        private static final Integer CODEC$lambda$0$4(LichData it) {
            return it.drainedAnimals;
        }

        private static final Boolean CODEC$lambda$0$5(LichData it) {
            return it.possessedKillVillager;
        }

        private static final Boolean CODEC$lambda$0$6(LichData it) {
            return it.killedWither;
        }

        private static final Boolean CODEC$lambda$0$7(LichData it) {
            return it.phylacteryBound;
        }

        private static final Integer CODEC$lambda$0$8(LichData it) {
            return it.phylacteryDeaths;
        }

        private static final List CODEC$lambda$0$9(LichData it) {
            return it.phylacteryDeathTimes;
        }

        private static final Integer CODEC$lambda$0$10(LichData it) {
            return it.phylacterySouls;
        }

        private static final Boolean CODEC$lambda$0$11(LichData it) {
            return it.isSoulFormActive;
        }

        private static final Boolean CODEC$lambda$0$12(LichData it) {
            return it.isVagrant;
        }

        public LichData() {
            this(null, 0, false, 0, 0, false, false, false, 0, null, 0, false, false, 8191, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(LichData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("lich_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$LichData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<LichData> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B\u0087\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0003J\u0089\u0001\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0017R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001e\u00a8\u00063"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData;", "", "killedBlazes", "", "usedSunGrenades", "isNightVisionActive", "", "isSpeedBoostActive", "isBatFormActive", "nightTicker", "inSunTick", "maxInSunTickClient", "visitedVillages", "", "", "villagersHalfBlood", "Ljava/util/UUID;", "trappedVillagers", "<init>", "(IIZZZIIILjava/util/List;Ljava/util/List;Ljava/util/List;)V", "getKilledBlazes", "()I", "getUsedSunGrenades", "()Z", "getNightTicker", "setNightTicker", "(I)V", "getInSunTick", "getMaxInSunTickClient", "getVisitedVillages", "()Ljava/util/List;", "getVillagersHalfBlood", "getTrappedVillagers", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class VampData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int killedBlazes;
        private final int usedSunGrenades;
        private final boolean isNightVisionActive;
        private final boolean isSpeedBoostActive;
        private final boolean isBatFormActive;
        private int nightTicker;
        private final int inSunTick;
        private final int maxInSunTickClient;
        @NotNull
        private final List<Long> visitedVillages;
        @NotNull
        private final List<UUID> villagersHalfBlood;
        @NotNull
        private final List<UUID> trappedVillagers;
        @NotNull
        private static final Codec<VampData> CODEC;

        public VampData(int killedBlazes, int usedSunGrenades, boolean isNightVisionActive, boolean isSpeedBoostActive, boolean isBatFormActive, int nightTicker, int inSunTick, int maxInSunTickClient, @NotNull List<Long> visitedVillages, @NotNull List<UUID> villagersHalfBlood, @NotNull List<UUID> trappedVillagers) {
            Intrinsics.checkNotNullParameter(visitedVillages, (String)"visitedVillages");
            Intrinsics.checkNotNullParameter(villagersHalfBlood, (String)"villagersHalfBlood");
            Intrinsics.checkNotNullParameter(trappedVillagers, (String)"trappedVillagers");
            this.killedBlazes = killedBlazes;
            this.usedSunGrenades = usedSunGrenades;
            this.isNightVisionActive = isNightVisionActive;
            this.isSpeedBoostActive = isSpeedBoostActive;
            this.isBatFormActive = isBatFormActive;
            this.nightTicker = nightTicker;
            this.inSunTick = inSunTick;
            this.maxInSunTickClient = maxInSunTickClient;
            this.visitedVillages = visitedVillages;
            this.villagersHalfBlood = villagersHalfBlood;
            this.trappedVillagers = trappedVillagers;
        }

        public /* synthetic */ VampData(int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, List list, List list2, List list3, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 1) != 0) {
                n = 0;
            }
            if ((n6 & 2) != 0) {
                n2 = 0;
            }
            if ((n6 & 4) != 0) {
                bl = false;
            }
            if ((n6 & 8) != 0) {
                bl2 = false;
            }
            if ((n6 & 0x10) != 0) {
                bl3 = false;
            }
            if ((n6 & 0x20) != 0) {
                n3 = 0;
            }
            if ((n6 & 0x40) != 0) {
                n4 = 0;
            }
            if ((n6 & 0x80) != 0) {
                n5 = 0;
            }
            if ((n6 & 0x100) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n6 & 0x200) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n6 & 0x400) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(n, n2, bl, bl2, bl3, n3, n4, n5, list, list2, list3);
        }

        public final int getKilledBlazes() {
            return this.killedBlazes;
        }

        public final int getUsedSunGrenades() {
            return this.usedSunGrenades;
        }

        public final boolean isNightVisionActive() {
            return this.isNightVisionActive;
        }

        public final boolean isSpeedBoostActive() {
            return this.isSpeedBoostActive;
        }

        public final boolean isBatFormActive() {
            return this.isBatFormActive;
        }

        public final int getNightTicker() {
            return this.nightTicker;
        }

        public final void setNightTicker(int n) {
            this.nightTicker = n;
        }

        public final int getInSunTick() {
            return this.inSunTick;
        }

        public final int getMaxInSunTickClient() {
            return this.maxInSunTickClient;
        }

        @NotNull
        public final List<Long> getVisitedVillages() {
            return this.visitedVillages;
        }

        @NotNull
        public final List<UUID> getVillagersHalfBlood() {
            return this.villagersHalfBlood;
        }

        @NotNull
        public final List<UUID> getTrappedVillagers() {
            return this.trappedVillagers;
        }

        public final int component1() {
            return this.killedBlazes;
        }

        public final int component2() {
            return this.usedSunGrenades;
        }

        public final boolean component3() {
            return this.isNightVisionActive;
        }

        public final boolean component4() {
            return this.isSpeedBoostActive;
        }

        public final boolean component5() {
            return this.isBatFormActive;
        }

        public final int component6() {
            return this.nightTicker;
        }

        public final int component7() {
            return this.inSunTick;
        }

        public final int component8() {
            return this.maxInSunTickClient;
        }

        @NotNull
        public final List<Long> component9() {
            return this.visitedVillages;
        }

        @NotNull
        public final List<UUID> component10() {
            return this.villagersHalfBlood;
        }

        @NotNull
        public final List<UUID> component11() {
            return this.trappedVillagers;
        }

        @NotNull
        public final VampData copy(int killedBlazes, int usedSunGrenades, boolean isNightVisionActive, boolean isSpeedBoostActive, boolean isBatFormActive, int nightTicker, int inSunTick, int maxInSunTickClient, @NotNull List<Long> visitedVillages, @NotNull List<UUID> villagersHalfBlood, @NotNull List<UUID> trappedVillagers) {
            Intrinsics.checkNotNullParameter(visitedVillages, (String)"visitedVillages");
            Intrinsics.checkNotNullParameter(villagersHalfBlood, (String)"villagersHalfBlood");
            Intrinsics.checkNotNullParameter(trappedVillagers, (String)"trappedVillagers");
            return new VampData(killedBlazes, usedSunGrenades, isNightVisionActive, isSpeedBoostActive, isBatFormActive, nightTicker, inSunTick, maxInSunTickClient, visitedVillages, villagersHalfBlood, trappedVillagers);
        }

        public static /* synthetic */ VampData copy$default(VampData vampData, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, List list, List list2, List list3, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = vampData.killedBlazes;
            }
            if ((n6 & 2) != 0) {
                n2 = vampData.usedSunGrenades;
            }
            if ((n6 & 4) != 0) {
                bl = vampData.isNightVisionActive;
            }
            if ((n6 & 8) != 0) {
                bl2 = vampData.isSpeedBoostActive;
            }
            if ((n6 & 0x10) != 0) {
                bl3 = vampData.isBatFormActive;
            }
            if ((n6 & 0x20) != 0) {
                n3 = vampData.nightTicker;
            }
            if ((n6 & 0x40) != 0) {
                n4 = vampData.inSunTick;
            }
            if ((n6 & 0x80) != 0) {
                n5 = vampData.maxInSunTickClient;
            }
            if ((n6 & 0x100) != 0) {
                list = vampData.visitedVillages;
            }
            if ((n6 & 0x200) != 0) {
                list2 = vampData.villagersHalfBlood;
            }
            if ((n6 & 0x400) != 0) {
                list3 = vampData.trappedVillagers;
            }
            return vampData.copy(n, n2, bl, bl2, bl3, n3, n4, n5, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "VampData(killedBlazes=" + this.killedBlazes + ", usedSunGrenades=" + this.usedSunGrenades + ", isNightVisionActive=" + this.isNightVisionActive + ", isSpeedBoostActive=" + this.isSpeedBoostActive + ", isBatFormActive=" + this.isBatFormActive + ", nightTicker=" + this.nightTicker + ", inSunTick=" + this.inSunTick + ", maxInSunTickClient=" + this.maxInSunTickClient + ", visitedVillages=" + this.visitedVillages + ", villagersHalfBlood=" + this.villagersHalfBlood + ", trappedVillagers=" + this.trappedVillagers + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.killedBlazes);
            result = result * 31 + Integer.hashCode(this.usedSunGrenades);
            result = result * 31 + Boolean.hashCode(this.isNightVisionActive);
            result = result * 31 + Boolean.hashCode(this.isSpeedBoostActive);
            result = result * 31 + Boolean.hashCode(this.isBatFormActive);
            result = result * 31 + Integer.hashCode(this.nightTicker);
            result = result * 31 + Integer.hashCode(this.inSunTick);
            result = result * 31 + Integer.hashCode(this.maxInSunTickClient);
            result = result * 31 + ((Object)this.visitedVillages).hashCode();
            result = result * 31 + ((Object)this.villagersHalfBlood).hashCode();
            result = result * 31 + ((Object)this.trappedVillagers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VampData)) {
                return false;
            }
            VampData vampData = (VampData)other;
            if (this.killedBlazes != vampData.killedBlazes) {
                return false;
            }
            if (this.usedSunGrenades != vampData.usedSunGrenades) {
                return false;
            }
            if (this.isNightVisionActive != vampData.isNightVisionActive) {
                return false;
            }
            if (this.isSpeedBoostActive != vampData.isSpeedBoostActive) {
                return false;
            }
            if (this.isBatFormActive != vampData.isBatFormActive) {
                return false;
            }
            if (this.nightTicker != vampData.nightTicker) {
                return false;
            }
            if (this.inSunTick != vampData.inSunTick) {
                return false;
            }
            if (this.maxInSunTickClient != vampData.maxInSunTickClient) {
                return false;
            }
            if (!Intrinsics.areEqual(this.visitedVillages, vampData.visitedVillages)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.villagersHalfBlood, vampData.villagersHalfBlood)) {
                return false;
            }
            return Intrinsics.areEqual(this.trappedVillagers, vampData.trappedVillagers);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("killedBlazes").forGetter(VampData::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("usedSunGrenades").forGetter(VampData::CODEC$lambda$0$1), (App)Codec.BOOL.optionalFieldOf("isNightVisionActive", (Object)false).forGetter(VampData::CODEC$lambda$0$2), (App)Codec.BOOL.optionalFieldOf("isSpeedBoostActive", (Object)false).forGetter(VampData::CODEC$lambda$0$3), (App)Codec.BOOL.optionalFieldOf("isBatFormActive", (Object)false).forGetter(VampData::CODEC$lambda$0$4), (App)Codec.INT.optionalFieldOf("nightTicker", (Object)0).forGetter(VampData::CODEC$lambda$0$5), (App)Codec.INT.optionalFieldOf("inSunTick", (Object)0).forGetter(VampData::CODEC$lambda$0$6), (App)Codec.INT.optionalFieldOf("maxInSunTickClient", (Object)0).forGetter(VampData::CODEC$lambda$0$7), (App)Codec.LONG.listOf().fieldOf("visitedVillages").forGetter(VampData::CODEC$lambda$0$8), (App)UUIDUtil.CODEC.listOf().fieldOf("villagersHalfBlood").forGetter(VampData::CODEC$lambda$0$9), (App)UUIDUtil.CODEC.listOf().fieldOf("trappedVillagers").forGetter(VampData::CODEC$lambda$0$10)).apply((Applicative)instance, VampData::new);
        }

        private static final Integer CODEC$lambda$0$0(VampData it) {
            return it.killedBlazes;
        }

        private static final Integer CODEC$lambda$0$1(VampData it) {
            return it.usedSunGrenades;
        }

        private static final Boolean CODEC$lambda$0$2(VampData it) {
            return it.isNightVisionActive;
        }

        private static final Boolean CODEC$lambda$0$3(VampData it) {
            return it.isSpeedBoostActive;
        }

        private static final Boolean CODEC$lambda$0$4(VampData it) {
            return it.isBatFormActive;
        }

        private static final Integer CODEC$lambda$0$5(VampData it) {
            return it.nightTicker;
        }

        private static final Integer CODEC$lambda$0$6(VampData it) {
            return it.inSunTick;
        }

        private static final Integer CODEC$lambda$0$7(VampData it) {
            return it.maxInSunTickClient;
        }

        private static final List CODEC$lambda$0$8(VampData it) {
            return it.visitedVillages;
        }

        private static final List CODEC$lambda$0$9(VampData it) {
            return it.villagersHalfBlood;
        }

        private static final List CODEC$lambda$0$10(VampData it) {
            return it.trappedVillagers;
        }

        public VampData() {
            this(0, 0, false, false, false, 0, 0, 0, null, null, null, 2047, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(VampData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$VampData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<VampData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B\u0085\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\u0087\u0001\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010.\u001a\u00020\u00062\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\u0003H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0018R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0018R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018\u00a8\u00064"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData;", "", "killedSheep", "", "killedWolves", "killHornedOne", "", "airSlayMonster", "nightHowl", "wolfPack", "pigmenKilled", "spreadLycanthropy", "isWolfManFormActive", "isWolfFormActive", "lycanSourceUUID", "Ljava/util/Optional;", "Ljava/util/UUID;", "hasGivenGold", "<init>", "(IIZIIIIZZZLjava/util/Optional;Z)V", "getKilledSheep", "()I", "getKilledWolves", "getKillHornedOne", "()Z", "getAirSlayMonster", "getNightHowl", "getWolfPack", "getPigmenKilled", "getSpreadLycanthropy", "getLycanSourceUUID", "()Ljava/util/Optional;", "getHasGivenGold", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class WereData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int killedSheep;
        private final int killedWolves;
        private final boolean killHornedOne;
        private final int airSlayMonster;
        private final int nightHowl;
        private final int wolfPack;
        private final int pigmenKilled;
        private final boolean spreadLycanthropy;
        private final boolean isWolfManFormActive;
        private final boolean isWolfFormActive;
        @NotNull
        private final Optional<UUID> lycanSourceUUID;
        private final boolean hasGivenGold;
        @NotNull
        private static final Codec<WereData> CODEC;

        public WereData(int killedSheep, int killedWolves, boolean killHornedOne, int airSlayMonster, int nightHowl, int wolfPack, int pigmenKilled, boolean spreadLycanthropy, boolean isWolfManFormActive, boolean isWolfFormActive, @NotNull Optional<UUID> lycanSourceUUID, boolean hasGivenGold) {
            Intrinsics.checkNotNullParameter(lycanSourceUUID, (String)"lycanSourceUUID");
            this.killedSheep = killedSheep;
            this.killedWolves = killedWolves;
            this.killHornedOne = killHornedOne;
            this.airSlayMonster = airSlayMonster;
            this.nightHowl = nightHowl;
            this.wolfPack = wolfPack;
            this.pigmenKilled = pigmenKilled;
            this.spreadLycanthropy = spreadLycanthropy;
            this.isWolfManFormActive = isWolfManFormActive;
            this.isWolfFormActive = isWolfFormActive;
            this.lycanSourceUUID = lycanSourceUUID;
            this.hasGivenGold = hasGivenGold;
        }

        public /* synthetic */ WereData(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, boolean bl3, boolean bl4, Optional optional, boolean bl5, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                n = 0;
            }
            if ((n7 & 2) != 0) {
                n2 = 0;
            }
            if ((n7 & 4) != 0) {
                bl = false;
            }
            if ((n7 & 8) != 0) {
                n3 = 0;
            }
            if ((n7 & 0x10) != 0) {
                n4 = 0;
            }
            if ((n7 & 0x20) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x40) != 0) {
                n6 = 0;
            }
            if ((n7 & 0x80) != 0) {
                bl2 = false;
            }
            if ((n7 & 0x100) != 0) {
                bl3 = false;
            }
            if ((n7 & 0x200) != 0) {
                bl4 = false;
            }
            if ((n7 & 0x400) != 0) {
                Optional<UUID> optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
                optional = optional2;
            }
            if ((n7 & 0x800) != 0) {
                bl5 = false;
            }
            this(n, n2, bl, n3, n4, n5, n6, bl2, bl3, bl4, optional, bl5);
        }

        public final int getKilledSheep() {
            return this.killedSheep;
        }

        public final int getKilledWolves() {
            return this.killedWolves;
        }

        public final boolean getKillHornedOne() {
            return this.killHornedOne;
        }

        public final int getAirSlayMonster() {
            return this.airSlayMonster;
        }

        public final int getNightHowl() {
            return this.nightHowl;
        }

        public final int getWolfPack() {
            return this.wolfPack;
        }

        public final int getPigmenKilled() {
            return this.pigmenKilled;
        }

        public final boolean getSpreadLycanthropy() {
            return this.spreadLycanthropy;
        }

        public final boolean isWolfManFormActive() {
            return this.isWolfManFormActive;
        }

        public final boolean isWolfFormActive() {
            return this.isWolfFormActive;
        }

        @NotNull
        public final Optional<UUID> getLycanSourceUUID() {
            return this.lycanSourceUUID;
        }

        public final boolean getHasGivenGold() {
            return this.hasGivenGold;
        }

        public final int component1() {
            return this.killedSheep;
        }

        public final int component2() {
            return this.killedWolves;
        }

        public final boolean component3() {
            return this.killHornedOne;
        }

        public final int component4() {
            return this.airSlayMonster;
        }

        public final int component5() {
            return this.nightHowl;
        }

        public final int component6() {
            return this.wolfPack;
        }

        public final int component7() {
            return this.pigmenKilled;
        }

        public final boolean component8() {
            return this.spreadLycanthropy;
        }

        public final boolean component9() {
            return this.isWolfManFormActive;
        }

        public final boolean component10() {
            return this.isWolfFormActive;
        }

        @NotNull
        public final Optional<UUID> component11() {
            return this.lycanSourceUUID;
        }

        public final boolean component12() {
            return this.hasGivenGold;
        }

        @NotNull
        public final WereData copy(int killedSheep, int killedWolves, boolean killHornedOne, int airSlayMonster, int nightHowl, int wolfPack, int pigmenKilled, boolean spreadLycanthropy, boolean isWolfManFormActive, boolean isWolfFormActive, @NotNull Optional<UUID> lycanSourceUUID, boolean hasGivenGold) {
            Intrinsics.checkNotNullParameter(lycanSourceUUID, (String)"lycanSourceUUID");
            return new WereData(killedSheep, killedWolves, killHornedOne, airSlayMonster, nightHowl, wolfPack, pigmenKilled, spreadLycanthropy, isWolfManFormActive, isWolfFormActive, lycanSourceUUID, hasGivenGold);
        }

        public static /* synthetic */ WereData copy$default(WereData wereData, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, boolean bl3, boolean bl4, Optional optional, boolean bl5, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = wereData.killedSheep;
            }
            if ((n7 & 2) != 0) {
                n2 = wereData.killedWolves;
            }
            if ((n7 & 4) != 0) {
                bl = wereData.killHornedOne;
            }
            if ((n7 & 8) != 0) {
                n3 = wereData.airSlayMonster;
            }
            if ((n7 & 0x10) != 0) {
                n4 = wereData.nightHowl;
            }
            if ((n7 & 0x20) != 0) {
                n5 = wereData.wolfPack;
            }
            if ((n7 & 0x40) != 0) {
                n6 = wereData.pigmenKilled;
            }
            if ((n7 & 0x80) != 0) {
                bl2 = wereData.spreadLycanthropy;
            }
            if ((n7 & 0x100) != 0) {
                bl3 = wereData.isWolfManFormActive;
            }
            if ((n7 & 0x200) != 0) {
                bl4 = wereData.isWolfFormActive;
            }
            if ((n7 & 0x400) != 0) {
                optional = wereData.lycanSourceUUID;
            }
            if ((n7 & 0x800) != 0) {
                bl5 = wereData.hasGivenGold;
            }
            return wereData.copy(n, n2, bl, n3, n4, n5, n6, bl2, bl3, bl4, optional, bl5);
        }

        @NotNull
        public String toString() {
            return "WereData(killedSheep=" + this.killedSheep + ", killedWolves=" + this.killedWolves + ", killHornedOne=" + this.killHornedOne + ", airSlayMonster=" + this.airSlayMonster + ", nightHowl=" + this.nightHowl + ", wolfPack=" + this.wolfPack + ", pigmenKilled=" + this.pigmenKilled + ", spreadLycanthropy=" + this.spreadLycanthropy + ", isWolfManFormActive=" + this.isWolfManFormActive + ", isWolfFormActive=" + this.isWolfFormActive + ", lycanSourceUUID=" + this.lycanSourceUUID + ", hasGivenGold=" + this.hasGivenGold + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.killedSheep);
            result = result * 31 + Integer.hashCode(this.killedWolves);
            result = result * 31 + Boolean.hashCode(this.killHornedOne);
            result = result * 31 + Integer.hashCode(this.airSlayMonster);
            result = result * 31 + Integer.hashCode(this.nightHowl);
            result = result * 31 + Integer.hashCode(this.wolfPack);
            result = result * 31 + Integer.hashCode(this.pigmenKilled);
            result = result * 31 + Boolean.hashCode(this.spreadLycanthropy);
            result = result * 31 + Boolean.hashCode(this.isWolfManFormActive);
            result = result * 31 + Boolean.hashCode(this.isWolfFormActive);
            result = result * 31 + this.lycanSourceUUID.hashCode();
            result = result * 31 + Boolean.hashCode(this.hasGivenGold);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WereData)) {
                return false;
            }
            WereData wereData = (WereData)other;
            if (this.killedSheep != wereData.killedSheep) {
                return false;
            }
            if (this.killedWolves != wereData.killedWolves) {
                return false;
            }
            if (this.killHornedOne != wereData.killHornedOne) {
                return false;
            }
            if (this.airSlayMonster != wereData.airSlayMonster) {
                return false;
            }
            if (this.nightHowl != wereData.nightHowl) {
                return false;
            }
            if (this.wolfPack != wereData.wolfPack) {
                return false;
            }
            if (this.pigmenKilled != wereData.pigmenKilled) {
                return false;
            }
            if (this.spreadLycanthropy != wereData.spreadLycanthropy) {
                return false;
            }
            if (this.isWolfManFormActive != wereData.isWolfManFormActive) {
                return false;
            }
            if (this.isWolfFormActive != wereData.isWolfFormActive) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lycanSourceUUID, wereData.lycanSourceUUID)) {
                return false;
            }
            return this.hasGivenGold == wereData.hasGivenGold;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("killedSheep").forGetter(WereData::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("killedWolves").forGetter(WereData::CODEC$lambda$0$1), (App)Codec.BOOL.fieldOf("killHornedOne").forGetter(WereData::CODEC$lambda$0$2), (App)Codec.INT.fieldOf("airSlayMonster").forGetter(WereData::CODEC$lambda$0$3), (App)Codec.INT.fieldOf("nightHowl").forGetter(WereData::CODEC$lambda$0$4), (App)Codec.INT.fieldOf("wolfPack").forGetter(WereData::CODEC$lambda$0$5), (App)Codec.INT.fieldOf("pigmenKilled").forGetter(WereData::CODEC$lambda$0$6), (App)Codec.BOOL.fieldOf("spreadLycanthropy").forGetter(WereData::CODEC$lambda$0$7), (App)Codec.BOOL.fieldOf("isWolfManFormActive").forGetter(WereData::CODEC$lambda$0$8), (App)Codec.BOOL.fieldOf("isWolfFormActive").forGetter(WereData::CODEC$lambda$0$9), (App)UUIDUtil.CODEC.optionalFieldOf("lycanSourceUUID").forGetter(WereData::CODEC$lambda$0$10), (App)Codec.BOOL.fieldOf("hasGivenGold").forGetter(WereData::CODEC$lambda$0$11)).apply((Applicative)instance, WereData::new);
        }

        private static final Integer CODEC$lambda$0$0(WereData it) {
            return it.killedSheep;
        }

        private static final Integer CODEC$lambda$0$1(WereData it) {
            return it.killedWolves;
        }

        private static final Boolean CODEC$lambda$0$2(WereData it) {
            return it.killHornedOne;
        }

        private static final Integer CODEC$lambda$0$3(WereData it) {
            return it.airSlayMonster;
        }

        private static final Integer CODEC$lambda$0$4(WereData it) {
            return it.nightHowl;
        }

        private static final Integer CODEC$lambda$0$5(WereData it) {
            return it.wolfPack;
        }

        private static final Integer CODEC$lambda$0$6(WereData it) {
            return it.pigmenKilled;
        }

        private static final Boolean CODEC$lambda$0$7(WereData it) {
            return it.spreadLycanthropy;
        }

        private static final Boolean CODEC$lambda$0$8(WereData it) {
            return it.isWolfManFormActive;
        }

        private static final Boolean CODEC$lambda$0$9(WereData it) {
            return it.isWolfFormActive;
        }

        private static final Optional CODEC$lambda$0$10(WereData it) {
            return it.lycanSourceUUID;
        }

        private static final Boolean CODEC$lambda$0$11(WereData it) {
            return it.hasGivenGold;
        }

        public WereData() {
            this(0, 0, false, 0, 0, 0, 0, false, false, false, null, false, 4095, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(WereData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$WereData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<WereData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

