/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.ability;

import dev.sterner.witchery.client.screen.AbilitySelectionScreen;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AbilityHandler;
import dev.sterner.witchery.features.affliction.ability.AbilityScrollHandler;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.lich.LichdomAbility;
import dev.sterner.witchery.features.affliction.vampire.VampireAbility;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfAbility;
import dev.sterner.witchery.features.death.DeathAbility;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.network.AfflictionAbilitySelectionC2SPayload;
import dev.sterner.witchery.network.AfflictionAbilityUseC2SPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\tJ \u0010\u001b\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/features/affliction/ability/AfflictionAbilityHandler;", "Ldev/sterner/witchery/features/affliction/ability/AbilityHandler;", "<init>", "()V", "abilityIndex", "", "getAbilityIndex", "()Ljava/lang/Integer;", "getAbilities", "", "Ldev/sterner/witchery/features/affliction/ability/AfflictionAbility;", "player", "Lnet/minecraft/world/entity/player/Player;", "getAllAvailableAbilities", "setAbilityIndex", "", "index", "updateAbilityIndex", "addAbilityOnLevelUp", "newLevel", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "force", "", "updateSelectedAbilities", "abilities", "", "scroll", "minecraft", "Lnet/minecraft/client/Minecraft;", "scrollDeltaX", "", "scrollDeltaY", "getSelectedAbility", "useSelectedAbility", "openSelectionScreen", "witchery"})
@SourceDebugExtension(value={"SMAP\nAfflictionAbilityHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AfflictionAbilityHandler.kt\ndev/sterner/witchery/features/affliction/ability/AfflictionAbilityHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,176:1\n1617#2,9:177\n1869#2:186\n1870#2:189\n1626#2:190\n774#2:191\n865#2,2:192\n774#2:194\n865#2,2:195\n774#2:197\n865#2,2:198\n774#2:215\n865#2,2:216\n774#2:218\n865#2,2:219\n774#2:221\n865#2,2:222\n774#2:224\n865#2,2:225\n1869#2,2:227\n1#3:187\n1#3:188\n69#4,15:200\n69#4,15:229\n*S KotlinDebug\n*F\n+ 1 AfflictionAbilityHandler.kt\ndev/sterner/witchery/features/affliction/ability/AfflictionAbilityHandler\n*L\n33#1:177,9\n33#1:186\n33#1:189\n33#1:190\n59#1:191\n59#1:192,2\n60#1:194\n60#1:195,2\n69#1:197\n69#1:198,2\n92#1:215\n92#1:216,2\n98#1:218\n98#1:219,2\n104#1:221\n104#1:222,2\n110#1:224\n110#1:225,2\n116#1:227,2\n33#1:188\n82#1:200,15\n130#1:229,15\n*E\n"})
public final class AfflictionAbilityHandler
implements AbilityHandler {
    @NotNull
    public static final AfflictionAbilityHandler INSTANCE = new AfflictionAbilityHandler();

    private AfflictionAbilityHandler() {
    }

    @Override
    @Nullable
    public Integer getAbilityIndex() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return null;
        }
        LocalPlayer player = localPlayer;
        return AfflictionPlayerAttachment.getData((Player)player).getAbilityIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AfflictionAbility> getAbilities(@NotNull Player player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(player);
        List<String> selectedIds = data2.getSelectedAbilities();
        List<AfflictionAbility> allAvailable = this.getAllAvailableAbilities(player);
        Iterable $this$mapNotNull$iv = selectedIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AfflictionAbility it$iv$iv;
            Object v0;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String id = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = allAvailable;
                for (Object t : iterable2) {
                    AfflictionAbility it = (AfflictionAbility)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            if ((AfflictionAbility)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List noDeath = (List)destination$iv$iv;
        if (DeathTransformationHelper.INSTANCE.isDeath(player)) {
            CollectionsKt.plus((Collection)noDeath, (Iterable)((Iterable)DeathAbility.getEntries()));
        } else if (DeathTransformationHelper.INSTANCE.hasDeathBoots(player)) {
            CollectionsKt.plus((Collection)noDeath, (Object)DeathAbility.FLUID_WALKING);
        }
        return noDeath;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<AfflictionAbility> getAllAvailableAbilities(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        deathAbilities = CollectionsKt.emptyList();
        if (DeathTransformationHelper.INSTANCE.isDeath(player)) {
            deathAbilities = (List)DeathAbility.getEntries();
        } else if (DeathTransformationHelper.INSTANCE.hasDeathBoots(player)) {
            deathAbilities = CollectionsKt.listOf((Object)DeathAbility.FLUID_WALKING);
        }
        data = AfflictionPlayerAttachment.getData(player);
        vampLevel = data.getVampireLevel();
        wereLevel = data.getWerewolfLevel();
        lichLevel = data.getLichLevel();
        $this$filter$iv = (Iterable)VampireAbility.getEntries();
        $i$f$filter = false;
        var10_10 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VampireAbility)element$iv$iv;
            $i$a$-filter-AfflictionAbilityHandler$getAllAvailableAbilities$vampAbilities$1 = false;
            if (!it.isAvailable(player, vampLevel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vampAbilities = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)WerewolfAbility.getEntries();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            ability = (WerewolfAbility)element$iv$iv;
            $i$a$-filter-AfflictionAbilityHandler$getAllAvailableAbilities$wereAbilities$1 = false;
            if (!ability.isAvailable(player, wereLevel)) ** GOTO lbl-1000
            switch (WhenMappings.$EnumSwitchMapping$0[ability.ordinal()]) {
                case 1: 
                case 2: {
                    v0 = WerewolfAbility.Companion.hasMoonCharm(player);
                    break;
                }
                default: {
                    v0 = true;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        wereAbilities = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)LichdomAbility.getEntries();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (LichdomAbility)element$iv$iv;
            $i$a$-filter-AfflictionAbilityHandler$getAllAvailableAbilities$lichAbilities$1 = false;
            if (!it.isAvailable(player, lichLevel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        lichAbilities = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)vampAbilities, (Iterable)wereAbilities), (Iterable)lichAbilities), (Iterable)deathAbilities);
    }

    @Override
    public void setAbilityIndex(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.updateAbilityIndex(player, index);
        if (player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AfflictionAbilitySelectionC2SPayload(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void updateAbilityIndex(@NotNull Player player, int index) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$updateAbilityIndex_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$updateAbilityIndex_u24lambda_u240.withAbilityIndex(index);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    public final void addAbilityOnLevelUp(@NotNull Player player, int newLevel, @NotNull AfflictionTypes affliction, boolean force) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)affliction), (String)"affliction");
        List currentSelectedIds = CollectionsKt.toMutableList((Collection)AfflictionPlayerAttachment.getData(player).getSelectedAbilities());
        List newAbilities = switch (WhenMappings.$EnumSwitchMapping$1[affliction.ordinal()]) {
            case 1 -> {
                Enum it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)VampireAbility.getEntries();
                boolean $i$f$filter = false;
                Iterable var11_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (VampireAbility)element$iv$iv;
                    boolean $i$a$-filter-AfflictionAbilityHandler$addAbilityOnLevelUp$newAbilities$1 = false;
                    if (!(((VampireAbility)it).getRequiredLevel() == newLevel && ((VampireAbility)it).getAffliction() == affliction || force)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                Enum it;
                Iterable $this$filter$iv = (Iterable)WerewolfAbility.getEntries();
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (WerewolfAbility)element$iv$iv;
                    boolean $i$a$-filter-AfflictionAbilityHandler$addAbilityOnLevelUp$newAbilities$2 = false;
                    if (!(((WerewolfAbility)it).getRequiredLevel() == newLevel && ((WerewolfAbility)it).getAffliction() == affliction || force)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 3 -> {
                Enum it;
                Iterable $this$filter$iv = (Iterable)LichdomAbility.getEntries();
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (LichdomAbility)element$iv$iv;
                    boolean $i$a$-filter-AfflictionAbilityHandler$addAbilityOnLevelUp$newAbilities$3 = false;
                    if (!(((LichdomAbility)it).getRequiredLevel() == newLevel && ((LichdomAbility)it).getAffliction() == affliction || force)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 4 -> {
                Enum it;
                Iterable $this$filter$iv = (Iterable)DeathAbility.getEntries();
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DeathAbility)element$iv$iv;
                    boolean $i$a$-filter-AfflictionAbilityHandler$addAbilityOnLevelUp$newAbilities$4 = false;
                    if (!false) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$forEach$iv = newAbilities;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object newAbility = element$iv = iterator.next();
            boolean bl = false;
            if (currentSelectedIds.contains(((AfflictionAbility)newAbility).getId()) || currentSelectedIds.size() >= 5) continue;
            currentSelectedIds.add(((AfflictionAbility)newAbility).getId());
        }
        if (!((Collection)currentSelectedIds).isEmpty()) {
            this.updateSelectedAbilities(player, currentSelectedIds);
        }
    }

    public static /* synthetic */ void addAbilityOnLevelUp$default(AfflictionAbilityHandler afflictionAbilityHandler, Player player, int n, AfflictionTypes afflictionTypes, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        afflictionAbilityHandler.addAbilityOnLevelUp(player, n, afflictionTypes, bl);
    }

    public final void updateSelectedAbilities(@NotNull Player player, @NotNull List<String> abilities) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(abilities, (String)"abilities");
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$updateSelectedAbilities_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$updateSelectedAbilities_u24lambda_u240.withSelectedAbilities(abilities).withAbilityIndex(-1);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
    }

    public final boolean scroll(@Nullable Minecraft minecraft, double scrollDeltaX, double scrollDeltaY) {
        Minecraft minecraft2 = minecraft;
        if (minecraft2 == null || (minecraft2 = minecraft2.player) == null) {
            return false;
        }
        Minecraft player = minecraft2;
        List<AfflictionAbility> abilities = this.getAbilities((Player)player);
        if (abilities.isEmpty()) {
            return false;
        }
        return new AbilityScrollHandler().handleScroll((Player)player, scrollDeltaY, this);
    }

    @Nullable
    public final AfflictionAbility getSelectedAbility(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<AfflictionAbility> abilities = this.getAbilities(player);
        int index = AfflictionPlayerAttachment.getData(player).getAbilityIndex();
        return (AfflictionAbility)CollectionsKt.getOrNull(abilities, (int)index);
    }

    public final boolean useSelectedAbility(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionAbility ability = this.getSelectedAbility(player);
        if (ability == null) {
            return false;
        }
        boolean isOnCooldown = AbilityCooldownManager.INSTANCE.isOnCooldown(player, ability);
        if (isOnCooldown) {
            return false;
        }
        if (player.level().isClientSide) {
            int index = AfflictionPlayerAttachment.getData(player).getAbilityIndex();
            PacketDistributor.sendToServer((CustomPacketPayload)new AfflictionAbilityUseC2SPayload(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        boolean result = ability.use(player);
        return result;
    }

    public final void openSelectionScreen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.level().isClientSide) {
            Minecraft.getInstance().setScreen((Screen)new AbilitySelectionScreen(player));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WerewolfAbility.values().length];
            try {
                nArray[WerewolfAbility.WOLF_FORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WerewolfAbility.WEREWOLF_FORM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AfflictionTypes.values().length];
            try {
                nArray[AfflictionTypes.VAMPIRISM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.LYCANTHROPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.LICHDOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AfflictionTypes.DEATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

