/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.event;

import dev.sterner.witchery.core.api.event.VampireEvent;
import dev.sterner.witchery.core.api.interfaces.VillagerTransfix;
import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.core.registry.WitcheryAttributes;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.network.SpawnBloodParticlesS2CPayload;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/features/affliction/event/AfflictionHandler;", "", "<init>", "()V", "DAMAGE_DISTRIBUTION", "", "POISON_CHANCE_BAD_BLOOD", "POISON_EFFECT_DURATION", "", "VILLAGER_DAMAGE_AMOUNT", "CAGE_DETECTION_RANGE", "", "MIN_CAGE_BARS", "BLOOD_HEALING_THRESHOLD", "BLOOD_TRANSFER_AMOUNT_BASE", "handleHurt", "player", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "original", "vampireDrinkBloodAbility", "", "Lnet/minecraft/server/level/ServerPlayer;", "entity", "playerBloodData", "Ldev/sterner/witchery/features/blood/BloodPoolLivingEntityAttachment$Data;", "handleTargetDamage", "", "targetData", "transferBlood", "playBloodDrinkingEffects", "handleVillagerHalfBlood", "villager", "Lnet/minecraft/world/entity/npc/Villager;", "witchery"})
@SourceDebugExtension(value={"SMAP\nAfflictionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AfflictionHandler.kt\ndev/sterner/witchery/features/affliction/event/AfflictionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1788#2,4:210\n1788#2,4:214\n*S KotlinDebug\n*F\n+ 1 AfflictionHandler.kt\ndev/sterner/witchery/features/affliction/event/AfflictionHandler\n*L\n198#1:210,4\n199#1:214,4\n*E\n"})
public final class AfflictionHandler {
    @NotNull
    public static final AfflictionHandler INSTANCE = new AfflictionHandler();
    private static final float DAMAGE_DISTRIBUTION = 0.75f;
    private static final float POISON_CHANCE_BAD_BLOOD = 0.15f;
    private static final int POISON_EFFECT_DURATION = 200;
    private static final float VILLAGER_DAMAGE_AMOUNT = 2.0f;
    private static final double CAGE_DETECTION_RANGE = 2.0;
    private static final int MIN_CAGE_BARS = 15;
    private static final int BLOOD_HEALING_THRESHOLD = 75;
    private static final int BLOOD_TRANSFER_AMOUNT_BASE = 10;

    private AfflictionHandler() {
    }

    public final float handleHurt(@NotNull LivingEntity player, @NotNull DamageSource damageSource, float original) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!(player instanceof Player)) {
            return original;
        }
        int level = AfflictionPlayerAttachment.getData((Player)player).getVampireLevel();
        if (level < 1) {
            return original;
        }
        BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData(player);
        if (bloodData.getBloodPool() > 0) {
            int bloodPerHealthPoint = 75;
            int maxBloodAbsorbableDamage = bloodData.getBloodPool() / bloodPerHealthPoint;
            float absorbableDamage = Math.min(original * 0.75f, (float)maxBloodAbsorbableDamage);
            int bloodRequired = (int)(absorbableDamage * (float)bloodPerHealthPoint);
            BloodPoolLivingEntityAttachment.setData(player, BloodPoolLivingEntityAttachment.Data.copy$default(bloodData, 0, bloodData.getBloodPool() - bloodRequired, 1, null));
            return original * 0.25f;
        }
        return original;
    }

    public final boolean vampireDrinkBloodAbility(@NotNull ServerPlayer player, @NotNull LivingEntity entity, @NotNull BloodPoolLivingEntityAttachment.Data playerBloodData) {
        BloodPoolReloadListener.BloodData quality;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)playerBloodData, (String)"playerBloodData");
        BloodPoolLivingEntityAttachment.Data targetData = BloodPoolLivingEntityAttachment.getData(entity);
        Object object = BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().get(entity.getType());
        if (object == null) {
            object = quality = Integer.valueOf(0);
        }
        if (playerBloodData.getBloodPool() >= playerBloodData.getMaxBlood() || targetData.getBloodPool() < 0 || targetData.getMaxBlood() <= 0) {
            return false;
        }
        VampireEvent.BloodDrink event = new VampireEvent.BloodDrink((Player)player, entity);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)quality, (Object)0) && player.level().random.nextFloat() < 0.15f) {
            player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
        }
        int targetHalfBlood = targetData.getMaxBlood() / 2;
        if (targetData.getBloodPool() <= targetHalfBlood && !player.isShiftKeyDown() && entity instanceof Villager) {
            this.handleVillagerHalfBlood(player, (Villager)entity);
        }
        if (targetData.getBloodPool() <= targetHalfBlood && !player.isShiftKeyDown()) {
            return true;
        }
        this.playBloodDrinkingEffects(player, entity);
        this.transferBlood(player, entity);
        this.handleTargetDamage(player, entity, targetData);
        return true;
    }

    private final void handleTargetDamage(ServerPlayer player, LivingEntity entity, BloodPoolLivingEntityAttachment.Data targetData) {
        boolean shouldHurt;
        int targetHalfBlood = targetData.getMaxBlood() / 2;
        boolean bl = entity instanceof Villager && entity instanceof VillagerTransfix && !entity.isSleeping() && !((VillagerTransfix)entity).witchery$isTransfixed() ? true : (shouldHurt = targetData.getBloodPool() < targetHalfBlood);
        if (shouldHurt) {
            if (entity instanceof Villager && AfflictionPlayerAttachment.getData((Player)player).getVillagersHalfBlood().contains(((Villager)entity).getUUID())) {
                VampireLeveling.removeVillagerHalfBlood((Player)player, (Villager)entity);
                VampireLeveling.removeTrappedVillager((Player)player, (Villager)entity);
            }
            entity.hurt(player.damageSources().playerAttack((Player)player), 2.0f);
        }
        if (targetData.getBloodPool() <= 0) {
            if (entity instanceof Player) {
                ((Player)entity).hurt(player.damageSources().playerAttack((Player)player), 2.0f);
            } else {
                entity.kill();
            }
        }
    }

    private final void transferBlood(ServerPlayer player, LivingEntity entity) {
        AttributeInstance attributeInstance = player.getAttribute((Holder)WitcheryAttributes.getVAMPIRE_DRINK_SPEED());
        int attribute = attributeInstance != null ? (int)attributeInstance.getValue() : 0;
        int modifiedAmount = 10 + attribute;
        BloodPoolHandler.decreaseBlood(entity, modifiedAmount);
        BloodPoolHandler.increaseBlood((LivingEntity)player, modifiedAmount);
    }

    private final void playBloodDrinkingEffects(ServerPlayer player, LivingEntity entity) {
        player.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.HONEY_DRINK, SoundSource.PLAYERS);
        Vec3 particlePosition = entity.position().add(0.5, 0.5, 0.5);
        ServerLevel serverLevel = player.serverLevel();
        Player player2 = (Player)player;
        Intrinsics.checkNotNull((Object)particlePosition);
        PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new SpawnBloodParticlesS2CPayload(player2, particlePosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private final void handleVillagerHalfBlood(ServerPlayer player, Villager villager) {
        int roof;
        int n;
        VampireLeveling.increaseVillagersHalfBlood(player, villager);
        List cageStates = villager.level().getBlockStates(villager.getBoundingBox().inflate(2.0, 2.0, 2.0)).toList();
        BlockPos roofPos = villager.blockPosition().above(2);
        List roofStates = villager.level().getBlockStates(new AABB(roofPos).inflate(2.0, 0.0, 2.0)).toList();
        Intrinsics.checkNotNull(cageStates);
        Iterable $this$count$iv = cageStates;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                BlockState it = (BlockState)element$iv;
                boolean bl = false;
                if (!it.is(Blocks.IRON_BARS) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int bars = n;
        Intrinsics.checkNotNull(roofStates);
        Iterable $this$count$iv2 = roofStates;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                BlockState it = (BlockState)element$iv;
                boolean bl = false;
                if (!(!it.is(Blocks.IRON_BARS) && !it.is(Blocks.AIR) && !it.is(Blocks.CAVE_AIR)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = roof = count$iv;
        }
        if (bars >= 15 && roof >= 9) {
            VampireLeveling.increaseTrappedVillagers(player, villager);
        }
    }
}

