/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.event;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.WerewolfEntity;
import dev.sterner.witchery.core.registry.WitcheryAttributes;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.TransformationPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireAbility;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfLeveling;
import dev.sterner.witchery.mixin.LivingEntityAccessor;
import dev.sterner.witchery.mixin.WalkAnimationStateAccessor;
import dev.sterner.witchery.network.RefreshDimensionsS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010&\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010)\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010*\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010+\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010,\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010-\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J\u000e\u0010.\u001a\u00020(2\u0006\u0010 \u001a\u00020!J\u000e\u0010/\u001a\u00020(2\u0006\u0010 \u001a\u00020!J\u0010\u00100\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u00101\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ldev/sterner/witchery/features/affliction/event/TransformationHandler;", "", "<init>", "()V", "SMALL_SIZE", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "getSMALL_SIZE", "()Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "setSMALL_SIZE", "(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V", "MAX_COOLDOWN", "", "bat", "Lnet/minecraft/world/entity/ambient/Bat;", "getBat", "()Lnet/minecraft/world/entity/ambient/Bat;", "setBat", "(Lnet/minecraft/world/entity/ambient/Bat;)V", "wolf", "Lnet/minecraft/world/entity/animal/Wolf;", "getWolf", "()Lnet/minecraft/world/entity/animal/Wolf;", "setWolf", "(Lnet/minecraft/world/entity/animal/Wolf;)V", "werewolf", "Ldev/sterner/witchery/content/entity/WerewolfEntity;", "getWerewolf", "()Ldev/sterner/witchery/content/entity/WerewolfEntity;", "setWerewolf", "(Ldev/sterner/witchery/content/entity/WerewolfEntity;)V", "villageCheckTicker", "getBatEntity", "player", "Lnet/minecraft/world/entity/player/Player;", "getWolfEntity", "isBat", "", "isWolf", "isWerewolf", "removeForm", "", "setBatForm", "setWolfForm", "setWereWolfForm", "removeAllTransformationModifiers", "increaseBatFormTimer", "tickWolf", "tickBat", "checkForVillage", "copyTransforms", "to", "Lnet/minecraft/world/entity/Mob;", "from", "Lnet/minecraft/client/player/AbstractClientPlayer;", "witchery"})
public final class TransformationHandler {
    @NotNull
    public static final TransformationHandler INSTANCE = new TransformationHandler();
    @NotNull
    private static AttributeModifier SMALL_SIZE = new AttributeModifier(Witchery.Companion.id("small_transform"), -0.6, AttributeModifier.Operation.ADD_VALUE);
    public static final int MAX_COOLDOWN = 200;
    @Nullable
    private static Bat bat;
    @Nullable
    private static Wolf wolf;
    @Nullable
    private static WerewolfEntity werewolf;
    private static int villageCheckTicker;

    private TransformationHandler() {
    }

    @NotNull
    public final AttributeModifier getSMALL_SIZE() {
        return SMALL_SIZE;
    }

    public final void setSMALL_SIZE(@NotNull AttributeModifier attributeModifier) {
        Intrinsics.checkNotNullParameter((Object)attributeModifier, (String)"<set-?>");
        SMALL_SIZE = attributeModifier;
    }

    @Nullable
    public final Bat getBat() {
        return bat;
    }

    public final void setBat(@Nullable Bat bat) {
        TransformationHandler.bat = bat;
    }

    @Nullable
    public final Wolf getWolf() {
        return wolf;
    }

    public final void setWolf(@Nullable Wolf wolf) {
        TransformationHandler.wolf = wolf;
    }

    @Nullable
    public final WerewolfEntity getWerewolf() {
        return werewolf;
    }

    public final void setWerewolf(@Nullable WerewolfEntity werewolfEntity) {
        werewolf = werewolfEntity;
    }

    @JvmStatic
    @Nullable
    public static final Bat getBatEntity(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (bat == null) {
            bat = (Bat)EntityType.BAT.create(player.level());
            Bat bat = TransformationHandler.bat;
            Intrinsics.checkNotNull((Object)bat);
            bat.setResting(false);
        }
        return bat;
    }

    @JvmStatic
    @Nullable
    public static final Wolf getWolfEntity(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (wolf == null) {
            wolf = (Wolf)EntityType.WOLF.create(player.level());
        }
        return wolf;
    }

    @JvmStatic
    @Nullable
    public static final WerewolfEntity getWerewolf(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (werewolf == null) {
            werewolf = (WerewolfEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getWEREWOLF().get()).create(player.level());
        }
        return werewolf;
    }

    @JvmStatic
    public static final boolean isBat(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return TransformationPlayerAttachment.getData(player).getTransformationType() == TransformationPlayerAttachment.TransformationType.BAT;
    }

    @JvmStatic
    public static final boolean isWolf(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return TransformationPlayerAttachment.getData(player).getTransformationType() == TransformationPlayerAttachment.TransformationType.WOLF;
    }

    @JvmStatic
    public static final boolean isWerewolf(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return TransformationPlayerAttachment.getData(player).getTransformationType() == TransformationPlayerAttachment.TransformationType.WEREWOLF;
    }

    @JvmStatic
    public static final void removeForm(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TransformationPlayerAttachment.setData(player, new TransformationPlayerAttachment.Data(TransformationPlayerAttachment.TransformationType.NONE, 200, 0, 4, null));
        INSTANCE.removeAllTransformationModifiers(player);
        VampireLeveling.INSTANCE.updateModifiers(player, AfflictionPlayerAttachment.getData(player).getVampireLevel(), false);
        WerewolfLeveling.INSTANCE.updateModifiers(player, false, false);
        if (player.level() instanceof ServerLevel) {
            WitcheryUtil.tryDisableBatFlight(player);
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new RefreshDimensionsS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @JvmStatic
    public static final void setBatForm(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.level().isClientSide) {
            return;
        }
        INSTANCE.removeAllTransformationModifiers(player);
        VampireLeveling.INSTANCE.updateModifiers(player, AfflictionPlayerAttachment.getData(player).getVampireLevel(), true);
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.SCALE);
        if (attributeInstance != null) {
            AttributeInstance attribute = attributeInstance;
            boolean bl = false;
            if (!attribute.hasModifier(SMALL_SIZE.id())) {
                attribute.addPermanentModifier(SMALL_SIZE);
            }
        }
        TransformationPlayerAttachment.setData(player, new TransformationPlayerAttachment.Data(TransformationPlayerAttachment.TransformationType.BAT, 0, 0));
    }

    @JvmStatic
    public static final void setWolfForm(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        INSTANCE.removeAllTransformationModifiers(player);
        WerewolfLeveling.INSTANCE.updateModifiers(player, true, false);
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.SCALE);
        if (attributeInstance != null) {
            AttributeInstance attribute = attributeInstance;
            boolean bl = false;
            if (!attribute.hasModifier(SMALL_SIZE.id())) {
                attribute.addPermanentModifier(SMALL_SIZE);
            }
        }
        TransformationPlayerAttachment.setData(player, new TransformationPlayerAttachment.Data(TransformationPlayerAttachment.TransformationType.WOLF, 0, 0, 6, null));
    }

    @JvmStatic
    public static final void setWereWolfForm(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        INSTANCE.removeAllTransformationModifiers(player);
        WerewolfLeveling.INSTANCE.updateModifiers(player, false, true);
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.SCALE);
        if (attributeInstance != null) {
            attributeInstance.removeModifier(SMALL_SIZE);
        }
        TransformationPlayerAttachment.setData(player, new TransformationPlayerAttachment.Data(TransformationPlayerAttachment.TransformationType.WEREWOLF, 0, 0, 6, null));
    }

    private final void removeAllTransformationModifiers(Player player) {
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.SCALE);
        if (attributeInstance != null) {
            attributeInstance.removeModifier(SMALL_SIZE);
        }
        WerewolfLeveling.INSTANCE.removeAllModifiers(player);
        VampireLeveling.INSTANCE.updateModifiers(player, AfflictionPlayerAttachment.getData(player).getVampireLevel(), false);
    }

    @JvmStatic
    public static final void increaseBatFormTimer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TransformationPlayerAttachment.Data data2 = TransformationPlayerAttachment.getData(player);
        TransformationPlayerAttachment.setData(player, TransformationPlayerAttachment.Data.copy$default(data2, null, data2.getBatFormTicker() + 1, 0, 5, null));
    }

    public final void tickWolf(@NotNull Player player) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player.level() instanceof ServerLevel || !TransformationHandler.isWolf(player)) break block1;
            Wolf wolf = TransformationHandler.wolf;
            if (wolf != null) {
                wolf.tick();
            }
        }
    }

    public final void tickBat(@NotNull Player player) {
        block5: {
            block6: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                    if (AfflictionPlayerAttachment.getData(player).getVampireLevel() != VampireAbility.BAT_FORM.getRequiredLevel()) break block5;
                    if (!(player.level() instanceof ServerLevel)) break block6;
                    if (!TransformationHandler.isBat(player)) break block7;
                    this.checkForVillage(player);
                    if (player.onGround()) {
                        if (player.getAbilities().flying) {
                            player.getAbilities().flying = false;
                            player.onUpdateAbilities();
                        }
                    } else {
                        WitcheryUtil.tryEnableBatFlight(player);
                    }
                    TransformationHandler.increaseBatFormTimer(player);
                    AttributeInstance attributeInstance = player.getAttribute((Holder)WitcheryAttributes.getVAMPIRE_BAT_FORM_DURATION());
                    int maxBatTime = ((Number)(attributeInstance != null ? (Number)attributeInstance.getValue() : (Number)0)).intValue();
                    int n = AfflictionPlayerAttachment.getData(player).getVampireLevel() >= 9 ? 1200 : 0;
                    TransformationPlayerAttachment.Data data2 = TransformationPlayerAttachment.getData(player);
                    TransformationPlayerAttachment.setData(player, TransformationPlayerAttachment.Data.copy$default(data2, null, 0, maxBatTime += n, 3, null));
                    if (TransformationPlayerAttachment.getData(player).getBatFormTicker() <= maxBatTime || player.isCreative() || player.isSpectator()) break block5;
                    TransformationHandler.removeForm(player);
                    break block5;
                }
                if (AfflictionPlayerAttachment.getData(player).getVampireLevel() == 7) {
                    VampireLeveling.resetVillages(player);
                }
                WitcheryUtil.tryDisableBatFlight(player);
                break block5;
            }
            if (!TransformationHandler.isBat(player)) break block5;
            Bat bat = TransformationHandler.bat;
            if (bat != null) {
                bat.tick();
            }
        }
    }

    private final void checkForVillage(Player player) {
        int n;
        if (AfflictionPlayerAttachment.getData(player).getVampireLevel() == 7 && (villageCheckTicker = (n = villageCheckTicker) + 1) > 20) {
            villageCheckTicker = 0;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.structureManager().getStructureWithPieceAt(player.blockPosition(), StructureTags.VILLAGE).isValid()) {
                StructureStart structureStart = serverLevel.structureManager().getStructureWithPieceAt(player.blockPosition(), StructureTags.VILLAGE);
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ChunkPos chunkPos = structureStart.getChunkPos();
                Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"getChunkPos(...)");
                VampireLeveling.addVillage(serverPlayer, chunkPos);
            }
        }
    }

    public final void copyTransforms(@NotNull Mob to, @NotNull AbstractClientPlayer from) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        to.tickCount = from.tickCount;
        to.hurtTime = from.hurtTime;
        to.hurtDuration = from.hurtDuration;
        to.yHeadRot = from.yHeadRot;
        to.yBodyRot = from.yBodyRot;
        to.yHeadRotO = from.yHeadRotO;
        to.yBodyRotO = from.yBodyRotO;
        to.swinging = from.swinging;
        to.swingTime = from.swingTime;
        to.attackAnim = from.attackAnim;
        to.oAttackAnim = from.oAttackAnim;
        to.setXRot(from.getXRot());
        to.xRotO = from.xRotO;
        to.setShiftKeyDown(from.isShiftKeyDown());
        to.setSprinting(from.isSprinting());
        to.setSwimming(from.isSwimming());
        to.setInvisible(from.isInvisible());
        to.setGlowingTag(from.hasGlowingTag());
        to.setAirSupply(from.getAirSupply());
        to.setCustomName(from.getCustomName());
        to.setCustomNameVisible(from.isCustomNameVisible());
        to.setPose(from.getPose());
        to.setTicksFrozen(from.getTicksFrozen());
        to.setOnGround(from.onGround());
        to.horizontalCollision = from.horizontalCollision;
        to.verticalCollision = from.verticalCollision;
        to.verticalCollisionBelow = from.verticalCollisionBelow;
        to.minorHorizontalCollision = from.minorHorizontalCollision;
        to.setSharedFlagOnFire(from.isOnFire());
        to.invulnerableTime = from.invulnerableTime;
        to.noCulling = from.noCulling;
        to.isInPowderSnow = from.isInPowderSnow;
        to.wasInPowderSnow = from.wasInPowderSnow;
        to.wasOnFire = from.wasOnFire;
        to.swingingArm = from.getMainArm() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        to.deathTime = from.deathTime;
        WalkAnimationState walkAnimationState = to.walkAnimation;
        Intrinsics.checkNotNull((Object)walkAnimationState, (String)"null cannot be cast to non-null type dev.sterner.witchery.mixin.WalkAnimationStateAccessor");
        WalkAnimationStateAccessor toAccessor = (WalkAnimationStateAccessor)walkAnimationState;
        WalkAnimationState walkAnimationState2 = from.walkAnimation;
        Intrinsics.checkNotNull((Object)walkAnimationState2, (String)"null cannot be cast to non-null type dev.sterner.witchery.mixin.WalkAnimationStateAccessor");
        WalkAnimationStateAccessor fromAccessor = (WalkAnimationStateAccessor)walkAnimationState2;
        toAccessor.setWalkSpeed(fromAccessor.getWalkSpeed());
        toAccessor.setWalkSpeedOld(fromAccessor.getWalkSpeedOld());
        toAccessor.setWalkPosition(fromAccessor.getWalkPosition());
        float swimAmt = ((LivingEntityAccessor)from).getSwimAmount();
        ((LivingEntityAccessor)to).setSwimAmount(swimAmt);
        float swimAmtO = ((LivingEntityAccessor)from).getSwimAmountO();
        ((LivingEntityAccessor)to).setSwimAmountO(swimAmtO);
        to.startUsingItem(((LivingEntity)from).getUsedItemHand());
    }
}

