/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.vampire;

import dev.sterner.witchery.content.block.sacrificial_circle.SacrificialBlock;
import dev.sterner.witchery.content.item.WineGlassItem;
import dev.sterner.witchery.core.api.event.VampireEvent;
import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryAttributes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryDamageSources;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import dev.sterner.witchery.mixin.DamageSourcesInvoker;
import dev.sterner.witchery.network.SpawnBloodParticlesS2CPayload;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0018H\u0007J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020%H\u0002J\u0018\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010/\u001a\u000200R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireSpecificEventHandler;", "", "<init>", "()V", "RESPAWN_BLOOD_AMOUNT", "", "RESPAWN_FOOD_LEVEL", "BLOOD_HEALING_THRESHOLD", "BLOOD_HEALING_AMOUNT", "", "NIGHT_VISION_DURATION", "SPEED_BOOST_DURATION", "BLOOD_DRAIN_TICK_RATE", "SUN_DAMAGE_AMOUNT", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "vampireTick", "Lnet/minecraft/server/level/ServerPlayer;", "handleBloodHealing", "applyActiveEffects", "handleSunExposure", "hasReversedSunTarot", "", "handleSunDamage", "affData", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "hasSunReversed", "decreaseSunTick", "playSunDamageEffects", "respawn", "oldPlayer", "newPlayer", "alive", "onKillEntity", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "resetNightCount", "hasNearbySacrificialCircle", "entity", "performChickenBloodRitual", "chicken", "Lnet/minecraft/world/entity/animal/Chicken;", "makeSacrificialCircle", "blockPos", "Lnet/minecraft/core/BlockPos;", "witchery"})
@SourceDebugExtension(value={"SMAP\nVampireSpecificEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VampireSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/vampire/VampireSpecificEventHandler\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n69#2,15:334\n69#2,15:349\n69#2,15:364\n1869#3,2:379\n*S KotlinDebug\n*F\n+ 1 VampireSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/vampire/VampireSpecificEventHandler\n*L\n112#1:334,15\n190#1:349,15\n235#1:364,15\n317#1:379,2\n*E\n"})
public final class VampireSpecificEventHandler {
    @NotNull
    public static final VampireSpecificEventHandler INSTANCE = new VampireSpecificEventHandler();
    public static final int RESPAWN_BLOOD_AMOUNT = 900;
    private static final int RESPAWN_FOOD_LEVEL = 10;
    private static final int BLOOD_HEALING_THRESHOLD = 75;
    private static final float BLOOD_HEALING_AMOUNT = 1.0f;
    private static final int NIGHT_VISION_DURATION = 300;
    private static final int SPEED_BOOST_DURATION = 80;
    private static final int BLOOD_DRAIN_TICK_RATE = 20;
    private static final float SUN_DAMAGE_AMOUNT = 2.0f;

    private VampireSpecificEventHandler() {
    }

    @JvmStatic
    public static final void tick(@Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        boolean isVampire = ((ServerPlayer)player).isAlive() && AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0;
        boolean hasSunReversed = INSTANCE.hasReversedSunTarot((ServerPlayer)player);
        if (isVampire) {
            VampireLeveling.increaseNightTicker((ServerPlayer)player);
            INSTANCE.vampireTick((ServerPlayer)player);
        } else if (hasSunReversed && ((ServerPlayer)player).isAlive()) {
            INSTANCE.handleSunExposure((ServerPlayer)player);
        }
    }

    private final void vampireTick(ServerPlayer player) {
        this.handleSunExposure(player);
        this.handleBloodHealing(player);
        this.applyActiveEffects(player);
    }

    private final void handleBloodHealing(ServerPlayer player) {
        BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        if (bloodData.getBloodPool() >= 75 && player.level().random.nextBoolean() && player.getHealth() < player.getMaxHealth() && player.getHealth() > 0.0f) {
            BloodPoolHandler.decreaseBlood((LivingEntity)player, 75);
            player.heal(1.0f);
        }
    }

    private final void applyActiveEffects(ServerPlayer player) {
        AfflictionPlayerAttachment.Data playerData = AfflictionPlayerAttachment.getData((Player)player);
        if (playerData.hasNightVision()) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300));
        }
        if (playerData.hasSpeedBoost()) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 80));
        }
    }

    private final void handleSunExposure(ServerPlayer player) {
        boolean isInSunlight = player.level().canSeeSky(player.blockPosition()) && player.level().isDay();
        AfflictionPlayerAttachment.Data currentData = AfflictionPlayerAttachment.getData((Player)player);
        int currentSunTick = currentData.getInSunTick();
        AttributeInstance attributeInstance = player.getAttribute((Holder)WitcheryAttributes.getVAMPIRE_SUN_RESISTANCE());
        int maxInSunTicks = (int)(attributeInstance != null ? attributeInstance.getValue() : 0.0);
        boolean hasSunReversed = this.hasReversedSunTarot(player);
        if (isInSunlight && currentData.getVampireLevel() > 0 || isInSunlight && hasSunReversed) {
            if (!player.isCreative() && !player.isSpectator()) {
                if (currentSunTick < maxInSunTicks) {
                    AfflictionPlayerAttachment.Data newData;
                    int newSunTick;
                    AfflictionPlayerAttachment.Data currentData$iv;
                    AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
                    Player player$iv = (Player)player;
                    boolean sync$iv = true;
                    boolean $i$f$smartUpdate = false;
                    AfflictionPlayerAttachment.Data $this$handleSunExposure_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
                    boolean bl = false;
                    AfflictionPlayerAttachment.Data newData$iv = $this$handleSunExposure_u24lambda_u240.incrementInSunTick(1, maxInSunTicks).withMaxInSunTickClient(maxInSunTicks);
                    AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
                    if (player$iv.level() instanceof ServerLevel) {
                        AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
                    }
                    if ((newSunTick = (newData = newData$iv).getInSunTick()) >= maxInSunTicks) {
                        this.handleSunDamage(player, newData, hasSunReversed);
                    }
                } else {
                    this.handleSunDamage(player, currentData, hasSunReversed);
                }
            }
        } else {
            this.decreaseSunTick(player);
        }
    }

    private final boolean hasReversedSunTarot(ServerPlayer player) {
        TarotPlayerAttachment.Data tarotData = TarotPlayerAttachment.getData((Player)player);
        int sunCardIndex = tarotData.getDrawnCards().indexOf(20);
        if (sunCardIndex != -1) {
            Boolean bl = (Boolean)CollectionsKt.getOrNull(tarotData.getReversedCards(), (int)sunCardIndex);
            return bl != null ? bl : false;
        }
        return false;
    }

    private final void handleSunDamage(ServerPlayer player, AfflictionPlayerAttachment.Data affData, boolean hasSunReversed) {
        DamageSources damageSources = player.level().damageSources();
        Intrinsics.checkNotNull((Object)damageSources, (String)"null cannot be cast to non-null type dev.sterner.witchery.mixin.DamageSourcesInvoker");
        DamageSource sunDamageSource = ((DamageSourcesInvoker)damageSources).invokeSource(WitcheryDamageSources.INSTANCE.getIN_SUN());
        BloodPoolLivingEntityAttachment.Data bloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        int vampireLevel = affData.getVampireLevel();
        VampireEvent.SunDamage event = new VampireEvent.SunDamage((Player)player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        if (hasSunReversed && vampireLevel == 0) {
            if (player.tickCount % 20 == 0) {
                player.hurt(sunDamageSource, 2.0f);
                this.playSunDamageEffects(player);
            }
            return;
        }
        if (vampireLevel < 5) {
            player.hurt(sunDamageSource, Float.MAX_VALUE);
        } else if (bloodData.getBloodPool() >= 75) {
            if (player.tickCount % 20 == 0) {
                player.hurt(sunDamageSource, 2.0f);
                this.playSunDamageEffects(player);
            }
        } else {
            player.hurt(sunDamageSource, Float.MAX_VALUE);
        }
    }

    private final void decreaseSunTick(ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData = AfflictionPlayerAttachment.getData((Player)player);
        if (currentData.getInSunTick() > 0) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$decreaseSunTick_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$decreaseSunTick_u24lambda_u240.decrementInSunTick(2);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
    }

    private final void playSunDamageEffects(ServerPlayer player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
        Entity entity = (Entity)player;
        Player player2 = (Player)player;
        Vec3 vec3 = player.position().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SpawnBloodParticlesS2CPayload(player2, vec3), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @JvmStatic
    public static final void respawn(@NotNull Player oldPlayer, @NotNull Player newPlayer, boolean alive) {
        Intrinsics.checkNotNullParameter((Object)oldPlayer, (String)"oldPlayer");
        Intrinsics.checkNotNullParameter((Object)newPlayer, (String)"newPlayer");
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(newPlayer);
        if (data2.getVampireLevel() > 0) {
            AfflictionPlayerAttachment.Data currentData$iv;
            BloodPoolLivingEntityAttachment.Data oldBloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)oldPlayer);
            newPlayer.getFoodData().setFoodLevel(10);
            BloodPoolLivingEntityAttachment.setData((LivingEntity)newPlayer, new BloodPoolLivingEntityAttachment.Data(oldBloodData.getMaxBlood(), 900));
            AttributeInstance attributeInstance = newPlayer.getAttribute((Holder)WitcheryAttributes.getVAMPIRE_SUN_RESISTANCE());
            int maxInSunTicks = (int)(attributeInstance != null ? attributeInstance.getValue() : 0.0);
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = newPlayer;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$respawn_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$respawn_u24lambda_u240.withInSunTick(0, maxInSunTicks).withMaxInSunTickClient(maxInSunTicks);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
    }

    @JvmStatic
    public static final void onKillEntity(@NotNull LivingEntity livingEntity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!(damageSource.getEntity() instanceof ServerPlayer)) {
            return;
        }
        Entity entity = damageSource.getEntity();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        ServerPlayer player = (ServerPlayer)entity;
        if (livingEntity instanceof Chicken && (player.getMainHandItem().is((Item)WitcheryItems.INSTANCE.getARTHANA().get()) || player.getOffhandItem().is((Item)WitcheryItems.INSTANCE.getWINE_GLASS().get())) && INSTANCE.hasNearbySacrificialCircle(livingEntity)) {
            INSTANCE.performChickenBloodRitual((Player)player, (Chicken)livingEntity);
        }
        if (livingEntity instanceof Blaze) {
            VampireLeveling.increaseKilledBlazes(player);
        }
    }

    @JvmStatic
    public static final void resetNightCount(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity instanceof Player && AfflictionPlayerAttachment.getData((Player)livingEntity).getVampireLevel() == 3) {
            VampireLeveling.resetNightCounter((Player)livingEntity);
        }
    }

    private final boolean hasNearbySacrificialCircle(LivingEntity entity) {
        Stream possibleSkull = BlockPos.betweenClosedStream((AABB)entity.getBoundingBox().inflate(2.0));
        Iterator iterator = possibleSkull.iterator();
        while (iterator.hasNext()) {
            BlockPos skullPos = (BlockPos)iterator.next();
            BlockState skullState = entity.level().getBlockState(skullPos);
            if (!skullState.is((Block)WitcheryBlocks.INSTANCE.getSACRIFICIAL_CIRCLE().get())) continue;
            return true;
        }
        return false;
    }

    private final void performChickenBloodRitual(Player player, Chicken chicken) {
        player.getOffhandItem().shrink(1);
        ItemStack stackCopy = player.getOffhandItem().copy();
        if (!stackCopy.isEmpty()) {
            Containers.dropItemStack((Level)chicken.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stackCopy);
        }
        ItemStack bloodWine = ((WineGlassItem)((Object)WitcheryItems.INSTANCE.getWINE_GLASS().get())).getDefaultInstance();
        bloodWine.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCHICKEN_BLOOD().get(), (Object)true);
        bloodWine.set((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get(), (Object)chicken.getUUID());
        player.setItemInHand(InteractionHand.OFF_HAND, bloodWine);
    }

    public final void makeSacrificialCircle(@NotNull Player player, @NotNull BlockPos blockPos) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            ArrayList<MultiBlockStructure.StructurePiece> pieces = SacrificialBlock.Companion.getSTRUCTURE().get().getStructurePieces();
            Iterable $this$forEach$iv = pieces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MultiBlockStructure.StructurePiece piece = (MultiBlockStructure.StructurePiece)element$iv;
                boolean bl = false;
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                MultiBlockStructure.StructurePiece.place$default(piece, blockPos, level, null, 4, null);
            }
            player.level().setBlockAndUpdate(blockPos, ((SacrificialBlock)((Object)WitcheryBlocks.INSTANCE.getSACRIFICIAL_CIRCLE().get())).defaultBlockState());
            BlockEntity blockEntity = player.level().getBlockEntity(blockPos);
            if (blockEntity == null) break block2;
            BlockEntity blockEntity2 = blockEntity;
            boolean bl = false;
            if (blockEntity2 instanceof MultiBlockComponentBlockEntity) {
                ((MultiBlockComponentBlockEntity)blockEntity2).setCorePos(blockPos);
            }
        }
    }
}

