/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.coven;

import dev.sterner.witchery.content.entity.CovenWitchEntity;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.features.coven.CovenDialogue;
import dev.sterner.witchery.features.coven.CovenPlayerAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0017J \u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u0017J\u0016\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010%\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010&\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0005JB\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190*0\u00142\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010/\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u00101\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u00102\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0014H\u0002J\u0016\u00105\u001a\u00020$2\u0006\u0010!\u001a\u0002062\u0006\u00107\u001a\u000208R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldev/sterner/witchery/features/coven/CovenHandler;", "", "<init>", "()V", "MAX_COVEN_WITCHES", "", "MAX_PLAYER_MEMBERS", "addWitchToCoven", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "addPlayerToCoven", "leader", "member", "removePlayerFromCoven", "memberUUID", "Ljava/util/UUID;", "getActiveCovenPlayers", "", "Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "radius", "", "getActiveCovenSize", "ritualPos", "summonWitchFromCoven", "index", "summonTo", "Lnet/minecraft/world/phys/Vec3;", "summonCovenAroundRitual", "level", "Lnet/minecraft/world/level/Level;", "returnWitchToCoven", "", "updateWitchHealth", "handleWitchDeath", "resurrectWitch", "removeWitchFromCoven", "calculateCirclePositions", "Lkotlin/Pair;", "centerX", "centerY", "centerZ", "count", "findValidSpawnPosition", "origin", "isSpawnPositionValid", "findWitchIndex", "witches", "Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$WitchData;", "disbandCovenFromContract", "Lnet/minecraft/server/level/ServerLevel;", "stack", "Lnet/minecraft/world/item/ItemStack;", "witchery"})
@SourceDebugExtension(value={"SMAP\nCovenHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CovenHandler.kt\ndev/sterner/witchery/features/coven/CovenHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n774#2:510\n865#2,2:511\n1617#2,9:513\n1869#2:522\n1870#2:524\n1626#2:525\n774#2:526\n865#2,2:527\n1788#2,4:529\n774#2:533\n865#2,2:534\n1878#2,2:536\n360#2,7:538\n1880#2:545\n774#2:546\n865#2:547\n1761#2,3:548\n866#2:551\n1869#2,2:552\n1563#2:554\n1634#2,3:555\n1583#2,11:558\n1878#2,2:569\n1761#2,3:571\n1880#2:575\n1594#2:576\n1#3:523\n1#3:574\n*S KotlinDebug\n*F\n+ 1 CovenHandler.kt\ndev/sterner/witchery/features/coven/CovenHandler\n*L\n177#1:510\n177#1:511,2\n193#1:513,9\n193#1:522\n193#1:524\n193#1:525\n195#1:526\n195#1:527,2\n207#1:529,4\n241#1:533\n241#1:534,2\n254#1:536,2\n262#1:538,7\n254#1:545\n463#1:546\n463#1:547\n463#1:548,3\n463#1:551\n464#1:552,2\n468#1:554\n468#1:555,3\n469#1:558,11\n469#1:569,2\n471#1:571,3\n469#1:575\n469#1:576\n193#1:523\n469#1:574\n*E\n"})
public final class CovenHandler {
    @NotNull
    public static final CovenHandler INSTANCE = new CovenHandler();
    private static final int MAX_COVEN_WITCHES = 13;
    private static final int MAX_PLAYER_MEMBERS = 8;

    private CovenHandler() {
    }

    public final boolean addWitchToCoven(@NotNull ServerPlayer player, @NotNull CovenWitchEntity witch) {
        Component witchName;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
        Component component = witch.getCustomName();
        if (component == null) {
            RandomSource randomSource = witch.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            component = witchName = (Component)CovenDialogue.INSTANCE.generateName(randomSource);
        }
        if (!witch.getHasDemonHeart()) {
            RandomSource randomSource = witch.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            player.sendSystemMessage((Component)CovenDialogue.INSTANCE.getNeedsHeartResponse(witchName, randomSource).withStyle(ChatFormatting.DARK_RED));
            return false;
        }
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        if (data2.getCovenWitches().size() >= 13) {
            RandomSource randomSource = witch.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            player.sendSystemMessage((Component)CovenDialogue.INSTANCE.getCovenFullResponse(witchName, randomSource).withStyle(ChatFormatting.RED));
            return false;
        }
        CompoundTag tag = new CompoundTag();
        if (witch.saveAsPassenger(tag)) {
            CovenPlayerAttachment.Data.WitchData witchData = new CovenPlayerAttachment.Data.WitchData(tag, witch.getHealth(), witchName, false, 8, null);
            List updatedWitches = CollectionsKt.plus((Collection)data2.getCovenWitches(), (Object)witchData);
            CovenPlayerAttachment.Data updatedData = CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null);
            CovenPlayerAttachment.setData$default((Player)player, updatedData, false, 4, null);
            CovenPlayerAttachment.INSTANCE.sync((Player)player, updatedData);
            ServerLevel level = player.serverLevel();
            level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, witch.getX(), witch.getY() + (double)witch.getBbHeight() / 2.0, witch.getZ(), 30, 0.3, 0.5, 0.3, 0.05);
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, witch.getX(), witch.getY() + (double)witch.getBbHeight() / 2.0, witch.getZ(), 20, 0.3, 0.5, 0.3, 0.1);
            witch.discard();
            player.level().playSound(null, player.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.0f, 1.0f);
            RandomSource randomSource = witch.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            player.sendSystemMessage((Component)CovenDialogue.INSTANCE.getBindingResponse(witchName, randomSource).withStyle(ChatFormatting.LIGHT_PURPLE));
            return true;
        }
        return false;
    }

    public final boolean addPlayerToCoven(@NotNull ServerPlayer leader, @NotNull ServerPlayer member) {
        Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)leader);
        if (data2.getPlayerMembers().size() >= 8) {
            leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.player_limit"), true);
            return false;
        }
        if (data2.getPlayerMembers().contains(member.getUUID())) {
            leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.already_member"), true);
            return false;
        }
        List updatedMembers = CollectionsKt.plus((Collection)data2.getPlayerMembers(), (Object)member.getUUID());
        CovenPlayerAttachment.Data updatedData = CovenPlayerAttachment.Data.copy$default(data2, null, updatedMembers, 0L, 5, null);
        CovenPlayerAttachment.setData$default((Player)leader, updatedData, false, 4, null);
        CovenPlayerAttachment.INSTANCE.sync((Player)leader, updatedData);
        Object[] objectArray = new Object[]{member.getDisplayName()};
        leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.added_player", (Object[])objectArray), false);
        objectArray = new Object[]{leader.getDisplayName()};
        member.displayClientMessage((Component)Component.translatable((String)"witchery.coven.joined", (Object[])objectArray), false);
        leader.level().playSound(null, leader.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removePlayerFromCoven(@NotNull ServerPlayer leader, @NotNull UUID memberUUID) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
        Intrinsics.checkNotNullParameter((Object)memberUUID, (String)"memberUUID");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)leader);
        if (!data2.getPlayerMembers().contains(memberUUID)) {
            leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.not_member"), true);
            return false;
        }
        Iterable $this$filter$iv = data2.getPlayerMembers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UUID it = (UUID)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)memberUUID))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List updatedMembers = (List)destination$iv$iv;
        CovenPlayerAttachment.Data updatedData = CovenPlayerAttachment.Data.copy$default(data2, null, updatedMembers, 0L, 5, null);
        CovenPlayerAttachment.setData$default((Player)leader, updatedData, false, 4, null);
        CovenPlayerAttachment.INSTANCE.sync((Player)leader, updatedData);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> getActiveCovenPlayers(@NotNull Player leader, @NotNull BlockPos pos, double radius) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)leader, (String)"leader");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData(leader);
        Level level = leader.level();
        Iterable $this$mapNotNull$iv = data2.getPlayerMembers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UUID uuid = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (level.getPlayerByUUID(uuid) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player member = (Player)element$iv$iv;
            boolean bl = false;
            if (!(member.isAlive() && Intrinsics.areEqual((Object)member.level(), (Object)level) && member.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= radius * radius)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final int getActiveCovenSize(@NotNull Player player, @NotNull BlockPos ritualPos) {
        int n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)ritualPos, (String)"ritualPos");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData(player);
        Iterable $this$count$iv = data2.getCovenWitches();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CovenPlayerAttachment.Data.WitchData it = (CovenPlayerAttachment.Data.WitchData)element$iv;
                boolean bl = false;
                if (!it.isActive() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int activeWitches = n;
        int activePlayers = this.getActiveCovenPlayers(player, ritualPos, 16.0).size();
        return activeWitches + activePlayers + 1;
    }

    @Nullable
    public final CovenWitchEntity summonWitchFromCoven(@NotNull Player player, int index, @NotNull Vec3 summonTo) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)summonTo, (String)"summonTo");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData(player);
        CovenPlayerAttachment.Data.WitchData witchData = (CovenPlayerAttachment.Data.WitchData)CollectionsKt.getOrNull(data2.getCovenWitches(), (int)index);
        if (witchData == null) {
            return null;
        }
        CovenPlayerAttachment.Data.WitchData witchData2 = witchData;
        if (!witchData2.isActive()) {
            return null;
        }
        Level level = player.level();
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)witchData2.getEntityData().copy(), (Level)level, CovenHandler::summonWitchFromCoven$lambda$0);
        CovenWitchEntity covenWitchEntity = entity instanceof CovenWitchEntity ? (CovenWitchEntity)entity : null;
        if (covenWitchEntity == null) {
            return null;
        }
        CovenWitchEntity mob = covenWitchEntity;
        mob.setHealth(witchData2.getHealth());
        mob.moveTo(summonTo.x, summonTo.y, summonTo.z);
        mob.setIsCoven(true);
        mob.setOwner(player.getUUID());
        mob.resetDespawnTimer();
        level.addFreshEntity((Entity)mob);
        return mob;
    }

    /*
     * WARNING - void declaration
     */
    public final int summonCovenAroundRitual(@NotNull Player player, @NotNull Level level, @NotNull BlockPos ritualPos) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ritualPos, (String)"ritualPos");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData(player);
        Iterable $this$filter$iv = data2.getCovenWitches();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CovenPlayerAttachment.Data.WitchData it = (CovenPlayerAttachment.Data.WitchData)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeWitches = (List)destination$iv$iv;
        if (activeWitches.isEmpty()) {
            return 0;
        }
        List<Pair<Double, Double>> positions = this.calculateCirclePositions((double)ritualPos.getX() + 0.5, (double)ritualPos.getY() + 1.0, (double)ritualPos.getZ() + 0.5, activeWitches.size(), 4.5);
        int summonedCount = 0;
        Iterable $this$forEachIndexed$iv = activeWitches;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            CovenWitchEntity it;
            BlockPos spawnPos;
            int n;
            CovenHandler covenHandler;
            Player player2;
            block7: {
                void $this$indexOfFirst$iv;
                Pair pair;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CovenPlayerAttachment.Data.WitchData cfr_ignored_0 = (CovenPlayerAttachment.Data.WitchData)item$iv;
                int actualIndex = n2;
                boolean bl = false;
                if ((Pair)CollectionsKt.getOrNull(positions, (int)actualIndex) == null) continue;
                double x = ((Number)pair.component1()).doubleValue();
                double z = ((Number)pair.component2()).doubleValue();
                BlockPos targetPos = BlockPos.containing((double)x, (double)((double)ritualPos.getY() + 1.0), (double)z);
                Intrinsics.checkNotNull((Object)targetPos);
                if (CovenHandler.findValidSpawnPosition$default(INSTANCE, level, targetPos, 0, 4, null) == null) continue;
                List<CovenPlayerAttachment.Data.WitchData> list = data2.getCovenWitches();
                player2 = player;
                covenHandler = INSTANCE;
                boolean $i$f$indexOfFirst = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$indexOfFirst$iv) {
                    CovenPlayerAttachment.Data.WitchData it2 = (CovenPlayerAttachment.Data.WitchData)item$iv2;
                    boolean bl2 = false;
                    if (it2 == activeWitches.get(actualIndex)) {
                        n = index$iv2;
                        break block7;
                    }
                    ++index$iv2;
                }
                n = -1;
            }
            int n3 = n;
            CovenWitchEntity witch = covenHandler.summonWitchFromCoven(player2, n3, new Vec3((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5));
            if (witch == null) continue;
            boolean bl = false;
            Optional<BlockPos> optional = Optional.of(ritualPos);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            it.setLastRitualPos(optional);
            ++summonedCount;
        }
        if (summonedCount > 0 && player instanceof ServerPlayer) {
            CovenPlayerAttachment.setData$default(player, CovenPlayerAttachment.Data.copy$default(data2, null, null, level.getGameTime(), 3, null), false, 4, null);
        }
        return summonedCount;
    }

    public final void returnWitchToCoven(@NotNull ServerPlayer player, @NotNull CovenWitchEntity witch) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        int witchIndex = this.findWitchIndex(witch, data2.getCovenWitches());
        if (witchIndex == -1) {
            return;
        }
        List updatedWitches = CollectionsKt.toMutableList((Collection)data2.getCovenWitches());
        updatedWitches.set(witchIndex, CovenPlayerAttachment.Data.WitchData.copy$default((CovenPlayerAttachment.Data.WitchData)updatedWitches.get(witchIndex), null, RangesKt.coerceAtLeast((float)witch.getHealth(), (float)1.0f), null, false, 13, null));
        CovenPlayerAttachment.setData$default((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null), false, 4, null);
    }

    public final void updateWitchHealth(@NotNull ServerPlayer player, @NotNull CovenWitchEntity witch) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        int witchIndex = this.findWitchIndex(witch, data2.getCovenWitches());
        if (witchIndex == -1) {
            return;
        }
        List updatedWitches = CollectionsKt.toMutableList((Collection)data2.getCovenWitches());
        updatedWitches.set(witchIndex, CovenPlayerAttachment.Data.WitchData.copy$default((CovenPlayerAttachment.Data.WitchData)updatedWitches.get(witchIndex), null, witch.getHealth(), null, false, 13, null));
        CovenPlayerAttachment.setData((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null), false);
    }

    public final void handleWitchDeath(@NotNull ServerPlayer player, @NotNull CovenWitchEntity witch) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        int witchIndex = this.findWitchIndex(witch, data2.getCovenWitches());
        if (witchIndex == -1) {
            return;
        }
        List updatedWitches = CollectionsKt.toMutableList((Collection)data2.getCovenWitches());
        updatedWitches.set(witchIndex, CovenPlayerAttachment.Data.WitchData.copy$default((CovenPlayerAttachment.Data.WitchData)updatedWitches.get(witchIndex), null, 0.0f, null, false, 5, null));
        CovenPlayerAttachment.setData$default((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null), false, 4, null);
        CovenPlayerAttachment.INSTANCE.sync((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null));
        player.displayClientMessage((Component)Component.translatable((String)"witchery.coven.witch_died"), false);
    }

    public final boolean resurrectWitch(@NotNull ServerPlayer player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        if (!(0 <= index ? index < ((Collection)data2.getCovenWitches()).size() : false)) {
            return false;
        }
        CovenPlayerAttachment.Data.WitchData witch = data2.getCovenWitches().get(index);
        if (witch.isActive()) {
            return false;
        }
        List updatedWitches = CollectionsKt.toMutableList((Collection)data2.getCovenWitches());
        updatedWitches.set(index, CovenPlayerAttachment.Data.WitchData.copy$default(witch, null, 20.0f, null, true, 5, null));
        CovenPlayerAttachment.setData$default((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null), false, 4, null);
        CovenPlayerAttachment.INSTANCE.sync((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null));
        return true;
    }

    public final boolean removeWitchFromCoven(@NotNull ServerPlayer player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)player);
        if (!(0 <= index ? index < ((Collection)data2.getCovenWitches()).size() : false)) {
            return false;
        }
        List updatedWitches = CollectionsKt.toMutableList((Collection)data2.getCovenWitches());
        updatedWitches.remove(index);
        CovenPlayerAttachment.setData$default((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null), false, 4, null);
        CovenPlayerAttachment.INSTANCE.sync((Player)player, CovenPlayerAttachment.Data.copy$default(data2, updatedWitches, null, 0L, 6, null));
        return true;
    }

    private final List<Pair<Double, Double>> calculateCirclePositions(double centerX, double centerY, double centerZ, int count, double radius) {
        if (count <= 0) {
            return CollectionsKt.emptyList();
        }
        List positions = new ArrayList();
        double angleIncrement = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double angle = (double)i * angleIncrement;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            positions.add(new Pair((Object)x, (Object)z));
        }
        return positions;
    }

    private final BlockPos findValidSpawnPosition(Level level, BlockPos origin, int radius) {
        if (this.isSpawnPositionValid(level, origin)) {
            return origin;
        }
        int r = 1;
        if (r <= radius) {
            while (true) {
                for (int dy = -1; dy < 2; ++dy) {
                    for (int angle = 0; angle < 8; ++angle) {
                        double radians = (double)angle * Math.PI / (double)4;
                        int dx = (int)((double)r * Math.cos(radians));
                        int dz = (int)((double)r * Math.sin(radians));
                        BlockPos checkPos = origin.offset(dx, dy, dz);
                        Intrinsics.checkNotNull((Object)checkPos);
                        if (!this.isSpawnPositionValid(level, checkPos)) continue;
                        return checkPos;
                    }
                }
                if (r == radius) break;
                ++r;
            }
        }
        return null;
    }

    static /* synthetic */ BlockPos findValidSpawnPosition$default(CovenHandler covenHandler, Level level, BlockPos blockPos, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return covenHandler.findValidSpawnPosition(level, blockPos, n);
    }

    private final boolean isSpawnPositionValid(Level level, BlockPos pos) {
        return level.getBlockState(pos).canBeReplaced() && level.getBlockState(pos.above()).canBeReplaced() && !level.getBlockState(pos.below()).isAir();
    }

    private final int findWitchIndex(CovenWitchEntity witch, List<CovenPlayerAttachment.Data.WitchData> witches) {
        int n = ((Collection)witches).size();
        for (int i = 0; i < n; ++i) {
            CompoundTag tag = witches.get(i).getEntityData();
            if (!tag.hasUUID("UUID") || !Intrinsics.areEqual((Object)tag.getUUID("UUID"), (Object)witch.getUUID())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void disbandCovenFromContract(@NotNull ServerLevel level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        DataComponentType componentType = (DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID_ORDERED_LIST().get();
        LinkedList contractList = (LinkedList)stack.get(componentType);
        Collection collection = contractList;
        if (!(collection == null || collection.isEmpty())) {
            UUID leaderUuid = (UUID)((Pair)CollectionsKt.first((List)contractList)).getFirst();
            ServerPlayer leader = level.getServer().getPlayerList().getPlayer(leaderUuid);
            if (leader != null) {
                void $this$mapIndexedNotNullTo$iv$iv;
                void $this$mapTo$iv$iv;
                Object element$iv3;
                void $this$forEach$iv;
                Object it;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                CovenPlayerAttachment.Data data2 = CovenPlayerAttachment.getData((Player)leader);
                Iterable iterable = data2.getPlayerMembers();
                boolean $i$f$filter = false;
                void var10_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    Object element$iv$iv;
                    block14: {
                        element$iv$iv = iterator.next();
                        UUID memberUuid = (UUID)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = contractList;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (Pair)element$iv2;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)memberUuid)) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    UUID memberUuid = (UUID)element$iv3;
                    boolean bl = false;
                    INSTANCE.removePlayerFromCoven(leader, memberUuid);
                }
                Iterable $this$map$iv = contractList;
                boolean $i$f$map = false;
                element$iv3 = $this$map$iv;
                Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Pair bl2 = (Pair)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add((String)it2.getSecond());
                }
                List contractWitchNames = (List)destination$iv$iv2;
                Iterable $this$mapIndexedNotNull$iv = data2.getCovenWitches();
                boolean $i$f$mapIndexedNotNull = false;
                destination$iv$iv2 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    boolean bl;
                    int index;
                    block15: {
                        void witchData;
                        void element$iv$iv;
                        int n;
                        if ((n = index$iv$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        it = item$iv$iv$iv;
                        int index$iv$iv = n;
                        boolean bl4 = false;
                        CovenPlayerAttachment.Data.WitchData witchData2 = (CovenPlayerAttachment.Data.WitchData)element$iv$iv;
                        index = index$iv$iv;
                        boolean bl5 = false;
                        String witchName = witchData.getName().getString();
                        Iterable $this$any$iv = contractWitchNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv4 : $this$any$iv) {
                                String it3 = (String)element$iv4;
                                boolean bl6 = false;
                                String string = ((Object)StringsKt.trim((CharSequence)it3)).toString();
                                Intrinsics.checkNotNull((Object)witchName);
                                if (!Intrinsics.areEqual((Object)string, (Object)((Object)StringsKt.trim((CharSequence)witchName)).toString())) continue;
                                bl = true;
                                break block15;
                            }
                            bl = false;
                        }
                    }
                    if ((bl ? Integer.valueOf(index) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl7 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List witchesToRemove = (List)destination$iv$iv3;
                Iterator iterator2 = CollectionsKt.sortedDescending((Iterable)witchesToRemove).iterator();
                while (iterator2.hasNext()) {
                    int index = ((Number)iterator2.next()).intValue();
                    this.removeWitchFromCoven(leader, index);
                }
                leader.displayClientMessage((Component)Component.translatable((String)"witchery.coven.contract_destroyed"), false);
                level.playSound(null, leader.blockPosition(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 0.5f);
                level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, leader.getX(), leader.getY() + 1.0, leader.getZ(), 20, 0.5, 0.5, 0.5, 0.05);
            }
        }
    }

    private static final Entity summonWitchFromCoven$lambda$0(Entity it) {
        return it;
    }
}

