/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.coven;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncCovenS2CPayload;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/features/coven/CovenPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "", "Data", "witchery"})
public final class CovenPlayerAttachment {
    @NotNull
    public static final CovenPlayerAttachment INSTANCE = new CovenPlayerAttachment();

    private CovenPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getCOVEN_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2, boolean sync) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getCOVEN_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        if (sync) {
            INSTANCE.sync(player, data2);
        }
    }

    public static /* synthetic */ void setData$default(Player player, Data data2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        CovenPlayerAttachment.setData(player, data2, bl);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncCovenS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB1\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data;", "", "covenWitches", "", "Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$WitchData;", "playerMembers", "Ljava/util/UUID;", "lastRitualTime", "", "<init>", "(Ljava/util/List;Ljava/util/List;J)V", "getCovenWitches", "()Ljava/util/List;", "getPlayerMembers", "getLastRitualTime", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "WitchData", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<WitchData> covenWitches;
        @NotNull
        private final List<UUID> playerMembers;
        private final long lastRitualTime;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@NotNull List<WitchData> covenWitches, @NotNull List<UUID> playerMembers, long lastRitualTime) {
            Intrinsics.checkNotNullParameter(covenWitches, (String)"covenWitches");
            Intrinsics.checkNotNullParameter(playerMembers, (String)"playerMembers");
            this.covenWitches = covenWitches;
            this.playerMembers = playerMembers;
            this.lastRitualTime = lastRitualTime;
        }

        public /* synthetic */ Data(List list, List list2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(list, list2, l);
        }

        @NotNull
        public final List<WitchData> getCovenWitches() {
            return this.covenWitches;
        }

        @NotNull
        public final List<UUID> getPlayerMembers() {
            return this.playerMembers;
        }

        public final long getLastRitualTime() {
            return this.lastRitualTime;
        }

        @NotNull
        public final List<WitchData> component1() {
            return this.covenWitches;
        }

        @NotNull
        public final List<UUID> component2() {
            return this.playerMembers;
        }

        public final long component3() {
            return this.lastRitualTime;
        }

        @NotNull
        public final Data copy(@NotNull List<WitchData> covenWitches, @NotNull List<UUID> playerMembers, long lastRitualTime) {
            Intrinsics.checkNotNullParameter(covenWitches, (String)"covenWitches");
            Intrinsics.checkNotNullParameter(playerMembers, (String)"playerMembers");
            return new Data(covenWitches, playerMembers, lastRitualTime);
        }

        public static /* synthetic */ Data copy$default(Data data2, List list, List list2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = data2.covenWitches;
            }
            if ((n & 2) != 0) {
                list2 = data2.playerMembers;
            }
            if ((n & 4) != 0) {
                l = data2.lastRitualTime;
            }
            return data2.copy(list, list2, l);
        }

        @NotNull
        public String toString() {
            return "Data(covenWitches=" + this.covenWitches + ", playerMembers=" + this.playerMembers + ", lastRitualTime=" + this.lastRitualTime + ")";
        }

        public int hashCode() {
            int result = ((Object)this.covenWitches).hashCode();
            result = result * 31 + ((Object)this.playerMembers).hashCode();
            result = result * 31 + Long.hashCode(this.lastRitualTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual(this.covenWitches, data2.covenWitches)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.playerMembers, data2.playerMembers)) {
                return false;
            }
            return this.lastRitualTime == data2.lastRitualTime;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)WitchData.Companion.getCODEC().listOf().fieldOf("covenWitches").forGetter(Data::CODEC$lambda$0$0), (App)UUIDUtil.CODEC.listOf().fieldOf("playerMembers").forGetter(Data::CODEC$lambda$0$1), (App)Codec.LONG.fieldOf("lastRitualTime").forGetter(Data::CODEC$lambda$0$2)).apply((Applicative)instance, Data::new);
        }

        private static final List CODEC$lambda$0$0(Data it) {
            return it.covenWitches;
        }

        private static final List CODEC$lambda$0$1(Data it) {
            return it.playerMembers;
        }

        private static final Long CODEC$lambda$0$2(Data it) {
            return it.lastRitualTime;
        }

        public Data() {
            this(null, null, 0L, 7, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("coven_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$WitchData;", "", "entityData", "Lnet/minecraft/nbt/CompoundTag;", "health", "", "name", "Lnet/minecraft/network/chat/Component;", "isActive", "", "<init>", "(Lnet/minecraft/nbt/CompoundTag;FLnet/minecraft/network/chat/Component;Z)V", "getEntityData", "()Lnet/minecraft/nbt/CompoundTag;", "getHealth", "()F", "getName", "()Lnet/minecraft/network/chat/Component;", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
        public static final class WitchData {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final CompoundTag entityData;
            private final float health;
            @NotNull
            private final Component name;
            private final boolean isActive;
            @NotNull
            private static final Codec<Component> COMPONENT_CODEC;
            @NotNull
            private static final Codec<WitchData> CODEC;

            public WitchData(@NotNull CompoundTag entityData, float health, @NotNull Component name, boolean isActive) {
                Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.entityData = entityData;
                this.health = health;
                this.name = name;
                this.isActive = isActive;
            }

            public /* synthetic */ WitchData(CompoundTag compoundTag, float f, Component component, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    bl = true;
                }
                this(compoundTag, f, component, bl);
            }

            @NotNull
            public final CompoundTag getEntityData() {
                return this.entityData;
            }

            public final float getHealth() {
                return this.health;
            }

            @NotNull
            public final Component getName() {
                return this.name;
            }

            public final boolean isActive() {
                return this.isActive;
            }

            @NotNull
            public final CompoundTag component1() {
                return this.entityData;
            }

            public final float component2() {
                return this.health;
            }

            @NotNull
            public final Component component3() {
                return this.name;
            }

            public final boolean component4() {
                return this.isActive;
            }

            @NotNull
            public final WitchData copy(@NotNull CompoundTag entityData, float health, @NotNull Component name, boolean isActive) {
                Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new WitchData(entityData, health, name, isActive);
            }

            public static /* synthetic */ WitchData copy$default(WitchData witchData, CompoundTag compoundTag, float f, Component component, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    compoundTag = witchData.entityData;
                }
                if ((n & 2) != 0) {
                    f = witchData.health;
                }
                if ((n & 4) != 0) {
                    component = witchData.name;
                }
                if ((n & 8) != 0) {
                    bl = witchData.isActive;
                }
                return witchData.copy(compoundTag, f, component, bl);
            }

            @NotNull
            public String toString() {
                return "WitchData(entityData=" + this.entityData + ", health=" + this.health + ", name=" + this.name + ", isActive=" + this.isActive + ")";
            }

            public int hashCode() {
                int result = this.entityData.hashCode();
                result = result * 31 + Float.hashCode(this.health);
                result = result * 31 + this.name.hashCode();
                result = result * 31 + Boolean.hashCode(this.isActive);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WitchData)) {
                    return false;
                }
                WitchData witchData = (WitchData)other;
                if (!Intrinsics.areEqual((Object)this.entityData, (Object)witchData.entityData)) {
                    return false;
                }
                if (Float.compare(this.health, witchData.health) != 0) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.name, (Object)witchData.name)) {
                    return false;
                }
                return this.isActive == witchData.isActive;
            }

            private static final Component COMPONENT_CODEC$lambda$0(String str) {
                return (Component)Component.literal((String)str);
            }

            private static final Component COMPONENT_CODEC$lambda$1(Function1 $tmp0, Object p0) {
                return (Component)$tmp0.invoke(p0);
            }

            private static final String COMPONENT_CODEC$lambda$2(Component component) {
                return component.getString();
            }

            private static final String COMPONENT_CODEC$lambda$3(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }

            private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
                return instance.group((App)CompoundTag.CODEC.fieldOf("entityData").forGetter(WitchData::CODEC$lambda$0$0), (App)Codec.FLOAT.fieldOf("health").forGetter(WitchData::CODEC$lambda$0$1), (App)COMPONENT_CODEC.fieldOf("name").forGetter(WitchData::CODEC$lambda$0$2), (App)Codec.BOOL.fieldOf("isActive").forGetter(WitchData::CODEC$lambda$0$3)).apply((Applicative)instance, WitchData::new);
            }

            private static final CompoundTag CODEC$lambda$0$0(WitchData it) {
                return it.entityData;
            }

            private static final Float CODEC$lambda$0$1(WitchData it) {
                return Float.valueOf(it.health);
            }

            private static final Component CODEC$lambda$0$2(WitchData it) {
                return it.name;
            }

            private static final Boolean CODEC$lambda$0$3(WitchData it) {
                return it.isActive;
            }

            static {
                Codec codec = Codec.STRING.xmap(arg_0 -> WitchData.COMPONENT_CODEC$lambda$1(WitchData::COMPONENT_CODEC$lambda$0, arg_0), arg_0 -> WitchData.COMPONENT_CODEC$lambda$3(WitchData::COMPONENT_CODEC$lambda$2, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"xmap(...)");
                COMPONENT_CODEC = codec;
                Codec codec2 = RecordCodecBuilder.create(WitchData::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
                CODEC = codec2;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$WitchData$Companion;", "", "<init>", "()V", "COMPONENT_CODEC", "Lcom/mojang/serialization/Codec;", "Lnet/minecraft/network/chat/Component;", "CODEC", "Ldev/sterner/witchery/features/coven/CovenPlayerAttachment$Data$WitchData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Codec<WitchData> getCODEC() {
                    return CODEC;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

