/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.curse;

import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.event.CurseEvent;
import dev.sterner.witchery.core.registry.WitcheryCurseRegistry;
import dev.sterner.witchery.features.curse.CursePlayerAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\"\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0007J$\u0010#\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010$\u001a\u0004\u0018\u00010%J$\u0010&\u001a\u00020\u00152\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010'\u001a\u0004\u0018\u00010%J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/features/curse/CurseHandler;", "", "<init>", "()V", "addCurse", "", "player", "Lnet/minecraft/world/entity/player/Player;", "sourcePlayer", "Lnet/minecraft/server/level/ServerPlayer;", "curse", "Lnet/minecraft/resources/ResourceLocation;", "catBoosted", "duration", "", "removeCurse", "Ldev/sterner/witchery/core/api/Curse;", "removeAllCurses", "hasCurse", "getCurseDuration", "tickCurse", "", "onHurt", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "breakBlock", "level", "Lnet/minecraft/world/level/Level;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "serverPlayer", "placeBlock", "entity", "Lnet/minecraft/world/entity/Entity;", "attackEntity", "target", "getActiveCurses", "", "witchery"})
@SourceDebugExtension(value={"SMAP\nCurseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurseHandler.kt\ndev/sterner/witchery/features/curse/CurseHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1#2:281\n1869#3,2:282\n1761#3,3:284\n1563#3:287\n1634#3,3:288\n*S KotlinDebug\n*F\n+ 1 CurseHandler.kt\ndev/sterner/witchery/features/curse/CurseHandler\n*L\n92#1:282,2\n113#1:284,3\n276#1:287\n276#1:288,3\n*E\n"})
public final class CurseHandler {
    @NotNull
    public static final CurseHandler INSTANCE = new CurseHandler();

    private CurseHandler() {
    }

    public final boolean addCurse(@NotNull Player player, @Nullable ServerPlayer sourcePlayer, @NotNull ResourceLocation curse, boolean catBoosted, int duration) {
        block4: {
            Object v0;
            List data2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)curse, (String)"curse");
                CurseEvent.Added result = new CurseEvent.Added(player, sourcePlayer, curse, catBoosted);
                NeoForge.EVENT_BUS.post((Event)result);
                if (result.isCanceled()) {
                    return false;
                }
                data2 = CollectionsKt.toMutableList((Collection)CursePlayerAttachment.getData(player).getPlayerCurseList());
                Iterable iterable = data2;
                for (Object t : iterable) {
                    CursePlayerAttachment.PlayerCurseData it = (CursePlayerAttachment.PlayerCurseData)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCurseId(), (Object)curse)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            CursePlayerAttachment.PlayerCurseData existingCurse = v0;
            CursePlayerAttachment.PlayerCurseData newCurseData = new CursePlayerAttachment.PlayerCurseData(curse, duration, catBoosted);
            if (existingCurse != null) {
                data2.remove(existingCurse);
            }
            data2.add(newCurseData);
            CursePlayerAttachment.setData(player, new CursePlayerAttachment.Data(data2));
            Curse curse2 = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(newCurseData.getCurseId());
            if (curse2 == null) break block4;
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            curse2.onAdded(level, player, newCurseData.getCatBoosted());
        }
        return true;
    }

    public static /* synthetic */ boolean addCurse$default(CurseHandler curseHandler, Player player, ServerPlayer serverPlayer, ResourceLocation resourceLocation, boolean bl, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 24000;
        }
        return curseHandler.addCurse(player, serverPlayer, resourceLocation, bl, n);
    }

    public final boolean removeCurse(@NotNull Player player, @NotNull Curse curse) {
        Object v0;
        List data2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)curse, (String)"curse");
            data2 = CollectionsKt.toMutableList((Collection)CursePlayerAttachment.getData(player).getPlayerCurseList());
            ResourceLocation curseId = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().getKey((Object)curse);
            Iterable iterable = data2;
            for (Object t : iterable) {
                CursePlayerAttachment.PlayerCurseData it = (CursePlayerAttachment.PlayerCurseData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCurseId(), (Object)curseId)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        CursePlayerAttachment.PlayerCurseData playerCurseData = v0;
        if (playerCurseData == null) {
            return false;
        }
        CursePlayerAttachment.PlayerCurseData curseData = playerCurseData;
        Level level = player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        curse.onRemoved(level, player, curseData.getCatBoosted());
        data2.remove(curseData);
        CursePlayerAttachment.setData(player, new CursePlayerAttachment.Data(data2));
        return true;
    }

    public final int removeAllCurses(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<CursePlayerAttachment.PlayerCurseData> data2 = CursePlayerAttachment.getData(player).getPlayerCurseList();
        if (data2.isEmpty()) {
            return 0;
        }
        int count = data2.size();
        Level level = player.level();
        Iterable $this$forEach$iv = data2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CursePlayerAttachment.PlayerCurseData curseData = (CursePlayerAttachment.PlayerCurseData)element$iv;
            boolean bl = false;
            Curse curse = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curseData.getCurseId());
            if (curse == null) continue;
            Intrinsics.checkNotNull((Object)level);
            curse.onRemoved(level, player, curseData.getCatBoosted());
        }
        CursePlayerAttachment.setData(player, new CursePlayerAttachment.Data(new ArrayList()));
        return count;
    }

    public final boolean hasCurse(@NotNull Player player, @NotNull Curse curse) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)curse, (String)"curse");
            ResourceLocation curseId = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().getKey((Object)curse);
            Iterable $this$any$iv = CursePlayerAttachment.getData(player).getPlayerCurseList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CursePlayerAttachment.PlayerCurseData it = (CursePlayerAttachment.PlayerCurseData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getCurseId(), (Object)curseId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int getCurseDuration(@NotNull Player player, @NotNull Curse curse) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)curse, (String)"curse");
            ResourceLocation curseId = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().getKey((Object)curse);
            Iterable iterable = CursePlayerAttachment.getData(player).getPlayerCurseList();
            for (Object t : iterable) {
                CursePlayerAttachment.PlayerCurseData it = (CursePlayerAttachment.PlayerCurseData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCurseId(), (Object)curseId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CursePlayerAttachment.PlayerCurseData playerCurseData = v0;
        return playerCurseData != null ? playerCurseData.getDuration() : -1;
    }

    public final void tickCurse(@Nullable Player player) {
        if (player == null) {
            return;
        }
        CursePlayerAttachment.Data data2 = CursePlayerAttachment.getData(player);
        if (data2.getPlayerCurseList().isEmpty()) {
            return;
        }
        boolean dataModified = false;
        List curses = CollectionsKt.toMutableList((Collection)data2.getPlayerCurseList());
        Iterator iterator = curses.iterator();
        while (iterator.hasNext()) {
            CursePlayerAttachment.PlayerCurseData curseData = (CursePlayerAttachment.PlayerCurseData)iterator.next();
            if (curseData.getDuration() == 0) {
                curseData.setDuration(curseData.getDuration() - 1);
                dataModified = true;
                Curse curse = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curseData.getCurseId());
                if (curse != null) {
                    Level level = player.level();
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                    curse.onTickCurse(level, player, curseData.getCatBoosted());
                }
            }
            if (curseData.getDuration() != 0) continue;
            Curse curse = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curseData.getCurseId());
            if (curse != null) {
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                curse.onRemoved(level, player, curseData.getCatBoosted());
            }
            iterator.remove();
            dataModified = true;
        }
        if (dataModified) {
            CursePlayerAttachment.setData(player, new CursePlayerAttachment.Data(curses));
        }
    }

    public final void onHurt(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource, float amount) {
        if (!(livingEntity instanceof Player) || damageSource == null) {
            return;
        }
        CursePlayerAttachment.Data data2 = CursePlayerAttachment.getData((Player)livingEntity);
        for (CursePlayerAttachment.PlayerCurseData curse : data2.getPlayerCurseList()) {
            Curse curse2 = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curse.getCurseId());
            if (curse2 == null) continue;
            Level level = ((Player)livingEntity).level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            curse2.onHurt(level, (Player)livingEntity, damageSource, amount, curse.getCatBoosted());
        }
    }

    public final void breakBlock(@Nullable Level level, @NotNull BlockState blockState, @Nullable Player serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (serverPlayer == null || level == null) {
            return;
        }
        CursePlayerAttachment.Data data2 = CursePlayerAttachment.getData(serverPlayer);
        for (CursePlayerAttachment.PlayerCurseData curse : data2.getPlayerCurseList()) {
            Curse curse2 = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curse.getCurseId());
            if (curse2 == null) continue;
            curse2.breakBlock(level, serverPlayer, blockState, curse.getCatBoosted());
        }
    }

    public final void placeBlock(@Nullable Level level, @Nullable BlockState blockState, @Nullable Entity entity) {
        if (level == null || blockState == null || !(entity instanceof Player)) {
            return;
        }
        CursePlayerAttachment.Data data2 = CursePlayerAttachment.getData((Player)entity);
        for (CursePlayerAttachment.PlayerCurseData curse : data2.getPlayerCurseList()) {
            Curse curse2 = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curse.getCurseId());
            if (curse2 == null) continue;
            curse2.placeBlock(level, (Player)entity, blockState, curse.getCatBoosted());
        }
    }

    public final void attackEntity(@Nullable Player player, @Nullable Level level, @Nullable Entity target) {
        if (player == null || level == null || target == null) {
            return;
        }
        CursePlayerAttachment.Data data2 = CursePlayerAttachment.getData(player);
        for (CursePlayerAttachment.PlayerCurseData curse : data2.getPlayerCurseList()) {
            Curse curse2 = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(curse.getCurseId());
            if (curse2 == null) continue;
            curse2.attackEntity(level, player, target, curse.getCatBoosted());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceLocation> getActiveCurses(@NotNull Player player) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$map$iv = CursePlayerAttachment.getData(player).getPlayerCurseList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CursePlayerAttachment.PlayerCurseData playerCurseData = (CursePlayerAttachment.PlayerCurseData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCurseId());
        }
        return (List)destination$iv$iv;
    }
}

