/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.infusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.network.SyncInfusionS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionPlayerAttachment;", "", "<init>", "()V", "MAX_CHARGE", "", "getData", "Ldev/sterner/witchery/features/infusion/InfusionPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "setInfusionCharge", "charge", "getInfusionCharge", "sync", "Data", "witchery"})
public final class InfusionPlayerAttachment {
    @NotNull
    public static final InfusionPlayerAttachment INSTANCE = new InfusionPlayerAttachment();
    public static final int MAX_CHARGE = 6000;

    private InfusionPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getINFUSION_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getINFUSION_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    @JvmStatic
    public static final void setInfusionCharge(@NotNull Player player, int charge) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Data current = InfusionPlayerAttachment.getData(player);
        InfusionPlayerAttachment.setData(player, Data.copy$default(current, null, charge, 1, null));
        WitcheryApi.INSTANCE.makePlayerWitchy(player);
    }

    @JvmStatic
    public static final int getInfusionCharge(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return InfusionPlayerAttachment.getData(player).getCharge();
    }

    /*
     * WARNING - void declaration
     */
    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            void $this$sync_u24lambda_u240;
            CompoundTag compoundTag;
            CompoundTag compoundTag2 = compoundTag = new CompoundTag();
            Entity entity = (Entity)player;
            boolean bl = false;
            $this$sync_u24lambda_u240.putUUID("Id", player.getUUID());
            $this$sync_u24lambda_u240.putInt("Charge", data2.getCharge());
            $this$sync_u24lambda_u240.putString("Type", data2.getType().getSerializedName());
            CompoundTag compoundTag3 = compoundTag;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncInfusionS2CPayload(compoundTag3), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionPlayerAttachment$Data;", "", "type", "Ldev/sterner/witchery/features/infusion/InfusionType;", "charge", "", "<init>", "(Ldev/sterner/witchery/features/infusion/InfusionType;I)V", "getType", "()Ldev/sterner/witchery/features/infusion/InfusionType;", "getCharge", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final InfusionType type;
        private final int charge;
        @NotNull
        private static final ResourceLocation ID;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(@NotNull InfusionType type, int charge) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.charge = charge;
        }

        public /* synthetic */ Data(InfusionType infusionType, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                infusionType = InfusionType.NONE;
            }
            if ((n2 & 2) != 0) {
                n = 6000;
            }
            this(infusionType, n);
        }

        @NotNull
        public final InfusionType getType() {
            return this.type;
        }

        public final int getCharge() {
            return this.charge;
        }

        @NotNull
        public final InfusionType component1() {
            return this.type;
        }

        public final int component2() {
            return this.charge;
        }

        @NotNull
        public final Data copy(@NotNull InfusionType type, int charge) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new Data(type, charge);
        }

        public static /* synthetic */ Data copy$default(Data data2, InfusionType infusionType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                infusionType = data2.type;
            }
            if ((n2 & 2) != 0) {
                n = data2.charge;
            }
            return data2.copy(infusionType, n);
        }

        @NotNull
        public String toString() {
            return "Data(type=" + this.type + ", charge=" + this.charge + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.charge);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.type != data2.type) {
                return false;
            }
            return this.charge == data2.charge;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)InfusionType.Companion.getCODEC().fieldOf("type").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("charge").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final InfusionType CODEC$lambda$0$0(Data it) {
            return it.type;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.charge;
        }

        public Data() {
            this(null, 0, 3, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("infusion_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/infusion/InfusionPlayerAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/infusion/InfusionPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

