/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import dev.sterner.witchery.content.item.PoppetItem;
import dev.sterner.witchery.core.api.PoppetUsage;
import dev.sterner.witchery.core.api.interfaces.PoppetType;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/poppet/HungerProtectionPoppet;", "Ldev/sterner/witchery/core/api/interfaces/PoppetType;", "<init>", "()V", "item", "Ldev/sterner/witchery/content/item/PoppetItem;", "kotlin.jvm.PlatformType", "getItem", "()Ldev/sterner/witchery/content/item/PoppetItem;", "onActivate", "", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "onCorruptedActivate", "isValidFor", "entity", "getDurabilityDamage", "", "usage", "Ldev/sterner/witchery/core/api/PoppetUsage;", "witchery"})
public final class HungerProtectionPoppet
implements PoppetType {
    private final PoppetItem item = (PoppetItem)((Object)WitcheryItems.INSTANCE.getHUNGER_PROTECTION_POPPET().get());

    @Override
    public PoppetItem getItem() {
        return this.item;
    }

    @Override
    public boolean onActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof Player) {
            ((Player)owner).getFoodData().setFoodLevel(((Player)owner).getFoodData().getFoodLevel() + 2);
            owner.level().playSound(null, ((Player)owner).getX(), ((Player)owner).getY(), ((Player)owner).getZ(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.7f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onCorruptedActivate(@NotNull LivingEntity owner, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof Player)) {
            return this.onActivate(owner, source);
        }
        ((Player)owner).getFoodData().setFoodLevel(Math.max(0, ((Player)owner).getFoodData().getFoodLevel() - 4));
        owner.addEffect(new MobEffectInstance(MobEffects.HUNGER, 200, 2));
        if (owner.level() instanceof ServerLevel) {
            Level level = owner.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, ((Player)owner).getX(), ((Player)owner).getY() + (double)((Player)owner).getBbHeight() * 0.5, ((Player)owner).getZ(), 15, 0.3, 0.3, 0.3, 0.05);
        }
        owner.level().playSound(null, ((Player)owner).getX(), ((Player)owner).getY(), ((Player)owner).getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.7f, 0.8f);
        ((Player)owner).displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.hunger_effect").withStyle(ChatFormatting.DARK_PURPLE), true);
        return true;
    }

    @Override
    public boolean isValidFor(@NotNull LivingEntity entity, @Nullable DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        DamageSource damageSource = source;
        return damageSource != null ? damageSource.is(DamageTypes.STARVE) : false;
    }

    @Override
    public int getDurabilityDamage(@NotNull PoppetUsage usage) {
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        return 1;
    }
}

