/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.possession;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.core.api.interfaces.Possessable;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import dev.sterner.witchery.network.SyncPossessedDataS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/features/possession/PossessedDataAttachment;", "", "<init>", "()V", "get", "Ldev/sterner/witchery/features/possession/PossessedDataAttachment$Data;", "entity", "Lnet/minecraft/world/entity/Entity;", "set", "", "data", "syncToClient", "onMobConverted", "original", "Lnet/minecraft/world/entity/LivingEntity;", "converted", "Data", "witchery"})
public final class PossessedDataAttachment {
    @NotNull
    public static final PossessedDataAttachment INSTANCE = new PossessedDataAttachment();

    private PossessedDataAttachment() {
    }

    @NotNull
    public final Data get(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = entity.getData(WitcheryDataAttachments.getPOSSESSED_DATA());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    public final void set(@NotNull Entity entity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        entity.setData(WitcheryDataAttachments.getPOSSESSED_DATA(), (Object)data2);
        this.syncToClient(entity);
    }

    public final void syncToClient(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!entity.level().isClientSide) {
            int n = entity.getId();
            Data data2 = this.get(entity);
            RegistryAccess registryAccess = entity.level().registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SyncPossessedDataS2CPayload(n, data2, (HolderLookup.Provider)registryAccess), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void onMobConverted(@NotNull LivingEntity original, @NotNull LivingEntity converted) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)converted, (String)"converted");
        Possessable possessable = original instanceof Possessable ? (Possessable)original : null;
        Player possessor = possessable != null ? possessable.getPossessor() : null;
        Data possessedData = this.get((Entity)converted);
        if (possessor != null) {
            PossessionComponentAttachment.INSTANCE.get(possessor).stopPossessing(false);
            Possessable possessable2 = converted instanceof Possessable ? (Possessable)converted : null;
            if (possessable2 != null) {
                possessable2.setPossessor(possessor);
            }
        }
        Data data2 = this.get((Entity)original);
        RegistryAccess registryAccess = original.level().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        possessedData.copyFrom(data2, (HolderLookup.Provider)registryAccess);
        this.set((Entity)converted, possessedData);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J+\u0010(\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0007H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Ldev/sterner/witchery/features/possession/PossessedDataAttachment$Data;", "", "hungerDatai", "Lnet/minecraft/nbt/CompoundTag;", "inventory", "Lnet/minecraft/world/SimpleContainer;", "selectedSlot", "", "<init>", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/SimpleContainer;I)V", "getHungerDatai", "()Lnet/minecraft/nbt/CompoundTag;", "setHungerDatai", "(Lnet/minecraft/nbt/CompoundTag;)V", "getInventory", "()Lnet/minecraft/world/SimpleContainer;", "setInventory", "(Lnet/minecraft/world/SimpleContainer;)V", "getSelectedSlot", "()I", "setSelectedSlot", "(I)V", "getHungerData", "moveItems", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "fromPlayerToThis", "", "dropItems", "entity", "Lnet/minecraft/world/entity/Entity;", "onPossessed", "copyFrom", "original", "registryAccess", "Lnet/minecraft/core/HolderLookup$Provider;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private CompoundTag hungerDatai;
        @Nullable
        private SimpleContainer inventory;
        private int selectedSlot;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(@Nullable CompoundTag hungerDatai, @Nullable SimpleContainer inventory, int selectedSlot) {
            this.hungerDatai = hungerDatai;
            this.inventory = inventory;
            this.selectedSlot = selectedSlot;
        }

        public /* synthetic */ Data(CompoundTag compoundTag, SimpleContainer simpleContainer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                compoundTag = null;
            }
            if ((n2 & 2) != 0) {
                simpleContainer = null;
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(compoundTag, simpleContainer, n);
        }

        @Nullable
        public final CompoundTag getHungerDatai() {
            return this.hungerDatai;
        }

        public final void setHungerDatai(@Nullable CompoundTag compoundTag) {
            this.hungerDatai = compoundTag;
        }

        @Nullable
        public final SimpleContainer getInventory() {
            return this.inventory;
        }

        public final void setInventory(@Nullable SimpleContainer simpleContainer) {
            this.inventory = simpleContainer;
        }

        public final int getSelectedSlot() {
            return this.selectedSlot;
        }

        public final void setSelectedSlot(int n) {
            this.selectedSlot = n;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompoundTag getHungerData() {
            if (this.hungerDatai == null) {
                void $this$getHungerData_u24lambda_u240;
                CompoundTag compoundTag;
                CompoundTag compoundTag2 = compoundTag = new CompoundTag();
                Data data2 = this;
                boolean bl = false;
                $this$getHungerData_u24lambda_u240.putInt("foodLevel", 20);
                data2.hungerDatai = compoundTag;
            }
            CompoundTag compoundTag = this.hungerDatai;
            Intrinsics.checkNotNull((Object)compoundTag);
            return compoundTag;
        }

        public final void moveItems(@NotNull Inventory playerInventory, boolean fromPlayerToThis) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                    if (playerInventory.player.level().isClientSide) {
                        return;
                    }
                    if (!fromPlayerToThis) break block4;
                    Player player = playerInventory.player;
                    Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                    this.dropItems((Entity)player);
                    this.inventory = new SimpleContainer(playerInventory.getContainerSize());
                    int n = playerInventory.getContainerSize();
                    for (int i = 0; i < n; ++i) {
                        ItemStack stack = playerInventory.getItem(i);
                        SimpleContainer simpleContainer = this.inventory;
                        Intrinsics.checkNotNull((Object)simpleContainer);
                        simpleContainer.setItem(i, playerInventory.removeItem(i, stack.getCount()));
                    }
                    this.selectedSlot = playerInventory.selected;
                    Player player2 = playerInventory.player;
                    Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
                    this.onPossessed((Entity)player2);
                    break block5;
                }
                SimpleContainer simpleContainer = this.inventory;
                if (simpleContainer == null) break block5;
                SimpleContainer inv = simpleContainer;
                boolean bl = false;
                int n = inv.getContainerSize();
                for (int i = 0; i < n; ++i) {
                    playerInventory.player.drop(playerInventory.removeItem(i, 64), false);
                    playerInventory.setItem(i, inv.removeItem(i, 64));
                }
                this.inventory = null;
                playerInventory.selected = this.selectedSlot;
                if (playerInventory.player instanceof ServerPlayer) {
                    Player player = playerInventory.player;
                    Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundSetCarriedItemPacket(this.selectedSlot));
                }
            }
        }

        public final void dropItems(@NotNull Entity entity) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                SimpleContainer simpleContainer = this.inventory;
                if (simpleContainer == null) break block1;
                SimpleContainer inv = simpleContainer;
                boolean bl = false;
                int n = inv.getContainerSize();
                for (int i = 0; i < n; ++i) {
                    ItemStack stack = inv.removeItem(i, 64);
                    if (stack.isEmpty()) continue;
                    entity.spawnAtLocation(stack);
                }
            }
        }

        private final void onPossessed(Entity entity) {
        }

        public final void copyFrom(@NotNull Data original, @NotNull HolderLookup.Provider registryAccess) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)original, (String)"original");
                Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
                CompoundTag compoundTag = original.hungerDatai;
                this.hungerDatai = compoundTag != null ? compoundTag.copy() : null;
                this.selectedSlot = original.selectedSlot;
                SimpleContainer simpleContainer = original.inventory;
                if (simpleContainer == null) break block1;
                SimpleContainer origInv = simpleContainer;
                boolean bl = false;
                this.inventory = new SimpleContainer(origInv.getContainerSize());
                int n = origInv.getContainerSize();
                for (int i = 0; i < n; ++i) {
                    SimpleContainer simpleContainer2 = this.inventory;
                    Intrinsics.checkNotNull((Object)simpleContainer2);
                    simpleContainer2.setItem(i, origInv.getItem(i).copy());
                }
            }
        }

        @Nullable
        public final CompoundTag component1() {
            return this.hungerDatai;
        }

        @Nullable
        public final SimpleContainer component2() {
            return this.inventory;
        }

        public final int component3() {
            return this.selectedSlot;
        }

        @NotNull
        public final Data copy(@Nullable CompoundTag hungerDatai, @Nullable SimpleContainer inventory, int selectedSlot) {
            return new Data(hungerDatai, inventory, selectedSlot);
        }

        public static /* synthetic */ Data copy$default(Data data2, CompoundTag compoundTag, SimpleContainer simpleContainer, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                compoundTag = data2.hungerDatai;
            }
            if ((n2 & 2) != 0) {
                simpleContainer = data2.inventory;
            }
            if ((n2 & 4) != 0) {
                n = data2.selectedSlot;
            }
            return data2.copy(compoundTag, simpleContainer, n);
        }

        @NotNull
        public String toString() {
            return "Data(hungerDatai=" + this.hungerDatai + ", inventory=" + this.inventory + ", selectedSlot=" + this.selectedSlot + ")";
        }

        public int hashCode() {
            int result = this.hungerDatai == null ? 0 : this.hungerDatai.hashCode();
            result = result * 31 + (this.inventory == null ? 0 : this.inventory.hashCode());
            result = result * 31 + Integer.hashCode(this.selectedSlot);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual((Object)this.hungerDatai, (Object)data2.hungerDatai)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inventory, (Object)data2.inventory)) {
                return false;
            }
            return this.selectedSlot == data2.selectedSlot;
        }

        public Data() {
            this(null, null, 0, 7, null);
        }

        static {
            Codec codec = Codec.unit((Object)new Data(null, null, 0, 7, null));
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"unit(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/possession/PossessedDataAttachment$Data$Companion;", "", "<init>", "()V", "codec", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/possession/PossessedDataAttachment$Data;", "registryAccess", "Lnet/minecraft/core/HolderLookup$Provider;", "CODEC", "getCODEC", "()Lcom/mojang/serialization/Codec;", "serializeInventory", "Lnet/minecraft/nbt/CompoundTag;", "inventory", "Lnet/minecraft/world/Container;", "provider", "deserializeInventory", "Lnet/minecraft/world/SimpleContainer;", "tag", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> codec(@NotNull HolderLookup.Provider registryAccess) {
                Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
                Codec codec = RecordCodecBuilder.create(arg_0 -> Companion.codec$lambda$0(registryAccess, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
                return codec;
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            private final CompoundTag serializeInventory(Container inventory, HolderLookup.Provider provider) {
                CompoundTag tag = new CompoundTag();
                if (inventory != null) {
                    tag.putInt("size", inventory.getContainerSize());
                    ListTag items = new ListTag();
                    int n = inventory.getContainerSize();
                    for (int i = 0; i < n; ++i) {
                        ItemStack stack = inventory.getItem(i);
                        if (stack.isEmpty()) continue;
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.putInt("Slot", i);
                        stack.save(provider, (Tag)itemTag);
                        items.add((Object)itemTag);
                    }
                    tag.put("Items", (Tag)items);
                }
                return tag;
            }

            private final SimpleContainer deserializeInventory(CompoundTag tag, HolderLookup.Provider provider) {
                if (!tag.contains("size")) {
                    return null;
                }
                int size = tag.getInt("size");
                SimpleContainer inventory = new SimpleContainer(size);
                ListTag items = tag.getList("Items", 10);
                int n = items.size();
                for (int i = 0; i < n; ++i) {
                    CompoundTag itemTag = items.getCompound(i);
                    int slot = itemTag.getInt("Slot");
                    if (slot < 0 || slot >= size) continue;
                    inventory.setItem(slot, (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)((Tag)itemTag)).get());
                }
                return inventory;
            }

            private static final App codec$lambda$0(HolderLookup.Provider $registryAccess, RecordCodecBuilder.Instance instance) {
                return instance.group((App)CompoundTag.CODEC.optionalFieldOf("hungerData", (Object)new CompoundTag()).forGetter(Companion::codec$lambda$0$0), (App)Codec.INT.fieldOf("selectedSlot").forGetter(Companion::codec$lambda$0$1), (App)CompoundTag.CODEC.optionalFieldOf("inventory", (Object)new CompoundTag()).xmap(arg_0 -> Companion.codec$lambda$0$3(arg_0 -> Companion.codec$lambda$0$2($registryAccess, arg_0), arg_0), arg_0 -> Companion.codec$lambda$0$5(arg_0 -> Companion.codec$lambda$0$4($registryAccess, arg_0), arg_0)).forGetter(Companion::codec$lambda$0$6)).apply((Applicative)instance, Companion::codec$lambda$0$7);
            }

            private static final CompoundTag codec$lambda$0$0(Data it) {
                CompoundTag compoundTag = it.getHungerDatai();
                if (compoundTag == null) {
                    compoundTag = new CompoundTag();
                }
                return compoundTag;
            }

            private static final Integer codec$lambda$0$1(Data it) {
                return it.getSelectedSlot();
            }

            private static final SimpleContainer codec$lambda$0$2(HolderLookup.Provider $registryAccess, CompoundTag tag) {
                Intrinsics.checkNotNull((Object)tag);
                return Companion.deserializeInventory(tag, $registryAccess);
            }

            private static final SimpleContainer codec$lambda$0$3(Function1 $tmp0, Object p0) {
                return (SimpleContainer)$tmp0.invoke(p0);
            }

            private static final CompoundTag codec$lambda$0$4(HolderLookup.Provider $registryAccess, SimpleContainer inv) {
                return Companion.serializeInventory((Container)inv, $registryAccess);
            }

            private static final CompoundTag codec$lambda$0$5(Function1 $tmp0, Object p0) {
                return (CompoundTag)$tmp0.invoke(p0);
            }

            private static final SimpleContainer codec$lambda$0$6(Data it) {
                SimpleContainer simpleContainer = it.getInventory();
                if (simpleContainer == null) {
                    simpleContainer = new SimpleContainer(0);
                }
                return simpleContainer;
            }

            private static final Data codec$lambda$0$7(CompoundTag hunger, Integer slot, SimpleContainer inv) {
                Data data2;
                Data $this$codec_u24lambda_u240_u247_u240 = data2 = new Data(null, null, 0, 7, null);
                boolean bl = false;
                $this$codec_u24lambda_u240_u247_u240.setHungerDatai(hunger.isEmpty() ? null : hunger);
                Intrinsics.checkNotNull((Object)slot);
                $this$codec_u24lambda_u240_u247_u240.setSelectedSlot(slot);
                SimpleContainer simpleContainer = inv;
                Intrinsics.checkNotNull((Object)simpleContainer);
                $this$codec_u24lambda_u240_u247_u240.setInventory((SimpleContainer)(simpleContainer.getContainerSize() > 0 ? inv : null));
                return data2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

