/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.effigy.EffigyBlockEntity;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.content.entity.BansheeEntity;
import dev.sterner.witchery.content.entity.SpectreEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.features.chain.ChainManager;
import dev.sterner.witchery.features.chain.ChainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/ritual/BindSpectralCreaturesRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "onEndRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "makeParticles", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nBindSpectralCreaturesRitual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BindSpectralCreaturesRitual.kt\ndev/sterner/witchery/features/ritual/BindSpectralCreaturesRitual\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n774#2:140\n865#2,2:141\n1869#2,2:143\n*S KotlinDebug\n*F\n+ 1 BindSpectralCreaturesRitual.kt\ndev/sterner/witchery/features/ritual/BindSpectralCreaturesRitual\n*L\n97#1:140\n97#1:141,2\n128#1:143,2\n*E\n"})
public final class BindSpectralCreaturesRitual
extends Ritual {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<UUID, BlockPos> entityToEffigyMap = new HashMap();

    public BindSpectralCreaturesRitual() {
        super("bind_spectral_creatures");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEndRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (level instanceof ServerLevel) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            AABB area = AABB.ofSize((Vec3)blockPos.getCenter(), (double)16.0, (double)16.0, (double)16.0);
            List list = level.getEntitiesOfClass(LivingEntity.class, area);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable iterable = list;
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LivingEntity it = (LivingEntity)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof BansheeEntity || it instanceof SpectreEntity)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unboundEntities = (List)destination$iv$iv;
            Optional<Object> possibleEffigies = BlockPos.betweenClosedStream((AABB)area).filter(arg_0 -> BindSpectralCreaturesRitual.onEndRitual$lambda$2(arg_0 -> BindSpectralCreaturesRitual.onEndRitual$lambda$1(level, arg_0), arg_0)).findAny();
            if (!((Collection)unboundEntities).isEmpty() && possibleEffigies.isPresent()) {
                Object object = possibleEffigies.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                BlockPos effigyPos = (BlockPos)object;
                Vec3 effigyCenter = effigyPos.getCenter();
                for (LivingEntity entity : unboundEntities) {
                    Vec3 vec3;
                    ((Map)entityToEffigyMap).put(entity.getUUID(), effigyPos);
                    Intrinsics.checkNotNull((Object)entity);
                    this.makeParticles(level, (Entity)entity);
                    ChainManager chainManager = ChainManager.INSTANCE;
                    ServerLevel serverLevel = (ServerLevel)level;
                    Intrinsics.checkNotNullExpressionValue((Object)effigyCenter.add(0.0, 0.2, 0.0), (String)"add(...)");
                    LivingEntity livingEntity = entity;
                    ChainType chainType = ChainType.SPIRIT;
                    ChainManager.createHookAndPullChain$default(chainManager, (Level)serverLevel, vec3, (Entity)livingEntity, 0.0f, 0.8f, 0, chainType, 8, null);
                }
            } else {
                Containers.dropContents((Level)level, (BlockPos)blockPos, (Container)goldenChalkBlockEntity);
            }
        }
    }

    private final void makeParticles(Level level, Entity entity) {
        if (level instanceof ServerLevel) {
            int particleCount = 15;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)particleCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, entity.getX() + level.random.nextDouble() - 0.5, entity.getY() + level.random.nextDouble() * entity.getBoundingBox().getSize(), entity.getZ() + level.random.nextDouble() - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static final boolean onEndRitual$lambda$1(Level $level, BlockPos it) {
        return ((ServerLevel)$level).getBlockEntity(it) instanceof EffigyBlockEntity;
    }

    private static final boolean onEndRitual$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/ritual/BindSpectralCreaturesRitual$Companion;", "", "<init>", "()V", "entityToEffigyMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lnet/minecraft/core/BlockPos;", "handleChainDiscard", "", "entity", "Lnet/minecraft/world/entity/Entity;", "makeBindingParticles", "level", "Lnet/minecraft/world/level/Level;", "entityPos", "Lnet/minecraft/world/phys/Vec3;", "effigyPos", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void handleChainDiscard(@Nullable Entity entity) {
            Object object = entity;
            if (object == null || (object = object.getUUID()) == null) {
                return;
            }
            Object entityId = object;
            BlockPos blockPos = (BlockPos)entityToEffigyMap.get(entityId);
            if (blockPos == null) {
                return;
            }
            BlockPos effigyPos = blockPos;
            Level level = entity.level();
            BlockEntity blockEntity = level.getBlockEntity(effigyPos);
            if (blockEntity instanceof EffigyBlockEntity) {
                Entity entity2 = entity;
                if (entity2 instanceof BansheeEntity) {
                    EffigyBlockEntity effigyBlockEntity = (EffigyBlockEntity)blockEntity;
                    effigyBlockEntity.setBansheeCount(effigyBlockEntity.getBansheeCount() + 1);
                    ((EffigyBlockEntity)blockEntity).setChanged();
                    entityToEffigyMap.remove(entityId);
                    ((BansheeEntity)entity).discard();
                } else if (entity2 instanceof SpectreEntity) {
                    EffigyBlockEntity effigyBlockEntity = (EffigyBlockEntity)blockEntity;
                    effigyBlockEntity.setSpecterCount(effigyBlockEntity.getSpecterCount() + 1);
                    ((EffigyBlockEntity)blockEntity).setChanged();
                    entityToEffigyMap.remove(entityId);
                    ((SpectreEntity)entity).discard();
                }
                Intrinsics.checkNotNull((Object)level);
                Vec3 vec3 = entity.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                Vec3 vec32 = ((EffigyBlockEntity)blockEntity).getBlockPos().getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                this.makeBindingParticles(level, vec3, vec32);
            }
        }

        private final void makeBindingParticles(Level level, Vec3 entityPos, Vec3 effigyPos) {
            if (level instanceof ServerLevel) {
                int particleCount = 20;
                Vec3 direction = effigyPos.subtract(entityPos).normalize();
                for (int i = 0; i < particleCount; ++i) {
                    Vec3 offset = new Vec3(level.random.nextDouble() - 0.5, level.random.nextDouble() - 0.5, level.random.nextDouble() - 0.5).scale(0.5);
                    Vec3 position = entityPos.add(direction.scale((double)i / (double)particleCount));
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, position.x + offset.x, position.y + offset.y, position.z + offset.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

