/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.spirit_world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncManifestationS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/spirit_world/ManifestationPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/spirit_world/ManifestationPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Data", "witchery"})
public final class ManifestationPlayerAttachment {
    @NotNull
    public static final ManifestationPlayerAttachment INSTANCE = new ManifestationPlayerAttachment();

    private ManifestationPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getMANIFESTATION_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getMANIFESTATION_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncManifestationS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/features/spirit_world/ManifestationPlayerAttachment$Data;", "", "hasRiteOfManifestation", "", "manifestationTimer", "", "<init>", "(ZI)V", "getHasRiteOfManifestation", "()Z", "setHasRiteOfManifestation", "(Z)V", "getManifestationTimer", "()I", "setManifestationTimer", "(I)V", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean hasRiteOfManifestation;
        private int manifestationTimer;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(boolean hasRiteOfManifestation, int manifestationTimer) {
            this.hasRiteOfManifestation = hasRiteOfManifestation;
            this.manifestationTimer = manifestationTimer;
        }

        public /* synthetic */ Data(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(bl, n);
        }

        public final boolean getHasRiteOfManifestation() {
            return this.hasRiteOfManifestation;
        }

        public final void setHasRiteOfManifestation(boolean bl) {
            this.hasRiteOfManifestation = bl;
        }

        public final int getManifestationTimer() {
            return this.manifestationTimer;
        }

        public final void setManifestationTimer(int n) {
            this.manifestationTimer = n;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.fieldOf("hasRiteOfManifestation").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("manifestationTimer").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final Boolean CODEC$lambda$0$0(Data it) {
            return it.hasRiteOfManifestation;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.manifestationTimer;
        }

        public Data() {
            this(false, 0, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("manifestation_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/spirit_world/ManifestationPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/spirit_world/ManifestationPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

