/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.content.entity.DeathEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.tarot.TarotEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/features/tarot/DeathEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onEntityKill", "", "player", "Lnet/minecraft/world/entity/player/Player;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "onTick", "onMorning", "onNightfall", "summonDeathPlayer", "deathPlayer", "targetPlayer", "level", "Lnet/minecraft/server/level/ServerLevel;", "summonDeathEntity", "witchery"})
@SourceDebugExtension(value={"SMAP\nDeathEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeathEffect.kt\ndev/sterner/witchery/features/tarot/DeathEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n774#2:237\n865#2,2:238\n1563#2:240\n1634#2,3:241\n1869#2,2:244\n*S KotlinDebug\n*F\n+ 1 DeathEffect.kt\ndev/sterner/witchery/features/tarot/DeathEffect\n*L\n87#1:237\n87#1:238,2\n88#1:240\n88#1:241,3\n90#1:244,2\n*E\n"})
public final class DeathEffect
extends TarotEffect {
    public DeathEffect() {
        super(14);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.death.reversed" : "tarot.witchery.death"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.death.reversed.description" : "tarot.witchery.death.description"));
    }

    @Override
    public void onEntityKill(@NotNull Player player, @NotNull LivingEntity entity, boolean isReversed) {
        block3: {
            Entity ethereal;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (isReversed || !entity.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE()) || !(player.level().random.nextFloat() < 0.1f) || !(player.level() instanceof ServerLevel)) break block3;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            Entity entity2 = ethereal = entity.getType().create((Level)level2);
            if (entity2 != null) {
                Entity newEntity = entity2;
                boolean bl = false;
                if (newEntity instanceof LivingEntity) {
                    newEntity.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                    EtherealEntityAttachment.setData((LivingEntity)newEntity, new EtherealEntityAttachment.Data(player.getUUID(), false, true, level2.getGameTime(), 24000L));
                    if (newEntity instanceof Mob) {
                        ((Mob)newEntity).setTarget(null);
                        ((Mob)newEntity).setLastHurtByMob(null);
                    }
                    level2.addFreshEntity(newEntity);
                    level2.sendParticles((ParticleOptions)ParticleTypes.SOUL, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / (float)2), entity.getZ(), 20, 0.3, 0.3, 0.3, 0.05);
                    level2.playSound(null, entity.blockPosition(), (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.HOSTILE, 1.0f, 0.8f);
                }
            }
        }
    }

    @Override
    public void onTick(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (isReversed && player.level().getGameTime() % (long)200 == 0L) {
            player.causeFoodExhaustion(0.5f);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onMorning(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MobEffectInstance it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection = player.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MobEffectInstance)element$iv$iv;
                boolean bl = false;
                if (!(!((MobEffect)it.getEffect().value()).isBeneficial())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MobEffectInstance)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getEffect());
            }
            List negativeEffects = (List)destination$iv$iv;
            Iterable $this$forEach$iv = negativeEffects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Holder it2 = (Holder)element$iv;
                boolean bl = false;
                player.removeEffect(it2);
            }
        }
    }

    @Override
    public void onNightfall(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (isReversed && player.level() instanceof ServerLevel && player.level().random.nextFloat() < 0.15f) {
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            Player deathPlayer = DeathTransformationHelper.INSTANCE.findDeathPlayer((Level)level2);
            if (deathPlayer != null && !Intrinsics.areEqual((Object)deathPlayer, (Object)player)) {
                this.summonDeathPlayer(deathPlayer, player, level2);
            } else {
                this.summonDeathEntity(player, level2);
            }
            this.removeCardFromReading(player, this.getCardNumber());
        }
    }

    private final void summonDeathPlayer(Player deathPlayer, Player targetPlayer, ServerLevel level) {
        double spawnX = 0.0;
        double spawnZ = 0.0;
        int attempts = 0;
        do {
            double angle = level.random.nextDouble() * (double)2 * Math.PI;
            double distance = 8.0 + level.random.nextDouble() * 12.0;
            spawnX = targetPlayer.getX() + Math.cos(angle) * distance;
            spawnZ = targetPlayer.getZ() + Math.sin(angle) * distance;
        } while (++attempts < 10 && targetPlayer.distanceToSqr(spawnX, targetPlayer.getY(), spawnZ) < 64.0);
        level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, deathPlayer.getX(), deathPlayer.getY() + (double)(deathPlayer.getBbHeight() / (float)2), deathPlayer.getZ(), 50, 0.5, 1.0, 0.5, 0.5);
        level.playSound(null, deathPlayer.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.8f);
        deathPlayer.teleportTo(spawnX, targetPlayer.getY(), spawnZ);
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, spawnX, targetPlayer.getY() + 1.0, spawnZ, 30, 0.5, 0.5, 0.5, 0.1);
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, spawnX, targetPlayer.getY(), spawnZ, 20, 0.5, 0.5, 0.5, 0.05);
        level.playSound(null, targetPlayer.blockPosition(), SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 0.5f);
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC};
        deathPlayer.displayClientMessage((Component)Component.literal((String)("You sense " + targetPlayer.getName().getString() + "'s fate calling...")).withStyle(chatFormattingArray), false);
    }

    private final void summonDeathEntity(Player player, ServerLevel level) {
        block2: {
            DeathEntity deathEntity;
            DeathEntity deathEntity2 = deathEntity = (DeathEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getDEATH().get()).create((Level)level);
            if (deathEntity2 == null) break block2;
            DeathEntity death = deathEntity2;
            boolean bl = false;
            double spawnX = 0.0;
            double spawnZ = 0.0;
            int attempts = 0;
            do {
                double angle = level.random.nextDouble() * (double)2 * Math.PI;
                double distance = 8.0 + level.random.nextDouble() * 12.0;
                spawnX = player.getX() + Math.cos(angle) * distance;
                spawnZ = player.getZ() + Math.sin(angle) * distance;
            } while (++attempts < 10 && player.distanceToSqr(spawnX, player.getY(), spawnZ) < 64.0);
            death.moveTo(spawnX, player.getY(), spawnZ, 0.0f, 0.0f);
            death.setForcedTarget((LivingEntity)player);
            level.addFreshEntity((Entity)death);
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, spawnX, player.getY() + 1.0, spawnZ, 30, 0.5, 0.5, 0.5, 0.1);
            level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, spawnX, player.getY(), spawnZ, 20, 0.5, 0.5, 0.5, 0.05);
            for (int i = 0; i < 30; ++i) {
                double ringAngle = (double)i / 30.0 * Math.PI * (double)2;
                double radius = 2.0;
                double px = spawnX + Math.cos(ringAngle) * radius;
                double pz = spawnZ + Math.sin(ringAngle) * radius;
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, px, player.getY() + 0.1, pz, 1, 0.0, 0.5, 0.0, 0.1);
            }
            level.playSound(null, player.blockPosition(), SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 0.5f);
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD};
            player.displayClientMessage((Component)Component.literal((String)"As night falls, Death comes for you!").withStyle(chatFormattingArray), false);
        }
    }
}

