/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import dev.sterner.witchery.features.tarot.TheHangedManEffect;
import dev.sterner.witchery.features.tarot.TheMagicianEffect;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/sterner/witchery/features/tarot/TarotEffectEventHandler;", "", "<init>", "()V", "lastDayTime", "", "onItemToss", "", "event", "Lnet/neoforged/neoforge/event/entity/item/ItemTossEvent;", "onPlayerTick", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Post;", "onBlockBreak", "Lnet/neoforged/neoforge/event/level/BlockEvent$BreakEvent;", "onEntityHurt", "Lnet/neoforged/neoforge/event/entity/player/AttackEntityEvent;", "onPlayerHurt", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "onEntityKill", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "onItemUse", "Lnet/neoforged/neoforge/event/entity/living/LivingEntityUseItemEvent$Finish;", "onPlayerSleep", "Lnet/neoforged/neoforge/event/level/SleepFinishedTimeEvent;", "onEntityEnterWater", "register", "bus", "Lnet/neoforged/bus/api/IEventBus;", "witchery"})
public final class TarotEffectEventHandler {
    @NotNull
    public static final TarotEffectEventHandler INSTANCE = new TarotEffectEventHandler();
    private static long lastDayTime;

    private TarotEffectEventHandler() {
    }

    @SubscribeEvent
    public final void onItemToss(@NotNull ItemTossEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData(player);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            boolean isReversed;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean bl2 = isReversed = bl != null ? bl : false;
            if (cardNumber != ((TheHangedManEffect)WitcheryTarotEffects.INSTANCE.getTHE_HANGED_MAN().get()).getCardNumber() || !isReversed) continue;
            event.setCanceled(true);
            ItemEntity itemEntity = event.getEntity();
            if (!player.getInventory().add(itemEntity.getItem().copy())) {
                itemEntity.discard();
            } else {
                itemEntity.discard();
            }
            player.displayClientMessage((Component)Component.literal((String)"You cannot let go!").withStyle(ChatFormatting.DARK_RED), true);
            return;
        }
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull PlayerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData(player);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        TheMagicianEffect.TheMagicianBrewReturn.INSTANCE.tick(player);
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            tarotEffect.onTick(player, isReversed);
        }
        long currentTime = player.level().getDayTime() % (long)24000;
        if (currentTime < lastDayTime) {
            var7_8 = ((Collection)data2.getDrawnCards()).size();
            for (i = 0; i < var7_8; ++i) {
                TarotEffect effect;
                int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
                Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
                boolean isReversed = bl != null ? bl : false;
                TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                if (tarotEffect == null) continue;
                tarotEffect.onMorning(player, isReversed);
            }
        } else if (lastDayTime < 12000L && currentTime >= 12000L) {
            var7_8 = ((Collection)data2.getDrawnCards()).size();
            for (i = 0; i < var7_8; ++i) {
                TarotEffect effect;
                int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
                Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
                boolean isReversed = bl != null ? bl : false;
                TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                if (tarotEffect == null) continue;
                tarotEffect.onNightfall(player, isReversed);
            }
        }
        lastDayTime = currentTime;
    }

    @SubscribeEvent
    public final void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player2 = serverPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)player2);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            Player player3 = (Player)player2;
            BlockState blockState = event.getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockPos blockPos = event.getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            tarotEffect.onBlockBreak(player3, blockState, blockPos, isReversed);
        }
    }

    @SubscribeEvent
    public final void onEntityHurt(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer attacker = serverPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)attacker);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            Player player2 = (Player)attacker;
            Player player3 = event.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getEntity(...)");
            tarotEffect.onEntityHit(player2, (Entity)player3, isReversed);
        }
    }

    @SubscribeEvent
    public final void onPlayerHurt(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        ServerPlayer serverPlayer = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)player);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        float modifiedDamage = event.getAmount();
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            float f;
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect != null) {
                Player player2 = (Player)player;
                DamageSource damageSource = event.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
                f = tarotEffect.onPlayerHurt(player2, damageSource, modifiedDamage, isReversed);
            } else {
                f = modifiedDamage;
            }
            modifiedDamage = f;
        }
        event.setAmount(modifiedDamage);
    }

    @SubscribeEvent
    public final void onEntityKill(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getSource().getEntity();
        ServerPlayer serverPlayer = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer attacker = serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        LivingEntity victim = livingEntity;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)attacker);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            tarotEffect.onEntityKill((Player)attacker, victim, isReversed);
        }
    }

    @SubscribeEvent
    public final void onItemUse(@NotNull LivingEntityUseItemEvent.Finish event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        ServerPlayer serverPlayer = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData((Player)player);
        if (data2.getDrawnCards().isEmpty()) {
            return;
        }
        int n = ((Collection)data2.getDrawnCards()).size();
        for (int i = 0; i < n; ++i) {
            TarotEffect effect;
            int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
            boolean isReversed = bl != null ? bl : false;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            Player player2 = (Player)player;
            ItemStack itemStack = event.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            tarotEffect.onItemUse(player2, itemStack, isReversed);
        }
    }

    @SubscribeEvent
    public final void onPlayerSleep(@NotNull SleepFinishedTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (Player player : event.getLevel().players()) {
            TarotPlayerAttachment.Data data2;
            if (!(player instanceof ServerPlayer) || (data2 = TarotPlayerAttachment.getData(player)).getDrawnCards().isEmpty()) continue;
            int n = ((Collection)data2.getDrawnCards()).size();
            for (int i = 0; i < n; ++i) {
                TarotEffect effect;
                int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
                Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
                boolean isReversed = bl != null ? bl : false;
                TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                if (tarotEffect == null) continue;
                tarotEffect.onSleep(player, isReversed);
            }
        }
    }

    @SubscribeEvent
    public final void onEntityEnterWater(@NotNull PlayerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (((ServerPlayer)entity).level().isClientSide) {
            return;
        }
        if (((ServerPlayer)entity).isInWater()) {
            TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData(entity);
            if (data2.getDrawnCards().isEmpty()) {
                return;
            }
            int n = ((Collection)data2.getDrawnCards()).size();
            for (int i = 0; i < n; ++i) {
                TarotEffect effect;
                int cardNumber = ((Number)data2.getDrawnCards().get(i)).intValue();
                Boolean bl = (Boolean)CollectionsKt.getOrNull(data2.getReversedCards(), (int)i);
                boolean isReversed = bl != null ? bl : false;
                TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                if (tarotEffect == null) continue;
                tarotEffect.onEnterWater(entity, isReversed);
            }
        }
    }

    public final void register(@NotNull IEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        bus.register((Object)this);
    }
}

