/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.network.SyncTarotS2CPayload;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0007J \u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment;", "", "<init>", "()V", "THREE_DAYS", "", "getData", "Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "handleCardChanges", "oldData", "newData", "sync", "serverTick", "Data", "witchery"})
public final class TarotPlayerAttachment {
    @NotNull
    public static final TarotPlayerAttachment INSTANCE = new TarotPlayerAttachment();
    public static final long THREE_DAYS = 72000L;

    private TarotPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getARCANA_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Data oldData = TarotPlayerAttachment.getData(player);
        player.setData(WitcheryDataAttachments.getARCANA_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
        if (player.level() instanceof ServerLevel) {
            INSTANCE.handleCardChanges(player, oldData, data2);
        }
    }

    private final void handleCardChanges(Player player, Data oldData, Data newData) {
        TarotEffect effect;
        boolean isReversed;
        int cardNumber;
        int i;
        int n = ((Collection)oldData.getDrawnCards()).size();
        for (i = 0; i < n; ++i) {
            cardNumber = ((Number)oldData.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(oldData.getReversedCards(), (int)i);
            boolean bl2 = isReversed = bl != null ? bl : false;
            if (newData.getDrawnCards().contains(cardNumber)) continue;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            tarotEffect.onRemoved(player, isReversed);
        }
        n = ((Collection)newData.getDrawnCards()).size();
        for (i = 0; i < n; ++i) {
            cardNumber = ((Number)newData.getDrawnCards().get(i)).intValue();
            Boolean bl = (Boolean)CollectionsKt.getOrNull(newData.getReversedCards(), (int)i);
            boolean bl3 = isReversed = bl != null ? bl : false;
            if (oldData.getDrawnCards().contains(cardNumber)) continue;
            TarotEffect tarotEffect = effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
            if (tarotEffect == null) continue;
            tarotEffect.onAdded(player, isReversed);
        }
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncTarotS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void serverTick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.level() instanceof ServerLevel) {
            Level level = player.level();
            Data data2 = TarotPlayerAttachment.getData(player);
            if (!((Collection)data2.getDrawnCards()).isEmpty() && level.getGameTime() - data2.getReadingTimestamp() >= 72000L) {
                Data newData = new Data(CollectionsKt.emptyList(), CollectionsKt.emptyList(), 0L);
                TarotPlayerAttachment.setData(player, newData);
                ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC};
                player.displayClientMessage((Component)Component.literal((String)"Your tarot reading has faded with time.").withStyle(chatFormattingArray), true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB1\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment$Data;", "", "drawnCards", "", "", "reversedCards", "", "readingTimestamp", "", "<init>", "(Ljava/util/List;Ljava/util/List;J)V", "getDrawnCards", "()Ljava/util/List;", "setDrawnCards", "(Ljava/util/List;)V", "getReversedCards", "setReversedCards", "getReadingTimestamp", "()J", "setReadingTimestamp", "(J)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private List<Integer> drawnCards;
        @NotNull
        private List<Boolean> reversedCards;
        private long readingTimestamp;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@NotNull List<Integer> drawnCards, @NotNull List<Boolean> reversedCards, long readingTimestamp) {
            Intrinsics.checkNotNullParameter(drawnCards, (String)"drawnCards");
            Intrinsics.checkNotNullParameter(reversedCards, (String)"reversedCards");
            this.drawnCards = drawnCards;
            this.reversedCards = reversedCards;
            this.readingTimestamp = readingTimestamp;
        }

        public /* synthetic */ Data(List list, List list2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(list, list2, l);
        }

        @NotNull
        public final List<Integer> getDrawnCards() {
            return this.drawnCards;
        }

        public final void setDrawnCards(@NotNull List<Integer> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.drawnCards = list;
        }

        @NotNull
        public final List<Boolean> getReversedCards() {
            return this.reversedCards;
        }

        public final void setReversedCards(@NotNull List<Boolean> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.reversedCards = list;
        }

        public final long getReadingTimestamp() {
            return this.readingTimestamp;
        }

        public final void setReadingTimestamp(long l) {
            this.readingTimestamp = l;
        }

        @NotNull
        public final List<Integer> component1() {
            return this.drawnCards;
        }

        @NotNull
        public final List<Boolean> component2() {
            return this.reversedCards;
        }

        public final long component3() {
            return this.readingTimestamp;
        }

        @NotNull
        public final Data copy(@NotNull List<Integer> drawnCards, @NotNull List<Boolean> reversedCards, long readingTimestamp) {
            Intrinsics.checkNotNullParameter(drawnCards, (String)"drawnCards");
            Intrinsics.checkNotNullParameter(reversedCards, (String)"reversedCards");
            return new Data(drawnCards, reversedCards, readingTimestamp);
        }

        public static /* synthetic */ Data copy$default(Data data2, List list, List list2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = data2.drawnCards;
            }
            if ((n & 2) != 0) {
                list2 = data2.reversedCards;
            }
            if ((n & 4) != 0) {
                l = data2.readingTimestamp;
            }
            return data2.copy(list, list2, l);
        }

        @NotNull
        public String toString() {
            return "Data(drawnCards=" + this.drawnCards + ", reversedCards=" + this.reversedCards + ", readingTimestamp=" + this.readingTimestamp + ")";
        }

        public int hashCode() {
            int result = ((Object)this.drawnCards).hashCode();
            result = result * 31 + ((Object)this.reversedCards).hashCode();
            result = result * 31 + Long.hashCode(this.readingTimestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual(this.drawnCards, data2.drawnCards)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.reversedCards, data2.reversedCards)) {
                return false;
            }
            return this.readingTimestamp == data2.readingTimestamp;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.listOf().fieldOf("drawnCards").forGetter(Data::CODEC$lambda$0$0), (App)Codec.BOOL.listOf().fieldOf("reversedCards").forGetter(Data::CODEC$lambda$0$1), (App)Codec.LONG.fieldOf("readingTimestamp").forGetter(Data::CODEC$lambda$0$2)).apply((Applicative)instance, Data::new);
        }

        private static final List CODEC$lambda$0$0(Data it) {
            return it.drawnCards;
        }

        private static final List CODEC$lambda$0$1(Data it) {
            return it.reversedCards;
        }

        private static final Long CODEC$lambda$0$2(Data it) {
            return it.readingTimestamp;
        }

        public Data() {
            this(null, null, 0L, 7, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("tarot_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/tarot/TarotPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

