/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.content.entity.BabaYagaEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.tarot.TarotEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/features/tarot/TheTowerEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onTick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onBlockBreak", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "witchery"})
public final class TheTowerEffect
extends TarotEffect {
    public TheTowerEffect() {
        super(17);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_tower.reversed" : "tarot.witchery.the_tower"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_tower.reversed.description" : "tarot.witchery.the_tower.description"));
    }

    @Override
    public void onTick(@NotNull Player player, boolean isReversed) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (isReversed || !(player.level() instanceof ServerLevel)) break block3;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.001f) {
                BabaYagaEntity babaYaga;
                BabaYagaEntity babaYagaEntity = babaYaga = (BabaYagaEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getBABA_YAGA().get()).create((Level)level2);
                if (babaYagaEntity != null) {
                    BabaYagaEntity it = babaYagaEntity;
                    boolean bl = false;
                    double spawnX = 0.0;
                    double spawnZ = 0.0;
                    int attempts = 0;
                    do {
                        double angle = level2.random.nextDouble() * (double)2 * Math.PI;
                        double distance = 8.0 + level2.random.nextDouble() * 8.0;
                        spawnX = player.getX() + Math.cos(angle) * distance;
                        spawnZ = player.getZ() + Math.sin(angle) * distance;
                    } while (++attempts < 10 && player.distanceToSqr(spawnX, player.getY(), spawnZ) < 64.0);
                    it.moveTo(spawnX, player.getY(), spawnZ, 0.0f, 0.0f);
                    level2.addFreshEntity((Entity)it);
                    ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD};
                    player.displayClientMessage((Component)Component.literal((String)"The Tower crumbles! Baba Yaga approaches").withStyle(chatFormattingArray), false);
                    level2.playSound(null, player.blockPosition(), SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 0.8f);
                    this.removeCardFromReading(player, this.getCardNumber());
                }
            }
        }
    }

    @Override
    public void onBlockBreak(@NotNull Player player, @NotNull BlockState blockState, @NotNull BlockPos pos, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!isReversed && player.level().random.nextFloat() < 0.5f) {
            player.level().explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.5f, Level.ExplosionInteraction.NONE);
        }
    }
}

