/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.features.tarot.TarotEffect;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/features/tarot/WheelOfFortuneEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onTick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onEntityKill", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "witchery"})
@SourceDebugExtension(value={"SMAP\nWheelOfFortuneEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WheelOfFortuneEffect.kt\ndev/sterner/witchery/features/tarot/WheelOfFortuneEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1869#2,2:69\n*S KotlinDebug\n*F\n+ 1 WheelOfFortuneEffect.kt\ndev/sterner/witchery/features/tarot/WheelOfFortuneEffect\n*L\n62#1:69,2\n*E\n"})
public final class WheelOfFortuneEffect
extends TarotEffect {
    public WheelOfFortuneEffect() {
        super(11);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.wheel_of_fortune.reversed" : "tarot.witchery.wheel_of_fortune"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.wheel_of_fortune.reversed.description" : "tarot.witchery.wheel_of_fortune.description"));
    }

    @Override
    public void onTick(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isReversed) {
            if (!player.hasEffect(MobEffects.LUCK)) {
                player.addEffect(new MobEffectInstance(MobEffects.LUCK, 400, 1, true, false));
            }
        } else if (!player.hasEffect(MobEffects.UNLUCK)) {
            player.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 400, 1, true, false));
        }
    }

    @Override
    public void onEntityKill(@NotNull Player player, @NotNull LivingEntity entity, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!isReversed && player.level().random.nextFloat() < 0.25f && player.level() instanceof ServerLevel) {
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            ResourceKey lootTable = entity.getLootTable();
            LootParams lootParams = new LootParams.Builder(level2).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)player.damageSources().playerAttack(player)).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).create(LootContextParamSets.ENTITY);
            LootTable loot = level2.getServer().reloadableRegistries().getLootTable(lootTable);
            ObjectArrayList items = loot.getRandomItems(lootParams);
            Intrinsics.checkNotNull((Object)items);
            Iterable $this$forEach$iv = (Iterable)items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack itemStack = (ItemStack)element$iv;
                boolean bl = false;
                Block.popResource((Level)((Level)level2), (BlockPos)entity.blockPosition(), (ItemStack)itemStack);
            }
        }
    }
}

