/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.recipe.spinning_wheel.SpinningWheelRecipe;
import dev.sterner.witchery.integration.emi.WitcheryEmiPlugin;
import dev.sterner.witchery.integration.emi.WitcherySlotWidget;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/integration/emi/SpinningEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "recipeId", "Lnet/minecraft/resources/ResourceLocation;", "recipe", "Ldev/sterner/witchery/content/recipe/spinning_wheel/SpinningWheelRecipe;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ldev/sterner/witchery/content/recipe/spinning_wheel/SpinningWheelRecipe;)V", "getRecipeId", "()Lnet/minecraft/resources/ResourceLocation;", "getRecipe", "()Ldev/sterner/witchery/content/recipe/spinning_wheel/SpinningWheelRecipe;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "getInputs", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "getOutputs", "Ldev/emi/emi/api/stack/EmiStack;", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "witchery"})
public final class SpinningEmiRecipe
implements EmiRecipe {
    @NotNull
    private final ResourceLocation recipeId;
    @NotNull
    private final SpinningWheelRecipe recipe;

    public SpinningEmiRecipe(@NotNull ResourceLocation recipeId, @NotNull SpinningWheelRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        this.recipeId = recipeId;
        this.recipe = recipe;
    }

    @NotNull
    public final ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public final SpinningWheelRecipe getRecipe() {
        return this.recipe;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return WitcheryEmiPlugin.Companion.getSPINNING_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipeId;
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        List mutableList = new ArrayList();
        for (ItemStack item : this.recipe.getInputItems()) {
            ItemStack[] itemStackArray = new ItemStack[]{item};
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            mutableList.add(emiIngredient);
        }
        return mutableList;
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        List mutableList = new ArrayList();
        EmiStack emiStack = EmiStack.of((ItemStack)this.recipe.getOutputItem());
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        mutableList.add(emiStack);
        return mutableList;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(Witchery.Companion.id("textures/gui/spinning_wheel_emi.png"), 9, 9, 123, 54, 0, 0);
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)this.recipe.getInputItems().get(0)), 9, 27, 0.0, 8, null).drawBack(false));
        if (this.recipe.getInputItems().size() > 1) {
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)this.recipe.getInputItems().get(1)), 45, 9, 0.0, 8, null).drawBack(false));
        }
        if (this.recipe.getInputItems().size() > 2) {
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)this.recipe.getInputItems().get(2)), 45, 27, 0.0, 8, null).drawBack(false));
        }
        if (this.recipe.getInputItems().size() > 3) {
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)this.recipe.getInputItems().get(3)), 45, 45, 0.0, 8, null).drawBack(false));
        }
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)this.recipe.getOutputItem()), 81, 27, 0.0, 8, null).drawBack(false).recipeContext((EmiRecipe)this));
        widgets.addText((Component)Component.literal((String)("Altar Power: " + this.recipe.getAltarPower() + "/s")), this.getDisplayWidth() / 4, this.getDisplayHeight() - 18, 0xFFFFFF, true);
    }
}

