/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.modonomicon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.integration.modonomicon.BookPotionCapacityPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0001(BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012$\u0010\u0005\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00070\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\nJ\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R8\u0010\u0005\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00070\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/integration/modonomicon/BookPotionEffectPage;", "Lcom/klikli_dev/modonomicon/book/page/BookPage;", "title", "Lcom/klikli_dev/modonomicon/book/BookTextHolder;", "text", "items", "", "Lkotlin/Pair;", "Lnet/minecraft/world/item/ItemStack;", "anchor", "", "condition", "Lcom/klikli_dev/modonomicon/book/conditions/BookCondition;", "<init>", "(Lcom/klikli_dev/modonomicon/book/BookTextHolder;Lcom/klikli_dev/modonomicon/book/BookTextHolder;Ljava/util/List;Ljava/lang/String;Lcom/klikli_dev/modonomicon/book/conditions/BookCondition;)V", "getTitle", "()Lcom/klikli_dev/modonomicon/book/BookTextHolder;", "setTitle", "(Lcom/klikli_dev/modonomicon/book/BookTextHolder;)V", "getText", "setText", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "hasTitle", "", "getType", "Lnet/minecraft/resources/ResourceLocation;", "prerenderMarkdown", "", "textRenderer", "Lcom/klikli_dev/modonomicon/client/gui/book/markdown/BookTextRenderer;", "toNetwork", "buffer", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "matchesQuery", "query", "itemStackMatchesQuery", "stack", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nBookPotionEffectPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookPotionEffectPage.kt\ndev/sterner/witchery/integration/modonomicon/BookPotionEffectPage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1761#2,3:138\n*S KotlinDebug\n*F\n+ 1 BookPotionEffectPage.kt\ndev/sterner/witchery/integration/modonomicon/BookPotionEffectPage\n*L\n83#1:138,3\n*E\n"})
public final class BookPotionEffectPage
extends BookPage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BookTextHolder title;
    @NotNull
    private BookTextHolder text;
    @NotNull
    private List<Pair<ItemStack, Pair<BookTextHolder, BookTextHolder>>> items;

    public BookPotionEffectPage(@NotNull BookTextHolder title, @NotNull BookTextHolder text, @NotNull List<Pair<ItemStack, Pair<BookTextHolder, BookTextHolder>>> items, @Nullable String anchor, @Nullable BookCondition condition) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.items = items;
    }

    @NotNull
    public final BookTextHolder getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull BookTextHolder bookTextHolder) {
        Intrinsics.checkNotNullParameter((Object)bookTextHolder, (String)"<set-?>");
        this.title = bookTextHolder;
    }

    @NotNull
    public final BookTextHolder getText() {
        return this.text;
    }

    public final void setText(@NotNull BookTextHolder bookTextHolder) {
        Intrinsics.checkNotNullParameter((Object)bookTextHolder, (String)"<set-?>");
        this.text = bookTextHolder;
    }

    @NotNull
    public final List<Pair<ItemStack, Pair<BookTextHolder, BookTextHolder>>> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<Pair<ItemStack, Pair<BookTextHolder, BookTextHolder>>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    public final boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @NotNull
    public ResourceLocation getType() {
        ResourceLocation resourceLocation = Witchery.Companion.id("potion_effect");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }

    public void prerenderMarkdown(@NotNull BookTextRenderer textRenderer) {
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((Component)Component.translatable((String)this.title.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = (BookTextHolder)new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    public void toNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.title.toNetwork(buffer);
        BookPotionCapacityPage.Companion.getITEMS_WITH_TEXT_TEXT_LIST_STREAM_CODEC().encode((Object)buffer, this.items);
        this.text.toNetwork(buffer);
        String string = this.anchor;
        if (string == null) {
            string = "";
        }
        buffer.writeUtf(string);
        BookCondition.toNetwork((BookCondition)this.condition, (RegistryFriendlyByteBuf)buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchesQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = this.title.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)query, (boolean)false, (int)2, null)) return true;
        if (this.itemStackMatchesQuery(query)) return true;
        String string4 = this.text.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        string2 = string4;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string5 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)query, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean itemStackMatchesQuery(@Nullable String query) {
        boolean bl;
        block4: {
            CharSequence charSequence = query;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return true;
            }
            Iterable $this$any$iv = this.items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    ItemStack stack = (ItemStack)pair.component1();
                    if (!this.matchesQuery(stack, query)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean matchesQuery(@NotNull ItemStack stack, @Nullable String query) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        String string = I18n.get((String)stack.getDescriptionId(), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        CharSequence charSequence = string3;
        String string4 = query;
        Intrinsics.checkNotNull((Object)string4);
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string4, (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/integration/modonomicon/BookPotionEffectPage$Companion;", "", "<init>", "()V", "fromJson", "Ldev/sterner/witchery/integration/modonomicon/BookPotionEffectPage;", "entryId", "Lnet/minecraft/resources/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "fromNetwork", "buffer", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nBookPotionEffectPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookPotionEffectPage.kt\ndev/sterner/witchery/integration/modonomicon/BookPotionEffectPage$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1563#2:138\n1634#2,3:139\n*S KotlinDebug\n*F\n+ 1 BookPotionEffectPage.kt\ndev/sterner/witchery/integration/modonomicon/BookPotionEffectPage$Companion\n*L\n108#1:138\n108#1:139,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BookPotionEffectPage fromJson(@Nullable ResourceLocation entryId, @NotNull JsonObject json, @NotNull HolderLookup.Provider provider) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            BookTextHolder title = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
            BookTextHolder text = BookGsonHelper.getAsBookTextHolder((JsonObject)json, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
            String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
            BookCondition condition = json.has("condition") ? BookCondition.fromJson((ResourceLocation)entryId, (JsonObject)json.getAsJsonObject("condition"), (HolderLookup.Provider)provider) : (BookCondition)new BookNoneCondition();
            JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"items");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonObject obj = element.getAsJsonObject();
                ItemStack stack = ItemStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)obj.get("item")).result().orElse(ItemStack.EMPTY);
                JsonObject textsObj = obj.getAsJsonObject("texts");
                BookTextHolder itemText = BookGsonHelper.getAsBookTextHolder((JsonObject)textsObj, (String)"text", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
                BookTextHolder itemText1 = BookGsonHelper.getAsBookTextHolder((JsonObject)textsObj, (String)"text_title", (BookTextHolder)BookTextHolder.EMPTY, (HolderLookup.Provider)provider);
                collection.add(TuplesKt.to((Object)stack, (Object)TuplesKt.to((Object)itemText, (Object)itemText1)));
            }
            List itemList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNull((Object)title);
            Intrinsics.checkNotNull((Object)text);
            return new BookPotionEffectPage(title, text, itemList, anchor, condition);
        }

        @NotNull
        public final BookPotionEffectPage fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BookTextHolder title = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
            List itemList = (List)BookPotionCapacityPage.Companion.getITEMS_WITH_TEXT_TEXT_LIST_STREAM_CODEC().decode((Object)buffer);
            BookTextHolder text = BookTextHolder.fromNetwork((RegistryFriendlyByteBuf)buffer);
            String anchor = buffer.readUtf();
            BookCondition condition = BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer);
            Intrinsics.checkNotNull((Object)title);
            Intrinsics.checkNotNull((Object)text);
            Intrinsics.checkNotNull((Object)itemList);
            return new BookPotionEffectPage(title, text, CollectionsKt.toMutableList((Collection)itemList), anchor, condition);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

