/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.modonomicon;

import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.modonomicon.client.render.page.BookRecipePageRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.ritual.RitualHelper;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.integration.modonomicon.BookRitualRecipePage;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 ,*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003:\u0001,B\u0011\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JF\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014JJ\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002J0\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/integration/modonomicon/BookRitualRecipePageRenderer;", "T", "Lnet/minecraft/world/item/crafting/Recipe;", "Lcom/klikli_dev/modonomicon/client/render/page/BookRecipePageRenderer;", "Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "Lcom/klikli_dev/modonomicon/book/page/BookRecipePage;", "page", "Ldev/sterner/witchery/integration/modonomicon/BookRitualRecipePage;", "<init>", "(Ldev/sterner/witchery/integration/modonomicon/BookRitualRecipePage;)V", "getRecipeHeight", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "ticks", "", "drawRecipe", "recipeHolder", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "recipeX", "recipeY", "second", "", "renderRitualCircle", "pattern", "", "", "blockMapping", "", "", "Lnet/minecraft/world/level/block/Block;", "squareX", "squareY", "squareSize", "renderItem", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "posX", "posY", "index", "Companion", "witchery"})
public abstract class BookRitualRecipePageRenderer<T extends Recipe<?>>
extends BookRecipePageRenderer<RitualRecipe, BookRecipePage<RitualRecipe>> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BookRitualRecipePageRenderer(@Nullable BookRitualRecipePage page) {
        super((BookRecipePage)page);
    }

    protected int getRecipeHeight() {
        return 45;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int recipeX = BookRecipePageRenderer.X - 9;
        int recipeY = BookRecipePageRenderer.Y + 18;
        BookPage bookPage = this.page;
        Intrinsics.checkNotNull((Object)bookPage);
        RecipeHolder recipeHolder = ((BookRecipePage)bookPage).getRecipe1();
        Intrinsics.checkNotNullExpressionValue((Object)recipeHolder, (String)"getRecipe1(...)");
        this.drawRecipe(guiGraphics, (RecipeHolder<RitualRecipe>)recipeHolder, recipeX, recipeY, mouseX, mouseY, false);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    protected void drawRecipe(@NotNull GuiGraphics guiGraphics, @NotNull RecipeHolder<RitualRecipe> recipeHolder, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter(recipeHolder, (String)"recipeHolder");
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        RitualRecipe recipe = (RitualRecipe)recipeHolder.value();
        Intrinsics.checkNotNull((Object)recipe);
        if (RitualHelper.INSTANCE.usesCurseCommands(recipe) && !((Boolean)WitcheryConfig.ENABLE_CURSES.get()).booleanValue()) {
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD};
            MutableComponent warningText = Component.literal((String)"Curses Disabled").withStyle(chatFormattingArray);
            int textWidth = Minecraft.getInstance().font.width((FormattedText)warningText);
            guiGraphics.drawStringWithBackdrop(Minecraft.getInstance().font, (Component)warningText, recipeX + 46 - textWidth / 2, recipeY - 40, textWidth, 0xFF0000);
        }
        int itemsPerRow = 2;
        int itemSpacing = 18;
        int startX = recipeX + 2 + 2 + 18 + 64 + 9;
        int startY = recipeY - 32 + 9;
        Iterator iterator = ((Iterable)recipe.getInputItems()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ItemStack item = (ItemStack)iterator.next();
            int row = index / itemsPerRow;
            int col = index % itemsPerRow;
            int x = startX - col * itemSpacing;
            int y = startY + row * itemSpacing;
            this.parentScreen.renderItemStack(guiGraphics, x, y, mouseX, mouseY, item);
        }
        int squareSize = 92;
        this.renderRitualCircle(guiGraphics, recipe.getPattern(), recipe.getBlockMapping(), recipeX, recipeY, squareSize);
        Intrinsics.checkNotNull((Object)pose);
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/altar_power_modonomicon.png"), recipeX + 9, recipeY + 108 - 9, 0.0f, 0.0f, 96, 23, 96, 23, 0.0f, 0, 3072, null);
        int powerTextY = recipeY + 108 - 2;
        MutableComponent leftText = Component.literal((String)String.valueOf(recipe.getAltarPower()));
        MutableComponent colonText = Component.literal((String)"   ");
        MutableComponent rightText = Component.literal((String)(recipe.getAltarPowerPerSecond() + "/s"));
        int leftWidth = Minecraft.getInstance().font.width((FormattedText)leftText);
        int colonWidth = Minecraft.getInstance().font.width((FormattedText)colonText);
        int colonX = recipeX + 36 + 15;
        guiGraphics.drawStringWithBackdrop(Minecraft.getInstance().font, (Component)leftText, colonX - leftWidth - 2, powerTextY, leftWidth, 0xFFFFFF);
        guiGraphics.drawStringWithBackdrop(Minecraft.getInstance().font, (Component)colonText, colonX, powerTextY, colonWidth, 0xFFFFFF);
        int rightWidth = Minecraft.getInstance().font.width((FormattedText)rightText);
        guiGraphics.drawStringWithBackdrop(Minecraft.getInstance().font, (Component)rightText, colonX + colonWidth + 2, powerTextY, rightWidth, 0xFFFFFF);
        boolean fullMoon = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.FULL_MOON);
        boolean newMoon = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.NEW_MOON);
        boolean night = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.NIGHT);
        boolean day = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.DAY);
        boolean waxing = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.WAXING);
        boolean waning = recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.WANING);
        boolean all = recipe.getCelestialConditions().isEmpty();
        int iconSize = 10;
        int x = 20;
        int y = 0;
        if (recipe.getRequireCat()) {
            int catX = 45;
            int catY = 0;
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/cat.png"), catX, catY, 0.0f, 0.0f, 10, 10, 10, 10, 0.0f, 0, 3072, null);
            boolean bl = catX <= mouseX ? mouseX <= catX + iconSize : false;
            if (bl) {
                boolean bl2 = catY <= mouseY ? mouseY <= catY + iconSize : false;
                if (bl2) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Requires Familiar Cat"), mouseX, mouseY);
                }
            }
        }
        if (recipe.getWeather().contains((Object)RitualRecipe.Weather.RAIN)) {
            int rainX = 45;
            int rainY = 11;
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/weather/rain.png"), rainX, rainY, 0.0f, 0.0f, 10, 10, 10, 10, 0.0f, 0, 3072, null);
            boolean bl = rainX <= mouseX ? mouseX <= rainX + iconSize : false;
            if (bl) {
                boolean bl3 = rainY <= mouseY ? mouseY <= rainY + iconSize : false;
                if (bl3) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Requires Rain"), mouseX, mouseY);
                }
            }
        }
        if (recipe.getWeather().contains((Object)RitualRecipe.Weather.STORM)) {
            int stormX = 45;
            int stormY = 22;
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/weather/storm.png"), stormX, stormY, 0.0f, 0.0f, 10, 10, 10, 10, 0.0f, 0, 3072, null);
            boolean bl = stormX <= mouseX ? mouseX <= stormX + iconSize : false;
            if (bl) {
                boolean bl4 = stormY <= mouseY ? mouseY <= stormY + iconSize : false;
                if (bl4) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Requires Thunderstorm"), mouseX, mouseY);
                }
            }
        }
        boolean showSun = day || all;
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/celestial/" + (showSun ? "sun" : "empty") + ".png"), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0, 2048, null);
        boolean bl = x <= mouseX ? mouseX <= x + iconSize : false;
        if (bl) {
            boolean bl5 = y <= mouseY ? mouseY <= y + iconSize : false;
            if (bl5) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Day"), mouseX, mouseY);
            }
        }
        boolean showFullMoon = fullMoon || night || all;
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/celestial/" + (showFullMoon ? "full_moon" : "empty") + ".png"), x, y += 11, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0, 2048, null);
        boolean bl6 = x <= mouseX ? mouseX <= x + iconSize : false;
        if (bl6) {
            boolean bl7 = y <= mouseY ? mouseY <= y + iconSize : false;
            if (bl7) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Full Moon"), mouseX, mouseY);
            }
        }
        boolean showNewMoon = newMoon || night || all;
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/celestial/" + (showNewMoon ? "new_moon" : "empty") + ".png"), x, y += 11, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0, 2048, null);
        boolean bl8 = x <= mouseX ? mouseX <= x + iconSize : false;
        if (bl8) {
            boolean bl9 = y <= mouseY ? mouseY <= y + iconSize : false;
            if (bl9) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"New Moon"), mouseX, mouseY);
            }
        }
        x = 9;
        y = 16;
        boolean showWaxing = waxing || night || all;
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/celestial/" + (showWaxing ? "waxing_moon" : "empty") + ".png"), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0, 2048, null);
        boolean bl10 = x <= mouseX ? mouseX <= x + iconSize : false;
        if (bl10) {
            boolean bl11 = y <= mouseY ? mouseY <= y + iconSize : false;
            if (bl11) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Waxing Moon"), mouseX, mouseY);
            }
        }
        x = 31;
        y = 16;
        boolean showWaning = waning || night || all;
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, pose, Witchery.Companion.id("textures/gui/celestial/" + (showWaning ? "waning_moon" : "empty") + ".png"), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0, 2048, null);
        boolean bl12 = x <= mouseX ? mouseX <= x + iconSize : false;
        if (bl12) {
            boolean bl13 = y <= mouseY ? mouseY <= y + iconSize : false;
            if (bl13) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)"Waning Moon"), mouseX, mouseY);
            }
        }
        if (!((Collection)recipe.getInputEntities()).isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            int entityX = startX - 60;
            int entityY = startY + 50;
            Iterator iterator2 = ((Iterable)recipe.getInputEntities()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                LivingEntity entity;
                ++n2;
                EntityType entityType = (EntityType)iterator2.next();
                Entity entity2 = entityType.create((Level)minecraft.level);
                if ((entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null) == null) {
                    return;
                }
                entity = entity;
                double entityHeight = entity.getBoundingBox().getYsize() * (double)4;
                double entityWidth = entity.getBoundingBox().getXsize() * (double)4;
                int baseScale = entityHeight > 2.0 ? 15 : (entityHeight > 1.0 ? 25 : 30);
                float widthAdjustment = entityWidth > 1.0 ? 0.8f : 1.0f;
                float scale = (float)baseScale * widthAdjustment;
                float yOffset = entityHeight <= 1.0 ? 0.0f : -8.0f;
                RenderUtils.INSTANCE.renderEntityInInventoryFollowsMouse(guiGraphics, entityX - 20, entityY + 20, entityX + 20, entityY - 20, (int)scale, yOffset + (float)9, mouseX, mouseY, entity);
            }
        }
        pose.popPose();
    }

    private final void renderRitualCircle(GuiGraphics guiGraphics, List<String> pattern, Map<Character, ? extends Block> blockMapping, int squareX, int squareY, int squareSize) {
        if (!((Collection)pattern).isEmpty()) {
            PoseStack poseStack = guiGraphics.pose();
            int itemSize = 16;
            int patternWidth = pattern.get(0).length() * itemSize;
            int patternHeight = pattern.size() * itemSize;
            int centerX = squareX + squareSize / 2;
            int centerY = squareY + squareSize / 2;
            int padding = 8;
            int targetSize = squareSize - padding * 2;
            float scale = (float)targetSize / (float)Math.max(patternWidth, patternHeight);
            poseStack.pushPose();
            poseStack.translate((double)centerX, (double)centerY, 0.0);
            poseStack.scale(scale, scale, 1.0f);
            poseStack.translate((double)(12 - patternWidth / 2), (double)(-16 - patternHeight / 2), 0.0);
            int n = ((Collection)pattern).size();
            for (int y = 0; y < n; ++y) {
                String row = pattern.get(y);
                int n2 = ((CharSequence)row).length();
                for (int x = 0; x < n2; ++x) {
                    char c = row.charAt(x);
                    Block block = blockMapping.get(Character.valueOf(c));
                    Block block2 = block;
                    if (block2 == null || (block2 = block2.asItem()) == null || (block2 = block2.getDefaultInstance()) == null) continue;
                    Block itemStack = block2;
                    int posX = x * itemSize;
                    int posY = y * itemSize;
                    this.renderItem(guiGraphics, (ItemStack)itemStack, posX, posY, y + x);
                }
            }
            poseStack.popPose();
        }
    }

    private final void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int posX, int posY, int index) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)posX, (double)posY, 0.0);
        if (itemStack.is((Item)WitcheryItems.INSTANCE.getGOLDEN_CHALK().get())) {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id("textures/block/golden_chalk.png");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            Companion.renderChalk(poseStack, resourceLocation);
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getRITUAL_CHALK().get())) {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id("textures/block/chalk_" + index % 15 + ".png");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            Companion.renderChalk(poseStack, resourceLocation);
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getOTHERWHERE_CHALK().get())) {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id("textures/block/chalk_" + index % 15 + ".png");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            Companion.renderChalk(poseStack, resourceLocation, new Color(190, 55, 250).getRGB());
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getINFERNAL_CHALK().get())) {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id("textures/block/chalk_" + index % 15 + ".png");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            Companion.renderChalk(poseStack, resourceLocation, new Color(230, 0, 75).getRGB());
        } else {
            guiGraphics.renderItem(itemStack, posX, posY, index);
        }
        poseStack.popPose();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/integration/modonomicon/BookRitualRecipePageRenderer$Companion;", "", "<init>", "()V", "renderChalk", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "color", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void renderChalk(@NotNull PoseStack poseStack, @NotNull ResourceLocation texture, int color) {
            Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 1, 33, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
            RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 0, 32, 0.0f, 0.0f, 16, 16, 16, 16, 1.0f, color);
        }

        public final void renderChalk(@NotNull PoseStack poseStack, @NotNull ResourceLocation texture) {
            Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 1, 33, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
            RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, texture, 0, 32, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, 0, 3072, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

