/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.misc.InventoryLockPlayerAttachment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player player;

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventAddToLockedSlot(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this.player == null) {
            return;
        }
        Inventory self = (Inventory)this;
        int targetSlot = self.getSlotWithRemainingSpace(stack);
        if (targetSlot == -1) {
            targetSlot = self.getFreeSlot();
        }
        if (targetSlot != -1 && InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(this.player, targetSlot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventAddToSpecificLockedSlot(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this.player != null && InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(this.player, slot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventSetItemInLockedSlot(int slot, ItemStack stack, CallbackInfo ci) {
        if (this.player != null && InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(this.player, slot) && !stack.isEmpty()) {
            ci.cancel();
        }
    }

    @Inject(method={"removeItem(II)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventRemoveFromLockedSlot(int slot, int count, CallbackInfoReturnable<ItemStack> cir) {
        if (this.player != null && InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(this.player, slot)) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }

    @Inject(method={"getSelected"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventUseOfLockedHotbarSlot(CallbackInfoReturnable<ItemStack> cir) {
        Inventory self = (Inventory)this;
        if (this.player != null && InventoryLockPlayerAttachment.INSTANCE.isSlotLocked(this.player, self.selected)) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }
}

