/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zoglin.class})
public class ZoglinMixin {
    @Inject(method={"setAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$zoglinNoAttack(LivingEntity target, CallbackInfo ci) {
        Zoglin mob = (Zoglin)this;
        UUID uuid = EtherealEntityAttachment.getData((LivingEntity)mob).getOwnerUUID();
        if (uuid != null && target.getUUID() == uuid) {
            ci.cancel();
        }
        if (target instanceof Player) {
            boolean bl;
            Player player = (Player)target;
            boolean bl2 = bl = AfflictionPlayerAttachment.getData(player).getVampireLevel() > 0;
            if (bl) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"findNearestValidAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$filterTargets(CallbackInfoReturnable<Optional<? extends LivingEntity>> cir) {
        Zoglin zoglin = (Zoglin)this;
        EtherealEntityAttachment.Data etherealData = EtherealEntityAttachment.getData((LivingEntity)zoglin);
        if (etherealData.getOwnerUUID() != null) {
            Optional target = zoglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearbyEntities -> nearbyEntities.findClosest(entity -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (etherealData.getOwnerUUID().equals(player.getUUID())) {
                        return false;
                    }
                    Player owner = zoglin.level().getPlayerByUUID(etherealData.getOwnerUUID());
                    if (owner != null && AfflictionPlayerAttachment.getData(owner).getLichLevel() > 0 && AfflictionPlayerAttachment.getData(player).getLichLevel() > 0) {
                        return false;
                    }
                }
                return Sensor.isEntityAttackable((LivingEntity)zoglin, (LivingEntity)entity);
            }));
            cir.setReturnValue(target);
        }
    }
}

