/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.sterner.witchery.content.block.coffin.CoffinBlock;
import dev.sterner.witchery.content.entity.DeathEntity;
import dev.sterner.witchery.content.entity.WerewolfEntity;
import dev.sterner.witchery.core.registry.WitcheryMobEffects;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.infusion.LightInfusionPlayerAttachment;
import dev.sterner.witchery.features.spirit_world.ManifestationPlayerAttachment;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"setModelProperties"}, at={@At(value="TAIL")})
    private void witchery$lightInfusionInvisibility(AbstractClientPlayer clientPlayer, CallbackInfo ci) {
        PlayerModel model;
        if (LightInfusionPlayerAttachment.isInvisible((Player)clientPlayer).isInvisible()) {
            model = (PlayerModel)this.getModel();
            model.setAllVisible(false);
        }
        if (clientPlayer.hasEffect(WitcheryMobEffects.INSTANCE.getGROTESQUE())) {
            model = (PlayerModel)this.getModel();
            model.head.visible = false;
        }
    }

    @WrapWithCondition(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private boolean witchery$renderGhostHand(ModelPart instance, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, @Local(argsOnly=true) MultiBufferSource multiBufferSource, @Local(argsOnly=true) AbstractClientPlayer player, @Local ResourceLocation resourceLocation) {
        if (ManifestationPlayerAttachment.getData((Player)player).getManifestationTimer() > 0) {
            int originalAlpha = 38;
            int reducedAlpha = (int)((double)originalAlpha * 0.75) << 24;
            int colorWithReducedAlpha = 0xFFFFFF | reducedAlpha;
            instance.render(poseStack, multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)resourceLocation)), packedLight, OverlayTexture.NO_OVERLAY, colorWithReducedAlpha);
            return false;
        }
        return true;
    }

    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$dontRenderCoffinSleep(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        Optional pos = entity.getSleepingPos();
        if (pos.isPresent() && entity.level().getBlockState((BlockPos)pos.get()).getBlock() instanceof CoffinBlock) {
            ci.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$renderTransformation(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        WerewolfEntity werewolf;
        if (DeathTransformationHelper.INSTANCE.isDeath((Player)entity)) {
            DeathEntity death = DeathTransformationHelper.INSTANCE.getDeathEntity((Player)entity);
            if (death != null) {
                TransformationHandler.INSTANCE.copyTransforms((Mob)death, entity);
                death.setItemInHand(InteractionHand.MAIN_HAND, entity.getMainHandItem());
                death.setItemInHand(InteractionHand.OFF_HAND, entity.getOffhandItem());
                Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)death).render((Entity)death, entityYaw, partialTicks, poseStack, buffer, packedLight);
                ci.cancel();
            }
        } else if (TransformationHandler.isBat((Player)entity)) {
            Bat bat = TransformationHandler.getBatEntity((Player)entity);
            if (bat != null) {
                TransformationHandler.INSTANCE.copyTransforms((Mob)bat, entity);
                boolean bl = entity.onGround() && !entity.getAbilities().flying;
                bat.setResting(bl);
                poseStack.pushPose();
                if (bl) {
                    poseStack.translate(0.0f, 0.85f, 0.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-180.0f));
                }
                Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)bat).render((Entity)bat, entityYaw, partialTicks, poseStack, buffer, packedLight);
                poseStack.popPose();
                ci.cancel();
            }
        } else if (TransformationHandler.isWolf((Player)entity)) {
            Wolf wolf = TransformationHandler.getWolfEntity((Player)entity);
            if (wolf != null) {
                TransformationHandler.INSTANCE.copyTransforms((Mob)wolf, entity);
                wolf.setInSittingPose(entity.isShiftKeyDown());
                Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)wolf).render((Entity)wolf, entityYaw, partialTicks, poseStack, buffer, packedLight);
                ci.cancel();
            }
        } else if (TransformationHandler.isWerewolf((Player)entity) && (werewolf = TransformationHandler.getWerewolf((Player)entity)) != null) {
            TransformationHandler.INSTANCE.copyTransforms((Mob)werewolf, entity);
            Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)werewolf).render((Entity)werewolf, entityYaw, partialTicks, poseStack, buffer, packedLight);
            ci.cancel();
        }
    }
}

