/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @Final
    private Abilities abilities;
    @Unique
    private static final EntityDimensions SOUL_SNEAKING_SIZE = EntityDimensions.scalable((float)0.6f, (float)0.6f);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"isSwimming"}, at={@At(value="HEAD")}, cancellable=true)
    private void flyLikeSuperman(CallbackInfoReturnable<Boolean> cir) {
        Player self = (Player)this;
        if (this.abilities.flying && this.isSprinting() && AfflictionPlayerAttachment.getData(self).isSoulForm()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getMovementEmission"}, at={@At(value="RETURN")}, cancellable=true)
    private void preventMoveEffects(CallbackInfoReturnable<Entity.MovementEmission> cir) {
        Player self = (Player)this;
        if (cir.getReturnValue() != Entity.MovementEmission.NONE && AfflictionPlayerAttachment.getData(self).isSoulForm()) {
            cir.setReturnValue((Object)Entity.MovementEmission.NONE);
        }
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getLookAngle()Lnet/minecraft/world/phys/Vec3;")})
    private void flySwimVertically(Vec3 motion, CallbackInfo ci) {
        double yMotion = this.getRotationVector().y;
        double modifier = yMotion < -0.2 ? 0.085 : 0.06;
        Player self = (Player)this;
        if (yMotion > 0.0 && !this.jumping && this.level().getBlockState(BlockPos.containing((double)this.getX(), (double)(this.getY() + 1.0 - 0.1), (double)this.getZ())).getFluidState().isEmpty() && AfflictionPlayerAttachment.getData(self).isSoulForm()) {
            Vec3 velocity = this.getDeltaMovement();
            this.setDeltaMovement(velocity.add(0.0, (yMotion - velocity.y) * modifier, 0.0));
        }
    }

    @Inject(method={"getDefaultDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustSize(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        Player self = (Player)this;
        if (AfflictionPlayerAttachment.getData(self).isSoulForm() && pose == Pose.CROUCHING) {
            cir.setReturnValue((Object)SOUL_SNEAKING_SIZE);
        }
    }
}

