/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.possessor;

import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import dev.sterner.witchery.mixin.possession.possessor.PossessorEntityMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class PossessorLivingEntityMixin
extends PossessorEntityMixin {
    @Unique
    private boolean witchery$wasSprinting;

    @Shadow
    public abstract void setSprinting(boolean var1);

    @Inject(method={"isFallFlying"}, at={@At(value="RETURN")}, cancellable=true)
    protected void witchery$canFly(CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(method={"setSprinting"}, at={@At(value="RETURN")})
    protected void witchery$setSprinting(boolean sprinting, CallbackInfo ci) {
    }

    @Inject(method={"onClimbable"}, at={@At(value="RETURN")}, cancellable=true)
    protected void witchery$canClimb(CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void witchery$canWalkOnFluid(FluidState fluid, CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/world/entity/LivingEntity;fallDistance:F", ordinal=0)}, cancellable=true)
    private void witchery$checkFallDamage(double fallY, boolean onGround, BlockState floorBlock, BlockPos floorPos, CallbackInfo info) {
        Player player;
        Mob possessed;
        if (this.witchery$getWorld().isClientSide) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player && (possessed = PossessionComponentAttachment.INSTANCE.get(player = (Player)self).getHost()) != null && this.witchery$getFallDistance() > 0.0f) {
            possessed.fallDistance = this.witchery$getFallDistance();
            possessed.copyPosition((Entity)this);
            possessed.move(MoverType.SELF, Vec3.ZERO);
            ((PossessorLivingEntityMixin)possessed).witchery$fall(fallY, onGround, floorBlock, floorPos);
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private DamageSource witchery$hurt(DamageSource source, DamageSource s, float amount) {
        Entity attacker = source.getEntity();
        if (attacker instanceof LivingEntity) {
            Mob delegate = null;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                delegate = PossessionComponentAttachment.INSTANCE.get(player).getHost();
            }
            if (delegate != null) {
                return WitcheryUtil.createProxiedDamage(source, delegate);
            }
        }
        return source;
    }

    @Inject(method={"getFluidFallingAdjustedMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSprinting()Z")})
    private void witchery$getFluidFallingAdjustedMovement(double gravity, boolean isFalling, Vec3 deltaMovement, CallbackInfoReturnable<Vec3> cir) {
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player) {
            Player player = (Player)self;
            this.witchery$isSprinting();
        }
    }

    @Inject(method={"getFluidFallingAdjustedMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSprinting()Z", shift=At.Shift.AFTER)})
    private void witchery$getFluidFallingAdjustedMovement2(double gravity, boolean isFalling, Vec3 deltaMovement, CallbackInfoReturnable<Vec3> cir) {
        if (this.witchery$wasSprinting) {
            this.witchery$wasSprinting = false;
            this.setSprinting(true);
        }
    }

    @Inject(method={"startSleeping"}, at={@At(value="RETURN")})
    private void witchery$startSleeping(BlockPos pos, CallbackInfo ci) {
        Player player;
        Mob host;
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player && (host = PossessionComponentAttachment.INSTANCE.get(player = (Player)self).getHost()) != null && host.getType().is(WitcheryTags.INSTANCE.getSLEEPERS())) {
            host.startSleeping(pos);
        }
    }

    @Inject(method={"stopSleeping"}, at={@At(value="RETURN")})
    private void witchery$stopSleeping(CallbackInfo ci) {
        Player player;
        Mob host;
        LivingEntity self = (LivingEntity)this;
        if (self instanceof Player && (host = PossessionComponentAttachment.INSTANCE.get(player = (Player)self).getHost()) != null && host.getType().is(WitcheryTags.INSTANCE.getSLEEPERS())) {
            host.stopSleeping();
        }
    }
}

