/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryShaders;
import dev.sterner.witchery.features.misc.BindingRitualAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="witchery", bus=EventBusSubscriber.Bus.GAME)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002Jx\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/client/BindingBoxRenderer;", "", "<init>", "()V", "TEXTURE_FRONT", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "TEXTURE_BACK", "TEXTURE_LEFT", "TEXTURE_RIGHT", "TEXTURE_TOP", "TEXTURE_BOTTOM", "TEXTURE_CORE", "onRenderLevel", "", "event", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "renderBindingBox", "radius", "", "fadeProgress", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "addGlowFace", "builder", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "matrix", "Lorg/joml/Matrix4f;", "x1", "y1", "z1", "x2", "y2", "z2", "x3", "y3", "z3", "x4", "y4", "z4", "witchery"})
@SourceDebugExtension(value={"SMAP\nBindingBoxRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BindingBoxRenderer.kt\ndev/sterner/witchery/client/BindingBoxRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n*S KotlinDebug\n*F\n+ 1 BindingBoxRenderer.kt\ndev/sterner/witchery/client/BindingBoxRenderer\n*L\n51#1:199\n51#1:200,2\n*E\n"})
public final class BindingBoxRenderer {
    @NotNull
    public static final BindingBoxRenderer INSTANCE = new BindingBoxRenderer();
    private static final ResourceLocation TEXTURE_FRONT = Witchery.Companion.id("textures/entity/soul_lantern_front.png");
    private static final ResourceLocation TEXTURE_BACK = Witchery.Companion.id("textures/entity/soul_lantern_front.png");
    private static final ResourceLocation TEXTURE_LEFT = Witchery.Companion.id("textures/entity/soul_lantern_right.png");
    private static final ResourceLocation TEXTURE_RIGHT = Witchery.Companion.id("textures/entity/soul_lantern_right.png");
    private static final ResourceLocation TEXTURE_TOP = Witchery.Companion.id("textures/entity/soul_lantern_top.png");
    private static final ResourceLocation TEXTURE_BOTTOM = Witchery.Companion.id("textures/entity/soul_lantern_top.png");
    private static final ResourceLocation TEXTURE_CORE = Witchery.Companion.id("textures/entity/soul_lantern_core.png");

    private BindingBoxRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRenderLevel(@NotNull RenderLevelStageEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getStage(), (Object)RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel clientLevel = minecraft.level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        Camera camera = minecraft.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Iterable iterable = level.entitiesForRendering();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"entitiesForRendering(...)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity entity = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(entity instanceof LivingEntity && ((LivingEntity)entity).distanceToSqr(cameraPos) < 16384.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nearbyEntities = (List)destination$iv$iv;
        for (Entity entity : nearbyEntities) {
            BindingRitualAttachment.Data bindingData;
            if (!(entity instanceof LivingEntity) || !(bindingData = BindingRitualAttachment.INSTANCE.getData((LivingEntity)entity)).isActive()) continue;
            BlockPos centerPos = bindingData.getCenterPos();
            double radius = bindingData.getRadius();
            poseStack.pushPose();
            poseStack.translate((double)centerPos.getX() + 0.5 - cameraPos.x, (double)centerPos.getY() + 0.5 - cameraPos.y, (double)centerPos.getZ() + 0.5 - cameraPos.z);
            float fadeProgress = RangesKt.coerceIn((float)((float)bindingData.getDuration() / 2400.0f), (float)0.0f, (float)1.0f);
            float f = (float)radius;
            Intrinsics.checkNotNull((Object)poseStack);
            Intrinsics.checkNotNull((Object)bufferSource);
            this.renderBindingBox(f, fadeProgress, poseStack, (MultiBufferSource)bufferSource);
            poseStack.popPose();
        }
    }

    private final void renderBindingBox(float radius, float fadeProgress, PoseStack poseStack, MultiBufferSource bufferSource) {
        BufferBuilder builder;
        ShaderInstance shaderInstance = WitcheryShaders.soulLantern;
        if (shaderInstance == null) {
            return;
        }
        ShaderInstance shader = shaderInstance;
        double time = (double)System.currentTimeMillis() / 1000.0;
        float wobble = (float)Math.sin(time * 2.0) * (radius * 0.01f);
        float wobble2 = (float)Math.cos(time * 1.5) * (radius * 0.01f);
        float min = -radius + wobble;
        float max = radius + wobble2;
        Matrix4f matrix = poseStack.last().pose();
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)bufferSource).endBatch();
        }
        ShaderInstance prevShader = RenderSystem.getShader();
        boolean prevCull = GL11.glIsEnabled((int)2884);
        boolean prevDepthMask = GL11.glGetBoolean((int)2930);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        shader.safeGetUniform("Alpha").set(fadeProgress * 0.5f);
        RenderSystem.setShader(() -> BindingBoxRenderer.renderBindingBox$lambda$0(shader));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_FRONT);
        BufferBuilder bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        Intrinsics.checkNotNull((Object)matrix);
        this.addGlowFace(bufferBuilder, matrix, min, min, max, max, min, max, max, max, max, min, max, max);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BACK);
        bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        this.addGlowFace(bufferBuilder, matrix, max, min, min, min, min, min, min, max, min, max, max, min);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_LEFT);
        bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        this.addGlowFace(bufferBuilder, matrix, min, min, min, min, min, max, min, max, max, min, max, min);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_RIGHT);
        bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        this.addGlowFace(bufferBuilder, matrix, max, min, max, max, min, min, max, max, min, max, max, max);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_TOP);
        bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        this.addGlowFace(bufferBuilder, matrix, min, max, max, max, max, max, max, max, min, min, max, min);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BOTTOM);
        bufferBuilder = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder);
        this.addGlowFace(bufferBuilder, matrix, min, min, min, max, min, min, max, min, max, min, min, max);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        float coreSize = radius * 0.97f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_CORE);
        BufferBuilder bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, -coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, coreSize, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, coreSize, -coreSize, coreSize, coreSize, -coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, -coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, -coreSize, -coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        bufferBuilder2 = builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)bufferBuilder2);
        this.addGlowFace(bufferBuilder2, matrix, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, -coreSize, -coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)prevDepthMask);
        if (prevCull) {
            RenderSystem.enableCull();
        }
        if (prevShader != null) {
            RenderSystem.setShader(() -> BindingBoxRenderer.renderBindingBox$lambda$1(prevShader));
        }
    }

    private final void addGlowFace(BufferBuilder builder, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        int light = 240;
        builder.addVertex(matrix, x1, y1, z1).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setUv2(light, light);
        builder.addVertex(matrix, x2, y2, z2).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setUv2(light, light);
        builder.addVertex(matrix, x3, y3, z3).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setUv2(light, light);
        builder.addVertex(matrix, x4, y4, z4).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setUv2(light, light);
    }

    private static final ShaderInstance renderBindingBox$lambda$0(ShaderInstance $shader) {
        return $shader;
    }

    private static final ShaderInstance renderBindingBox$lambda$1(ShaderInstance $prevShader) {
        return $prevShader;
    }
}

