/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\bJ \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007Jh\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002Jp\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/sterner/witchery/client/OreHighlightRenderer;", "", "<init>", "()V", "highlightedOres", "", "Ldev/sterner/witchery/client/OreHighlightRenderer$HighlightedOre;", "addHighlightedOres", "", "positions", "", "Lnet/minecraft/core/BlockPos;", "duration", "", "tick", "renderOreHighlights", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "partialTick", "", "renderBox", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "x", "", "y", "z", "width", "height", "depth", "red", "green", "blue", "alpha", "line", "matrix", "Lorg/joml/Matrix4f;", "normal", "Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", "x1", "y1", "z1", "x2", "y2", "z2", "HighlightedOre", "witchery"})
@SourceDebugExtension(value={"SMAP\nOreHighlightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OreHighlightRenderer.kt\ndev/sterner/witchery/client/OreHighlightRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1563#2:112\n1634#2,3:113\n*S KotlinDebug\n*F\n+ 1 OreHighlightRenderer.kt\ndev/sterner/witchery/client/OreHighlightRenderer\n*L\n20#1:112\n20#1:113,3\n*E\n"})
public final class OreHighlightRenderer {
    @NotNull
    public static final OreHighlightRenderer INSTANCE = new OreHighlightRenderer();
    @NotNull
    private static final List<HighlightedOre> highlightedOres = new ArrayList();

    private OreHighlightRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    public final void addHighlightedOres(@NotNull List<? extends BlockPos> positions, int duration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        long endTime = System.currentTimeMillis() + (long)(duration * 50);
        Iterable iterable = positions;
        List<HighlightedOre> list = highlightedOres;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockPos blockPos = (BlockPos)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightedOre((BlockPos)it, endTime));
        }
        list.addAll((List)destination$iv$iv);
    }

    public final void tick() {
        long currentTime = System.currentTimeMillis();
        highlightedOres.removeIf(arg_0 -> OreHighlightRenderer.tick$lambda$1(arg_0 -> OreHighlightRenderer.tick$lambda$0(currentTime, arg_0), arg_0));
    }

    @JvmStatic
    public static final void renderOreHighlights(@NotNull PoseStack poseStack, @NotNull Camera camera, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (highlightedOres.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        poseStack.pushPose();
        Vec3 camPos = camera.getPosition();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        for (HighlightedOre highlight : highlightedOres) {
            float alpha = RangesKt.coerceIn((float)((float)(highlight.getEndTime() - System.currentTimeMillis()) / 10000.0f), (float)0.0f, (float)1.0f);
            Intrinsics.checkNotNull((Object)buffer);
            INSTANCE.renderBox(poseStack, buffer, highlight.getPos().getX(), highlight.getPos().getY(), highlight.getPos().getZ(), 1.0, 1.0, 1.0, 1.0f, 1.0f, 0.0f, alpha);
        }
        bufferSource.endBatch();
        poseStack.popPose();
    }

    private final void renderBox(PoseStack poseStack, VertexConsumer buffer, double x, double y, double z, double width, double height, double depth, float red, float green, float blue, float alpha) {
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        float x1 = (float)x;
        float y1 = (float)y;
        float z1 = (float)z;
        float x2 = (float)(x + width);
        float y2 = (float)(y + height);
        float z2 = (float)(z + depth);
        Intrinsics.checkNotNull((Object)matrix);
        Intrinsics.checkNotNull((Object)normal);
        this.line(buffer, matrix, normal, x1, y1, z1, x2, y1, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y1, z1, x2, y1, z2, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y1, z2, x1, y1, z2, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x1, y1, z2, x1, y1, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x1, y2, z1, x2, y2, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y2, z1, x2, y2, z2, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y2, z2, x1, y2, z2, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x1, y2, z2, x1, y2, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x1, y1, z1, x1, y2, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y1, z1, x2, y2, z1, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x2, y1, z2, x2, y2, z2, red, green, blue, alpha);
        this.line(buffer, matrix, normal, x1, y1, z2, x1, y2, z2, red, green, blue, alpha);
    }

    private final void line(VertexConsumer buffer, Matrix4f matrix, PoseStack.Pose normal, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float dz = z2 - z1;
        float length = Mth.sqrt((float)(dx * dx + dy * dy + dz * dz));
        float nx = dx / length;
        float ny = dy / length;
        float nz = dz / length;
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setNormal(normal, nx, ny, nz);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setNormal(normal, nx, ny, nz);
    }

    private static final boolean tick$lambda$0(long $currentTime, HighlightedOre it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEndTime() < $currentTime;
    }

    private static final boolean tick$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/client/OreHighlightRenderer$HighlightedOre;", "", "pos", "Lnet/minecraft/core/BlockPos;", "endTime", "", "<init>", "(Lnet/minecraft/core/BlockPos;J)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getEndTime", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "witchery"})
    public static final class HighlightedOre {
        @NotNull
        private final BlockPos pos;
        private final long endTime;

        public HighlightedOre(@NotNull BlockPos pos, long endTime) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
            this.endTime = endTime;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        public final long component2() {
            return this.endTime;
        }

        @NotNull
        public final HighlightedOre copy(@NotNull BlockPos pos, long endTime) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new HighlightedOre(pos, endTime);
        }

        public static /* synthetic */ HighlightedOre copy$default(HighlightedOre highlightedOre, BlockPos blockPos, long l, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = highlightedOre.pos;
            }
            if ((n & 2) != 0) {
                l = highlightedOre.endTime;
            }
            return highlightedOre.copy(blockPos, l);
        }

        @NotNull
        public String toString() {
            return "HighlightedOre(pos=" + this.pos + ", endTime=" + this.endTime + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + Long.hashCode(this.endTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HighlightedOre)) {
                return false;
            }
            HighlightedOre highlightedOre = (HighlightedOre)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)highlightedOre.pos)) {
                return false;
            }
            return this.endTime == highlightedOre.endTime;
        }
    }
}

