/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.DeathEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J0\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/sterner/witchery/client/model/DeathEntityModel;", "Lnet/minecraft/client/model/HierarchicalModel;", "Ldev/sterner/witchery/content/entity/DeathEntity;", "Lnet/minecraft/client/model/ArmedModel;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "getRoot", "()Lnet/minecraft/client/model/geom/ModelPart;", "head", "hood", "body", "robe", "leftArm", "rightArm", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "translateToHand", "side", "Lnet/minecraft/world/entity/HumanoidArm;", "Companion", "witchery"})
public final class DeathEntityModel
extends HierarchicalModel<DeathEntity>
implements ArmedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart hood;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart robe;
    @NotNull
    private final ModelPart leftArm;
    @NotNull
    private final ModelPart rightArm;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("death"), "main");

    public DeathEntityModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(DeathEntityModel::_init_$lambda$0);
        this.root = root;
        ModelPart modelPart = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.head = modelPart;
        ModelPart modelPart2 = this.head.getChild("hood");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.hood = modelPart2;
        ModelPart modelPart3 = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.body = modelPart3;
        ModelPart modelPart4 = this.body.getChild("robe");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.robe = modelPart4;
        ModelPart modelPart5 = this.body.getChild("lArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.leftArm = modelPart5;
        ModelPart modelPart6 = this.body.getChild("rArm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"getChild(...)");
        this.rightArm = modelPart6;
    }

    @NotNull
    public final ModelPart getRoot() {
        return this.root;
    }

    public void setupAnim(@NotNull DeathEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float idleAmplitude = 0.05f;
        this.leftArm.xRot = Mth.sin((float)(ageInTicks * 0.067f)) * idleAmplitude;
        this.rightArm.xRot = -0.4f + Mth.sin((float)(ageInTicks * 0.067f)) * (idleAmplitude * 0.5f);
        this.rightArm.zRot = 0.1f;
        this.leftArm.zRot = -0.1f;
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @Nullable
    public ModelPart root() {
        return this.root;
    }

    public void translateToHand(@NotNull HumanoidArm side, @NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        ModelPart modelPart = this.rightArm;
        poseStack.translate(-0.0, 0.8, -0.0);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(-0.0, -0.2, -0.0);
    }

    private static final RenderType _init_$lambda$0(ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return RenderType.entityTranslucent((ResourceLocation)location);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/DeathEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
            head.addOrReplaceChild("hood", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -4.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
            PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 14).addBox(-3.5f, -6.2348f, -3.1736f, 7.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.2348f, (float)1.1736f));
            body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.7652f, (float)0.8264f, (float)0.1745f, (float)0.0f, (float)0.0f));
            body.addOrReplaceChild("robe", CubeListBuilder.create().texOffs(27, 29).addBox(-4.5f, -1.0f, -5.0f, 9.0f, 13.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.7348f, (float)1.3264f, (float)0.0873f, (float)0.0f, (float)0.0f));
            body.addOrReplaceChild("lArm", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -0.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 47).addBox(-0.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)4.0f, (float)-5.2348f, (float)-1.1736f));
            body.addOrReplaceChild("rArm", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-2.0f, -0.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(1, 47).mirror().addBox(-2.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(-0.05f)).mirror(false), PartPose.offset((float)-4.0f, (float)-5.2348f, (float)-1.1736f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

