/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.ImpEntity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\"B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J8\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/client/model/ImpEntityModel;", "Lnet/minecraft/client/model/HierarchicalModel;", "Ldev/sterner/witchery/content/entity/ImpEntity;", "Lnet/minecraft/client/model/ArmedModel;", "modelPart", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "root", "head", "body", "right_arm", "left_arm", "right_wing", "left_wing", "tail", "right_horn2", "right_horn", "bone", "bone2", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "translateToHand", "side", "Lnet/minecraft/world/entity/HumanoidArm;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "Companion", "witchery"})
public final class ImpEntityModel
extends HierarchicalModel<ImpEntity>
implements ArmedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart right_arm;
    @NotNull
    private final ModelPart left_arm;
    @NotNull
    private final ModelPart right_wing;
    @NotNull
    private final ModelPart left_wing;
    @NotNull
    private final ModelPart tail;
    @NotNull
    private final ModelPart right_horn2;
    @NotNull
    private final ModelPart right_horn;
    @NotNull
    private final ModelPart bone;
    @NotNull
    private final ModelPart bone2;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("imp"), "main");

    public ImpEntityModel(@NotNull ModelPart modelPart) {
        Intrinsics.checkNotNullParameter((Object)modelPart, (String)"modelPart");
        super(ImpEntityModel::_init_$lambda$0);
        ModelPart modelPart2 = modelPart.getChild("root");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.root = modelPart2;
        ModelPart modelPart3 = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.head = modelPart3;
        ModelPart modelPart4 = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.body = modelPart4;
        ModelPart modelPart5 = this.body.getChild("right_arm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.right_arm = modelPart5;
        ModelPart modelPart6 = this.body.getChild("left_arm");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"getChild(...)");
        this.left_arm = modelPart6;
        ModelPart modelPart7 = this.body.getChild("right_wing");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart7, (String)"getChild(...)");
        this.right_wing = modelPart7;
        ModelPart modelPart8 = this.body.getChild("left_wing");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart8, (String)"getChild(...)");
        this.left_wing = modelPart8;
        ModelPart modelPart9 = this.body.getChild("tail");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart9, (String)"getChild(...)");
        this.tail = modelPart9;
        ModelPart modelPart10 = this.head.getChild("right_horn2");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart10, (String)"getChild(...)");
        this.right_horn2 = modelPart10;
        ModelPart modelPart11 = this.head.getChild("right_horn");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart11, (String)"getChild(...)");
        this.right_horn = modelPart11;
        ModelPart modelPart12 = this.right_horn.getChild("bone");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart12, (String)"getChild(...)");
        this.bone = modelPart12;
        ModelPart modelPart13 = this.right_horn2.getChild("bone2");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart13, (String)"getChild(...)");
        this.bone2 = modelPart13;
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull ImpEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.root().getAllParts().forEach(arg_0 -> ImpEntityModel.setupAnim$lambda$1(ImpEntityModel::setupAnim$lambda$0, arg_0));
        float f = ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwing;
        float g = Mth.cos((float)f) * (float)Math.PI * 0.15f + limbSwingAmount;
        float cfr_ignored_0 = ageInTicks - (float)entity.tickCount;
        float i = ageInTicks * 9.0f * ((float)Math.PI / 180);
        float j = (float)Math.min((double)(limbSwingAmount / 0.3f), 1.0);
        float k = 1.0f - j;
        boolean l = false;
        float m = 0.0f;
        float n = 0.0f;
        float o = 0.0f;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.right_wing.xRot = -0.2f * (1.0f - j);
        this.right_wing.yRot = -0.7853982f + g;
        this.left_wing.xRot = -0.2f * (1.0f - j);
        this.left_wing.yRot = 0.7853982f - g;
        this.body.xRot = j * 0.7853982f;
        m = (float)l * Mth.lerp((float)j, (float)-1.0471976f, (float)-1.134464f);
        ModelPart var10000 = this.root;
        var10000.y += (float)Math.cos(i) * 0.25f * k;
        this.right_arm.xRot = m;
        this.left_arm.xRot = m;
        n = k * (1.0f - (float)l);
        o = 0.43633232f - Mth.cos((float)(i + 4.712389f)) * (float)Math.PI * 0.075f * n;
        this.left_arm.zRot = -o;
        this.right_arm.zRot = o;
        this.right_arm.yRot = 0.27925268f * (float)l;
        this.left_arm.yRot = -0.27925268f * (float)l;
    }

    public void translateToHand(@NotNull HumanoidArm side, @NotNull PoseStack poseStack) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        this.root.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        poseStack.translate(0.0f, 0.0625f, 0.1875f);
        poseStack.mulPose(Axis.XP.rotation(this.right_arm.xRot));
        poseStack.scale(0.7f, 0.7f, 0.7f);
        poseStack.translate(0.0625f, 0.0f, 0.0f);
    }

    private static final RenderType _init_$lambda$0(ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return RenderType.entityTranslucent((ResourceLocation)location);
    }

    private static final Unit setupAnim$lambda$0(ModelPart obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.resetPose();
        return Unit.INSTANCE;
    }

    private static final void setupAnim$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/ImpEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_horn2 = head.addOrReplaceChild("right_horn2", CubeListBuilder.create().texOffs(16, 26).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)5.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)-0.3054f));
            PartDefinition bone2 = right_horn2.addOrReplaceChild("bone2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            bone2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(10, 23).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)1.7f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
            PartDefinition right_horn = head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(16, 26).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)5.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.3054f));
            PartDefinition bone = right_horn.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            bone.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(10, 23).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)1.7f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
            PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 17).addBox(-1.5f, -4.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 10).addBox(-1.5f, -5.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(20, 0).addBox(0.0f, -3.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)1.45f, (float)-0.5f, (float)0.0f));
            body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, -3.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)-1.5f, (float)-0.5f, (float)0.0f));
            body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 7).addBox(-0.5f, -6.0f, -0.6f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)0.0f, (float)0.6f));
            body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, -6.0f, -0.6f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)0.0f, (float)0.6f));
            body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 22).addBox(1.0f, -1.0f, 0.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-3.0f, (float)1.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

