/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.DistilleryGemModel;
import dev.sterner.witchery.client.model.JarModel;
import dev.sterner.witchery.content.block.distillery.DistilleryBlockEntity;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/client/renderer/block/DistilleryBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/distillery/DistilleryBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "jarModel", "Ldev/sterner/witchery/client/model/JarModel;", "gemModel", "Ldev/sterner/witchery/client/model/DistilleryGemModel;", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class DistilleryBlockEntityRenderer
implements BlockEntityRenderer<DistilleryBlockEntity> {
    @NotNull
    private JarModel jarModel;
    @NotNull
    private DistilleryGemModel gemModel;

    public DistilleryBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(JarModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.jarModel = new JarModel(modelPart);
        ModelPart modelPart2 = ctx.bakeLayer(DistilleryGemModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.gemModel = new DistilleryGemModel(modelPart2);
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull DistilleryBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.0, (double)pos.getY() - 0.0, (double)pos.getZ() - 0.0, (double)pos.getX() + 0.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.0);
    }

    public void render(@NotNull DistilleryBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            poseStack.pushPose();
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(-0.5, -1.5, 0.5);
            this.gemModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.eyes((ResourceLocation)Witchery.Companion.id("textures/block/distillery_gem.png"))), packedLight, packedOverlay);
            poseStack.popPose();
        }
        Object[] objectArray = new Pair[]{new Pair((Object)Float.valueOf(0.3875f), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(-0.3875f), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.3875f)), new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-0.3875f))};
        List offsets = CollectionsKt.listOf((Object[])objectArray);
        RenderType jarTexture = RenderType.entityCutout((ResourceLocation)Witchery.Companion.id("textures/block/jar_block.png"));
        VertexConsumer buffer = bufferSource.getBuffer(jarTexture);
        Iterator iterator = ((Iterable)offsets).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Pair offset = (Pair)iterator.next();
            if (((ItemStack)blockEntity.getItems().get(2)).getCount() <= index) continue;
            poseStack.pushPose();
            poseStack.translate(0.5 + ((Number)offset.getFirst()).doubleValue(), 0.0, 0.5 + ((Number)offset.getSecond()).doubleValue());
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0, -2.1, 0.0);
            this.jarModel.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

