/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.BansheeEntityModel;
import dev.sterner.witchery.client.model.SpectreEntityModel;
import dev.sterner.witchery.content.block.effigy.EffigyBlock;
import dev.sterner.witchery.content.block.effigy.EffigyBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/client/renderer/block/EffigyBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/effigy/EffigyBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getCtx", "()Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "setCtx", "spectreHeadModel", "Ldev/sterner/witchery/client/model/SpectreEntityModel;", "getSpectreHeadModel", "()Ldev/sterner/witchery/client/model/SpectreEntityModel;", "setSpectreHeadModel", "(Ldev/sterner/witchery/client/model/SpectreEntityModel;)V", "bansheeHeadModel", "Ldev/sterner/witchery/client/model/BansheeEntityModel;", "getBansheeHeadModel", "()Ldev/sterner/witchery/client/model/BansheeEntityModel;", "setBansheeHeadModel", "(Ldev/sterner/witchery/client/model/BansheeEntityModel;)V", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class EffigyBlockEntityRenderer
implements BlockEntityRenderer<EffigyBlockEntity> {
    @NotNull
    private BlockEntityRendererProvider.Context ctx;
    @NotNull
    private SpectreEntityModel spectreHeadModel;
    @NotNull
    private BansheeEntityModel bansheeHeadModel;

    public EffigyBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        ModelPart modelPart = this.ctx.bakeLayer(SpectreEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.spectreHeadModel = new SpectreEntityModel(modelPart);
        ModelPart modelPart2 = this.ctx.bakeLayer(BansheeEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.bansheeHeadModel = new BansheeEntityModel(modelPart2);
    }

    @NotNull
    public final BlockEntityRendererProvider.Context getCtx() {
        return this.ctx;
    }

    public final void setCtx(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.ctx = context;
    }

    @NotNull
    public final SpectreEntityModel getSpectreHeadModel() {
        return this.spectreHeadModel;
    }

    public final void setSpectreHeadModel(@NotNull SpectreEntityModel spectreEntityModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)spectreEntityModel), (String)"<set-?>");
        this.spectreHeadModel = spectreEntityModel;
    }

    @NotNull
    public final BansheeEntityModel getBansheeHeadModel() {
        return this.bansheeHeadModel;
    }

    public final void setBansheeHeadModel(@NotNull BansheeEntityModel bansheeEntityModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)bansheeEntityModel), (String)"<set-?>");
        this.bansheeHeadModel = bansheeEntityModel;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull EffigyBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 0.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0);
    }

    public void render(@NotNull EffigyBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        double z;
        double x;
        double angle;
        int i;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockState renderState = blockEntity.getBlockState().is((Block)WitcheryBlocks.INSTANCE.getSCARECROW().get()) ? (BlockState)((EffigyBlock)((Object)WitcheryBlocks.INSTANCE.getSCARECROW().get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir) : (BlockState)((EffigyBlock)((Object)WitcheryBlocks.INSTANCE.getCLAY_EFFIGY().get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir);
        BakedModel model = this.ctx.getBlockRenderDispatcher().getBlockModelShaper().getBlockModel(renderState);
        this.ctx.getBlockRenderDispatcher().getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.cutout()), renderState, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        poseStack.popPose();
        int spectreCount = RangesKt.coerceAtMost((int)blockEntity.getSpecterCount(), (int)5);
        int bansheeCount = RangesKt.coerceAtMost((int)blockEntity.getBansheeCount(), (int)5);
        float spectreY = 1.2f;
        float bansheeY = 0.8f;
        float radius = 0.8f;
        RenderType spectreRenderType = RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/entity/spectre.png"));
        RenderType bansheeRenderType = RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/entity/banshee.png"));
        Level level = blockEntity.getLevel();
        float time = (float)(level != null ? level.getGameTime() : 0L) + partialTick;
        float rotationSpeed = 0.02f;
        float rotationSpeedier = 0.03f;
        for (i = 0; i < spectreCount; ++i) {
            angle = ((double)((float)i / (float)spectreCount * (float)2) * Math.PI + (double)(time * rotationSpeedier)) % (Math.PI * 2);
            x = (double)radius * Math.cos(angle);
            z = (double)radius * Math.sin(angle);
            poseStack.pushPose();
            poseStack.translate(0.5 + x, (double)spectreY, 0.5 + z);
            poseStack.scale(0.5f, -0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(-angle * 57.29577951308232) + (float)180));
            this.spectreHeadModel.getHead().render(poseStack, bufferSource.getBuffer(spectreRenderType), packedLight, packedOverlay, 0x40FFFFFF);
            poseStack.popPose();
        }
        for (i = 0; i < bansheeCount; ++i) {
            angle = ((double)((float)i / (float)bansheeCount * (float)2) * Math.PI + (double)(time * rotationSpeed)) % (Math.PI * 2);
            x = (double)radius * Math.cos(angle);
            z = (double)radius * Math.sin(angle);
            poseStack.pushPose();
            poseStack.translate(0.5 + x, (double)bansheeY, 0.5 + z);
            poseStack.scale(0.5f, -0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(-angle * 57.29577951308232) + (float)180));
            this.bansheeHeadModel.getHead().render(poseStack, bufferSource.getBuffer(bansheeRenderType), packedLight, packedOverlay, 0x40FFFFFF);
            this.bansheeHeadModel.getHeadMain().render(poseStack, bufferSource.getBuffer(bansheeRenderType), packedLight, packedOverlay, 0x40FFFFFF);
            poseStack.popPose();
        }
    }
}

