/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.LifeBloodPlantModel;
import dev.sterner.witchery.content.block.life_blood.LifeBloodBlock;
import dev.sterner.witchery.content.block.life_blood.LifeBloodBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/client/renderer/block/LifeBloodBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/life_blood/LifeBloodBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "mainTexture", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getMainTexture", "()Lnet/minecraft/resources/ResourceLocation;", "plantTexture", "getPlantTexture", "main", "Ldev/sterner/witchery/client/model/LifeBloodPlantModel;", "getMain", "()Ldev/sterner/witchery/client/model/LifeBloodPlantModel;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "Companion", "witchery"})
public final class LifeBloodBlockEntityRenderer
implements BlockEntityRenderer<LifeBloodBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ResourceLocation mainTexture;
    private final ResourceLocation plantTexture;
    @NotNull
    private final LifeBloodPlantModel main;
    private static final float RESCALE_FACTOR = 1.3f;

    public LifeBloodBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.mainTexture = Witchery.Companion.id("textures/block/life_blood_v2.png");
        this.plantTexture = Witchery.Companion.id("textures/block/life_blood_plant_v2.png");
        ModelPart modelPart = ctx.bakeLayer(LifeBloodPlantModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.main = new LifeBloodPlantModel(modelPart);
    }

    public final ResourceLocation getMainTexture() {
        return this.mainTexture;
    }

    public final ResourceLocation getPlantTexture() {
        return this.plantTexture;
    }

    @NotNull
    public final LifeBloodPlantModel getMain() {
        return this.main;
    }

    public void render(@NotNull LifeBloodBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Boolean berry = (Boolean)blockEntity.getBlockState().getValue((Property)CaveVinesPlantBlock.BERRIES);
        boolean isBottom = blockEntity.getBlockState().getBlock() instanceof LifeBloodBlock;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.scale(1.3f, 1.0f, 1.3f);
        poseStack.translate(-0.5000000183398914, 0.0, -0.5000000183398914);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        if (isBottom) {
            this.main.getCross().render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.mainTexture)), packedLight, packedOverlay, -1);
            if (berry.booleanValue()) {
                this.main.getGlow().render(poseStack, bufferSource.getBuffer((RenderType)WitcheryRenderTypes.INSTANCE.getLIFE().apply(this.mainTexture)), packedLight, packedOverlay, -1);
            }
        } else {
            this.main.getCross().render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.plantTexture)), packedLight, packedOverlay, -1);
            if (berry.booleanValue()) {
                this.main.getGlow().render(poseStack, bufferSource.getBuffer((RenderType)WitcheryRenderTypes.INSTANCE.getLIFE().apply(this.plantTexture)), packedLight, packedOverlay, -1);
            }
        }
        poseStack.popPose();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/client/renderer/block/LifeBloodBlockEntityRenderer$Companion;", "", "<init>", "()V", "RESCALE_FACTOR", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

