/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.MushroomLogModel;
import dev.sterner.witchery.content.block.mushroom_log.MushroomLogBlockEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J0\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J0\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/client/renderer/block/MushroomLogBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/mushroom_log/MushroomLogBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/MushroomLogModel;", "getModel", "()Ldev/sterner/witchery/client/model/MushroomLogModel;", "setModel", "(Ldev/sterner/witchery/client/model/MushroomLogModel;)V", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "renderLog", "renderMushrooms", "witchery"})
public final class MushroomLogBlockEntityRenderer
implements BlockEntityRenderer<MushroomLogBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context ctx;
    @NotNull
    private MushroomLogModel model;

    public MushroomLogBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        ModelPart modelPart = this.ctx.bakeLayer(MushroomLogModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new MushroomLogModel(modelPart);
    }

    @NotNull
    public final MushroomLogModel getModel() {
        return this.model;
    }

    public final void setModel(@NotNull MushroomLogModel mushroomLogModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)mushroomLogModel), (String)"<set-?>");
        this.model = mushroomLogModel;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull MushroomLogBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 0.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getY() + 0.0, (double)pos.getZ() + 1.0);
    }

    public void render(@NotNull MushroomLogBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        this.renderLog(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        if (!blockEntity.getCurrentMushroom().isEmpty()) {
            this.renderMushrooms(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private final void renderLog(MushroomLogBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction;
        poseStack.pushPose();
        Direction direction2 = direction = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1: {
                poseStack.translate(0.0, 0.5, -0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case 2: {
                poseStack.translate(1.0, 0.5, 1.5);
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case 3: {
                poseStack.translate(1.5, 0.5, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case 4: {
                poseStack.translate(-0.5, 0.5, 1.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            default: {
                poseStack.translate(0.5, 0.5, 0.5);
            }
        }
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -1.0, -0.5);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)Witchery.Companion.id("textures/block/mushroom_log.png")));
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
        poseStack.popPose();
    }

    private final void renderMushrooms(MushroomLogBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = blockEntity.getCurrentMushroom().getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockState mushroomState = ((BlockItem)item).getBlock().defaultBlockState();
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        List<MushroomLogBlockEntity.MushroomData> mushroomData = blockEntity.getMushroomData();
        for (MushroomLogBlockEntity.MushroomData data2 : mushroomData) {
            poseStack.pushPose();
            double baseX = 0.5;
            double baseY = 1.0;
            double baseZ = 0.5;
            Direction direction2 = direction;
            switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                case 1: {
                    double adjustedZ = 1.0 - (double)data2.getZOffset() - 1.5;
                    poseStack.translate(baseX + (double)data2.getXOffset(), baseY, adjustedZ);
                    break;
                }
                case 2: {
                    double adjustedZ = baseZ - (double)data2.getZOffset();
                    poseStack.translate(baseX - (double)data2.getXOffset(), baseY, adjustedZ);
                    break;
                }
                case 3: {
                    double adjustedX = 1.0 - (double)data2.getZOffset() - 0.5;
                    poseStack.translate(adjustedX, baseY, baseZ + (double)data2.getXOffset());
                    break;
                }
                case 4: {
                    double adjustedX = baseX - (double)data2.getZOffset() - 1.0;
                    poseStack.translate(adjustedX, baseY, baseZ - (double)data2.getXOffset());
                    break;
                }
                default: {
                    poseStack.translate(baseX + (double)data2.getXOffset(), baseY, baseZ + (double)data2.getZOffset());
                }
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(data2.getRotation()));
            float scale = data2.getScale();
            poseStack.translate(-0.5 * (double)scale, 0.0, -0.5 * (double)scale);
            poseStack.scale(scale, scale, scale);
            this.ctx.getBlockRenderDispatcher().renderSingleBlock(mushroomState, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

