/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.content.block.sacrificial_circle.SacrificialBlockEntity;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/client/renderer/block/SacrificialCircleBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/sacrificial_circle/SacrificialBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class SacrificialCircleBlockEntityRenderer
implements BlockEntityRenderer<SacrificialBlockEntity> {
    public SacrificialCircleBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull SacrificialBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.0, (double)pos.getY() - 0.0, (double)pos.getZ() - 1.0, (double)pos.getX() + 1.0, (double)pos.getY() + 0.0, (double)pos.getZ() + 1.0);
    }

    public void render(@NotNull SacrificialBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        double radius = 1.4;
        Vec3 center = blockEntity.getBlockPos().getCenter().subtract(0.5, 0.5, 0.5);
        BlockState skullState = Blocks.SKELETON_SKULL.defaultBlockState();
        SkullBlockEntity skullBlockEntity = new SkullBlockEntity(BlockPos.ZERO, skullState);
        poseStack.pushPose();
        poseStack.translate(center.x - (double)blockEntity.getBlockPos().getX(), center.y - (double)blockEntity.getBlockPos().getY(), center.z - (double)blockEntity.getBlockPos().getZ());
        if (blockEntity.getHasSkull()) {
            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)skullBlockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
        poseStack.popPose();
        int n = ((Collection)blockEntity.getCandles()).size();
        for (int i = 0; i < n; ++i) {
            BlockItem candleItem;
            Item item = ((ItemStack)blockEntity.getCandles().get(i)).getItem();
            if ((item instanceof BlockItem ? (BlockItem)item : null) == null) continue;
            candleItem = candleItem;
            Block candleBlock = candleItem.getBlock();
            double angle = Math.toRadians(360.0 / (double)blockEntity.getCandles().size() * (double)i);
            double xOffset = radius * Math.cos(angle);
            double zOffset = radius * Math.sin(angle);
            poseStack.pushPose();
            poseStack.translate(center.x + xOffset - (double)blockEntity.getBlockPos().getX(), center.y - (double)blockEntity.getBlockPos().getY(), center.z + zOffset - (double)blockEntity.getBlockPos().getZ());
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(candleBlock.defaultBlockState(), poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
            Level level = blockEntity.getLevel();
            Intrinsics.checkNotNull((Object)level);
            int randomOffset = level.random.nextInt(5);
            Level level2 = blockEntity.getLevel();
            Intrinsics.checkNotNull((Object)level2);
            if ((level2.getGameTime() + (long)randomOffset) % (long)20 != 0L) continue;
            Level level3 = blockEntity.getLevel();
            if (level3 == null) continue;
            level3.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, center.x + xOffset + 0.5, center.y + 0.5, center.z + zOffset + 0.5, 0.0, 0.0, 0.0);
        }
    }
}

