/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.tarot;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.tarot.TarotCardObject;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.network.LockInTarotCardsC2SPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0006\u0010\u0013\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0002J(\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010&\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\bH\u0002J \u0010'\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0016J \u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020\rH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000bH\u0002J\b\u00102\u001a\u000200H\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\"H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ldev/sterner/witchery/client/tarot/TarotReadingScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "<init>", "()V", "player", "Lnet/minecraft/world/entity/player/Player;", "cards", "", "Ldev/sterner/witchery/client/tarot/TarotCardObject;", "deckCard", "animationTicks", "", "isDrawing", "", "hasDrawn", "hoveredCard", "init", "", "hasCrystalBallNearby", "startDrawing", "resize", "minecraft", "Lnet/minecraft/client/Minecraft;", "width", "height", "tick", "updateHoverEffects", "mouseX", "mouseY", "sendCardsToServer", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "", "renderCard", "card", "isDeck", "renderTooltip", "mouseClicked", "", "button", "keyPressed", "keyCode", "scanCode", "modifiers", "isPauseScreen", "getCardTexture", "Lnet/minecraft/resources/ResourceLocation;", "cardNumber", "getBackTexture", "easeOutCubic", "t", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nTarotReadingScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TarotReadingScreen.kt\ndev/sterner/witchery/client/tarot/TarotReadingScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,400:1\n1563#2:401\n1634#2,3:402\n1563#2:405\n1634#2,3:406\n1563#2:409\n1634#2,3:410\n*S KotlinDebug\n*F\n+ 1 TarotReadingScreen.kt\ndev/sterner/witchery/client/tarot/TarotReadingScreen\n*L\n201#1:401\n201#1:402,3\n202#1:405\n202#1:406,3\n358#1:409\n358#1:410,3\n*E\n"})
public final class TarotReadingScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Player player;
    @NotNull
    private final List<TarotCardObject> cards = new ArrayList();
    @NotNull
    private final TarotCardObject deckCard = new TarotCardObject(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false, 0.0f, 2046, null);
    private int animationTicks;
    private boolean isDrawing;
    private boolean hasDrawn;
    @Nullable
    private TarotCardObject hoveredCard;
    public static final float OFFSET = 25.0f;
    public static final int NUM_CARDS = 3;
    public static final int ANIMATION_DURATION = 30;
    public static final int FLIP_DELAY = 10;
    public static final double CRYSTAL_BALL_RANGE = 8.0;
    public static final float CARD_Y_OFFSET = -40.0f;

    public TarotReadingScreen() {
        super((Component)Component.literal((String)"Tarot Reading"));
    }

    protected void init() {
        super.init();
        float padding = 20.0f;
        float leftOffset = 25.0f;
        this.deckCard.setScreenX((float)this.width - 46.0f - padding - leftOffset);
        this.deckCard.setScreenY((float)this.height - 81.0f - padding);
        this.deckCard.setTargetX(this.deckCard.getScreenX());
        this.deckCard.setTargetY(this.deckCard.getScreenY());
    }

    private final boolean hasCrystalBallNearby() {
        Player player = this.player;
        if (player == null) {
            return false;
        }
        Player player2 = player;
        Level level = player2.level();
        BlockPos pos = player2.blockPosition();
        for (int x = -8; x < 9; ++x) {
            for (int y = -8; y < 9; ++y) {
                for (int z = -8; z < 9; ++z) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    BlockState state = level.getBlockState(checkPos);
                    if (!Intrinsics.areEqual((Object)state.getBlock(), (Object)WitcheryBlocks.INSTANCE.getCRYSTAL_BALL().get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final void startDrawing() {
        if (this.isDrawing || this.hasDrawn) {
            return;
        }
        this.isDrawing = true;
        this.animationTicks = 0;
        boolean hasCrystalBall = this.hasCrystalBallNearby();
        float reversedChance = hasCrystalBall ? 0.35f : 0.5f;
        Player player = this.player;
        if (player == null || (player = player.level()) == null || (player = player.random) == null) {
            return;
        }
        Player random = player;
        List availableCards = CollectionsKt.toMutableList((Iterable)((Iterable)new IntRange(1, 22)));
        float topDeckOffsetX = 4.0f;
        float topDeckOffsetY = -4.0f;
        for (int i = 0; i < 3; ++i) {
            int cardIndex = ((Number)availableCards.remove(random.nextInt(availableCards.size()))).intValue();
            TarotCardObject card = new TarotCardObject(cardIndex, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false, 0.0f, 2046, null);
            card.setReversed(random.nextFloat() < reversedChance);
            card.setScreenX(this.deckCard.getScreenX() + topDeckOffsetX);
            card.setScreenY(this.deckCard.getScreenY() + topDeckOffsetY);
            card.setRotationY(180.0f);
            float totalWidth = 178.0f;
            float startX = (float)this.width / 2.0f - totalWidth / 2.0f;
            card.setTargetX(startX + (float)i * 66.0f);
            card.setTargetY((float)this.height / 2.0f - 40.5f + -40.0f);
            this.cards.add(card);
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        super.resize(minecraft, width, height);
        float padding = 20.0f;
        float leftOffset = 25.0f;
        this.deckCard.setScreenX((float)width - 46.0f - padding - leftOffset);
        this.deckCard.setScreenY((float)height - 81.0f - padding);
        this.deckCard.setTargetX(this.deckCard.getScreenX());
        this.deckCard.setTargetY(this.deckCard.getScreenY());
        if (this.hasDrawn || this.isDrawing) {
            float totalWidth = 178.0f;
            float startX = (float)width / 2.0f - totalWidth / 2.0f;
            float targetY = (float)height / 2.0f - 40.5f + -40.0f;
            Iterator iterator = ((Iterable)this.cards).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                TarotCardObject card = (TarotCardObject)iterator.next();
                card.setTargetX(startX + (float)i * 66.0f);
                card.setTargetY(targetY);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.isDrawing) {
            int n = this.animationTicks;
            this.animationTicks = n + 1;
            Iterator iterator = ((Iterable)this.cards).iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                int index = n2++;
                TarotCardObject card = (TarotCardObject)iterator.next();
                int cardStartTick = index * 10;
                if (this.animationTicks <= cardStartTick) continue;
                float progress = RangesKt.coerceIn((float)((float)(this.animationTicks - cardStartTick) / 30.0f), (float)0.0f, (float)1.0f);
                float eased = this.easeOutCubic(progress);
                card.setScreenX(Mth.lerp((float)eased, (float)this.deckCard.getScreenX(), (float)card.getTargetX()));
                card.setScreenY(Mth.lerp((float)eased, (float)this.deckCard.getScreenY(), (float)card.getTargetY()));
                int flipStartTick = cardStartTick + 30 + index * 10;
                if (this.animationTicks <= flipStartTick || card.isFlipped()) continue;
                float flipProgress = RangesKt.coerceIn((float)((float)(this.animationTicks - flipStartTick) / 20.0f), (float)0.0f, (float)1.0f);
                card.setRotationY(Mth.lerp((float)flipProgress, (float)180.0f, (float)0.0f));
                if (!(flipProgress >= 1.0f)) continue;
                card.setFlipped(true);
            }
            if (this.animationTicks > 100) {
                this.isDrawing = false;
                this.hasDrawn = true;
                this.sendCardsToServer();
            }
        }
    }

    private final void updateHoverEffects(int mouseX, int mouseY) {
        if (!this.hasDrawn || this.isDrawing) {
            return;
        }
        this.hoveredCard = null;
        for (TarotCardObject card : this.cards) {
            if (!card.isFlipped()) continue;
            float cardLeft = card.getScreenX();
            float cardRight = card.getScreenX() + 46.0f;
            float cardTop = card.getScreenY();
            float cardBottom = card.getScreenY() + 81.0f;
            if ((float)mouseX >= cardLeft && (float)mouseX <= cardRight && (float)mouseY >= cardTop && (float)mouseY <= cardBottom) {
                this.hoveredCard = card;
                float centerX = card.getScreenX() + 23.0f;
                float centerY = card.getScreenY() + 40.5f;
                float relX = ((float)mouseX - centerX) / 23.0f;
                float relY = ((float)mouseY - centerY) / 40.5f;
                card.setRotationY(-relX * 10.0f);
                card.setRotationX(-relY * 10.0f);
                break;
            }
            card.setRotationY(Mth.lerp((float)0.2f, (float)card.getRotationY(), (float)0.0f));
            card.setRotationX(Mth.lerp((float)0.2f, (float)card.getRotationX(), (float)0.0f));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendCardsToServer() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.cards;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TarotCardObject tarotCardObject = (TarotCardObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCardNumber());
        }
        List cardNumbers = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.cards;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TarotCardObject bl = (TarotCardObject)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.isReversed());
        }
        List reversedStates = (List)destination$iv$iv2;
        PacketDistributor.sendToServer((CustomPacketPayload)new LockInTarotCardsC2SPayload(cardNumbers, reversedStates), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Object offsetCard;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.updateHoverEffects(mouseX, mouseY);
        for (int i = 0; i < 5; ++i) {
            offsetCard = new TarotCardObject(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, false, 0.0f, 2046, null);
            ((TarotCardObject)offsetCard).setScreenX(this.deckCard.getScreenX() + (float)i * 1.0f);
            ((TarotCardObject)offsetCard).setScreenY(this.deckCard.getScreenY() - (float)i * 1.0f);
            ((TarotCardObject)offsetCard).setRotationY(this.deckCard.getRotationY());
            this.renderCard(guiGraphics, (TarotCardObject)offsetCard, true, partialTick);
        }
        if (!this.hasDrawn && !this.isDrawing) {
            offsetCard = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC};
            MutableComponent text = Component.literal((String)"Draw to seal your fate").withStyle((ChatFormatting[])offsetCard);
            Minecraft minecraft = this.minecraft;
            Intrinsics.checkNotNull((Object)minecraft);
            int textWidth = minecraft.font.width((FormattedText)text);
            int textX = (int)(this.deckCard.getScreenX() + 23.0f - (float)textWidth / 2.0f);
            int textY = (int)(this.deckCard.getScreenY() - (float)15);
            Minecraft minecraft2 = this.minecraft;
            Intrinsics.checkNotNull((Object)minecraft2);
            guiGraphics.drawString(minecraft2.font, (Component)text, textX, textY, 16766720, true);
        }
        for (TarotCardObject card : this.cards) {
            this.renderCard(guiGraphics, card, false, partialTick);
        }
        if (this.hoveredCard != null && this.hasDrawn) {
            TarotCardObject tarotCardObject = this.hoveredCard;
            Intrinsics.checkNotNull((Object)tarotCardObject);
            this.renderTooltip(guiGraphics, mouseX, mouseY, tarotCardObject);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private final void renderCard(GuiGraphics guiGraphics, TarotCardObject card, boolean isDeck, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)card.getScreenX(), (double)card.getScreenY(), 0.0);
        poseStack.translate(23.0, 40.5, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(card.getRotationY()));
        if (card.isReversed() && card.getRotationY() < 90.0f) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
        if (card.isFlipped()) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(card.getRotationZ()));
            poseStack.mulPose(Axis.XP.rotationDegrees(card.getRotationX()));
        }
        poseStack.translate(-23.0, -40.5, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        if (card.getRotationY() >= 90.0f || isDeck) {
            guiGraphics.blit(this.getBackTexture(), 0, 0, 0.0f, 0.0f, 46, 81, 46, 81);
        }
        if (card.getRotationY() < 90.0f && !isDeck) {
            guiGraphics.blit(this.getCardTexture(card.getCardNumber()), 0, 0, 0.0f, 0.0f, 46, 81, 46, 81);
        }
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, TarotCardObject card) {
        void $this$mapTo$iv$iv;
        Object currentLine;
        List tooltip = new ArrayList();
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD};
        MutableComponent mutableComponent = Component.literal((String)TarotCardObject.Companion.getArcanaName(card.getCardNumber(), card.isReversed())).withStyle(chatFormattingArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltip.add(mutableComponent);
        MutableComponent mutableComponent2 = Component.literal((String)"");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        tooltip.add(mutableComponent2);
        if (card.isReversed()) {
            chatFormattingArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
            MutableComponent mutableComponent3 = Component.literal((String)"Reversed Card").withStyle(chatFormattingArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
            tooltip.add(mutableComponent3);
            MutableComponent mutableComponent4 = Component.literal((String)"Negative Effect").withStyle(ChatFormatting.DARK_RED);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"withStyle(...)");
            v4 = tooltip.add(mutableComponent4);
        } else {
            chatFormattingArray = new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC};
            MutableComponent mutableComponent5 = Component.literal((String)"Upright Card").withStyle(chatFormattingArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"withStyle(...)");
            tooltip.add(mutableComponent5);
            MutableComponent mutableComponent6 = Component.literal((String)"Positive Effect").withStyle(ChatFormatting.DARK_GREEN);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"withStyle(...)");
            v4 = tooltip.add(mutableComponent6);
        }
        TarotEffect tarotEffect = WitcheryTarotEffects.INSTANCE.getByCardNumber(card.getCardNumber());
        if (tarotEffect != null) {
            String effectText = tarotEffect.getDescription(card.isReversed()).getString();
            MutableComponent mutableComponent7 = Component.literal((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent7, (String)"literal(...)");
            tooltip.add(mutableComponent7);
            MutableComponent mutableComponent8 = Component.literal((String)"Effect:").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent8, (String)"withStyle(...)");
            tooltip.add(mutableComponent8);
            int maxWidth = 200;
            Intrinsics.checkNotNull((Object)effectText);
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)effectText, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            currentLine = "";
            for (String word : words) {
                String testLine = ((CharSequence)currentLine).length() == 0 ? word : (String)currentLine + " " + word;
                Minecraft minecraft = this.minecraft;
                Intrinsics.checkNotNull((Object)minecraft);
                if (minecraft.font.width(testLine) <= maxWidth) {
                    currentLine = testLine;
                    continue;
                }
                if (((CharSequence)currentLine).length() > 0) {
                    MutableComponent mutableComponent9 = Component.literal((String)("  " + (String)currentLine)).withStyle(ChatFormatting.DARK_GRAY);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent9, (String)"withStyle(...)");
                    tooltip.add(mutableComponent9);
                }
                currentLine = word;
            }
            if (((CharSequence)currentLine).length() > 0) {
                MutableComponent mutableComponent10 = Component.literal((String)("  " + (String)currentLine)).withStyle(ChatFormatting.DARK_GRAY);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent10, (String)"withStyle(...)");
                tooltip.add(mutableComponent10);
            }
        }
        Iterable $this$map$iv = tooltip;
        boolean $i$f$map = false;
        currentLine = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVisualOrderText());
        }
        List lines = (List)destination$iv$iv;
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        guiGraphics.renderTooltip(minecraft.font, lines, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.hasDrawn && !this.isDrawing) {
            float deckLeft = this.deckCard.getScreenX();
            float deckRight = this.deckCard.getScreenX() + 46.0f;
            float deckTop = this.deckCard.getScreenY();
            float deckBottom = this.deckCard.getScreenY() + 81.0f;
            if (mouseX >= (double)deckLeft && mouseX <= (double)deckRight && mouseY >= (double)deckTop && mouseY <= (double)deckBottom) {
                this.startDrawing();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        if (minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private final ResourceLocation getCardTexture(int cardNumber) {
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/gui/arcana/" + cardNumber + ".png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }

    private final ResourceLocation getBackTexture() {
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/gui/arcana/back.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }

    private final float easeOutCubic(float t) {
        float t1 = t - 1.0f;
        return t1 * t1 * t1 + 1.0f;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/client/tarot/TarotReadingScreen$Companion;", "", "<init>", "()V", "OFFSET", "", "NUM_CARDS", "", "ANIMATION_DURATION", "FLIP_DELAY", "CRYSTAL_BALL_RANGE", "", "CARD_Y_OFFSET", "open", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void open(@NotNull Player player) {
            void $this$open_u24lambda_u240;
            TarotReadingScreen tarotReadingScreen;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            TarotReadingScreen tarotReadingScreen2 = tarotReadingScreen = new TarotReadingScreen();
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = false;
            ((TarotReadingScreen)$this$open_u24lambda_u240).player = player;
            minecraft.setScreen((Screen)tarotReadingScreen);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

