/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import dev.sterner.witchery.content.block.SuspiciousGraveyardDirtBlock;
import dev.sterner.witchery.content.item.TornPageItem;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010#\u001a\u00020 J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0018\u0010-\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010.\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0014J\u001e\u0010/\u001a\u00020 2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u00100\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Ldev/sterner/witchery/content/block/SuspiciousGraveyardDirtBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "brushProgress", "", "brushResetTime", "", "coolDownEndsAtTick", "value", "Lnet/minecraft/world/item/ItemStack;", "storedItem", "getStoredItem", "()Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/core/Direction;", "hitDirection", "getHitDirection", "()Lnet/minecraft/core/Direction;", "lootTable", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/storage/loot/LootTable;", "lootTableSeed", "brush", "", "startTick", "player", "Lnet/minecraft/world/entity/player/Player;", "unpackLootTable", "", "onBrushingCompleted", "dropLoot", "resetBrushingState", "tryLoadLootTable", "tag", "Lnet/minecraft/nbt/CompoundTag;", "trySaveLootTable", "getUpdateTag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "loadAdditional", "saveAdditional", "setLootTable", "seed", "completionState", "getCompletionState", "()I", "witchery"})
public final class SuspiciousGraveyardDirtBlockEntity
extends BlockEntity {
    private int brushProgress;
    private long brushResetTime;
    private long coolDownEndsAtTick;
    @NotNull
    private ItemStack storedItem;
    @Nullable
    private Direction hitDirection;
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public SuspiciousGraveyardDirtBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getBRUSHABLE_BLOCK().get(), pos, blockState);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.storedItem = itemStack;
    }

    @NotNull
    public final ItemStack getStoredItem() {
        return this.storedItem;
    }

    @Nullable
    public final Direction getHitDirection() {
        return this.hitDirection;
    }

    public final boolean brush(long startTick, @NotNull Player player, @Nullable Direction hitDirection) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.brushResetTime = startTick + 40L;
        if (startTick >= this.coolDownEndsAtTick && this.level instanceof ServerLevel) {
            this.coolDownEndsAtTick = startTick + 10L;
            this.unpackLootTable(player);
            int i = this.getCompletionState();
            ++this.brushProgress;
            if (this.brushProgress >= 10) {
                this.onBrushingCompleted(player);
                return true;
            }
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
            int j = this.getCompletionState();
            if (i != j) {
                BlockState blockState = this.getBlockState();
                BlockState blockState2 = (BlockState)blockState.setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(j));
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                level2.setBlock(this.getBlockPos(), blockState2, 3);
            }
            return false;
        }
        return false;
    }

    private final void unpackLootTable(Player player) {
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (!level.isClientSide()) {
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                if (level2.getServer() != null && Intrinsics.areEqual((Object)this.storedItem, (Object)ItemStack.EMPTY)) {
                    Object[] objectArray = new ItemStack[]{Items.BONE.getDefaultInstance(), Items.ROTTEN_FLESH.getDefaultInstance(), ((TornPageItem)((Object)WitcheryItems.INSTANCE.getTORN_PAGE().get())).getDefaultInstance(), Items.SKELETON_SKULL.getDefaultInstance()};
                    List list = CollectionsKt.listOf((Object[])objectArray);
                    Level level3 = this.level;
                    Intrinsics.checkNotNull((Object)level3);
                    Object e = list.get(level3.random.nextInt(list.size() - 1));
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    this.storedItem = (ItemStack)e;
                    this.lootTable = null;
                    this.setChanged();
                }
            }
        }
    }

    private final void onBrushingCompleted(Player player) {
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getServer() != null) {
                Block block;
                this.dropLoot(player);
                BlockState currentBlockState = this.getBlockState();
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                level2.levelEvent(3008, this.getBlockPos(), Block.getId((BlockState)currentBlockState));
                if (this.getBlockState().getBlock() instanceof SuspiciousGraveyardDirtBlock) {
                    Block block2 = this.getBlockState().getBlock();
                    Intrinsics.checkNotNull((Object)block2, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.SuspiciousGraveyardDirtBlock");
                    SuspiciousGraveyardDirtBlock graveyardDirtBlock = (SuspiciousGraveyardDirtBlock)block2;
                    block = graveyardDirtBlock.getTurnsInto();
                } else {
                    block = Blocks.AIR;
                }
                Block replacementBlock = block;
                Level level3 = this.level;
                Intrinsics.checkNotNull((Object)level3);
                level3.setBlock(this.worldPosition, replacementBlock.defaultBlockState(), 3);
            }
        }
    }

    private final void dropLoot(Player player) {
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.getServer() != null) {
                this.unpackLootTable(player);
                if (!this.storedItem.isEmpty()) {
                    double entityWidth = EntityType.ITEM.getWidth();
                    double positionOffset = 1.0 - entityWidth;
                    double halfWidth = entityWidth / 2.0;
                    Direction direction = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                    Intrinsics.checkNotNull((Object)direction, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
                    Direction dropDirection = direction;
                    BlockPos dropPosition = this.worldPosition.relative(dropDirection, 1);
                    double dropX = (double)dropPosition.getX() + 0.5 * positionOffset + halfWidth;
                    double dropY = (double)dropPosition.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
                    double dropZ = (double)dropPosition.getZ() + 0.5 * positionOffset + halfWidth;
                    Level level2 = this.level;
                    Intrinsics.checkNotNull((Object)level2);
                    Level level3 = this.level;
                    Intrinsics.checkNotNull((Object)level3);
                    ItemEntity itemEntity = new ItemEntity(level2, dropX, dropY, dropZ, this.storedItem.split(level3.random.nextInt(21) + 10));
                    itemEntity.setDeltaMovement(Vec3.ZERO);
                    Level level4 = this.level;
                    Intrinsics.checkNotNull((Object)level4);
                    level4.addFreshEntity((Entity)itemEntity);
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    this.storedItem = itemStack;
                }
            }
        }
    }

    public final void resetBrushingState() {
        if (this.level != null) {
            if (this.brushProgress != 0) {
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                if (level.getGameTime() >= this.brushResetTime) {
                    int oldCompletionState = this.getCompletionState();
                    this.brushProgress = (int)Math.max(0.0, (double)(this.brushProgress - 2));
                    int newCompletionState = this.getCompletionState();
                    if (oldCompletionState != newCompletionState) {
                        Level level2 = this.level;
                        Intrinsics.checkNotNull((Object)level2);
                        level2.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(newCompletionState)), 3);
                    }
                    Level level3 = this.level;
                    Intrinsics.checkNotNull((Object)level3);
                    this.brushResetTime = level3.getGameTime() + 4L;
                }
            }
            if (this.brushProgress == 0) {
                this.hitDirection = null;
                this.brushResetTime = 0L;
                this.brushResetTime = 0L;
            } else {
                Level level = this.level;
                Intrinsics.checkNotNull((Object)level);
                level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
            }
        }
    }

    private final boolean tryLoadLootTable(CompoundTag tag) {
        if (tag.contains("LootTable", 8)) {
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("LootTable")));
            this.lootTableSeed = tag.getLong("LootTableSeed");
            return true;
        }
        return false;
    }

    private final boolean trySaveLootTable(CompoundTag tag) {
        if (this.lootTable == null) {
            return false;
        }
        ResourceKey<LootTable> resourceKey = this.lootTable;
        Intrinsics.checkNotNull(resourceKey);
        tag.putString("LootTable", resourceKey.location().toString());
        if (this.lootTableSeed != 0L) {
            tag.putLong("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = super.getUpdateTag(registries);
        if (this.hitDirection != null) {
            Direction direction = this.hitDirection;
            Intrinsics.checkNotNull((Object)direction);
            compoundTag.putInt("hit_direction", direction.ordinal());
        }
        if (!this.storedItem.isEmpty()) {
            compoundTag.put("item", this.storedItem.save(registries));
        }
        Intrinsics.checkNotNull((Object)compoundTag);
        return compoundTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        if (!this.tryLoadLootTable(tag) && tag.contains("item")) {
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)((Tag)tag.getCompound("item"))).orElse(ItemStack.EMPTY);
            Intrinsics.checkNotNull((Object)itemStack, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
            this.storedItem = itemStack;
        } else {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.storedItem = itemStack;
        }
        if (tag.contains("hit_direction")) {
            this.hitDirection = (Direction)EntriesMappings.entries$0.get(tag.getInt("hit_direction"));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag) && !this.storedItem.isEmpty()) {
            tag.put("item", this.storedItem.save(registries));
        }
    }

    public final void setLootTable(@Nullable ResourceKey<LootTable> lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    private final int getCompletionState() {
        return this.brushProgress == 0 ? 0 : (this.brushProgress < 3 ? 1 : (this.brushProgress < 6 ? 2 : 3));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

