/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J6\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010H\u0016J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J@\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0014J(\u0010%\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J(\u0010(\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u001eH\u0002J8\u0010*\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0016\u00a8\u0006/"}, d2={"Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "setPlacedBy", "", "pLevel", "pPos", "Lnet/minecraft/core/BlockPos;", "pState", "pPlacer", "Lnet/minecraft/world/entity/LivingEntity;", "pStack", "Lnet/minecraft/world/item/ItemStack;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "pHand", "Lnet/minecraft/world/InteractionHand;", "playerWillDestroy", "pos", "player", "onBlockBroken", "Lnet/minecraft/world/level/BlockGetter;", "neighborChanged", "pBlock", "pFromPos", "pIsMoving", "", "witchery"})
public abstract class WitcheryBaseEntityBlock
extends Block
implements EntityBlock {
    public WitcheryBaseEntityBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (arg_0, arg_1, arg_2, arg_3) -> WitcheryBaseEntityBlock.getTicker$lambda$0(level, state, arg_0, arg_1, arg_2, arg_3);
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof WitcheryBaseBlockEntity) {
            ((WitcheryBaseBlockEntity)be).onPlace(pPlacer, pStack);
        }
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHitResult) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHitResult, (String)"pHitResult");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof WitcheryBaseBlockEntity) {
            InteractionResult interactionResult;
            InteractionResult earlyResult = ((WitcheryBaseBlockEntity)be).onUseWithoutItem(pPlayer);
            if (earlyResult.consumesAction()) {
                interactionResult = earlyResult;
            } else {
                InteractionResult interactionResult2 = ((WitcheryBaseBlockEntity)be).onUse(pPlayer, InteractionHand.MAIN_HAND).result();
                Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"result(...)");
                interactionResult = interactionResult2;
            }
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        Intrinsics.checkNotNullParameter((Object)pHitResult, (String)"pHitResult");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof WitcheryBaseBlockEntity) {
            ItemInteractionResult earlyResult = ((WitcheryBaseBlockEntity)be).onUseWithItem(pPlayer, pStack, pHand);
            return earlyResult.consumesAction() ? earlyResult : ((WitcheryBaseBlockEntity)be).onUse(pPlayer, pHand);
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.onBlockBroken(state, (BlockGetter)level, pos, player);
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    private final void onBlockBroken(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof WitcheryBaseBlockEntity) {
            ((WitcheryBaseBlockEntity)be).onBreak(player);
        }
    }

    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlock, (String)"pBlock");
        Intrinsics.checkNotNullParameter((Object)pFromPos, (String)"pFromPos");
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof WitcheryBaseBlockEntity) {
            ((WitcheryBaseBlockEntity)be).onNeighborUpdate(pState, pPos, pFromPos);
        }
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    private static final void getTicker$lambda$0(Level $level, BlockState $state, Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof WitcheryBaseBlockEntity) {
            WitcheryBaseBlockEntity witcheryBaseBlockEntity = (WitcheryBaseBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)pos);
            witcheryBaseBlockEntity.tick($level, pos, $state);
        }
    }
}

